/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.validation.snt.version.v1;

import java.util.Collections;
import java.util.List;
import javax.validation.ConstraintValidatorContext;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import ru.uss.core.utils.LambdaUtils;
import ru.uss.core.validation.common.AbstractClassLevelValidator;
import ru.uss.esf.model.snt.version.v1.SntShippingInfoV1;
import ru.uss.esf.model.snt.version.v1.SntTransportTypeV1;
import ru.uss.esf.model.snt.version.v1.SntV1;
import ru.uss.esf.validation.snt.version.v1.SntShippingInfoTransportTypeCheckV1;

public class SntShippingInfoTransportTypeValidatorV1
extends AbstractClassLevelValidator<SntShippingInfoTransportTypeCheckV1, SntV1> {
    @Override
    public void initialize(SntShippingInfoTransportTypeCheckV1 constraintAnnotation) {
    }

    @Override
    public boolean isValid(SntV1 sntV1, ConstraintValidatorContext context) {
        String sellerCountryCode = LambdaUtils.nullSafeApplyFunction(sntV1, sntV11 -> sntV11.getSeller().getCountryCode());
        String customerCountryCode = LambdaUtils.nullSafeApplyFunction(sntV1, sntV11 -> sntV11.getCustomer().getCountryCode());
        String consignorCountryCode = LambdaUtils.nullSafeApplyFunction(sntV1, sntV11 -> sntV11.getConsignor().getCountryCode());
        String consigneeCountryCode = LambdaUtils.nullSafeApplyFunction(sntV1, sntV11 -> sntV11.getConsignee().getCountryCode());
        boolean isTransportTypesRequired = false;
        if (StringUtils.isNotEmpty(sellerCountryCode) && !"KZ".equalsIgnoreCase(sellerCountryCode) || StringUtils.isNotEmpty(customerCountryCode) && !"KZ".equalsIgnoreCase(customerCountryCode) || StringUtils.isNotEmpty(consignorCountryCode) && !"KZ".equalsIgnoreCase(consignorCountryCode) || StringUtils.isNotEmpty(consigneeCountryCode) && !"KZ".equalsIgnoreCase(consigneeCountryCode)) {
            isTransportTypesRequired = true;
        }
        SntShippingInfoV1 shippingInfo = sntV1.getShippingInfo();
        List transportTypes = LambdaUtils.nullSafeApplyFunction(shippingInfo, sntShippingInfoV1 -> shippingInfo.getTransportTypes(), Collections.emptyList());
        if (isTransportTypesRequired && (shippingInfo == null || CollectionUtils.size(transportTypes) == 0)) {
            return this.setupContextWithValidationError(context, "shippingInfo.transportTypes", "{sntShippingInfoV1.transportType.notNull}");
        }
        if (CollectionUtils.size(transportTypes) > 1 && !transportTypes.contains(SntTransportTypeV1.MULTIMODAL)) {
            return this.setupContextWithValidationError(context, "shippingInfo.transportTypes", "{sntShippingInfoV1.transportType.onlyOne}");
        }
        return true;
    }
}

