/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.validation.snt.version.v1;

import javax.validation.ConstraintValidatorContext;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import ru.uss.core.utils.LambdaUtils;
import ru.uss.core.validation.common.AbstractClassLevelValidator;
import ru.uss.esf.model.snt.abstractsnt.SntType;
import ru.uss.esf.model.snt.version.v1.SntCustomerTypeV1;
import ru.uss.esf.model.snt.version.v1.SntTobaccoSetV1;
import ru.uss.esf.model.snt.version.v1.SntV1;
import ru.uss.esf.validation.snt.version.v1.SntTobaccoSetCheckV1;

public class SntTobaccoSetValidatorV1
extends AbstractClassLevelValidator<SntTobaccoSetCheckV1, SntV1> {
    @Override
    public void initialize(SntTobaccoSetCheckV1 constraintAnnotation) {
    }

    @Override
    public boolean isValid(SntV1 snt, ConstraintValidatorContext context) {
        boolean isCustomerIndividual;
        SntTobaccoSetV1 tobaccoSet = snt.getTobaccoSet();
        if (tobaccoSet == null) {
            return true;
        }
        boolean result = true;
        boolean hasTransferType = snt.getTransferType() != null;
        SntType sntType = snt.getSntType();
        boolean isExport = snt.getSntExport() != null;
        boolean isImport = snt.getSntImport() != null;
        boolean isCustomerNonResident = snt.getCustomer() != null && BooleanUtils.isTrue(snt.getCustomer().getNonResident());
        boolean isCustomerRetail = snt.getCustomer() != null && snt.getCustomer().isRetail();
        boolean bl = isCustomerIndividual = snt.getCustomer() != null && snt.getCustomer().isIndividual();
        if (!SntType.RETURNED_SNT.equals(sntType)) {
            if (snt.isCustomerRetail() && !"44".equals(tobaccoSet.getOperationCode())) {
                result = this.setupContextWithValidationError(context, "tobaccoSet.operationCode", "{sntV1.customer.retail.required.end_user.operationCode}");
            }
            if (!snt.isCustomerRetail() && "44".equals(tobaccoSet.getOperationCode())) {
                result = this.setupContextWithValidationError(context, "customer.statuses", "{sntV1.operationCode.end_user.required.customer.retail}");
            }
        } else if (snt.isSellerRetail() && tobaccoSet.getOperationCode() != null) {
            result = this.setupContextWithValidationError(context, "tobaccoSet.operationCode", this.generateNullFieldMessage("sntTobaccoSetV1.operationCode"));
        }
        if (!(sntType == SntType.RETURNED_SNT || tobaccoSet.getOperationCode() != null || hasTransferType || isExport || isImport)) {
            result = this.setupContextWithValidationError(context, "tobaccoSet.operationCode", "{sntTobaccoSetV1.operationCode.notNull}");
        }
        if (StringUtils.isEmpty(tobaccoSet.getKogdOfRecipient())) {
            boolean isCustomerSmallRetailOutlet;
            boolean bl2 = isCustomerSmallRetailOutlet = snt.getCustomer() != null && snt.getCustomer().containsCategory(SntCustomerTypeV1.SMALL_RETAIL_OUTLET);
            if (!(SntType.RETURNED_SNT.equals(snt.getSntType()) || snt.isTransferOnePersonInKz() || snt.getCustomer() != null && isCustomerNonResident || isCustomerIndividual || isCustomerRetail || isCustomerSmallRetailOutlet)) {
                result = this.setupContextWithValidationError(context, "tobaccoSet.kogdOfRecipient", "{sntTobaccoSetV1.kogdOfRecipient.notNull}");
            }
        }
        if (!this.validateForSmallRetailOutlet(snt, context)) {
            result = false;
        }
        return result;
    }

    private boolean validateForSmallRetailOutlet(SntV1 snt, ConstraintValidatorContext context) {
        String g8OperationCode;
        boolean result = true;
        if (!(snt.getSntType() != SntType.PRIMARY_SNT && snt.getSntType() != SntType.FIXED_SNT || snt.getCustomer() == null || !snt.getCustomer().containsCategory(SntCustomerTypeV1.SMALL_RETAIL_OUTLET) || !StringUtils.isNotEmpty(g8OperationCode = LambdaUtils.nullSafeApplyFunction(snt, s -> s.getTobaccoSet().getOperationCode())) || "39".equals(g8OperationCode) || "41".equals(g8OperationCode) || "42".equals(g8OperationCode))) {
            result = this.setupContextWithValidationError(context, "tobaccoSet.operationCode", "{sntTobaccoSetV1.operationCode.smallRetailOutlet.required.39.41.42}");
        }
        return result;
    }
}

