/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.validation.snt.version.v1;

import javax.validation.ConstraintValidatorContext;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import ru.uss.core.utils.LambdaUtils;
import ru.uss.core.validation.common.AbstractClassLevelValidator;
import ru.uss.esf.model.snt.abstractsnt.SntType;
import ru.uss.esf.model.snt.version.v1.SntTransferTypeV1;
import ru.uss.esf.model.snt.version.v1.SntV1;
import ru.uss.esf.validation.snt.version.v1.SntTransferTypeCheckV1;

public class SntTransferTypeValidatorV1
extends AbstractClassLevelValidator<SntTransferTypeCheckV1, SntV1> {
    @Override
    public void initialize(SntTransferTypeCheckV1 constraintAnnotation) {
    }

    @Override
    public boolean isValid(SntV1 value, ConstraintValidatorContext context) {
        if (value.getTransferType() == SntTransferTypeV1.OTHER && SntType.RETURNED_SNT.equals(value.getSntType())) {
            return this.setupContextWithValidationError(context, "transferType", "{sntV1.transferType.other.returnedOrFixed}");
        }
        if (value.getSeller() == null || value.getCustomer() == null) {
            return true;
        }
        if (value.getTransferType() == SntTransferTypeV1.ONE_PERSON_IN_KZ) {
            if (!"KZ".equals(value.getSeller().getCountryCode()) || !"KZ".equals(value.getCustomer().getCountryCode())) {
                return this.setupContextWithValidationError(context, "transferType", "{sntV1.transferType.onlyKZ}");
            }
            if (value.getSntExport() != null || value.getSntImport() != null || value.getTransferType() == SntTransferTypeV1.ONE_PERSON_IN_EAEU) {
                return this.setupContextWithValidationError(context, "transferType", "{sntV1.transferType.exclusive1}");
            }
        }
        if (value.getTransferType() == SntTransferTypeV1.ONE_PERSON_IN_EAEU && (value.getSntExport() != null || value.getSntImport() != null || value.getTransferType() == SntTransferTypeV1.ONE_PERSON_IN_KZ)) {
            return this.setupContextWithValidationError(context, "transferType", "{sntV1.transferType.exclusive2}");
        }
        if ((value.getTransferType() == SntTransferTypeV1.ONE_PERSON_IN_EAEU || value.getTransferType() == SntTransferTypeV1.OTHER) && BooleanUtils.isFalse(LambdaUtils.nullSafeApplyFunction(value, snt -> snt.getSeller().getNonResident(), false, false)) && BooleanUtils.isFalse(LambdaUtils.nullSafeApplyFunction(value, snt -> snt.getCustomer().getNonResident(), false, false))) {
            return this.setupContextWithValidationError(context, "transferType", "{sntV1.transferType.needsResident}");
        }
        if (value.getTransferType() != SntTransferTypeV1.ONE_PERSON_IN_KZ && CollectionUtils.containsAny(value.getSellerParticipantTins(), value.getCustomerParticipantTins())) {
            return this.setupContextWithValidationError(context, "transferType", "{sntV1.transferType.onePersonInKzRequired}");
        }
        return true;
    }
}

