/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.validation.transit;

import java.util.Date;
import javax.validation.ConstraintValidatorContext;
import org.apache.commons.lang3.StringUtils;
import ru.uss.core.utils.DateTimeUtils;
import ru.uss.core.utils.LambdaUtils;
import ru.uss.core.validation.common.AbstractClassLevelValidator;
import ru.uss.esf.model.transit.TransitType;
import ru.uss.esf.model.transit.version.v1.Carrier;
import ru.uss.esf.model.transit.version.v1.TransitV1;
import ru.uss.esf.validation.common.field.TinValidator;
import ru.uss.esf.validation.transit.TransitCarrierCheck;

public class TransitCarrierValidator
extends AbstractClassLevelValidator<TransitCarrierCheck, TransitV1> {
    private static final Date REQUIRED_FIELD_START_DATE = DateTimeUtils.getDate("05.06.2020");

    @Override
    public void initialize(TransitCarrierCheck constraintAnnotation) {
    }

    @Override
    public boolean isValid(TransitV1 transit, ConstraintValidatorContext context) {
        if (transit == null) {
            return true;
        }
        Carrier carrier = transit.getCarrier();
        if (carrier == null) {
            return true;
        }
        Date importDate = LambdaUtils.nullSafeApplyFunction(transit, v -> v.getImportData().getImportDate());
        if (!(carrier.getNoResident().booleanValue() || !StringUtils.isEmpty(carrier.getIdentifier()) && TinValidator.isTin(carrier.getIdentifier()) || importDate != null && DateTimeUtils.lessThan(importDate, REQUIRED_FIELD_START_DATE))) {
            return this.setupContextWithValidationError(context, "carrier.identifier", "{transit.carrier.identifier.tin_required_for_resident}");
        }
        if (!(carrier.getNoResident().booleanValue() || !StringUtils.isEmpty(carrier.getOgdCode()) && !StringUtils.isEmpty(carrier.getOgdName()) || importDate != null && DateTimeUtils.lessThan(importDate, REQUIRED_FIELD_START_DATE))) {
            return this.setupContextWithValidationError(context, "carrier.identifier", "{transit.carrier.identifier.ogd_required_for_resident}");
        }
        if (transit.getType() != TransitType.TRANSIT && transit.getCarrier2() != null) {
            return this.setupContextWithValidationError(context, "carrier2", "{transit.carrier2.mustBeNull}");
        }
        if (transit.getType() != TransitType.TRANSIT && transit.getType() != TransitType.IMPORT) {
            if (transit.getCarrier() != null && StringUtils.isNotEmpty(transit.getCarrier().getStamp())) {
                return this.setupContextWithValidationError(context, "carrier.stamp", "{transit.carrier.mustBeNull}");
            }
            if (transit.getCarrier2() != null && StringUtils.isNotEmpty(transit.getCarrier2().getStamp())) {
                return this.setupContextWithValidationError(context, "carrier2.stamp", "{transit.carrier.mustBeNull}");
            }
        }
        return true;
    }
}

