/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.validation.transit;

import java.util.Date;
import javax.validation.ConstraintValidatorContext;
import org.apache.commons.lang3.StringUtils;
import ru.uss.core.utils.DateTimeUtils;
import ru.uss.core.utils.LambdaUtils;
import ru.uss.core.validation.common.AbstractClassLevelValidator;
import ru.uss.esf.model.transit.version.v1.Consignee;
import ru.uss.esf.model.transit.version.v1.Consignor;
import ru.uss.esf.model.transit.version.v1.TransitV1;
import ru.uss.esf.validation.transit.TransitTaxpayerOgdCheck;

public class TransitTaxpayerOgdValidator
extends AbstractClassLevelValidator<TransitTaxpayerOgdCheck, TransitV1> {
    private static final Date REQUIRED_FIELD_START_DATE = DateTimeUtils.getDate("23.04.2020");
    private String message;

    @Override
    public void initialize(TransitTaxpayerOgdCheck constraintAnnotation) {
        this.message = constraintAnnotation.message();
    }

    @Override
    public boolean isValid(TransitV1 value, ConstraintValidatorContext context) {
        if (value == null) {
            return true;
        }
        Date importDate = LambdaUtils.nullSafeApplyFunction(value, v -> v.getImportData().getImportDate());
        Consignee consignee = value.getConsignee();
        if (!(consignee == null || consignee.getNoResident().booleanValue() || !StringUtils.isEmpty(consignee.getOgdCode()) && !StringUtils.isEmpty(consignee.getOgdName()) || importDate != null && DateTimeUtils.lessThan(importDate, REQUIRED_FIELD_START_DATE))) {
            if (StringUtils.isNotEmpty(consignee.getOgdCode())) {
                return this.setupContextWithValidationError(context, "consignee.identifier", "{transit.consignee.identifier.ogd_not_found_for_resident}");
            }
            return this.setupContextWithValidationError(context, "consignee.identifier", "{transit.consignee.identifier.ogd_required_for_resident}");
        }
        Consignor consignor = value.getConsignor();
        if (!(consignor == null || consignor.getNoResident().booleanValue() || !StringUtils.isEmpty(consignor.getOgdCode()) && !StringUtils.isEmpty(consignor.getOgdName()) || importDate != null && DateTimeUtils.lessThan(importDate, REQUIRED_FIELD_START_DATE))) {
            if (StringUtils.isNotEmpty(consignor.getOgdCode())) {
                return this.setupContextWithValidationError(context, "consignor.identifier", "{transit.consignor.identifier.ogd_not_found_for_resident}");
            }
            return this.setupContextWithValidationError(context, "consignor.identifier", "{transit.consignor.identifier.ogd_required_for_resident}");
        }
        return true;
    }
}

