/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.esf.validation.transit;

import javax.validation.ConstraintValidatorContext;
import org.apache.commons.lang3.StringUtils;
import ru.uss.core.validation.common.AbstractClassLevelValidator;
import ru.uss.esf.model.transit.version.v1.Products;
import ru.uss.esf.validation.transit.TransitVinCodeCheck;

public class TransitVinCodeCheckValidator
extends AbstractClassLevelValidator<TransitVinCodeCheck, Products.Product> {
    private static final String CAR_TNVED_GROUP = "8703";

    @Override
    public void initialize(TransitVinCodeCheck annotation) {
        this.annotation = annotation;
    }

    @Override
    public boolean isValid(Products.Product product, ConstraintValidatorContext context) {
        if (product == null) {
            return true;
        }
        if (StringUtils.isEmpty(product.getVinCode()) && StringUtils.isNotEmpty(product.getTnved()) && product.getTnved().startsWith(CAR_TNVED_GROUP)) {
            return this.setupContextWithValidationError(context, ((TransitVinCodeCheck)this.annotation).fieldPath(), ((TransitVinCodeCheck)this.annotation).message());
        }
        return true;
    }
}

