/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.ndsbc.api1.ks;

import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.Documentation;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.collections4.CollectionUtils;
import ru.uss.core.model.Error;
import ru.uss.core.model.ErrorAware;
import ru.uss.esf.model.ndsbc.ks.KsError;
import ru.uss.esf.model.ndsbc.ks.KsProcessStatus;
import ru.uss.ndsbc.api1.ks.KsStatusLogProcessResult;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="KsStatusLogResponse")
@XmlType(name="KsStatusLogResponse")
@Documentation(value="\u041a\u043e\u043d\u0442\u0435\u0439\u043d\u0435\u0440 \u043e\u0442\u0432\u0435\u0442\u0430")
public class KsStatusLogResponse
implements ErrorAware {
    @XmlElementWrapper(name="processingResult")
    @XmlElement(name="ksStatusLogProcessResult", required=true)
    @Documentation(value="\u0421\u043f\u0438\u0441\u043e\u043a \u0441\u0442\u0430\u0442\u0443\u0441\u043e\u0432")
    private List<KsStatusLogProcessResult> processingResult;
    @XmlElement(required=true)
    @Documentation(value="\u0421\u0442\u0430\u0442\u0443\u0441 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0438 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u044f")
    protected KsProcessStatus status;
    @XmlElementWrapper(name="errorList")
    @XmlElement(required=false, name="error")
    @Documentation(value="\u0421\u043f\u0438\u0441\u043e\u043a \u043e\u0448\u0438\u0431\u043e\u043a")
    protected List<KsError> errors;

    public KsStatusLogResponse() {
    }

    public KsStatusLogResponse(KsProcessStatus status, List<KsStatusLogProcessResult> processingResult) {
        this.status = status;
        this.processingResult = processingResult;
    }

    public static KsStatusLogResponse successResponse(List<KsStatusLogProcessResult> processingResult) {
        return new KsStatusLogResponse(KsProcessStatus.PROCESSED, processingResult);
    }

    public static KsStatusLogResponse wrongResponse(List<Error> errorList) {
        KsStatusLogResponse response = new KsStatusLogResponse();
        response.setErrors(KsError.of(errorList));
        response.status = KsProcessStatus.FAILED;
        return response;
    }

    public KsProcessStatus getStatus() {
        return this.status;
    }

    public void setStatus(KsProcessStatus status) {
        this.status = status;
    }

    public List<KsError> getErrors() {
        return this.errors;
    }

    public void setErrors(List<KsError> errors) {
        this.errors = errors;
    }

    public List<KsStatusLogProcessResult> getProcessingResult() {
        return this.processingResult;
    }

    public void setProcessingResult(List<KsStatusLogProcessResult> processingResult) {
        this.processingResult = processingResult;
    }

    @Override
    public List<Error> getErrorList() {
        return CollectionUtils.isNotEmpty(this.errors) ? KsError.convertToError(this.errors) : Collections.emptyList();
    }
}

