/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.vstore.builder;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.Random;
import javax.security.auth.x500.X500PrivateCredential;
import ru.uss.vstore.builder.ValidUFormProductBuilderV1;
import ru.uss.vstore.model.doc.EUFormStatusType;
import ru.uss.vstore.model.doc.EUFormType;
import ru.uss.vstore.model.uform.version.v1.UFormProductV1;
import ru.uss.vstore.model.uform.version.v1.UFormV1;
import ru.uss.vstore.utils.UFormSignatureHelper;

public class ValidUFormBuilderV1 {
    private UFormV1 uFormV1;

    public ValidUFormBuilderV1(UFormV1 uFormV1) {
        this.uFormV1 = uFormV1;
    }

    public static ValidUFormBuilderV1 create() {
        UFormV1 uFormV1 = new UFormV1();
        uFormV1.setNumber(String.valueOf(Math.abs(new Random().nextLong() + 1L)));
        uFormV1.setDate(new Date());
        uFormV1.setProducts(new ArrayList<UFormProductV1>());
        return new ValidUFormBuilderV1(uFormV1);
    }

    public ValidUFormBuilderV1 setNumber(String number) {
        this.uFormV1.setNumber(number);
        return this;
    }

    public ValidUFormBuilderV1 setDate(Date date) {
        this.uFormV1.setDate(date);
        return this;
    }

    public ValidUFormBuilderV1 setUttnTypeCode(EUFormType type) {
        this.uFormV1.setType(type);
        return this;
    }

    public ValidUFormBuilderV1 setSenderTin(String senderTin) {
        return this;
    }

    public ValidUFormBuilderV1 setRecipientTin(String recipientTin) {
        return this;
    }

    public ValidUFormBuilderV1 setTotalSum(BigDecimal totalSum) {
        this.uFormV1.setTotalSum(totalSum);
        return this;
    }

    public ValidUFormBuilderV1 setStatus(EUFormStatusType status) {
        return this;
    }

    public ValidUFormBuilderV1 setSenderStoreId(Long storeId) {
        return this;
    }

    public ValidUFormBuilderV1 setRecipientStoreId(Long storeId) {
        return this;
    }

    public ValidUFormBuilderV1 setSourceDocumentNum(String sourceDocumentNum) {
        return this;
    }

    public ValidUFormBuilderV1 setSourceDocumentDate(Date sourceDocumentDate) {
        return this;
    }

    public ValidUFormProductBuilderV1 addProduct() {
        return new ValidUFormProductBuilderV1(this.uFormV1);
    }

    public UFormV1 build() {
        return this.uFormV1;
    }

    public UFormV1 buildAndSign(X500PrivateCredential cert) {
        UFormV1 uFormV1 = this.build();
        try {
            UFormSignatureHelper.sign(uFormV1, cert);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return uFormV1;
    }
}

