/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.vstore.model.doc;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import javax.xml.bind.annotation.Documentation;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.beans.BeanUtils;
import ru.uss.core.adapter.DateAdapter;
import ru.uss.core.model.DocumentInfo;
import ru.uss.core.model.VersionedDocument;
import ru.uss.core.validation.common.RequiredString;
import ru.uss.esf.validation.common.field.Tin;
import ru.uss.vstore.model.doc.DocumentGtdRelation;
import ru.uss.vstore.model.doc.DocumentProductGtd;
import ru.uss.vstore.model.doc.ECustomsDutyType;
import ru.uss.vstore.model.doc.EDocumentStatusType;
import ru.uss.vstore.model.doc.EGtdDeclarationKindType;
import ru.uss.vstore.model.doc.EGtdDeclarationType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="DocumentGtd")
@Documentation(value="\u0418\u0441\u0445\u043e\u0434\u043d\u044b\u0439 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442 \u0413\u0422\u0414")
@JsonIgnoreProperties(value={"inputDateAsString"}, allowGetters=true)
public class DocumentGtd
implements Serializable,
DocumentInfo,
VersionedDocument {
    public static final String VERSION = "DtV1";
    @XmlTransient
    @Documentation(value="ID")
    private Long id;
    @RequiredString(required=false, minLen=1, maxLen=36, fieldPath="messageId")
    @XmlElement
    @Documentation(value="\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0432\u0445\u043e\u0434\u044f\u0449\u0435\u0433\u043e \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u044f \u0432 \u043e\u0447\u0435\u0440\u0435\u0434\u0438")
    private String messageId;
    @XmlElement
    @Documentation(value="\u0422\u0438\u043f \u0434\u0435\u043a\u043b\u0430\u0440\u0430\u0446\u0438\u0438")
    private EGtdDeclarationType declarationType;
    @RequiredString(required=true, minLen=1, maxLen=32, fieldPath="number")
    @NotNull(message="{document.number.notNull}")
    @XmlElement(required=true)
    @Documentation(value="\u0418\u0441\u0445\u043e\u0434\u044f\u0449\u0438\u0439 \u043d\u043e\u043c\u0435\u0440 \u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430")
    private @NotNull(message="{document.number.notNull}") String number;
    @NotNull(message="{document.date.notNull}")
    @XmlElement(required=true)
    @XmlJavaTypeAdapter(value=DateAdapter.class)
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="dd.MM.yyyy")
    @Documentation(value="\u0414\u0430\u0442\u0430 \u0438\u0441\u0445\u043e\u0434\u043d\u043e\u0433\u043e \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430")
    private @NotNull(message="{document.date.notNull}") Date date;
    @NotNull(message="{document.date.notNull}")
    @XmlElement(required=true)
    @XmlJavaTypeAdapter(value=DateAdapter.class)
    @JsonFormat(shape=JsonFormat.Shape.NUMBER)
    @Documentation(value="\u0414\u0430\u0442\u0430 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u044f \u0414\u0422")
    private @NotNull(message="{document.date.notNull}") Date inputDate;
    @NotNull(message="{document.tin.notNull}")
    @Tin(message="{document.tin.format}")
    @XmlElement
    @Documentation(value="\u0411\u0418\u041d \u043f\u043e\u043a\u0443\u043f\u0430\u0442\u0435\u043b\u044f")
    private @NotNull(message="{document.tin.notNull}") String tin;
    @XmlElement
    @Documentation(value="\u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 \u043f\u043e\u043a\u0443\u043f\u0430\u0442\u0435\u043b\u044f \u0438\u0437 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0430 \u041d\u041f \u0418\u0421 \u042d\u0421\u0424")
    private String name;
    @RequiredString(required=false, minLen=1, maxLen=512, fieldPath="buyerName")
    @XmlElement
    @Documentation(value="\u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 \u043f\u043e\u043a\u0443\u043f\u0430\u0442\u0435\u043b\u044f \u0438\u0437 \u0414\u0422")
    private String buyerName;
    @RequiredString(required=false, minLen=1, maxLen=512, fieldPath="consignorName")
    @XmlElement
    @Documentation(value="\u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 \u043f\u043e\u0441\u0442\u0430\u0432\u0449\u0438\u043a\u0430 \u0438\u0437 \u0414\u0422")
    private String consignorName;
    @XmlElement
    @Documentation(value="\u041a\u043e\u0434 \u0442\u0438\u043f\u0430 \u0442\u0430\u043c\u043e\u0436\u0435\u043d\u043d\u043e\u0439 \u043f\u043e\u0448\u043b\u0438\u043d\u044b")
    private ECustomsDutyType customsDutyTypeCode;
    @XmlElement
    @Documentation(value="\u0412\u0441\u0435\u0433\u043e \u0442\u043e\u0432\u0430\u0440\u043e\u0432")
    private int totalGoodsNumber;
    @XmlElement
    @Documentation(value="\u041e\u0431\u0449\u0430\u044f \u0442\u0430\u043c\u043e\u0436\u0435\u043d\u043d\u0430\u044f \u0441\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c \u043f\u043e \u0414\u0422")
    private BigDecimal totalCustCost;
    @RequiredString(required=false, minLen=1, maxLen=2, fieldPath="dispatchCountryCode")
    @NotNull(message="{document.dispatchCountryCode.notNull}")
    @XmlElement(required=true)
    @Documentation(value="\u0421\u0442\u0440\u0430\u043d\u0430 \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f. \u0411\u0443\u043a\u0432\u0435\u043d\u043d\u044b\u0439 \u043a\u043e\u0434 \u043f\u043e  \u043a\u043b\u0430\u0441\u0441\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440\u0443 \u0441\u0442\u0440\u0430\u043d \u043c\u0438\u0440\u0430")
    private @NotNull(message="{document.dispatchCountryCode.notNull}") String dispatchCountryCode;
    @RequiredString(required=false, minLen=1, maxLen=2, fieldPath="destinationCountryCode")
    @XmlElement
    @Documentation(value="\u0421\u0442\u0440\u0430\u043d\u0430 \u043d\u0430\u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f. \u0411\u0443\u043a\u0432\u0435\u043d\u043d\u044b\u0439 \u043a\u043e\u0434 \u043f\u043e \u043a\u043b\u0430\u0441\u0441\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440\u0443 \u0441\u0442\u0440\u0430\u043d \u043c\u0438\u0440\u0430")
    private String destinationCountryCode;
    @RequiredString(required=false, minLen=1, maxLen=3, fieldPath="currencyCode")
    @XmlElement
    @Documentation(value="\u041a\u043e\u0434 \u0432\u0430\u043b\u044e\u0442\u044b \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430")
    private String currencyCode;
    @XmlElement
    @Documentation(value="\u041a\u0443\u0440\u0441 \u0432\u0430\u043b\u044e\u0442\u044b \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430")
    private BigDecimal currencyRate;
    @XmlTransient
    @Documentation(value="\u0421\u0442\u0430\u0442\u0443\u0441 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430")
    private EDocumentStatusType status;
    @XmlElement
    @Documentation(value="\u041e\u0440\u0438\u0433\u0438\u043d\u0430\u043b\u044c\u043d\u044b\u0439 \u0437\u0430\u043f\u0440\u043e\u0441 XML \u0438\u0437 \u043e\u0447\u0435\u0440\u0435\u0434\u0438")
    private String originalRequestXml;
    @Valid
    @Size(min=1, message="{document.products.emptyList}")
    @NotNull(message="{document.products.emptyList}")
    @XmlElementWrapper
    @XmlElement(name="product", required=true)
    @Documentation(value="\u0422\u043e\u0432\u0430\u0440\u044b")
    private @Valid @Size(min=1, message="{document.products.emptyList}") @NotNull(message="{document.products.emptyList}") List<DocumentProductGtd> products = new ArrayList<DocumentProductGtd>();
    @XmlTransient
    @Documentation(value="\u0422\u043e\u0432\u0430\u0440\u044b \u0414\u0422, \u0440\u0430\u0437\u043b\u043e\u0436\u0435\u043d\u043d\u044b\u0435 \u043f\u043e \u043d\u043e\u043c\u0435\u0440\u0443 \u0442\u043e\u0432\u0430\u0440\u043d\u043e\u0439 \u043f\u043e\u0437\u0438\u0446\u0438\u0438")
    private Map<String, DocumentProductGtd> productByRowNum;
    @XmlTransient
    @Documentation(value="\u041f\u043e\u0440\u044f\u0434\u043a\u043e\u0432\u044b\u0439 \u043d\u043e\u043c\u0435\u0440 \u0432\u0435\u0440\u0441\u0438\u0438 \u041a\u0414\u0422 (\u043d\u0435 \u0437\u0430\u043f\u043e\u043b\u043d\u044f\u0435\u0442\u0441\u044f \u0434\u043b\u044f \u0414\u0422)")
    private Integer kdtVersion;
    @RequiredString(required=false, minLen=1, maxLen=2, fieldPath="customsModeCode")
    @XmlElement
    @Documentation(value="\u041a\u043e\u0434 \u0437\u0430\u044f\u0432\u043b\u044f\u0435\u043c\u043e\u0439 \u0442\u0430\u043c\u043e\u0436\u0435\u043d\u043d\u043e\u0439 \u043f\u0440\u043e\u0446\u0435\u0434\u0443\u0440\u044b")
    private String customsModeCode;
    @RequiredString(required=false, minLen=1, maxLen=2, fieldPath="categoryCode")
    @XmlElement
    @Documentation(value="\u041a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044f \u043b\u0438\u0446\u0430. \u0414\u0432\u0443\u0445\u0437\u043d\u0430\u0447\u043d\u044b\u0439 \u0446\u0438\u0444\u0440\u043e\u0432\u043e\u0439 \u043a\u043e\u0434 \u043a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u0438 \u043b\u0438\u0446\u0430 \u0441\u043e\u0433\u043b\u0430\u0441\u043d\u043e \u0443\u0447\u0440\u0435\u0434\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u043c \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430\u043c \u0438\u043b\u0438 \u0441\u0432\u0438\u0434\u0435\u0442\u0435\u043b\u044c\u0441\u0442\u0432\u0443 \u043e \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438 \u0432 \u043a\u0430\u0447\u0435\u0441\u0442\u0432\u0435 \u0438\u043d\u0434\u0438\u0432\u0438\u0434\u0443\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u043f\u0440\u0435\u0434\u043f\u0440\u0438\u043d\u0438\u043c\u0430\u0442\u0435\u043b\u044f")
    private String categoryCode;
    @XmlElement
    @Documentation(value="\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0442\u044d\u0433\u0430 DeclarationKind. \u041e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0430 \u0414\u0422, \u0441\u043e\u0434\u0435\u0440\u0436\u0430\u0449\u0435\u0439 \u0442\u043e\u0432\u0430\u0440\u044b \u0432 \u043d\u0435\u0441\u043e\u0431\u0440\u0430\u043d\u043d\u043e\u043c \u0438\u043b\u0438 \u0440\u0430\u0437\u043e\u0431\u0440\u0430\u043d\u043d\u043e\u043c \u0432\u0438\u0434\u0435")
    private EGtdDeclarationKindType declarationKind;
    @XmlTransient
    @Documentation(value="\u0424\u043b\u0430\u0433 \u043e\u043f\u0440\u0438\u0445\u043e\u0434\u043e\u0432\u0430\u043d\u0438\u044f \u0442\u043e\u0432\u0430\u0440\u043e\u0432 \u043d\u0430 \u0424\u041b-\u0441\u043a\u043b\u0430\u0434")
    private boolean isIndividual;
    @XmlTransient
    @Documentation(value="\u0424\u043b\u0430\u0433 \u0441\u043e\u0432\u0435\u0440\u0448\u0435\u043d\u043d\u043e\u0439 \u043a\u043e\u043c\u043f\u043b\u0435\u043a\u0442\u0430\u0446\u0438\u0438")
    private boolean packingDone;
    @XmlTransient
    @Documentation(value="\u0424\u043b\u0430\u0433 \u0441\u043e\u0432\u0435\u0440\u0448\u0435\u043d\u043d\u043e\u0433\u043e \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f")
    private boolean editingDone;
    @XmlTransient
    @Documentation(value="\u041e\u0448\u0438\u0431\u043a\u0430 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0438")
    private String processingError;
    @XmlTransient
    private Date gsvsDate;
    @XmlTransient
    private List<DocumentGtdRelation> relations;

    public DocumentGtd(DocumentGtd documentGtd) {
        BeanUtils.copyProperties(documentGtd, this);
    }

    public DocumentGtd() {
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    public EGtdDeclarationType getDeclarationType() {
        return this.declarationType;
    }

    public void setDeclarationType(EGtdDeclarationType declarationType) {
        this.declarationType = declarationType;
    }

    public String getNumber() {
        return this.number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public Date getInputDate() {
        return this.inputDate;
    }

    public void setInputDate(Date inputDate) {
        this.inputDate = inputDate;
    }

    @JsonProperty(value="inputDateAsString")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="dd.MM.yyyy")
    public Date getInputDateAsString() {
        return this.inputDate;
    }

    public String getTin() {
        return this.tin;
    }

    public void setTin(String tin) {
        this.tin = tin;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ECustomsDutyType getCustomsDutyTypeCode() {
        return this.customsDutyTypeCode;
    }

    public void setCustomsDutyTypeCode(ECustomsDutyType customsDutyTypeCode) {
        this.customsDutyTypeCode = customsDutyTypeCode;
    }

    public int getTotalGoodsNumber() {
        return this.totalGoodsNumber;
    }

    public void setTotalGoodsNumber(int totalGoodsNumber) {
        this.totalGoodsNumber = totalGoodsNumber;
    }

    public BigDecimal getTotalCustCost() {
        return this.totalCustCost;
    }

    public void setTotalCustCost(BigDecimal totalCustCost) {
        this.totalCustCost = totalCustCost;
    }

    public String getDispatchCountryCode() {
        return this.dispatchCountryCode;
    }

    public void setDispatchCountryCode(String dispatchCountryCode) {
        this.dispatchCountryCode = dispatchCountryCode;
    }

    public String getCurrencyCode() {
        return this.currencyCode;
    }

    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    public BigDecimal getCurrencyRate() {
        return this.currencyRate;
    }

    public void setCurrencyRate(BigDecimal currencyRate) {
        this.currencyRate = currencyRate;
    }

    public EDocumentStatusType getStatus() {
        return this.status;
    }

    public void setStatus(EDocumentStatusType status) {
        this.status = status;
    }

    public String getOriginalRequestXml() {
        return this.originalRequestXml;
    }

    public void setOriginalRequestXml(String originalRequestXml) {
        this.originalRequestXml = originalRequestXml;
    }

    public List<DocumentProductGtd> getProducts() {
        return this.products;
    }

    public void setProducts(List<DocumentProductGtd> products) {
        this.products = products;
    }

    public String getRelatedRegistrationNumber() {
        return "";
    }

    @Override
    public String getRegistrationNumber() {
        return this.number;
    }

    @Override
    public String getVersion() {
        return VERSION;
    }

    public Integer getKdtVersion() {
        return this.kdtVersion;
    }

    public void setKdtVersion(Integer kdtVersion) {
        this.kdtVersion = kdtVersion;
    }

    public String getCustomsModeCode() {
        return this.customsModeCode;
    }

    public void setCustomsModeCode(String customsModeCode) {
        this.customsModeCode = customsModeCode;
    }

    public String getBuyerName() {
        return this.buyerName;
    }

    public void setBuyerName(String buyerName) {
        this.buyerName = buyerName;
    }

    public EGtdDeclarationKindType getDeclarationKind() {
        return this.declarationKind;
    }

    public void setDeclarationKind(EGtdDeclarationKindType declarationKind) {
        this.declarationKind = declarationKind;
    }

    public boolean isIndividual() {
        return this.isIndividual;
    }

    public void setIndividual(boolean individual) {
        this.isIndividual = individual;
    }

    public Map<String, DocumentProductGtd> getProductByRowNumMap() {
        if (!CollectionUtils.isEmpty(this.products) && (this.productByRowNum == null || this.productByRowNum.isEmpty())) {
            this.productByRowNum = !this.hasSplittedGoods() ? Collections.unmodifiableMap(this.products.stream().collect(Collectors.toMap(DocumentProductGtd::getRowNum, Function.identity()))) : Collections.unmodifiableMap(this.products.stream().collect(Collectors.toMap(DocumentProductGtd::getInnerRowIndex, Function.identity())));
        }
        return this.productByRowNum;
    }

    public String getCategoryCode() {
        return this.categoryCode;
    }

    public void setCategoryCode(String categoryCode) {
        this.categoryCode = categoryCode;
    }

    public boolean hasSplittedGoods() {
        return CollectionUtils.isNotEmpty(this.getProducts()) && Boolean.TRUE.equals(this.getProducts().get(0).getSplittedGoods());
    }

    public Set<String> getPrecedingDocumentNumbers() {
        Set<String> result = Collections.emptySet();
        if (CollectionUtils.isNotEmpty(this.getProducts())) {
            result = this.getProducts().stream().map(DocumentProductGtd::getPrecedingDocumentNumbers).flatMap(Collection::stream).collect(Collectors.toSet());
        }
        return result;
    }

    public Map<String, DocumentProductGtd> getProductByRowNum() {
        return this.productByRowNum;
    }

    public void setProductByRowNum(Map<String, DocumentProductGtd> productByRowNum) {
        this.productByRowNum = productByRowNum;
    }

    public boolean isPackingDone() {
        return this.packingDone;
    }

    public void setPackingDone(boolean packingDone) {
        this.packingDone = packingDone;
    }

    public boolean isEditingDone() {
        return this.editingDone;
    }

    public void setEditingDone(boolean editingDone) {
        this.editingDone = editingDone;
    }

    public String getProcessingError() {
        return this.processingError;
    }

    public void setProcessingError(String processingError) {
        this.processingError = processingError;
    }

    public String getDestinationCountryCode() {
        return this.destinationCountryCode;
    }

    public void setDestinationCountryCode(String destinationCountryCode) {
        this.destinationCountryCode = destinationCountryCode;
    }

    public String getConsignorName() {
        return this.consignorName;
    }

    public void setConsignorName(String consignorName) {
        this.consignorName = consignorName;
    }

    public Date getGsvsDate() {
        return this.gsvsDate;
    }

    public void setGsvsDate(Date gsvsDate) {
        this.gsvsDate = gsvsDate;
    }

    public List<DocumentGtdRelation> getRelations() {
        return this.relations == null ? Collections.emptyList() : this.relations;
    }

    public void setRelations(List<DocumentGtdRelation> relations) {
        this.relations = relations;
    }

    public Set<DocumentProductGtd> getSplittedProducts() {
        return this.getProducts().stream().filter(product -> BooleanUtils.isTrue(product.getSplittedGoods())).collect(Collectors.toSet());
    }
}

