/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.vstore.model.saldo;

import java.math.BigDecimal;
import javax.xml.bind.annotation.Documentation;
import org.apache.commons.lang3.StringUtils;
import ru.uss.vstore.model.saldo.SaldoMovementType;

public class SaldoMovement {
    @Documentation(value="\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0441\u043a\u043b\u0430\u0434\u0430")
    private Long taxpayerStoreId;
    @Documentation(value="\u0414\u043e\u043f. \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0442\u043e\u0432\u0430\u0440\u0430")
    private Long productId;
    @Documentation(value="\u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 \u0442\u043e\u0432\u0430\u0440\u0430")
    private String name;
    @Documentation(value="\u0422\u041d\u0412\u0415\u0414-\u043a\u043e\u0434")
    private String tnvedCode;
    @Documentation(value="\u0422\u0438\u043f \u0434\u0432\u0438\u0436\u0435\u043d\u0438\u044f")
    private SaldoMovementType movementType;
    @Documentation(value="\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u0442\u043e\u0432\u0430\u0440\u0430")
    private BigDecimal quantity;
    @Documentation(value="\u0415\u0434\u0438\u043d\u0438\u0446\u0430 \u0438\u0437\u043c\u0435\u0440\u0435\u043d\u0438\u044f")
    private String measureUnitCode;
    public static String TNVED_UNKNOWN_CODE = "-";

    public SaldoMovement() {
    }

    public SaldoMovement(Long taxpayerStoreId, Long productId, String name, String tnvedCode, String movementType, BigDecimal quantity, String measureUnitCode) {
        this.taxpayerStoreId = taxpayerStoreId;
        this.productId = productId;
        this.name = name;
        this.tnvedCode = StringUtils.isBlank(tnvedCode) ? TNVED_UNKNOWN_CODE : tnvedCode;
        this.movementType = SaldoMovementType.valueOf(movementType);
        this.quantity = quantity == null ? BigDecimal.ZERO : quantity;
        this.measureUnitCode = measureUnitCode;
    }

    public Long getTaxpayerStoreId() {
        return this.taxpayerStoreId;
    }

    public void setTaxpayerStoreId(Long taxpayerStoreId) {
        this.taxpayerStoreId = taxpayerStoreId;
    }

    public Long getProductId() {
        return this.productId;
    }

    public void setProductId(Long productId) {
        this.productId = productId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTnvedCode() {
        return this.tnvedCode;
    }

    public void setTnvedCode(String tnvedCode) {
        this.tnvedCode = tnvedCode;
    }

    public SaldoMovementType getMovementType() {
        return this.movementType;
    }

    public void setMovementType(SaldoMovementType movementType) {
        this.movementType = movementType;
    }

    public BigDecimal getQuantity() {
        return this.quantity;
    }

    public void setQuantity(BigDecimal quantity) {
        this.quantity = quantity;
    }

    public String getCombinedKey() {
        return this.productId + "_" + this.taxpayerStoreId;
    }

    public String getMeasureUnitCode() {
        return this.measureUnitCode;
    }

    public void setMeasureUnitCode(String measureUnitCode) {
        this.measureUnitCode = measureUnitCode;
    }
}

