/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.vstore.model.store;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Objects;
import java.util.Set;
import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.Documentation;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.lang3.StringUtils;
import ru.uss.esf.model.DocumentParticipantType;
import ru.uss.vstore.model.dict.Gsvs;
import ru.uss.vstore.model.dict.GsvsMeta;
import ru.uss.vstore.model.dict.MeasureUnit;
import ru.uss.vstore.model.doc.ECustomsDutyType;
import ru.uss.vstore.model.doc.EOriginType;
import ru.uss.vstore.model.doc.VirtualLabelType;
import ru.uss.vstore.model.history.EHistoryOperationType;
import ru.uss.vstore.model.store.TaxpayerStore;
import ru.uss.vstore.utils.GsvsCodeUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="virtualLabel")
@XmlType(name="VirtualLabel")
@Documentation(value="\u0412\u0438\u0440\u0442\u0443\u0430\u043b\u044c\u043d\u0430\u044f \u043c\u0435\u0442\u043a\u0430")
public class VirtualLabel
implements Serializable {
    @XmlElement(required=true)
    @Documentation(value="\u041f\u0435\u0440\u0432\u0438\u0447\u043d\u044b\u0439 \u043a\u043b\u044e\u0447")
    private Long id;
    @Documentation(value="\u0420\u043e\u0434\u0438\u0442\u0435\u043b\u044c\u0441\u043a\u0430\u044f \u043c\u0435\u0442\u043a\u0430")
    private VirtualLabel parentVirtualLabel;
    @NotNull
    @XmlElement(required=true)
    @Documentation(value="\u041a\u043e\u0434 \u0432\u0438\u0440\u0442\u0443\u0430\u043b\u044c\u043d\u043e\u0439 \u043c\u0435\u0442\u043a\u0438")
    private String code;
    @NotNull
    @XmlElement(required=true)
    @Documentation(value="\u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 \u0422\u0420\u0423 \u0438\u0437 \u0443\u0447\u0435\u0442\u043d\u043e\u0439 \u0421\u0438\u0441\u0442\u0435\u043c\u044b \u041d\u041f")
    private String name;
    @XmlTransient
    @Documentation(value="\u041a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044f \u0442\u043e\u0432\u0430\u0440\u0430 \u0438\u0437 \u0413\u043b\u043e\u0431\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0430 \u0412\u0421")
    private Gsvs gsvs;
    @NotNull
    @XmlElement(required=true)
    @Documentation(value="\u041a\u043e\u0434 \u041a\u041f\u0412\u042d\u0414")
    private String kpvedCode;
    @NotNull
    @XmlElement(required=true)
    @Documentation(value="\u041a\u043e\u0434 \u0422\u041d\u0412\u042d\u0414 \u0415\u0410\u042d\u0421")
    private String tnvedCode;
    @XmlElement(required=false)
    @Documentation(value="\u041a\u043e\u0434 GTIN")
    private String gtinCode;
    @NotNull
    @XmlElement(required=true)
    @Documentation(value="\u0421\u043a\u0432\u043e\u0437\u043d\u043e\u0439 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0413\u0421\u0412\u0421 1 \u0443\u0440\u043e\u0432\u043d\u044f - \u041a\u041f\u0412\u042d\u0414")
    private Long kpvedFixedId;
    @NotNull
    @XmlElement(required=true)
    @Documentation(value="\u0421\u043a\u0432\u043e\u0437\u043d\u043e\u0439 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0413\u0421\u0412\u0421 2 \u0443\u0440\u043e\u0432\u043d\u044f - \u0422\u041d\u0412\u042d\u0414")
    private Long tnvedFixedId;
    @XmlElement(required=false)
    @Documentation(value="\u0421\u043a\u0432\u043e\u0437\u043d\u043e\u0439 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0413\u0421\u0412\u0421 3 \u0443\u0440\u043e\u0432\u043d\u044f - GTIN")
    private Long gtinFixedId;
    @XmlElement(required=false)
    @Documentation(value="\u0421\u043a\u0432\u043e\u0437\u043d\u043e\u0439 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0442\u043e\u0432\u0430\u0440\u0430 \u0432 \u043f\u0440\u0435\u0434\u0435\u043b\u0430\u0445 \u041d\u041f")
    private Long productId;
    @XmlElement(required=false)
    @Documentation(value="\u041f\u0440\u0435\u0434\u044b\u0434\u0443\u0449\u0438\u0439 \u0441\u043a\u0432\u043e\u0437\u043d\u043e\u0439 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0442\u043e\u0432\u0430\u0440\u0430 \u0432 \u043f\u0440\u0435\u0434\u0435\u043b\u0430\u0445 \u041d\u041f")
    private Long previousProductId;
    @XmlTransient
    @Documentation(value="\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0442\u043e\u0432\u0430\u0440\u0430 \u0434\u043b\u044f \u0443\u043a\u0430\u0437\u0430\u043d\u0438\u044f \u0432 \u0438\u0441\u0442\u043e\u0440\u0438\u0438 \u0412\u041c")
    private Long relationProductId;
    @NotNull
    @XmlElement(required=true)
    @Documentation(value="\u0422\u0438\u043f \u043f\u0440\u043e\u0438\u0441\u0445\u043e\u0436\u0434\u0435\u043d\u0438\u044f: \u0438\u043c\u043f\u043e\u0440\u0442 \u0438\u043b\u0438 \u043f\u0440\u043e\u0438\u0437\u0432\u043e\u0434\u0441\u0442\u0432\u043e")
    private EOriginType originType;
    @NotNull
    @XmlElement(required=true)
    @Documentation(value="\u041a\u043e\u0434 \u0441\u0442\u0440\u0430\u043d\u044b")
    private String countryCode;
    @NotNull
    @XmlElement(required=true)
    @Documentation(value="\u0422\u0438\u043f \u043f\u043e\u0448\u043b\u0438\u043d\u044b")
    private ECustomsDutyType dutyType = ECustomsDutyType.NOT_INSTALLED;
    @NotNull
    @XmlElement(required=true)
    @Documentation(value="\u041a\u043e\u0434 \u0435\u0434\u0438\u043d\u0438\u0446\u044b \u0438\u0437\u043c\u0435\u0440\u0435\u043d\u0438\u044f")
    private String measureUnitCode;
    @NotNull
    @XmlElement(required=true)
    @Documentation(value="\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e")
    private BigDecimal quantity;
    @XmlTransient
    @Documentation(value="\u041f\u0440\u0435\u0434\u044b\u0434\u0443\u0449\u0435\u0435 \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e (\u043a\u043e\u043d\u0432\u0435\u0440\u0442\u0438\u0440\u0443\u0435\u043c\u043e\u0435 \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e)")
    private BigDecimal previousQuantity;
    @NotNull
    @XmlElement(required=true)
    @Documentation(value="\u0426\u0435\u043d\u0430 \u0437\u0430 \u0435\u0434\u0438\u043d\u0438\u0446\u0443")
    private BigDecimal unitPrice;
    @XmlElement(required=true)
    @NotNull
    @Documentation(value="\u0414\u0430\u0442\u0430 \u0438 \u0432\u0440\u0435\u043c\u044f \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u044f \u043c\u0435\u0442\u043a\u0438")
    private Date createDate;
    @NotNull
    @XmlElement(required=true)
    @Documentation(value="\u0414\u0430\u0442\u0430 \u0438 \u0432\u0440\u0435\u043c\u044f \u043f\u043e\u0441\u043b\u0434\u0435\u043d\u0435\u0433\u043e \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f \u0412\u041c")
    private Date modifyDate;
    @XmlElement
    @Documentation(value="\u0414\u0430\u0442\u0430 \u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u043a\u0438 \u0412\u041c \u0434\u043b\u044f \u0441\u043f\u0438\u0441\u0430\u043d\u0438\u044f")
    private Date archiveDate;
    @XmlTransient
    @NotNull
    @Documentation(value="\u0421\u043a\u043b\u0430\u0434 \u041d\u041f, \u0433\u0434\u0435 \u043d\u0430\u0445\u043e\u0434\u0438\u0442\u0441\u044f \u0442\u043e\u0432\u0430\u0440")
    private TaxpayerStore taxpayerStore;
    @XmlElement(required=true)
    @NotNull
    @Documentation(value="\u0418\u0418\u041d/\u0411\u0418\u041d \u041d\u041f")
    private String tin;
    @XmlElement(required=true)
    @NotNull
    @Documentation(value="\u0424\u043e\u0440\u043c\u0430 \u043e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u0438 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f")
    private DocumentParticipantType participantType;
    @XmlElement(required=false)
    @Documentation(value="\u041a\u043e\u0434 \u043f\u0440\u043e\u0435\u043a\u0442\u0430")
    private Long projectCode;
    @XmlElement(required=false)
    @Documentation(value="\u041a\u043e\u0434 \u043c\u0430\u0440\u043a\u0438\u0440\u043e\u0432\u043a\u0438 (GTIN)")
    private String markingCode;
    @XmlElement(required=false)
    @Documentation(value="\u0424\u0438\u0437\u0438\u0447\u0435\u0441\u043a\u0430\u044f \u043c\u0435\u0442\u043a\u0430")
    private String physicalLabel;
    @XmlElement
    @Documentation(value="\u041e\u0441\u043d\u043e\u0432\u0430\u043d\u0438\u0435 \u0434\u043b\u044f \u0440\u0435\u043e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u0438")
    private String reorganizationReason;
    @XmlElement(required=false)
    @Documentation(value="\u2116 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430-\u043e\u0441\u043d\u043e\u0432\u0430\u043d\u0438\u044f \u0434\u043b\u044f \u0434\u0432\u0438\u0436\u0435\u043d\u0438\u044f \u043c\u0435\u0442\u043e\u043a")
    private String movementDoc;
    @XmlTransient
    @Documentation(value="\u041d\u043e\u043c\u0435\u0440 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430 \u043e\u0441\u043d\u043e\u0432\u0430\u043d\u0438\u044f \u0434\u043b\u044f \u0443\u043a\u0430\u0437\u0430\u043d\u0438\u044f \u0432 \u0438\u0441\u0442\u043e\u0440\u0438\u0438 \u0412\u041c")
    private String relationMovementDoc;
    @XmlElement(required=false)
    @Documentation(value="\u041d\u043e\u043c\u0435\u0440 \u0442\u043e\u0432\u0430\u0440\u043d\u043e\u0439 \u043f\u043e\u0437\u0438\u0446\u0438\u0438 \u0432 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0435-\u043e\u0441\u043d\u043e\u0432\u0430\u043d\u0438\u0438 \u0434\u043b\u044f \u0434\u0432\u0438\u0436\u0435\u043d\u0438\u044f \u043c\u0435\u0442\u043e\u043a")
    private String productNumberInMovementDoc;
    @NotNull
    @XmlElement(required=true)
    @Documentation(value="\u2116 \u043f\u0440\u0438\u0445\u043e\u0434\u043d\u043e\u0433\u043e \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430")
    private String receiptDocNumber;
    @Documentation(value="\u041d\u043e\u043c\u0435\u0440 \u0442\u043e\u0432\u0430\u0440\u043d\u043e\u0439 \u043f\u043e\u0437\u0438\u0446\u0438\u0438 \u0432 \u043f\u0440\u0438\u0445\u043e\u0434\u043d\u043e\u043c \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0435")
    @XmlElement(required=false)
    private String productNumberInReceiptDoc;
    @XmlElement
    @Documentation(value="\u041d\u043e\u043c\u0435\u0440 \u0432\u0435\u0440\u0441\u0438\u0438 \u0438\u043c\u043f\u0440\u043e\u0442\u043d\u043e\u0433\u043e \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430")
    private String importDocVersion;
    @XmlElement(required=false)
    @Documentation(value="\u2116 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430 \u043f\u0440\u043e\u0438\u0437\u0432\u043e\u0434\u0441\u0442\u0432\u0430/\u0438\u043c\u043f\u043e\u0440\u0442\u0430 (\u0414\u0422, \u0424\u041d\u041e 328.00, CT-KZ, CT-1)")
    private String manufactureOrImportDocNumber;
    @XmlElement(required=false)
    @Documentation(value="\u041d\u043e\u043c\u0435\u0440 \u0442\u043e\u0432\u0430\u0440\u043d\u043e\u0439 \u043f\u043e\u0437\u0438\u0446\u0438\u0438 \u0438\u0437 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430 \u0438\u043c\u043f\u043e\u0440\u0442\u0430 (\u0414\u0422 \u0438\u043b\u0438 \u0424\u041d\u041e 328.00)")
    private String productNumberInImportDoc;
    @XmlElement
    @Documentation(value="\u0414\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0439 \u043d\u043e\u043c\u0435\u0440 \u0442\u043e\u0432\u0430\u0440\u043d\u043e\u0439 \u043f\u043e\u0437\u0438\u0446\u0438\u0438 \u0438\u0437 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430 \u0438\u043c\u043f\u043e\u0440\u0442\u0430 (\u0414\u0422 \u0438\u043b\u0438 \u0424\u041d\u041e 328.00)")
    private String additionalProductNumberInImportDoc;
    @XmlElement(required=false)
    @Documentation(value="\u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 \u0442\u043e\u0432\u0430\u0440\u043e\u0432 \u0432 \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0438\u0438 \u0441 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u043e\u043c \u0438\u043c\u043f\u043e\u0440\u0442\u0430 (\u0414\u0422 \u0438\u043b\u0438 \u0424\u041d\u041e 328.00)")
    private String productNameInImportDoc;
    @NotNull
    @XmlElement(required=true)
    @Documentation(value="\u0421\u0442\u0430\u0442\u0443\u0441 \u0412\u041c")
    private Boolean isActive;
    @NotNull
    @XmlElement
    @Documentation(value="\u0415\u0434\u0438\u043d\u0438\u0446\u0430 \u0438\u0437\u043c\u0435\u0440\u0435\u043d\u0438\u044f")
    private MeasureUnit measureUnit;
    @NotNull
    @XmlElement(required=true)
    @Documentation(value="\u0412\u043e\u0437\u043c\u043e\u0436\u0435\u043d \u044d\u043a\u0441\u043f\u043e\u0440\u0442")
    private Boolean canExport;
    @XmlTransient
    @Documentation(value="\u0414\u043e\u0447\u0435\u0440\u043d\u0438\u0435 \u043c\u0435\u0442\u043a\u0438")
    private Set<VirtualLabel> children;
    @NotNull
    @XmlElement(required=true)
    @Documentation(value="\u041a\u043e\u0434 \u0442\u0438\u043f\u0430 \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u0438")
    private EHistoryOperationType operationType;
    @XmlElement
    @Documentation(value="\u0422\u0438\u043f \u0432\u0438\u0440\u0442\u0443\u0430\u043b\u044c\u043d\u043e\u0439 \u043c\u0435\u0442\u043a\u0438")
    private VirtualLabelType type;
    @XmlTransient
    private VirtualLabelType actualType;
    @XmlElement
    @Documentation(value="\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u0432 \u0440\u0435\u0437\u0435\u0440\u0432\u0435")
    private BigDecimal reservedQuantity;
    @XmlElement(required=false)
    @Documentation(value="\u041a\u0440\u0435\u043f\u043e\u0441\u0442\u044c (% \u0441\u043e\u0434\u0435\u0440\u0436\u0430\u043d\u0438\u044f \u0441\u043f\u0438\u0440\u0442\u0430)")
    private BigDecimal spiritPercent;
    @XmlElement
    @Documentation(value="\u0424\u043b\u0430\u0433 \u043e\u043f\u0442\u043e\u0432\u0438\u043a\u0430")
    private Boolean isWholeSaler;
    @XmlElement
    @Documentation(value="\u0424\u043b\u0430\u0433 \u043a\u043e\u043d\u0444\u0438\u0441\u043a\u043e\u0432\u0430\u043d\u043d\u043e\u0433\u043e \u0442\u043e\u0432\u0430\u0440\u0430")
    private Boolean confiscated;
    @XmlElement
    @Documentation(value="\u0424\u043b\u0430\u0433 \u043a\u043e\u043d\u0435\u0447\u043d\u043e\u0433\u043e \u043f\u043e\u0442\u0440\u0435\u0431\u0438\u0442\u0435\u043b\u044f. \u0417\u0430\u043f\u0440\u0435\u0442 \u043d\u0430 \u0434\u0430\u043b\u044c\u043d\u0435\u0439\u0448\u0435\u0435 \u0434\u0432\u0438\u0436\u0435\u043d\u0438\u0435 \u043f\u043e \u0421\u041d\u0422")
    private Boolean finalEndUser;
    @XmlElement(required=false)
    @Documentation(value="\u041f\u0438\u043d-\u043a\u043e\u0434")
    private String pinCode;
    @XmlElement
    @Documentation(value="\u0422\u0438\u043f \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430")
    private String documentType;
    @XmlElement
    @Documentation(value="\u0414\u043e\u043f. \u0442\u0438\u043f \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430")
    private String documentSubType;
    @JsonIgnore
    @XmlTransient
    private boolean deactivateFlag;
    @JsonIgnore
    @XmlTransient
    private boolean isRemoveParentRelation;
    @JsonIgnore
    @XmlTransient
    private boolean isCreateParentRelation;
    @JsonIgnore
    @XmlTransient
    private String unlinkedMovementDoc;
    @JsonIgnore
    @XmlTransient
    private boolean isSkipPreviousHistory;
    @JsonIgnore
    @XmlTransient
    private int level;
    @JsonIgnore
    @XmlTransient
    private BigDecimal margin;
    @JsonIgnore
    @XmlTransient
    private boolean needNewProductId;
    @JsonIgnore
    @XmlTransient
    private boolean markParentAsInactiveForever;
    @JsonIgnore
    @XmlTransient
    private boolean markPublishDebtByGtin;
    @JsonIgnore
    @XmlTransient
    private boolean markPublishDebtByProductId;
    @JsonIgnore
    @XmlTransient
    private boolean collapseVm;
    @XmlElement
    private VirtualLabelType parentRelatonVmType;

    public VirtualLabel(VirtualLabel anotherVirtualLabel) {
        this.parentVirtualLabel = anotherVirtualLabel.parentVirtualLabel;
        this.gsvs = anotherVirtualLabel.gsvs;
        this.name = anotherVirtualLabel.name;
        this.originType = anotherVirtualLabel.originType;
        this.countryCode = anotherVirtualLabel.countryCode;
        this.kpvedCode = anotherVirtualLabel.kpvedCode;
        this.tnvedCode = anotherVirtualLabel.tnvedCode;
        this.gtinCode = anotherVirtualLabel.gtinCode;
        this.kpvedFixedId = anotherVirtualLabel.kpvedFixedId;
        this.tnvedFixedId = anotherVirtualLabel.tnvedFixedId;
        this.gtinFixedId = anotherVirtualLabel.gtinFixedId;
        this.productId = anotherVirtualLabel.productId;
        this.previousProductId = anotherVirtualLabel.previousProductId;
        this.dutyType = anotherVirtualLabel.dutyType;
        this.measureUnitCode = anotherVirtualLabel.measureUnitCode;
        this.quantity = anotherVirtualLabel.quantity;
        this.unitPrice = anotherVirtualLabel.unitPrice;
        this.receiptDocNumber = anotherVirtualLabel.receiptDocNumber;
        this.productNumberInReceiptDoc = anotherVirtualLabel.productNumberInReceiptDoc;
        this.importDocVersion = anotherVirtualLabel.importDocVersion;
        this.manufactureOrImportDocNumber = anotherVirtualLabel.manufactureOrImportDocNumber;
        this.productNumberInImportDoc = anotherVirtualLabel.productNumberInImportDoc;
        this.additionalProductNumberInImportDoc = anotherVirtualLabel.additionalProductNumberInImportDoc;
        this.productNameInImportDoc = anotherVirtualLabel.productNameInImportDoc;
        this.movementDoc = anotherVirtualLabel.movementDoc;
        this.productNumberInMovementDoc = anotherVirtualLabel.productNumberInMovementDoc;
        this.createDate = new Date();
        this.taxpayerStore = anotherVirtualLabel.taxpayerStore;
        this.tin = anotherVirtualLabel.tin;
        this.participantType = anotherVirtualLabel.participantType;
        this.projectCode = anotherVirtualLabel.projectCode;
        this.physicalLabel = anotherVirtualLabel.physicalLabel;
        this.markingCode = anotherVirtualLabel.markingCode;
        this.reorganizationReason = anotherVirtualLabel.reorganizationReason;
        this.isActive = true;
        this.reservedQuantity = anotherVirtualLabel.reservedQuantity;
        this.measureUnit = anotherVirtualLabel.measureUnit;
        this.canExport = anotherVirtualLabel.isCanExport();
        this.modifyDate = new Date();
        this.operationType = anotherVirtualLabel.operationType;
        this.needNewProductId = anotherVirtualLabel.needNewProductId;
        this.confiscated = anotherVirtualLabel.confiscated;
        this.isWholeSaler = anotherVirtualLabel.isWholeSaler;
        this.pinCode = anotherVirtualLabel.pinCode;
        this.spiritPercent = anotherVirtualLabel.spiritPercent;
        this.type = anotherVirtualLabel.type;
        this.finalEndUser = anotherVirtualLabel.finalEndUser;
        this.archiveDate = anotherVirtualLabel.archiveDate;
        this.isSkipPreviousHistory = anotherVirtualLabel.isSkipPreviousHistory;
    }

    public static VirtualLabel emptyInstance() {
        return new VirtualLabel();
    }

    @XmlElement(required=true)
    @Documentation(value="\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0441\u043a\u043b\u0430\u0434\u0430 \u041d\u041f")
    public Long getTaxpayerStoreId() {
        return this.taxpayerStore != null ? this.taxpayerStore.getId() : null;
    }

    public VirtualLabel() {
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public VirtualLabel getParentVirtualLabel() {
        return this.parentVirtualLabel;
    }

    public Long getParentVirtualLabelId() {
        if (this.parentVirtualLabel != null) {
            return this.parentVirtualLabel.getId();
        }
        return null;
    }

    public void setParentVirtualLabel(VirtualLabel parentVirtualLabel) {
        this.parentVirtualLabel = parentVirtualLabel;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Gsvs getGsvs() {
        return this.gsvs;
    }

    public void setGsvs(Gsvs gsvs) {
        this.gsvs = gsvs;
    }

    public EOriginType getOriginType() {
        return this.originType;
    }

    public void setOriginType(EOriginType originType) {
        this.originType = originType;
    }

    public String getCountryCode() {
        return this.countryCode;
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public String getTnvedCode() {
        return this.tnvedCode;
    }

    public void setTnvedCode(String tnvedCode) {
        this.tnvedCode = tnvedCode;
    }

    public ECustomsDutyType getDutyType() {
        return this.dutyType;
    }

    public void setDutyType(ECustomsDutyType dutyType) {
        this.dutyType = dutyType;
    }

    public String getMeasureUnitCode() {
        return this.measureUnitCode;
    }

    public void setMeasureUnitCode(String measureUnitCode) {
        this.measureUnitCode = measureUnitCode;
    }

    public BigDecimal getQuantity() {
        return this.quantity;
    }

    public void setQuantity(BigDecimal quantity) {
        this.quantity = quantity;
    }

    public BigDecimal getPreviousQuantity() {
        return this.previousQuantity;
    }

    public void setPreviousQuantity(BigDecimal previousQuantity) {
        this.previousQuantity = previousQuantity;
    }

    public BigDecimal getUnitPrice() {
        return this.unitPrice;
    }

    public void setUnitPrice(BigDecimal unitPrice) {
        this.unitPrice = unitPrice;
    }

    public String getReceiptDocNumber() {
        return this.receiptDocNumber;
    }

    public void setReceiptDocNumber(String receiptDocNumber) {
        this.receiptDocNumber = receiptDocNumber;
    }

    public String getProductNumberInReceiptDoc() {
        return this.productNumberInReceiptDoc;
    }

    public void setProductNumberInReceiptDoc(String productNumberInReceiptDoc) {
        this.productNumberInReceiptDoc = productNumberInReceiptDoc;
    }

    public Date getCreateDate() {
        return this.createDate;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    public TaxpayerStore getTaxpayerStore() {
        return this.taxpayerStore;
    }

    public void setTaxpayerStore(TaxpayerStore taxpayerStore) {
        this.taxpayerStore = taxpayerStore;
    }

    public String getTin() {
        return this.tin;
    }

    public void setTin(String tin) {
        this.tin = tin;
    }

    public DocumentParticipantType getParticipantType() {
        return this.participantType;
    }

    public void setParticipantType(DocumentParticipantType participantType) {
        this.participantType = participantType;
    }

    public Long getProjectCode() {
        return this.projectCode;
    }

    public void setProjectCode(Long projectCode) {
        this.projectCode = projectCode;
    }

    public String getPhysicalLabel() {
        return this.physicalLabel;
    }

    public void setPhysicalLabel(String physicalLabel) {
        this.physicalLabel = physicalLabel;
    }

    public String getReorganizationReason() {
        return this.reorganizationReason;
    }

    public void setReorganizationReason(String reorganizationReason) {
        this.reorganizationReason = reorganizationReason;
    }

    public String getImportDocVersion() {
        return this.importDocVersion;
    }

    public void setImportDocVersion(String importDocVersion) {
        this.importDocVersion = importDocVersion;
    }

    public String getManufactureOrImportDocNumber() {
        return this.manufactureOrImportDocNumber;
    }

    public void setManufactureOrImportDocNumber(String manufactureOrImportDocNumber) {
        this.manufactureOrImportDocNumber = manufactureOrImportDocNumber;
    }

    public String getProductNumberInImportDoc() {
        return this.productNumberInImportDoc;
    }

    public void setProductNumberInImportDoc(String productNumberInImportDoc) {
        this.productNumberInImportDoc = productNumberInImportDoc;
    }

    public String getAdditionalProductNumberInImportDoc() {
        return this.additionalProductNumberInImportDoc;
    }

    public void setAdditionalProductNumberInImportDoc(String additionalProductNumberInImportDoc) {
        this.additionalProductNumberInImportDoc = additionalProductNumberInImportDoc;
    }

    public String getProductNameInImportDoc() {
        return this.productNameInImportDoc;
    }

    public void setProductNameInImportDoc(String productNameInImportDoc) {
        this.productNameInImportDoc = productNameInImportDoc;
    }

    public String getMovementDoc() {
        return this.movementDoc;
    }

    public void setMovementDoc(String movementDoc) {
        this.movementDoc = movementDoc;
    }

    public String getProductNumberInMovementDoc() {
        return this.productNumberInMovementDoc;
    }

    public void setProductNumberInMovementDoc(String productNumberInMovementDoc) {
        this.productNumberInMovementDoc = productNumberInMovementDoc;
    }

    public Boolean isActive() {
        return this.isActive;
    }

    public void setActive(Boolean active) {
        this.isActive = active;
    }

    public MeasureUnit getMeasureUnit() {
        return this.measureUnit;
    }

    public void setMeasureUnit(MeasureUnit measureUnit) {
        this.measureUnit = measureUnit;
    }

    public Date getModifyDate() {
        return this.modifyDate;
    }

    public void setModifyDate(Date modifyDate) {
        this.modifyDate = modifyDate;
    }

    public Date getArchiveDate() {
        return this.archiveDate;
    }

    public void setArchiveDate(Date archiveDate) {
        this.archiveDate = archiveDate;
    }

    public Set<VirtualLabel> getChildren() {
        return this.children;
    }

    public void setChildren(Set<VirtualLabel> children) {
        this.children = children;
    }

    public Long getKpvedFixedId() {
        return this.kpvedFixedId;
    }

    public void setKpvedFixedId(Long kpvedFixedId) {
        this.kpvedFixedId = kpvedFixedId;
    }

    public Long getTnvedFixedId() {
        return this.tnvedFixedId;
    }

    public void setTnvedFixedId(Long tnvedFixedId) {
        this.tnvedFixedId = tnvedFixedId;
    }

    public Long getGtinFixedId() {
        return this.gtinFixedId;
    }

    public void setGtinFixedId(Long gtinFixedId) {
        this.gtinFixedId = gtinFixedId;
    }

    public Long getProductId() {
        return this.productId;
    }

    public void setProductId(Long productId) {
        this.productId = productId;
    }

    public Long getPreviousProductId() {
        return this.previousProductId;
    }

    public void setPreviousProductId(Long previousProductId) {
        this.previousProductId = previousProductId;
    }

    public String getKpvedCode() {
        return this.kpvedCode;
    }

    public void setKpvedCode(String kpvedCode) {
        this.kpvedCode = kpvedCode;
    }

    public String getGtinCode() {
        return this.gtinCode;
    }

    public void setGtinCode(String gtinCode) {
        this.gtinCode = gtinCode;
    }

    public Boolean isCanExport() {
        return this.canExport;
    }

    public void setCanExport(Boolean canExport) {
        this.canExport = canExport;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public Boolean getActive() {
        return this.isActive;
    }

    public Boolean getCanExport() {
        return this.canExport;
    }

    public BigDecimal getReservedQuantity() {
        return this.reservedQuantity;
    }

    public void setReservedQuantity(BigDecimal reservedQuantity) {
        this.reservedQuantity = reservedQuantity;
    }

    public VirtualLabelType getType() {
        return this.type;
    }

    public void setType(VirtualLabelType type) {
        this.type = type;
    }

    public VirtualLabelType getActualType() {
        return this.actualType;
    }

    public void setActualType(VirtualLabelType actualType) {
        this.actualType = actualType;
    }

    public BigDecimal getMargin() {
        return this.margin;
    }

    public void setMargin(BigDecimal margin) {
        this.margin = margin;
    }

    public boolean needNewProductId() {
        return this.needNewProductId;
    }

    public void setNeedNewProductId(boolean needNewProductId) {
        this.needNewProductId = needNewProductId;
    }

    public void enableNewProductIdGeneration() {
        this.needNewProductId = true;
    }

    public boolean isDeactivateFlag() {
        return this.deactivateFlag;
    }

    public void setDeactivateFlag(boolean deactivateFlag) {
        this.deactivateFlag = deactivateFlag;
    }

    public Boolean getWholeSaler() {
        return this.isWholeSaler;
    }

    public void setWholeSaler(Boolean wholeSaler) {
        this.isWholeSaler = wholeSaler;
    }

    public String getPinCode() {
        return this.pinCode;
    }

    public void setPinCode(String pinCode) {
        this.pinCode = pinCode;
    }

    public Boolean getConfiscated() {
        return this.confiscated;
    }

    public void setConfiscated(Boolean confiscated) {
        this.confiscated = confiscated;
    }

    public String getMarkingCode() {
        return this.markingCode;
    }

    public void setMarkingCode(String markingCode) {
        this.markingCode = markingCode;
    }

    public String getGsvsCode() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getKpvedCode());
        builder.append(!StringUtils.isEmpty(this.tnvedCode) ? "-" + this.tnvedCode : "");
        builder.append(!StringUtils.isEmpty(this.gtinCode) ? "/" + this.gtinCode : "");
        return builder.toString();
    }

    public Boolean getFinalEndUser() {
        return this.finalEndUser;
    }

    public void setFinalEndUser(Boolean finalEndUser) {
        this.finalEndUser = finalEndUser;
    }

    public BigDecimal getSpiritPercent() {
        return this.spiritPercent;
    }

    public void setSpiritPercent(BigDecimal spiritPercent) {
        this.spiritPercent = spiritPercent;
    }

    public EHistoryOperationType getOperationType() {
        return this.operationType;
    }

    public void setOperationType(EHistoryOperationType operationType) {
        this.operationType = operationType;
    }

    public String getDocumentType() {
        return this.documentType;
    }

    public void setDocumentType(String documentType) {
        this.documentType = documentType;
    }

    public String getDocumentSubType() {
        return this.documentSubType;
    }

    public void setDocumentSubType(String documentSubType) {
        this.documentSubType = documentSubType;
    }

    public boolean isMarkParentAsInactiveForever() {
        return this.markParentAsInactiveForever;
    }

    public void markParentAsInactiveForever() {
        this.markParentAsInactiveForever = true;
    }

    public void enableCollapseVm() {
        this.collapseVm = true;
    }

    public boolean isCollapseVm() {
        return this.collapseVm;
    }

    public boolean isMarkPublishDebtByGtin() {
        return this.markPublishDebtByGtin;
    }

    public boolean isMarkPublishDebtByProductId() {
        return this.markPublishDebtByProductId;
    }

    public void markPublishDebtByGtin() {
        this.markPublishDebtByGtin = true;
    }

    public void markPublishDebtByProductId() {
        this.markPublishDebtByProductId = true;
    }

    public String generatePublishLabel(String repayDebtType) {
        return repayDebtType + "_" + this.getTin() + "_" + this.getGtinCode();
    }

    public void mergeWithParent(VirtualLabel parent) {
        if (parent != null) {
            this.parentVirtualLabel = parent;
            this.originType = parent.originType;
            this.countryCode = parent.countryCode;
            this.dutyType = parent.dutyType;
            this.receiptDocNumber = parent.receiptDocNumber;
            this.productNumberInReceiptDoc = parent.productNumberInReceiptDoc;
            this.importDocVersion = parent.importDocVersion;
            this.manufactureOrImportDocNumber = parent.manufactureOrImportDocNumber;
            this.productNumberInImportDoc = this.productNumberInImportDoc == null ? parent.productNumberInImportDoc : this.productNumberInImportDoc;
            String string = this.additionalProductNumberInImportDoc = this.additionalProductNumberInImportDoc == null ? parent.additionalProductNumberInImportDoc : this.additionalProductNumberInImportDoc;
            if (StringUtils.isBlank(this.productNameInImportDoc)) {
                this.productNameInImportDoc = parent.productNameInImportDoc;
            }
            this.name = StringUtils.isEmpty(this.name) ? parent.name : this.name;
            this.physicalLabel = StringUtils.isEmpty(this.physicalLabel) ? parent.physicalLabel : this.physicalLabel;
            this.markingCode = StringUtils.isEmpty(this.markingCode) ? parent.markingCode : this.markingCode;
            this.kpvedFixedId = this.kpvedFixedId == null ? parent.kpvedFixedId : this.kpvedFixedId;
            this.tnvedFixedId = this.tnvedFixedId == null ? parent.tnvedFixedId : this.tnvedFixedId;
            this.gtinFixedId = this.gtinFixedId == null ? parent.gtinFixedId : this.gtinFixedId;
            this.kpvedCode = StringUtils.isEmpty(this.kpvedCode) ? parent.kpvedCode : this.kpvedCode;
            this.tnvedCode = StringUtils.isEmpty(this.tnvedCode) ? parent.tnvedCode : this.tnvedCode;
            this.gtinCode = StringUtils.isEmpty(this.gtinCode) ? parent.gtinCode : this.gtinCode;
            BigDecimal bigDecimal = this.unitPrice = this.unitPrice == null ? parent.unitPrice : this.unitPrice;
            if (this.measureUnit == null) {
                this.measureUnit = parent.measureUnit;
                this.measureUnitCode = parent.measureUnitCode;
            }
            if (Objects.equals(this.tin, parent.tin) && !this.needNewProductId) {
                this.productId = parent.productId;
            }
            this.previousProductId = parent.productId;
            this.canExport = this.canExport == null ? parent.canExport : this.canExport;
            this.pinCode = StringUtils.isEmpty(this.pinCode) ? parent.getPinCode() : this.pinCode;
            this.spiritPercent = this.spiritPercent == null ? parent.getSpiritPercent() : this.spiritPercent;
            this.isWholeSaler = this.isWholeSaler == null ? parent.getWholeSaler() : this.isWholeSaler;
            this.confiscated = this.getConfiscated() == null ? parent.getConfiscated() : this.confiscated;
            this.type = parent.getType();
            this.archiveDate = parent.getArchiveDate();
            this.finalEndUser = parent.getFinalEndUser();
        }
    }

    public void setGsvsData(GsvsMeta gsvsMeta) {
        if (gsvsMeta != null) {
            this.kpvedFixedId = gsvsMeta.getKpvedFixedId();
            this.tnvedFixedId = gsvsMeta.getTnvedFixedId();
            this.gtinFixedId = gsvsMeta.getGtinFixedId();
            this.kpvedCode = gsvsMeta.getKpvedCode();
            this.tnvedCode = gsvsMeta.getTnvedCode();
            this.gtinCode = gsvsMeta.getGtinCode();
        }
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.parentVirtualLabel, this.gsvs, this.originType, this.countryCode, this.kpvedCode, this.tnvedCode, this.gtinCode, this.dutyType, this.measureUnitCode, this.quantity, this.unitPrice, this.receiptDocNumber, this.productNumberInReceiptDoc, this.reorganizationReason, this.manufactureOrImportDocNumber, this.productNameInImportDoc, this.productNumberInImportDoc, this.movementDoc, this.productNumberInMovementDoc, this.projectCode, this.participantType, this.tin, this.taxpayerStore, this.markingCode, this.physicalLabel, this.operationType, this.canExport, this.isActive, this.createDate, this.name, this.productId, this.previousProductId});
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof VirtualLabel)) {
            return false;
        }
        VirtualLabel other = (VirtualLabel)obj;
        return Objects.equals(this.parentVirtualLabel, other.parentVirtualLabel) && Objects.equals(this.gsvs, other.gsvs) && Objects.equals(this.name, other.name) && Objects.equals(this.productId, other.productId) && Objects.equals(this.previousProductId, other.previousProductId) && Objects.equals((Object)this.originType, (Object)other.originType) && Objects.equals(this.countryCode, other.countryCode) && Objects.equals(this.kpvedCode, other.kpvedCode) && Objects.equals(this.gtinCode, other.gtinCode) && Objects.equals(this.tnvedCode, other.tnvedCode) && Objects.equals((Object)this.dutyType, (Object)other.dutyType) && Objects.equals(this.measureUnitCode, other.measureUnitCode) && Objects.equals(this.quantity, other.quantity) && Objects.equals(this.unitPrice, other.unitPrice) && Objects.equals(this.receiptDocNumber, other.receiptDocNumber) && Objects.equals(this.productNumberInReceiptDoc, other.productNumberInReceiptDoc) && Objects.equals(this.importDocVersion, other.importDocVersion) && Objects.equals(this.manufactureOrImportDocNumber, other.manufactureOrImportDocNumber) && Objects.equals(this.productNumberInImportDoc, other.productNumberInImportDoc) && Objects.equals(this.productNameInImportDoc, other.productNameInImportDoc) && Objects.equals(this.movementDoc, other.movementDoc) && Objects.equals(this.productNumberInMovementDoc, other.productNumberInMovementDoc) && Objects.equals(this.createDate, other.createDate) && Objects.equals(this.taxpayerStore, other.taxpayerStore) && Objects.equals(this.projectCode, other.projectCode) && Objects.equals((Object)this.participantType, (Object)other.participantType) && Objects.equals(this.tin, other.tin) && Objects.equals(this.markingCode, other.markingCode) && Objects.equals(this.physicalLabel, other.physicalLabel) && Objects.equals(this.reorganizationReason, other.reorganizationReason) && Objects.equals(this.isActive, other.isActive) && Objects.equals(this.measureUnit, other.measureUnit) && Objects.equals(this.canExport, other.canExport) && Objects.equals(this.modifyDate, other.modifyDate) && Objects.equals((Object)this.operationType, (Object)other.operationType) && Objects.equals(this.finalEndUser, other.finalEndUser) && Objects.equals(this.spiritPercent, other.spiritPercent) && Objects.equals(this.pinCode, other.pinCode) && Objects.equals(this.reservedQuantity, other.reservedQuantity) && Objects.equals((Object)this.type, (Object)other.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName() + "[");
        sb.append("id=" + this.id).append(this.parentVirtualLabel != null ? ", parentId=" + this.parentVirtualLabel.getId() : "").append(this.productId != null ? ", productId=" + this.productId : "").append(this.previousProductId != null ? ", previousProductId=" + this.previousProductId : "").append(this.operationType != null ? ", operationType=" + this.operationType.name() : "").append(", tin=").append(this.tin).append(this.taxpayerStore != null ? String.format(" (%d, %d)", this.taxpayerStore.getId(), this.taxpayerStore.getProjectCode()) : "").append(this.quantity != null ? ", quantity=" + this.quantity.doubleValue() : "").append(!StringUtils.isEmpty(this.movementDoc) ? ", movementDoc=" + this.movementDoc : "").append(this.productNumberInMovementDoc != null ? String.format(" (%s)", this.productNumberInMovementDoc) : "").append(this.projectCode != null ? ", projectCode=" + this.projectCode : "").append(this.participantType != null ? ", participantType=" + (Object)((Object)this.participantType) : "").append(", gsvsCode=").append(this.getGsvsCode()).append(", measureUnit=").append(this.measureUnit != null ? String.format(" %s-%s (%d)", this.measureUnit.getCode(), this.measureUnit.getNameRu(), this.measureUnit.getId()) : null).append(!StringUtils.isEmpty(this.manufactureOrImportDocNumber) ? ", manufactureOrImportDocNumber=" + this.manufactureOrImportDocNumber : "").append(this.productNumberInImportDoc != null ? String.format(" (%s)", this.productNumberInImportDoc) : "").append(!StringUtils.isEmpty(this.productNameInImportDoc) ? ", productNameInImportDoc=" + this.productNameInImportDoc : "").append(!StringUtils.isEmpty(this.receiptDocNumber) ? ", receiptDocNumber=" + this.receiptDocNumber : "").append(this.productNumberInReceiptDoc != null ? String.format(" (%s)", this.productNumberInReceiptDoc) : "").append(!StringUtils.isEmpty(this.physicalLabel) ? ", physicalLabel=" + this.physicalLabel : "").append(!StringUtils.isEmpty(this.markingCode) ? ", markingCode=" + this.markingCode : "").append(this.originType != null ? ", originType=" + this.originType.name() : "").append(!StringUtils.isEmpty(this.countryCode) ? ", countryCode=" + this.countryCode : "").append(this.dutyType != null ? ", dutyType=" + this.dutyType.name() : "").append(this.unitPrice != null ? ", unitPrice=" + this.unitPrice.doubleValue() : "").append(!StringUtils.isEmpty(this.reorganizationReason) ? ", reorganizationReason=" + this.reorganizationReason : "").append(this.canExport != null ? ", canExport=" + this.canExport : "").append(this.createDate != null ? ", createDate=" + this.createDate : "").append(this.modifyDate != null ? ", modifyDate=" + this.modifyDate : "").append(!StringUtils.isEmpty(this.code) ? ", code=" + this.code : "").append(", isActive=" + this.isActive).append(!StringUtils.isEmpty(this.name) ? ", name=" + this.name : "").append("]");
        return sb.toString();
    }

    public static VirtualLabel createPrototype(String tin, TaxpayerStore store, EOriginType originType, String countryCode, ECustomsDutyType dutyType, String receiptDocNumber) {
        VirtualLabel label = new VirtualLabel();
        label.setTin(tin);
        label.setTaxpayerStore(store);
        label.setOriginType(originType);
        label.setCountryCode(countryCode);
        label.setDutyType(dutyType);
        label.setReceiptDocNumber(receiptDocNumber);
        label.setOperationType(EHistoryOperationType.CREATED);
        return label;
    }

    public String getExtendedProductId() {
        String extendedProductId = this.kpvedCode + "-" + this.tnvedCode;
        if (this.gtinCode != null) {
            extendedProductId = extendedProductId + "/" + this.gtinCode;
        }
        if (this.physicalLabel != null) {
            extendedProductId = extendedProductId + GsvsCodeUtils.formatPhysicalLabel(this.physicalLabel);
        }
        extendedProductId = extendedProductId + GsvsCodeUtils.formatProductId(this.productId);
        if (this.pinCode != null) {
            extendedProductId = extendedProductId + GsvsCodeUtils.formatPinCode(this.pinCode);
        }
        return extendedProductId;
    }

    public Long getMeasureUnitId() {
        return this.measureUnit == null ? null : this.measureUnit.getId();
    }

    public String getMovementDocKey() {
        return this.movementDoc + "_" + this.productNumberInMovementDoc;
    }

    public String getImportDocKey() {
        return this.manufactureOrImportDocNumber + "_" + this.productNumberInImportDoc + "_" + this.tin;
    }

    public String getProductIdKey() {
        return this.productId + "_" + this.tin;
    }

    public Long getRelationProductId() {
        return this.relationProductId;
    }

    public void setRelationProductId(Long relationProductId) {
        this.relationProductId = relationProductId;
    }

    public String getRelationMovementDoc() {
        return this.relationMovementDoc;
    }

    public void setRelationMovementDoc(String relationMovementDoc) {
        this.relationMovementDoc = relationMovementDoc;
    }

    public VirtualLabelType getParentRelatonVmType() {
        return this.parentRelatonVmType;
    }

    public void setParentRelatonVmType(VirtualLabelType parentRelatonVmType) {
        this.parentRelatonVmType = parentRelatonVmType;
    }

    public boolean isRemoveParentRelation() {
        return this.isRemoveParentRelation;
    }

    public void setRemoveParentRelation(boolean removeParentRelation) {
        this.isRemoveParentRelation = removeParentRelation;
    }

    public String getUnlinkedMovementDoc() {
        return this.unlinkedMovementDoc;
    }

    public void setUnlinkedMovementDoc(String unlinkedMovementDoc) {
        this.unlinkedMovementDoc = unlinkedMovementDoc;
    }

    public boolean isCreateParentRelation() {
        return this.isCreateParentRelation;
    }

    public void setCreateParentRelation(boolean createParentRelation) {
        this.isCreateParentRelation = createParentRelation;
    }

    public String getMovementNumProductKey() {
        return this.movementDoc + "_" + this.productNumberInMovementDoc;
    }

    public boolean isSkipPreviousHistory() {
        return this.isSkipPreviousHistory;
    }

    public void setSkipPreviousHistory(boolean skipPreviousHistory) {
        this.isSkipPreviousHistory = skipPreviousHistory;
    }

    public boolean isNeedNewProductId() {
        return this.needNewProductId;
    }

    public void setMarkParentAsInactiveForever(boolean markParentAsInactiveForever) {
        this.markParentAsInactiveForever = markParentAsInactiveForever;
    }

    public void setMarkPublishDebtByGtin(boolean markPublishDebtByGtin) {
        this.markPublishDebtByGtin = markPublishDebtByGtin;
    }

    public void setMarkPublishDebtByProductId(boolean markPublishDebtByProductId) {
        this.markPublishDebtByProductId = markPublishDebtByProductId;
    }

    public void setCollapseVm(boolean collapseVm) {
        this.collapseVm = collapseVm;
    }
}

