/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.vstore.model.store;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import ru.uss.core.model.DocumentType;
import ru.uss.core.utils.LambdaUtils;
import ru.uss.core.utils.RegistrationNumberUtils;
import ru.uss.vstore.model.doc.EOriginType;
import ru.uss.vstore.model.doc.EUFormDetailingType;
import ru.uss.vstore.model.doc.EUFormType;
import ru.uss.vstore.model.history.EHistoryOperationType;
import ru.uss.vstore.model.store.VirtualLabelDocumentSummary;
import ru.uss.vstore.model.store.VirtualLabelNodeDetail;

public class VirtualLabelChainNode
implements Serializable {
    private static final String CANCEL_SUFFIX = " (CANCEL)";
    private static final List<EHistoryOperationType> returnOperationTypes = Collections.unmodifiableList(Arrays.asList(EHistoryOperationType.EXPORT_RETURN, EHistoryOperationType.RETAIL_RETURN_FIXED, EHistoryOperationType.RETAIL_RETURN, EHistoryOperationType.LESSEE_RETURN, EHistoryOperationType.RETURN));
    private VirtualLabelNodeDetail virtualLabelNodeDetail;
    private EUFormDetailingType detailingType;
    @JsonIgnore
    private VirtualLabelChainNode parentNode;
    private List<VirtualLabelChainNode> parentNodes = new ArrayList<VirtualLabelChainNode>();
    private List<VirtualLabelChainNode> childNodes = new ArrayList<VirtualLabelChainNode>();
    private List<VirtualLabelNodeDetail> chainNodeLinkList = new ArrayList<VirtualLabelNodeDetail>();
    private List<VirtualLabelDocumentSummary> virtualLabelDocumentSummaries = new ArrayList<VirtualLabelDocumentSummary>();
    private VsMovementType vsMovementType;
    private Boolean isBalanceUform = null;
    private Boolean isTnvedWithdrawal;
    private List<VirtualLabelAttribute> vlAttributeChanges = new ArrayList<VirtualLabelAttribute>();
    private String taxpayerName;
    private String shortTaxpayerName;
    private Boolean isSearchingNode;
    private boolean isReturn;
    private BigDecimal balance;
    private Integer level;

    public VirtualLabelChainNode(VirtualLabelNodeDetail virtualLabelNodeDetail) {
        this.virtualLabelNodeDetail = virtualLabelNodeDetail;
    }

    public VirtualLabelNodeDetail getVirtualLabelNodeDetail() {
        return this.virtualLabelNodeDetail;
    }

    public void setVirtualLabelNodeDetail(VirtualLabelNodeDetail virtualLabelNodeDetail) {
        this.virtualLabelNodeDetail = virtualLabelNodeDetail;
    }

    public List<VirtualLabelChainNode> getParentNodes() {
        return this.parentNodes;
    }

    public void setParentNodes(List<VirtualLabelChainNode> parentNodes) {
        this.parentNodes = parentNodes;
    }

    public List<VirtualLabelChainNode> getChildNodes() {
        return this.childNodes;
    }

    public void setChildNodes(List<VirtualLabelChainNode> childNodes) {
        this.childNodes = childNodes;
    }

    public EUFormDetailingType getDetailingType() {
        return this.detailingType;
    }

    public void setDetailingType(EUFormDetailingType detailingType) {
        this.detailingType = detailingType;
    }

    public List<VirtualLabelNodeDetail> getChainNodeLinkList() {
        return this.chainNodeLinkList;
    }

    public void setChainNodeLinkList(List<VirtualLabelNodeDetail> chainNodeLinkList) {
        this.chainNodeLinkList = chainNodeLinkList;
    }

    public VsMovementType getVsMovementType() {
        return this.vsMovementType;
    }

    public void setVsMovementType(VsMovementType vsMovementType) {
        this.vsMovementType = vsMovementType;
    }

    public Boolean getBalanceUform() {
        return this.isBalanceUform;
    }

    public void setBalanceUform(Boolean balanceUform) {
        this.isBalanceUform = balanceUform;
    }

    public Long getVirtualLabelId() {
        if (this.virtualLabelNodeDetail != null) {
            return this.virtualLabelNodeDetail.getId();
        }
        return null;
    }

    public Long getVirtualLabelParentId() {
        if (this.virtualLabelNodeDetail != null) {
            return this.virtualLabelNodeDetail.getParentVirtualLabelId();
        }
        return null;
    }

    public String getProductNumberInMovementDoc() {
        return LambdaUtils.nullSafeApplyFunction(this.virtualLabelNodeDetail, vl -> vl.getProductNumberInMovementDoc());
    }

    public String getMovementOrRecipientDoc() {
        String movementOrRecipientDoc = null;
        if (this.virtualLabelNodeDetail != null) {
            movementOrRecipientDoc = this.isMovementDoc() ? this.virtualLabelNodeDetail.getMovementDoc() : this.virtualLabelNodeDetail.getReceiptDocNumber();
        }
        if (movementOrRecipientDoc != null) {
            movementOrRecipientDoc = movementOrRecipientDoc.replace(CANCEL_SUFFIX, "");
        }
        return movementOrRecipientDoc;
    }

    public VirtualLabelChainNode getParentNode() {
        return this.parentNode;
    }

    public void setParentNode(VirtualLabelChainNode parentNode) {
        this.parentNode = parentNode;
    }

    public List<VirtualLabelDocumentSummary> getVirtualLabelDocumentSummaries() {
        return this.virtualLabelDocumentSummaries;
    }

    public void setVirtualLabelDocumentSummaries(List<VirtualLabelDocumentSummary> virtualLabelDocumentSummaries) {
        this.virtualLabelDocumentSummaries = virtualLabelDocumentSummaries;
    }

    public Boolean getTnvedWithdrawal() {
        return this.isTnvedWithdrawal;
    }

    public void setTnvedWithdrawal(Boolean tnvedWithdrawal) {
        this.isTnvedWithdrawal = tnvedWithdrawal;
    }

    public List<VirtualLabelAttribute> getVlAttributeChanges() {
        return this.vlAttributeChanges;
    }

    public void setVlAttributeChanges(List<VirtualLabelAttribute> vlAttributeChanges) {
        this.vlAttributeChanges = vlAttributeChanges;
    }

    public String getTaxpayerName() {
        return this.taxpayerName;
    }

    public void setTaxpayerName(String taxpayerName) {
        this.taxpayerName = taxpayerName;
    }

    public String getShortTaxpayerName() {
        return this.shortTaxpayerName;
    }

    public void setShortTaxpayerName(String shortTaxpayerName) {
        this.shortTaxpayerName = shortTaxpayerName;
    }

    public Boolean getSearchingNode() {
        return this.isSearchingNode;
    }

    public void setSearchingNode(Boolean searchingNode) {
        this.isSearchingNode = searchingNode;
    }

    public boolean isReturn() {
        return this.isReturn;
    }

    public void setReturn(boolean aReturn) {
        this.isReturn = aReturn;
    }

    public BigDecimal getBalance() {
        return this.balance;
    }

    public void setBalance(BigDecimal balance) {
        this.balance = balance;
    }

    public Integer getLevel() {
        return this.level;
    }

    public void setLevel(Integer level) {
        this.level = level;
    }

    @JsonProperty(value="vlFormType")
    public VlFormType getVlFormType() {
        EUFormType euFormType;
        String movementOrRecipientDoc = this.getMovementOrRecipientDoc();
        if (StringUtils.isNotEmpty(movementOrRecipientDoc)) {
            movementOrRecipientDoc = movementOrRecipientDoc.replace(CANCEL_SUFFIX, "");
        }
        if (EUFormType.WRITE_OFF.equals((Object)(euFormType = RegistrationNumberUtils.determineUFormType(movementOrRecipientDoc)))) {
            return VlFormType.WRITE_OFF_FORM;
        }
        if (EUFormType.DETAILING.equals((Object)euFormType)) {
            return VlFormType.DETAILING_FORM;
        }
        EHistoryOperationType operationTypeCode = this.virtualLabelNodeDetail.getOperationTypeCode();
        if (this.isReturn || returnOperationTypes.contains((Object)operationTypeCode)) {
            return VlFormType.RETURN_FORM;
        }
        return VlFormType.DEFAULT_FORM;
    }

    public boolean isMovementDoc() {
        if (this.virtualLabelNodeDetail != null) {
            return StringUtils.isNotEmpty(this.virtualLabelNodeDetail.getMovementDoc());
        }
        return false;
    }

    public boolean hasDirectParent() {
        if (this.virtualLabelNodeDetail.getParentVirtualLabelId() == null) {
            return true;
        }
        if (CollectionUtils.isNotEmpty(this.parentNodes)) {
            return this.parentNodes.stream().anyMatch(pn -> pn.getVirtualLabelId().equals(this.virtualLabelNodeDetail.getParentVirtualLabelId()));
        }
        return false;
    }

    public boolean isMainDetailing() {
        if (this.detailingType == null) {
            return false;
        }
        switch (this.detailingType) {
            case CONVERSION: 
            case EDITING: 
            case RE_SORTING: {
                return true;
            }
            case PACKING: 
            case UNPACKING: {
                return this.getVirtualLabelParentId() == null;
            }
        }
        return true;
    }

    @JsonProperty
    public String getOriginTru() {
        EOriginType originType = this.virtualLabelNodeDetail.getOriginType();
        switch (originType) {
            case IMPORT: {
                return BooleanUtils.isTrue(this.isTnvedWithdrawal) ? "1" : "2";
            }
            case MANUFACTURE: {
                return BooleanUtils.isTrue(this.isTnvedWithdrawal) ? "3" : "4";
            }
        }
        return "5";
    }

    public String getAncestorKey() {
        return this.virtualLabelNodeDetail.getAncestorKey();
    }

    public String getAncestorParentKey() {
        return this.virtualLabelNodeDetail.getAncestorParentKey();
    }

    public VirtualLabelDocumentSummary findVirtualLabelDocumentSummary(DocumentType documentType, VirtualLabelDocumentSummary.LinkSourceType linkSourceType) {
        return this.virtualLabelDocumentSummaries.stream().filter(ds -> documentType.equals((Object)ds.getDocumentType()) && linkSourceType.equals((Object)ds.getLinkSourceType())).findFirst().orElse(null);
    }

    @JsonProperty(value="uFormType")
    public EUFormType getUFormType() {
        return RegistrationNumberUtils.determineUFormType(this.getMovementOrRecipientDoc());
    }

    @JsonProperty(value="sntCustomerTin")
    public String getSntCustomerTin() {
        VirtualLabelDocumentSummary sntSummary = this.findVirtualLabelDocumentSummary(DocumentType.SNT, VirtualLabelDocumentSummary.LinkSourceType.MOVEMENT_DOC);
        return LambdaUtils.nullSafeApplyFunction(sntSummary, VirtualLabelDocumentSummary::getCustomerTin);
    }

    @JsonProperty(value="sntCustomerName")
    public String getSntCustomerName() {
        VirtualLabelDocumentSummary sntSummary = this.findVirtualLabelDocumentSummary(DocumentType.SNT, VirtualLabelDocumentSummary.LinkSourceType.MOVEMENT_DOC);
        return LambdaUtils.nullSafeApplyFunction(sntSummary, VirtualLabelDocumentSummary::getCustomerName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VirtualLabelChainNode that = (VirtualLabelChainNode)o;
        return Objects.equals(this.virtualLabelNodeDetail, that.virtualLabelNodeDetail) && this.detailingType == that.detailingType && Objects.equals(this.parentNodes, that.parentNodes);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.virtualLabelNodeDetail, this.detailingType, this.parentNodes});
    }

    public static enum VlFormType {
        DEFAULT_FORM,
        WRITE_OFF_FORM,
        RETURN_FORM,
        DETAILING_FORM;

    }

    public static enum VirtualLabelAttribute {
        TNVED_CODE,
        NAME,
        MEASURE_UNIT,
        ORIGIN_TYPE,
        QUANTITY,
        PRICE,
        PRICE_SUM;

    }

    public static enum VsMovementType {
        OTHER,
        EAEC,
        KZ,
        ORIGIN_5;

    }
}

