/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.vstore.model.uform.abstractuform;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.Serializable;
import java.math.BigDecimal;
import javax.validation.constraints.Digits;
import javax.validation.constraints.Pattern;
import javax.xml.bind.annotation.Documentation;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import ru.uss.core.utils.DefaultBigDecimalDeserializer;
import ru.uss.core.validation.common.IsNotNull;
import ru.uss.core.validation.common.PositiveNumber;
import ru.uss.core.validation.common.RequiredString;
import ru.uss.esf.validation.common.field.DecimalFormat;
import ru.uss.vstore.model.dict.GsvsMeta;
import ru.uss.vstore.model.dict.MeasureUnit;
import ru.uss.vstore.validation.uform.UFormTypes;
import ru.uss.vstore.validation.uformproduct.version.v1.ImmutableInProducts;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="AbstractUFormProduct")
public abstract class AbstractUFormProduct
implements Serializable {
    @Pattern(regexp="([0-9]{2}\\.){3}([0-9]{2}){1}((-[0-9]{10})|(-[0-9]{10}/([0-9]{8}|[0-9]{11,14})))?", message="{uFormProduct.gsvsCode.format}")
    @ImmutableInProducts(groups={UFormTypes.Conversion.class, UFormTypes.Editing.class})
    @IsNotNull(message="{uFormProduct.gsvsCode.notNull}")
    @XmlElement(required=true)
    @Documentation(value="\u0421\u043e\u0441\u0442\u0430\u0432\u043d\u043e\u0439 \u043a\u043e\u0434 \u0413\u0421 \u0412\u0421")
    private @Pattern(regexp="([0-9]{2}\\.){3}([0-9]{2}){1}((-[0-9]{10})|(-[0-9]{10}/([0-9]{8}|[0-9]{11,14})))?", message="{uFormProduct.gsvsCode.format}") String gsvsCode;
    @XmlTransient
    @Documentation(value="\u0421\u043a\u0432\u043e\u0437\u043d\u043e\u0439 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0413\u0421 \u0412\u0421")
    private Long gsvsFixedId;
    @XmlTransient
    @Documentation(value="\u0413\u043b\u043e\u0431\u0430\u043b\u044c\u043d\u044b\u0439 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a \u0412\u0438\u0440\u0442\u0443\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0441\u043a\u043b\u0430\u0434\u0430")
    private GsvsMeta gsvsMeta;
    @RequiredString(fieldPath="uFormProduct.measureUnitCode", maxLen=255)
    @ImmutableInProducts(groups={UFormTypes.Editing.class, UFormTypes.ReSorting.class})
    @XmlElement(required=true)
    @Documentation(value="\u0415\u0434\u0438\u043d\u0438\u0446\u0430 \u0438\u0437\u043c\u0435\u0440\u0435\u043d\u0438\u044f")
    private String measureUnitCode;
    @XmlTransient
    @Documentation(value="\u0415\u0434\u0438\u043d\u0438\u0446\u0430 \u0438\u0437\u043c\u0435\u0440\u0435\u043d\u0438\u044f")
    private MeasureUnit measureUnit;
    @JsonDeserialize(using=DefaultBigDecimalDeserializer.class, as=BigDecimal.class)
    @IsNotNull(fieldPath="uFormProduct.quantity")
    @PositiveNumber(fieldPath="uFormProduct.quantity")
    @Digits(integer=12, fraction=6, message="{uFormProduct.quantity.digits}")
    @DecimalFormat(message="{uFormProduct.quantity.decimalFormat}")
    @ImmutableInProducts(groups={UFormTypes.Editing.class, UFormTypes.ReSorting.class})
    @XmlElement(required=true)
    @Documentation(value="\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e")
    private @Digits(integer=12, fraction=6, message="{uFormProduct.quantity.digits}") BigDecimal quantity;
    @JsonDeserialize(using=DefaultBigDecimalDeserializer.class, as=BigDecimal.class)
    @IsNotNull(fieldPath="uFormProduct.price")
    @Digits(integer=12, fraction=2, message="{uFormProduct.price.digits}")
    @XmlElement
    @Documentation(value="\u0426\u0435\u043d\u0430")
    private @Digits(integer=12, fraction=2, message="{uFormProduct.price.digits}") BigDecimal price;
    @JsonDeserialize(using=DefaultBigDecimalDeserializer.class, as=BigDecimal.class)
    @IsNotNull(fieldPath="uFormProduct.sum")
    @Digits(integer=15, fraction=2, message="{uFormProduct.sum.digits}")
    @XmlElement
    @Documentation(value="\u0421\u0443\u043c\u043c\u0430")
    private @Digits(integer=15, fraction=2, message="{uFormProduct.sum.digits}") BigDecimal sum;

    public String getGsvsCode() {
        return this.gsvsCode;
    }

    public void setGsvsCode(String gsvsCode) {
        this.gsvsCode = gsvsCode;
    }

    public Long getGsvsFixedId() {
        return this.gsvsFixedId;
    }

    public void setGsvsFixedId(Long gsvsFixedId) {
        this.gsvsFixedId = gsvsFixedId;
    }

    public String getMeasureUnitCode() {
        return this.measureUnitCode;
    }

    public void setMeasureUnitCode(String measureUnitCode) {
        this.measureUnitCode = measureUnitCode;
    }

    public MeasureUnit getMeasureUnit() {
        return this.measureUnit;
    }

    public void setMeasureUnit(MeasureUnit measureUnit) {
        this.measureUnit = measureUnit;
    }

    public BigDecimal getQuantity() {
        return this.quantity;
    }

    public void setQuantity(BigDecimal quantity) {
        this.quantity = quantity;
    }

    public BigDecimal getPrice() {
        return this.price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public BigDecimal getSum() {
        return this.sum;
    }

    public void setSum(BigDecimal sum) {
        this.sum = sum;
    }

    public GsvsMeta getGsvsMeta() {
        return this.gsvsMeta;
    }

    public void setGsvsMeta(GsvsMeta gsvsMeta) {
        this.gsvsMeta = gsvsMeta;
    }

    public abstract String getPhysicalLabel();
}

