/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.vstore.utils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class GsvsCodeUtils {
    public static String NO_PRODUCT_ID_CODE = "1";
    public static final String GTIN_STRING_PATTERN = "[0-9]{8}|[0-9]{11,14}";
    public static final Pattern GTIN_PATTERN = Pattern.compile("[0-9]{8}|[0-9]{11,14}");
    public static final String GSVS_CODE_REGEXP = "([0-9]{2}\\.){3}([0-9]{2}){1}((-[0-9]{10})|(-[0-9]{10}/([0-9]{8}|[0-9]{11,14})))?";
    public static final String GSVS_EXTENDED_CODE_REGEXP = "([0-9]{2}\\.){3}([0-9]{2}){1}((-[0-9]{10})|(-[0-9]{10}/([0-9]{8}|[0-9]{11,14})))?(\\[[a-zA-Z_0-9]+\\])?(<[0-9]{1,20}>)?(\\([0-9]+\\)){1}(\\{[0-9]*\\})?";
    public static final String GSVS_SNT_CODE_REGEXP = "([0-9]{2}\\.){3}([0-9]{2}){1}((-[0-9]{10})|(-[0-9]{10}/([0-9]{8}|[0-9]{11,14})))?(\\[[a-zA-Z_0-9]+\\])?(<[0-9]{1,20}>)?(\\{[0-9]*\\})?";
    private static final Pattern GSVS_CODE_PATTERN = Pattern.compile("^([0-9]{2}\\.){3}([0-9]{2}){1}((-[0-9]{10})|(-[0-9]{10}/([0-9]{8}|[0-9]{11,14})))?$");
    private static final Pattern GSVS_EXTENDED_CODE_PATTERN = Pattern.compile("^([0-9]{2}\\.){3}([0-9]{2}){1}((-[0-9]{10})|(-[0-9]{10}/([0-9]{8}|[0-9]{11,14})))?(\\[[a-zA-Z_0-9]+\\])?(<[0-9]{1,20}>)?(\\([0-9]+\\)){1}(\\{[0-9]*\\})?$");
    private static final Pattern GSVS_EXTENDED_SNT_CODE_PATTERN = Pattern.compile("^([0-9]{2}\\.){3}([0-9]{2}){1}((-[0-9]{10})|(-[0-9]{10}/([0-9]{8}|[0-9]{11,14})))?(\\[[a-zA-Z_0-9]+\\])?(<[0-9]{1,20}>)?(\\{[0-9]*\\})?$");
    private static final Pattern DIGITS_PATTERN = Pattern.compile("(\\d+)");
    private static final String PRODUCT_ID_OPEN_TAG = "<";
    private static final String PRODUCT_ID_CLOSE_TAG = ">";
    private static final String STORE_ID_OPEN_TAG = "(";
    private static final String STORE_ID_CLOSE_TAG = ")";
    private static final String PINCODE_OPEN_TAG = "{";
    private static final String PINCODE_CLOSE_TAG = "}";
    private static final String PHYSICAL_LABEL_OPEN_TAG = "[";
    private static final String PHYSICAL_LABEL_CLOSE_TAG = "]";

    public static String composeGsvsCode(String kpvedCode, String tnvedCode, String gtinCode) {
        if (!StringUtils.isEmpty(kpvedCode)) {
            return String.format("%1$s%2$s%3$s", kpvedCode, StringUtils.isEmpty(tnvedCode) ? "" : "-" + tnvedCode, StringUtils.isEmpty(gtinCode) ? "" : "/" + gtinCode);
        }
        return null;
    }

    public static String composeGsvsExtendedCode(String kpvedCode, String tnvedCode, String gtinCode, String pinCode, Long productId, Long storeId) {
        if (!StringUtils.isEmpty(kpvedCode)) {
            return String.format("%1$s%2$s%3$s%4$s%5$s%6$s", kpvedCode, StringUtils.isEmpty(tnvedCode) ? "" : "-" + tnvedCode, StringUtils.isEmpty(gtinCode) ? "" : "/" + gtinCode, productId == null ? "" : PRODUCT_ID_OPEN_TAG + productId + PRODUCT_ID_CLOSE_TAG, storeId == null ? "" : STORE_ID_OPEN_TAG + storeId + STORE_ID_CLOSE_TAG, StringUtils.isEmpty(pinCode) ? "" : PINCODE_OPEN_TAG + pinCode + PINCODE_CLOSE_TAG);
        }
        return null;
    }

    public static String parseSntGsvsCode(String catalogTruId) {
        if (GsvsCodeUtils.isValidGsvsExtendedSntCode(catalogTruId)) {
            return GsvsCodeUtils.composeGsvsCode(GsvsCodeUtils.parseKpvedCode(catalogTruId), GsvsCodeUtils.parseTnvedCode(catalogTruId), GsvsCodeUtils.parseGtinCode(catalogTruId));
        }
        return null;
    }

    public static String parseGsvsCode(String catalogTruId) {
        if (GsvsCodeUtils.isValidGsvsExtendedCode(catalogTruId)) {
            return GsvsCodeUtils.composeGsvsCode(GsvsCodeUtils.parseKpvedCode(catalogTruId), GsvsCodeUtils.parseTnvedCode(catalogTruId), GsvsCodeUtils.parseGtinCode(catalogTruId));
        }
        return null;
    }

    public static String parseKpvedCode(String gsvsCode) {
        if (GsvsCodeUtils.isValidGsvsCode(gsvsCode) || GsvsCodeUtils.isValidGsvsExtendedCode(gsvsCode) || GsvsCodeUtils.isValidGsvsExtendedSntCode(gsvsCode)) {
            return gsvsCode.substring(0, 11);
        }
        return null;
    }

    public static String parseTnvedCode(String gsvsCode) {
        if ((GsvsCodeUtils.isValidGsvsCode(gsvsCode) || GsvsCodeUtils.isValidGsvsExtendedCode(gsvsCode) || GsvsCodeUtils.isValidGsvsExtendedSntCode(gsvsCode)) && gsvsCode.contains("-")) {
            return gsvsCode.substring(gsvsCode.indexOf("-") + 1, gsvsCode.indexOf("-") + 11);
        }
        return null;
    }

    public static String changeTnvedCode(String gsvsExtendedCode, String tnvedCode) {
        String oldTnvedCode = GsvsCodeUtils.parseTnvedCode(gsvsExtendedCode);
        return gsvsExtendedCode.replace(oldTnvedCode, tnvedCode);
    }

    public static String parseGtinCode(String gsvsCode) {
        if ((GsvsCodeUtils.isValidGsvsCode(gsvsCode) || GsvsCodeUtils.isValidGsvsExtendedCode(gsvsCode) || GsvsCodeUtils.isValidGsvsExtendedSntCode(gsvsCode)) && gsvsCode.contains("/")) {
            Matcher matcher = DIGITS_PATTERN.matcher(gsvsCode.split("/")[1]);
            return matcher.find() ? matcher.group() : "";
        }
        return null;
    }

    public static String parsePhysicalLabel(String gsvsExtendedCode) {
        if (GsvsCodeUtils.isValidGsvsExtendedCode(gsvsExtendedCode) && gsvsExtendedCode.contains(PHYSICAL_LABEL_OPEN_TAG) && gsvsExtendedCode.contains(PHYSICAL_LABEL_CLOSE_TAG)) {
            return gsvsExtendedCode.substring(gsvsExtendedCode.indexOf(PHYSICAL_LABEL_OPEN_TAG) + 1, gsvsExtendedCode.indexOf(PHYSICAL_LABEL_CLOSE_TAG));
        }
        return null;
    }

    public static Long parseProductId(String gsvsExtendedCode) {
        if ((GsvsCodeUtils.isValidGsvsExtendedCode(gsvsExtendedCode) || GsvsCodeUtils.isValidGsvsExtendedSntCode(gsvsExtendedCode)) && gsvsExtendedCode.contains(PRODUCT_ID_OPEN_TAG)) {
            return Long.parseLong(gsvsExtendedCode.substring(gsvsExtendedCode.indexOf(PRODUCT_ID_OPEN_TAG) + 1, gsvsExtendedCode.indexOf(PRODUCT_ID_CLOSE_TAG)));
        }
        return null;
    }

    public static Long parseStoreId(String gsvsExtendedCode) {
        if (GsvsCodeUtils.isValidGsvsExtendedCode(gsvsExtendedCode)) {
            return Long.parseLong(gsvsExtendedCode.substring(gsvsExtendedCode.indexOf(STORE_ID_OPEN_TAG) + 1, gsvsExtendedCode.indexOf(STORE_ID_CLOSE_TAG)));
        }
        return null;
    }

    public static boolean isValidGsvsCode(String gsvsCode) {
        return GsvsCodeUtils.isValidGsvsCode(gsvsCode, GSVS_CODE_PATTERN);
    }

    public static boolean isValidGsvsExtendedCode(String gsvsExtendedCode) {
        return GsvsCodeUtils.isValidGsvsCode(gsvsExtendedCode, GSVS_EXTENDED_CODE_PATTERN);
    }

    public static boolean isValidGsvsExtendedSntCode(String gsvsExtendedSntCode) {
        return GsvsCodeUtils.isValidGsvsCode(gsvsExtendedSntCode, GSVS_EXTENDED_SNT_CODE_PATTERN);
    }

    public static boolean isValidGsvsCode(String gsvsCode, Pattern gsvsPattern) {
        return !StringUtils.isEmpty(gsvsCode) && gsvsPattern.matcher(gsvsCode).find();
    }

    public static String parsePinCode(String gsvsExtendedCode) {
        if (GsvsCodeUtils.isValidGsvsExtendedCode(gsvsExtendedCode) && gsvsExtendedCode.contains(PINCODE_OPEN_TAG) && gsvsExtendedCode.contains(PINCODE_CLOSE_TAG)) {
            return gsvsExtendedCode.substring(gsvsExtendedCode.indexOf(PINCODE_OPEN_TAG) + 1, gsvsExtendedCode.indexOf(PINCODE_CLOSE_TAG));
        }
        return null;
    }

    public static String formatProductId(Long productId) {
        return PRODUCT_ID_OPEN_TAG + productId + PRODUCT_ID_CLOSE_TAG;
    }

    public static String formatStoreId(Long storeId) {
        return STORE_ID_OPEN_TAG + storeId + STORE_ID_CLOSE_TAG;
    }

    public static String formatPinCode(String pincode) {
        return PINCODE_OPEN_TAG + pincode + PINCODE_CLOSE_TAG;
    }

    public static String formatPhysicalLabel(String physicalLabel) {
        return PHYSICAL_LABEL_OPEN_TAG + physicalLabel + PHYSICAL_LABEL_CLOSE_TAG;
    }
}

