/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.vstore.validation.gsvs;

import java.util.regex.Pattern;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.apache.commons.lang3.StringUtils;
import ru.uss.core.validation.common.GtinValidator;
import ru.uss.vstore.model.dict.EGsvsType;
import ru.uss.vstore.model.dict.Gsvs;
import ru.uss.vstore.utils.GsvsCodeUtils;
import ru.uss.vstore.validation.gsvs.GsvsCode;

public class GsvsCodeValidator
implements ConstraintValidator<GsvsCode, Gsvs> {
    @Override
    public void initialize(GsvsCode constraintAnnotation) {
    }

    @Override
    public boolean isValid(Gsvs gsvs, ConstraintValidatorContext context) {
        if (gsvs.getCode() == null) {
            return true;
        }
        if (EGsvsType.GTIN.equals((Object)gsvs.getGsvsTypeCode()) && !GsvsCodeUtils.GTIN_PATTERN.matcher(gsvs.getCode()).matches()) {
            context.buildConstraintViolationWithTemplate("{gsvs.code.wrongFormat}").addPropertyNode("code").addConstraintViolation();
            return false;
        }
        if (EGsvsType.KPVED.equals((Object)gsvs.getGsvsTypeCode()) && !GsvsCodeValidator.isValidKpved(gsvs.getCode()) || EGsvsType.TNVED.equals((Object)gsvs.getGsvsTypeCode()) && !GsvsCodeValidator.isValidTnved(gsvs.getCode()) || EGsvsType.GTIN.equals((Object)gsvs.getGsvsTypeCode()) && gsvs.getCode().length() != 11 && !GtinValidator.isGtin(gsvs.getCode())) {
            context.buildConstraintViolationWithTemplate("{gsvs.code.wrongFormat}").addPropertyNode("code").addConstraintViolation();
            return false;
        }
        return true;
    }

    public static boolean isValidKpved(String code) {
        if (StringUtils.isEmpty(code)) {
            return false;
        }
        return Pattern.matches("[A-Z]", code) || Pattern.matches("[0-9]{2}", code) || Pattern.matches("[0-9]{2}[.][0-9]{1}", code) || Pattern.matches("[0-9]{2}[.][0-9]{2}", code) || Pattern.matches("[0-9]{2}[.][0-9]{2}[.][0-9]{1}", code) || Pattern.matches("[0-9]{2}[.][0-9]{2}[.][0-9]{2}", code) || Pattern.matches("[0-9]{2}[.][0-9]{2}[.][0-9]{2}[.][0-9]{2}", code);
    }

    public static boolean isValidTnved(String code) {
        return !StringUtils.isEmpty(code) && Pattern.matches("[0-9]{10}", code);
    }
}

