/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.vstore.validation.uform;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import javax.validation.ConstraintValidatorContext;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import ru.uss.core.utils.DateTimeUtils;
import ru.uss.core.utils.RegistrationNumberUtils;
import ru.uss.core.validation.common.AbstractClassLevelValidator;
import ru.uss.vstore.model.doc.EUFormType;
import ru.uss.vstore.model.uform.version.v1.UFormProductV1;
import ru.uss.vstore.model.uform.version.v1.UFormV1;
import ru.uss.vstore.validation.uform.UFormManufactureOrImportDocNumberCheckV1;

public class UFormManufactureOrImportDocNumberValidatorV1
extends AbstractClassLevelValidator<UFormManufactureOrImportDocNumberCheckV1, UFormV1> {
    @Override
    public void initialize(UFormManufactureOrImportDocNumberCheckV1 uFormManufactureOrImportDocNumberCheckV1) {
    }

    @Override
    public boolean isValid(UFormV1 uFormV1, ConstraintValidatorContext context) {
        List<EUFormType> productNumberRequiredFormTypes = Arrays.asList(EUFormType.BALANCE, EUFormType.BALANCE_CORRECTION, EUFormType.MANUFACTURE);
        boolean isValid = true;
        List<UFormProductV1> checkProducts = uFormV1.getProducts();
        if (CollectionUtils.isNotEmpty(checkProducts)) {
            for (int i = 0; i < checkProducts.size(); ++i) {
                UFormProductV1 currentProduct = checkProducts.get(i);
                String manufactureOrImportDocNumber = currentProduct.getManufactureOrImportDocNumber();
                if (Objects.equals("1", currentProduct.getOriginCode()) && StringUtils.isEmpty(manufactureOrImportDocNumber)) {
                    context.buildConstraintViolationWithTemplate("{uFormProduct.manufactureOrImportDocNumber.notNull}").addPropertyNode("products[" + i + "].manufactureOrImportDocNumber").addConstraintViolation();
                    isValid = false;
                    continue;
                }
                int declarationNumberLength = 0;
                if (StringUtils.isNotEmpty(manufactureOrImportDocNumber)) {
                    declarationNumberLength = manufactureOrImportDocNumber.length();
                }
                if ((Objects.equals("1", currentProduct.getOriginCode()) || Objects.equals("2", currentProduct.getOriginCode())) && declarationNumberLength != 0) {
                    if (declarationNumberLength != 18 && declarationNumberLength != 20) {
                        context.buildConstraintViolationWithTemplate("{uFormProduct.manufactureOrImportDocNumber.invalid.format.18.20}").addPropertyNode("products[" + i + "].manufactureOrImportDocNumber").addConstraintViolation();
                        isValid = false;
                        continue;
                    }
                    if (!(declarationNumberLength != 18 || Pattern.matches("[0-9]{4}[0-9]{8}[NI]{1}[0-9]{5}", manufactureOrImportDocNumber) && DateTimeUtils.isDateValid(manufactureOrImportDocNumber.substring(4, 12), "ddMMyyyy"))) {
                        context.buildConstraintViolationWithTemplate("{uFormProduct.manufactureOrImportDocNumber.invalid.format.18}").addPropertyNode("products[" + i + "].manufactureOrImportDocNumber").addConstraintViolation();
                        isValid = false;
                        continue;
                    }
                    if (!(declarationNumberLength != 20 || (Pattern.matches("[0-9]{5}/[0-9]{6}/[0-9]{7}", manufactureOrImportDocNumber) || Pattern.matches("[0-9]{5}/[0-9]{6}/B[0-9]{6}", manufactureOrImportDocNumber)) && DateTimeUtils.isDateValid(manufactureOrImportDocNumber.substring(6, 12), "ddMMyy"))) {
                        context.buildConstraintViolationWithTemplate("{uFormProduct.manufactureOrImportDocNumber.invalid.format.20}").addPropertyNode("products[" + i + "].manufactureOrImportDocNumber").addConstraintViolation();
                        isValid = false;
                        continue;
                    }
                    if (productNumberRequiredFormTypes.contains((Object)uFormV1.getType()) && RegistrationNumberUtils.isZvt(manufactureOrImportDocNumber) && currentProduct.getProductNumberInImportDoc() == null) {
                        this.setupContextWithValidationError(context, "products[" + i + "].manufactureOrImportDocNumber", "{uFormProduct.productNumberInImportDoc.zvtErrorFormat}");
                        isValid = false;
                        continue;
                    }
                }
                if ((Objects.equals("3", currentProduct.getOriginCode()) || Objects.equals("4", currentProduct.getOriginCode())) && declarationNumberLength != 0) {
                    if (declarationNumberLength != 11 && declarationNumberLength != 13) {
                        context.buildConstraintViolationWithTemplate("{uFormProduct.manufactureOrImportDocNumber.invalid.format.11.13}").addPropertyNode("products[" + i + "].manufactureOrImportDocNumber").addConstraintViolation();
                        isValid = false;
                        continue;
                    }
                    if (declarationNumberLength == 11 && !Pattern.matches("KZ[0-9]{9}", manufactureOrImportDocNumber)) {
                        context.buildConstraintViolationWithTemplate("{uFormProduct.manufactureOrImportDocNumber.invalid.format.11}").addPropertyNode("products[" + i + "].manufactureOrImportDocNumber").addConstraintViolation();
                        isValid = false;
                        continue;
                    }
                    if (declarationNumberLength == 13 && !Pattern.matches("KZ.{2}[0-9]{9}", manufactureOrImportDocNumber)) {
                        context.buildConstraintViolationWithTemplate("{uFormProduct.manufactureOrImportDocNumber.invalid.format.13}").addPropertyNode("products[" + i + "].manufactureOrImportDocNumber").addConstraintViolation();
                        isValid = false;
                        continue;
                    }
                }
                if (!Objects.equals("5", currentProduct.getOriginCode()) || declarationNumberLength == 0) continue;
                context.buildConstraintViolationWithTemplate("{uFormProduct.manufactureOrImportDocNumber.mustBeNull}").addPropertyNode("products[" + i + "].manufactureOrImportDocNumber").addConstraintViolation();
                isValid = false;
            }
        }
        return isValid;
    }
}

