/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.vstore.validation.uform;

import java.math.BigDecimal;
import javax.validation.ConstraintValidatorContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.uss.core.validation.common.AbstractClassLevelValidator;
import ru.uss.vstore.model.uform.version.v1.UFormProductV1;
import ru.uss.vstore.model.uform.version.v1.UFormV1;
import ru.uss.vstore.validation.uform.UFormSourceTotalSumCheckV1;
import ru.uss.vstore.validation.uform.UFormTotalSumValidatorV1;

public class UFormSourceTotalSumValidatorV1
extends AbstractClassLevelValidator<UFormSourceTotalSumCheckV1, UFormV1> {
    private static final Logger LOGGER = LoggerFactory.getLogger(UFormTotalSumValidatorV1.class);

    @Override
    public void initialize(UFormSourceTotalSumCheckV1 uFormSourceTotalSumCheckV1) {
    }

    @Override
    public boolean isValid(UFormV1 uFormV1, ConstraintValidatorContext context) {
        if (uFormV1 == null || uFormV1.getSourceProducts() == null || uFormV1.getSourceTotalSum() == null) {
            return true;
        }
        BigDecimal productsTotalSum = BigDecimal.ZERO;
        for (UFormProductV1 productV1 : uFormV1.getSourceProducts()) {
            if (productV1.getSum() == null) continue;
            productsTotalSum = productsTotalSum.add(productV1.getSum());
        }
        BigDecimal errorSum = BigDecimal.ZERO;
        BigDecimal totalSum = uFormV1.getSourceTotalSum();
        if (productsTotalSum.compareTo(totalSum) < 0) {
            errorSum = totalSum.subtract(productsTotalSum);
        } else if (productsTotalSum.compareTo(totalSum) > 0) {
            errorSum = productsTotalSum.subtract(totalSum);
        }
        if (errorSum.compareTo(new BigDecimal(200)) > 0) {
            return this.setupContextWithValidationError(context, "sourceTotalSum", "{uForm.sourceTotalSum.permissibleError}");
        }
        return true;
    }
}

