/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.vstore.validation.uformproduct.version.v1;

import javax.validation.ConstraintValidatorContext;
import org.apache.commons.lang3.StringUtils;
import ru.uss.vstore.model.uform.version.v1.UFormProductV1;
import ru.uss.vstore.validation.uformproduct.version.v1.AbstractProductOriginCertificateNumberValidator;
import ru.uss.vstore.validation.uformproduct.version.v1.UFormProductManufactureOrImportDocNumberV1;

public class UFormProductManufactureOrImportDocNumberValidatorV1
extends AbstractProductOriginCertificateNumberValidator<UFormProductManufactureOrImportDocNumberV1> {
    @Override
    public void initialize(UFormProductManufactureOrImportDocNumberV1 constraintAnnotation) {
    }

    @Override
    public boolean isValid(UFormProductV1 value, ConstraintValidatorContext context) {
        String originCode = value.getOriginCode();
        if (StringUtils.isBlank(originCode)) {
            return true;
        }
        String manufactureOrImportDocNumber = value.getManufactureOrImportDocNumber();
        if (StringUtils.isBlank(manufactureOrImportDocNumber)) {
            if ("1".equals(originCode)) {
                return this.setupContextWithValidationError(context, this.generateNotNullFieldMessage("uFormProduct.manufactureOrImportDocNumber"));
            }
            return true;
        }
        if ("1".equals(originCode) || "2".equals(originCode)) {
            return this.validateForLength_18_20(manufactureOrImportDocNumber, context);
        }
        if ("3".equals(originCode) || "4".equals(originCode)) {
            return this.validateForLength_11_13(manufactureOrImportDocNumber, context);
        }
        if ("5".equals(originCode)) {
            return this.setupContextWithValidationError(context, "{uFormProduct.manufactureOrImportDocNumber.unsupported}");
        }
        return true;
    }
}

