/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.vstore.validation.uformproduct.version.v1;

import java.util.List;
import javax.validation.ConstraintValidatorContext;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import ru.uss.core.validation.common.AbstractClassLevelValidator;
import ru.uss.vstore.model.uform.version.v1.UFormProductV1;
import ru.uss.vstore.model.uform.version.v1.UFormV1;
import ru.uss.vstore.validation.uformproduct.version.v1.UFormProductNameInImportDocV1;

public class UFormProductNameInImportDocValidatorV1
extends AbstractClassLevelValidator<UFormProductNameInImportDocV1, UFormV1> {
    public UFormProductNameInImportDocValidatorV1() {
        super("");
    }

    @Override
    public void initialize(UFormProductNameInImportDocV1 constraintAnnotation) {
    }

    @Override
    public boolean isValid(UFormV1 formV1, ConstraintValidatorContext context) {
        List<UFormProductV1> products = formV1.getProducts();
        if (CollectionUtils.isEmpty(products)) {
            return true;
        }
        boolean productsValid = true;
        for (int index = 0; index < products.size(); ++index) {
            productsValid &= this.isProductValid(index, products.get(index), context);
        }
        return productsValid;
    }

    private boolean isProductValid(int index, UFormProductV1 productV1, ConstraintValidatorContext context) {
        String originCode = productV1.getOriginCode();
        if (StringUtils.isBlank(originCode)) {
            return true;
        }
        if (("1".equals(originCode) || "2".equals(originCode)) && productV1.getProductNameInImportDoc() == null) {
            return this.setupContextWithValidationError(context, "products[" + index + "].productNameInImportDoc", this.generateNotNullFieldMessage("uFormProduct.productNameInImportDoc"));
        }
        return true;
    }
}

