/*
 * Decompiled with CFR 0.152.
 */
package ru.uss.vstore.validation.uformproduct.version.v1;

import java.util.regex.Pattern;
import javax.validation.ConstraintValidatorContext;
import org.apache.commons.lang3.StringUtils;
import ru.uss.core.utils.DateTimeUtils;
import ru.uss.core.utils.RegistrationNumberUtils;
import ru.uss.core.validation.common.AbstractClassLevelValidator;
import ru.uss.vstore.model.uform.version.v1.UFormProductV1;
import ru.uss.vstore.validation.uformproduct.version.v1.UFormProductNumberInImportDocV1;

public class UFormProductNumberInImportDocValidatorV1
extends AbstractClassLevelValidator<UFormProductNumberInImportDocV1, UFormProductV1> {
    private static final Pattern PRODUCT_NUMBER_SHORT_PATTERN = Pattern.compile("^[0-9]{1,5}$");
    private static final Pattern PRODUCT_NUMBER_FULL_PATTERN = Pattern.compile("^[0-9]{1,5}(/[0-9]{1,5})?$");
    private static final Pattern PATTERN_FOR_20_LENGTH = Pattern.compile("^[0-9]{5}/[0-9]{6}/[0-9]{7}$");
    private static final Pattern PATTERN_FOR_42_LENGTH = RegistrationNumberUtils.SNT_PATTERN;

    public UFormProductNumberInImportDocValidatorV1() {
        super("productNumberInImportDoc");
    }

    @Override
    public void initialize(UFormProductNumberInImportDocV1 constraintAnnotation) {
    }

    @Override
    public boolean isValid(UFormProductV1 productV1, ConstraintValidatorContext context) {
        String originCode = productV1.getOriginCode();
        if (StringUtils.isBlank(originCode)) {
            return true;
        }
        if ("1".equals(originCode) && productV1.getProductNumberInImportDoc() == null) {
            return this.setupContextWithValidationError(context, this.generateNotNullFieldMessage("uFormProduct.productNumberInImportDoc"));
        }
        String manufactureOrImportDocNumber = productV1.getManufactureOrImportDocNumber();
        if (manufactureOrImportDocNumber != null && manufactureOrImportDocNumber.length() == 20 && PATTERN_FOR_20_LENGTH.matcher(manufactureOrImportDocNumber).matches() && DateTimeUtils.isDateValid(manufactureOrImportDocNumber.substring(6, 12), "ddMMyy")) {
            if (productV1.getProductNumberInImportDoc() != null && !PRODUCT_NUMBER_FULL_PATTERN.matcher(productV1.getProductNumberInImportDoc()).matches()) {
                return this.setupContextWithValidationError(context, "{uFormProduct.productNumberInImportDoc.dtErrorFormat}");
            }
            return true;
        }
        if (manufactureOrImportDocNumber != null && manufactureOrImportDocNumber.length() == 42 && PATTERN_FOR_42_LENGTH.matcher(manufactureOrImportDocNumber).matches() && DateTimeUtils.isDateValid(manufactureOrImportDocNumber.substring(25, 33), "yyyyMMdd")) {
            if (productV1.getProductNumberInImportDoc() != null && !PRODUCT_NUMBER_FULL_PATTERN.matcher(productV1.getProductNumberInImportDoc()).matches()) {
                return this.setupContextWithValidationError(context, "{uFormProduct.productNumberInImportDoc.dtErrorFormat}");
            }
            return true;
        }
        if (productV1.getProductNumberInImportDoc() != null) {
            if (!PRODUCT_NUMBER_SHORT_PATTERN.matcher(productV1.getProductNumberInImportDoc()).matches()) {
                return this.setupContextWithValidationError(context, "{uFormProduct.productNumberInImportDoc.fnoErrorFormat}");
            }
            return true;
        }
        return true;
    }
}

