/*
 * Decompiled with CFR 0.152.
 */
package ru.ussgroup.security.trusty;

import java.math.BigInteger;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import ru.ussgroup.security.trusty.TrustyCertValidationCode;
import ru.ussgroup.security.trusty.certpath.TrustyAsyncCertPathValidator;
import ru.ussgroup.security.trusty.exception.TrustyOCSPCertificateException;
import ru.ussgroup.security.trusty.exception.TrustyOCSPNonceException;
import ru.ussgroup.security.trusty.exception.TrustyOCSPNotAvailableException;
import ru.ussgroup.security.trusty.exception.TrustyOCSPUnknownProblemException;
import ru.ussgroup.security.trusty.ocsp.TrustyOCSPStatus;
import ru.ussgroup.security.trusty.ocsp.TrustyOCSPValidationResult;
import ru.ussgroup.security.trusty.ocsp.TrustyOCSPValidator;
import ru.ussgroup.security.trusty.utils.ExceptionHandler;

public class TrustyCertificateValidator {
    private TrustyAsyncCertPathValidator certPathValidator;
    private TrustyOCSPValidator ocspValidator;

    public TrustyCertificateValidator(TrustyAsyncCertPathValidator certPathValidator, TrustyOCSPValidator ocspValidator) {
        this.certPathValidator = certPathValidator;
        this.ocspValidator = ocspValidator;
    }

    public Map<BigInteger, TrustyCertValidationCode> validate(Set<X509Certificate> certs) throws TrustyOCSPNotAvailableException, TrustyOCSPNonceException, TrustyOCSPCertificateException, TrustyOCSPUnknownProblemException {
        return this.validate(certs, new Date());
    }

    public Map<BigInteger, TrustyCertValidationCode> validate(Set<X509Certificate> certs, Date date) throws TrustyOCSPNotAvailableException, TrustyOCSPNonceException, TrustyOCSPCertificateException, TrustyOCSPUnknownProblemException {
        return ExceptionHandler.handleFutureResult(this.validateAsync(certs, date));
    }

    public CompletableFuture<Map<BigInteger, TrustyCertValidationCode>> validateAsync(Set<X509Certificate> certs) {
        return this.validateAsync(certs, new Date());
    }

    public CompletableFuture<Map<BigInteger, TrustyCertValidationCode>> validateAsync(Set<X509Certificate> certs, Date date) {
        HashSet<X509Certificate> fullList = new HashSet<X509Certificate>();
        HashMap<BigInteger, List<X509Certificate>> serial2Path = new HashMap<BigInteger, List<X509Certificate>>();
        for (X509Certificate cert : certs) {
            List<X509Certificate> fullCertPath = Collections.singletonList(cert);
            fullList.addAll(fullCertPath);
            serial2Path.put(cert.getSerialNumber(), fullCertPath);
        }
        CompletionStage ocspFuture = this.ocspValidator.validateAsync(fullList).thenApply(TrustyOCSPValidationResult::getStatuses);
        CompletableFuture<Map<BigInteger, TrustyCertValidationCode>> certPathFuture = this.certPathValidator.validateAsync(certs, date);
        return certPathFuture.thenCombine(ocspFuture, (certPathRes, ocspRes) -> {
            block0: for (Map.Entry entry : certPathRes.entrySet()) {
                if (entry.getValue() != TrustyCertValidationCode.SUCCESS) continue;
                for (X509Certificate cert : (List)serial2Path.get(entry.getKey())) {
                    if (((TrustyOCSPStatus)ocspRes.get(cert.getSerialNumber())).getStatus() == 1) continue;
                    entry.setValue(TrustyCertValidationCode.OCSP_FAILED);
                    continue block0;
                }
            }
            return certPathRes;
        });
    }

    public TrustyOCSPStatus getStatus(X509Certificate cert) {
        try {
            HashSet<X509Certificate> certs = new HashSet<X509Certificate>();
            certs.add(cert);
            return (TrustyOCSPStatus)((Map)((CompletableFuture)this.ocspValidator.validateAsync(certs).thenApply(TrustyOCSPValidationResult::getStatuses)).get()).get(cert.getSerialNumber());
        }
        catch (InterruptedException ex) {
            Logger.getLogger(TrustyCertificateValidator.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ExecutionException ex) {
            Logger.getLogger(TrustyCertificateValidator.class.getName()).log(Level.SEVERE, null, ex);
        }
        return null;
    }
}

