/*
 * Decompiled with CFR 0.152.
 */
package at.ac.tuwien.infosys.jaxb;

import at.ac.tuwien.infosys.jaxb.SchemagenUtil;
import com.sun.xml.bind.v2.model.core.EnumConstant;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class AnnotationUtils {
    public static final Logger logger = Logger.getLogger(SchemagenUtil.class.getName());
    public static final Map<Object, AnnotationInvocationHandler> PROXY_HANDLERS = new IdentityHashMap<Object, AnnotationInvocationHandler>();

    private AnnotationUtils() {
    }

    public static <T extends Annotation> Map<String, Object> getAnnotationValues(Class<T> annoClass, T anno) {
        HashMap<String, Object> annoValues = new HashMap<String, Object>();
        for (Method m : annoClass.getDeclaredMethods()) {
            try {
                Object value = null;
                if (anno != null) {
                    try {
                        value = m.invoke(anno, new Object[0]);
                    }
                    catch (Exception e) {
                        value = m.getDefaultValue();
                    }
                } else {
                    value = m.getDefaultValue();
                }
                annoValues.put(m.getName(), value);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return annoValues;
    }

    public static <T extends Annotation> T createAnnotationProxy(Class<T> annoClass, T annoValueDefaults) {
        Map<String, Object> annoValues = AnnotationUtils.getAnnotationValues(annoClass, annoValueDefaults);
        return AnnotationUtils.createAnnotationProxy(annoClass, annoValues, annoClass.getClassLoader());
    }

    public static <T extends Annotation> T createAnnotationProxy(Class<T> annoClass, Map<String, Object> annoValues) {
        return AnnotationUtils.createAnnotationProxy(annoClass, annoValues, annoClass.getClassLoader());
    }

    public static <T extends Annotation> T createAnnotationProxy(Class<T> annoClass, Map<String, Object> annoValues, ClassLoader cl) {
        AnnotationInvocationHandler h = new AnnotationInvocationHandler(annoClass, annoValues);
        Annotation proxy = (Annotation)Proxy.newProxyInstance(cl, new Class[]{annoClass}, (InvocationHandler)h);
        PROXY_HANDLERS.put(proxy, h);
        return (T)proxy;
    }

    public static <T, C, AnnoT extends Annotation> AnnoT getAnnoFromEnum(EnumConstant<T, C> c, Class<AnnoT> annoClass) {
        try {
            C enumClazz = c.getEnclosingClass().getClazz();
            if (enumClazz instanceof Class) {
                Class enumClass = (Class)enumClazz;
                Field field = enumClass.getField(c.getName());
                return field.getAnnotation(annoClass);
            }
            return SchemagenUtil.extractAnnotation(enumClazz, annoClass);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Unable to get annotation '@" + annoClass + "' for enum constant " + c, e);
            return null;
        }
    }

    public static class AnnotationInvocationHandler
    implements InvocationHandler {
        public final Class<?> annoClass;
        public final Map<String, Object> annoValues = new HashMap<String, Object>();

        public AnnotationInvocationHandler(Class<?> annoClass, Map<String, Object> annoValues) {
            this.annoClass = annoClass;
            this.annoValues.putAll(annoValues);
        }

        @Override
        public Object invoke(Object o, Method m, Object[] args) throws Throwable {
            if (m.getName().equals("toString") && !this.annoValues.containsKey(m.getName())) {
                return "annotation @" + this.annoClass.getName() + "(" + this.annoValues + ")";
            }
            if (m.getName().equals("hashCode")) {
                return this.annoClass.hashCode() + this.annoValues.hashCode();
            }
            if (!this.annoValues.containsKey(m.getName())) {
                throw new IllegalAccessException("Annotation proxy for '" + this + "' does not have method '" + m.getName() + "'");
            }
            return this.annoValues.get(m.getName());
        }

        public String toString() {
            return "[AnnotationInvocationHandler @" + this.annoClass.getName().replace("interface ", "") + ", " + this.annoValues + "]";
        }
    }
}

