/*
 * Decompiled with CFR 0.152.
 */
package at.ac.tuwien.infosys.jaxb;

import at.ac.tuwien.infosys.jaxb.AnnotationUtils;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SchemagenUtil {
    public static final Logger logger = Logger.getLogger(SchemagenUtil.class.getName());

    public static <T> List<? extends Annotation> extractAnnotations(T type) throws Exception {
        LinkedList result = new LinkedList();
        List annos = null;
        Object tsym = type;
        if (type.getClass().getName().endsWith("ClassType")) {
            tsym = type.getClass().getField("tsym").get(type);
        }
        annos = (List)tsym.getClass().getMethod("getAnnotationMirrors", new Class[0]).invoke(tsym, new Object[0]);
        for (Object anno : annos) {
            String annoType = anno.getClass().getField("type").get(anno).toString();
            Class<?> annoClass = Class.forName(annoType);
            List values = (List)anno.getClass().getField("values").get(anno);
            HashMap<String, Object> annoValues = new HashMap<String, Object>();
            for (Object value : values) {
                Object fst = value.getClass().getField("fst").get(value);
                Object snd = value.getClass().getField("snd").get(value);
                String attrName = fst.getClass().getField("name").get(fst).toString();
                Object attrValue = snd.getClass().getMethod("getValue", new Class[0]).invoke(snd, new Object[0]);
                annoValues.put(attrName, attrValue);
            }
            Object annoInst = AnnotationUtils.createAnnotationProxy(annoClass, annoValues);
            result.add(annoInst);
        }
        return result;
    }

    public static <T, A extends Annotation> A extractAnnotation(T type, Class<A> annoType) {
        try {
            for (Annotation a : SchemagenUtil.extractAnnotations(type)) {
                if (!annoType.isAssignableFrom(a.getClass())) continue;
                return (A)a;
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Unable to extract annotation '" + annoType + "' from type '" + type.getClass() + "'", e);
        }
        return null;
    }
}

