/*
 * Decompiled with CFR 0.152.
 */
package at.ac.tuwien.infosys.jaxb;

import at.ac.tuwien.infosys.jaxb.AnnotationUtils;
import com.sun.xml.bind.v2.model.annotation.AnnotationSource;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.HashMap;
import javax.validation.constraints.AssertFalse;
import javax.validation.constraints.AssertTrue;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Digits;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import javax.xml.bind.annotation.Facets;
import javax.xml.bind.annotation.MinOccurs;

public class ValidationFacetsFilter {
    public Annotation filterAnnotation(Class<? extends Annotation> cls, Annotation original, AnnotatedElement elem) {
        return this.filterAnnotation(cls, original, new AnnotatedElementWrapper(elem));
    }

    public Annotation filterAnnotation(Class<? extends Annotation> cls, Annotation original, AnnotationSource info) {
        if (cls == Facets.class) {
            return this.filterFacets((Facets)original, info);
        }
        if (cls == MinOccurs.class) {
            return this.filterMinOccurs((MinOccurs)original, info);
        }
        return original;
    }

    private Facets filterFacets(Facets original, AnnotationSource info) {
        Size size;
        HashMap<String, Object> annoValues = new HashMap<String, Object>(AnnotationUtils.getAnnotationValues(Facets.class, original));
        boolean override = false;
        String[] enums = new String[]{};
        try {
            enums = original.enumeration();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (enums.length <= 0) {
            if (info.readAnnotation(AssertFalse.class) != null) {
                override = true;
                annoValues.put("enumeration", new String[]{"false", "0"});
            } else if (info.readAnnotation(AssertTrue.class) != null) {
                override = true;
                annoValues.put("enumeration", new String[]{"true", "1"});
            }
        }
        long fractions = -1L;
        try {
            fractions = original.fractionDigits();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (fractions == -1L && info.readAnnotation(Digits.class) != null) {
            override = true;
            annoValues.put("fractionDigits", info.readAnnotation(Digits.class).fraction());
        }
        long length = -1L;
        try {
            length = original.length();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (length == -1L && info.readAnnotation(Size.class) != null && (size = info.readAnnotation(Size.class)).max() == size.min()) {
            override = true;
            annoValues.put("length", size.max());
        }
        long maxLength = -1L;
        try {
            maxLength = original.maxLength();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (maxLength == -1L && info.readAnnotation(Size.class) != null) {
            override = true;
            annoValues.put("maxLength", info.readAnnotation(Size.class).max());
        }
        long minLength = -1L;
        try {
            minLength = original.minLength();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (minLength == -1L && info.readAnnotation(Size.class) != null) {
            override = true;
            annoValues.put("minLength", info.readAnnotation(Size.class).min());
        }
        String maxInclusive = "";
        try {
            maxInclusive = original.maxInclusive();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if ("".equals(maxInclusive)) {
            if (info.readAnnotation(DecimalMax.class) != null) {
                override = true;
                annoValues.put("maxInclusive", info.readAnnotation(DecimalMax.class).value());
            } else if (info.readAnnotation(Max.class) != null) {
                override = true;
                annoValues.put("maxInclusive", Long.toString(info.readAnnotation(Max.class).value()));
            }
        }
        String minInclusive = "";
        try {
            minInclusive = original.minInclusive();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if ("".equals(minInclusive)) {
            if (info.readAnnotation(DecimalMin.class) != null) {
                override = true;
                annoValues.put("minInclusive", info.readAnnotation(DecimalMin.class).value());
            } else if (info.readAnnotation(Min.class) != null) {
                override = true;
                annoValues.put("minInclusive", Long.toString(info.readAnnotation(Min.class).value()));
            }
        }
        String pattern = "";
        try {
            pattern = original.pattern();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if ("".equals(pattern) && info.readAnnotation(Pattern.class) != null) {
            override = true;
            annoValues.put("pattern", info.readAnnotation(Pattern.class).regexp());
        }
        long totalDigits = -1L;
        try {
            totalDigits = original.totalDigits();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (totalDigits == -1L && info.readAnnotation(Digits.class) != null) {
            override = true;
            annoValues.put("totalDigits", info.readAnnotation(Digits.class).integer() + info.readAnnotation(Digits.class).fraction());
        }
        return override ? AnnotationUtils.createAnnotationProxy(Facets.class, annoValues) : original;
    }

    private MinOccurs filterMinOccurs(MinOccurs original, AnnotationSource info) {
        HashMap<String, Object> annoValues = new HashMap<String, Object>(AnnotationUtils.getAnnotationValues(MinOccurs.class, original));
        if (original == null && info.readAnnotation(NotNull.class) != null) {
            annoValues.put("value", 1L);
            return AnnotationUtils.createAnnotationProxy(MinOccurs.class, annoValues);
        }
        return original;
    }

    static class AnnotatedElementWrapper
    implements AnnotationSource {
        private AnnotatedElement element;

        public AnnotatedElementWrapper(AnnotatedElement element) {
            this.element = element;
        }

        @Override
        public <A extends Annotation> A readAnnotation(Class<A> type) {
            return this.element.getAnnotation(type);
        }

        @Override
        public boolean hasAnnotation(Class<? extends Annotation> type) {
            return this.element.isAnnotationPresent(type);
        }
    }
}

