/*
 * Decompiled with CFR 0.152.
 */
package at.ac.tuwien.infosys.jaxb;

import at.ac.tuwien.infosys.jaxb.Constants;
import com.sun.codemodel.JAnnotationUse;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JFieldVar;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.Plugin;
import com.sun.tools.xjc.generator.bean.ClassOutlineImpl;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.FieldOutline;
import com.sun.tools.xjc.outline.Outline;
import com.sun.tools.xjc.reader.xmlschema.bindinfo.BindInfo;
import com.sun.xml.xsom.XSAnnotation;
import com.sun.xml.xsom.XSComponent;
import com.sun.xml.xsom.XSFacet;
import com.sun.xml.xsom.XSSimpleType;
import com.sun.xml.xsom.XSType;
import com.sun.xml.xsom.impl.AnnotationImpl;
import com.sun.xml.xsom.impl.ParticleImpl;
import javax.xml.bind.annotation.Annotation;
import javax.xml.bind.annotation.Documentation;
import javax.xml.bind.annotation.Facets;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

public class WsImportFacetsPlugin
extends Plugin {
    public String getOptionName() {
        return "jaxb-facets";
    }

    public String getUsage() {
        return "  -jaxb-facets    :  Generate JAXB annotations for XSD <facet>'s and <annotation>'s";
    }

    public boolean run(Outline outline, Options opt, ErrorHandler errorHandler) throws SAXException {
        for (ClassOutline c : outline.getClasses()) {
            ClassOutlineImpl ci = (ClassOutlineImpl)c;
            XSComponent schemaEl = ci.target.getSchemaComponent();
            WsImportFacetsPlugin.addXsdAnnotation(ci, schemaEl);
            WsImportFacetsPlugin.addXsdFacets(ci, schemaEl);
        }
        return true;
    }

    public static void addXsdFacets(ClassOutlineImpl ci, XSComponent schemaEl) {
        JDefinedClass clazz = ci.implClass;
        for (FieldOutline f : ci.getDeclaredFields()) {
            XSType type;
            ParticleImpl p;
            XSComponent schema = f.getPropertyInfo().getSchemaComponent();
            if (!(schema instanceof ParticleImpl) || !(p = (ParticleImpl)schema).getTerm().isElementDecl() || !(type = p.getTerm().asElementDecl().getType()).isSimpleType()) continue;
            XSSimpleType stype = type.asSimpleType();
            for (String fName : Constants.FACET_NAMES) {
                XSFacet fValue = stype.getFacet(fName);
                if (fValue == null) continue;
                String name = f.getPropertyInfo().getName(false);
                JFieldVar var = (JFieldVar)clazz.fields().get(name);
                JAnnotationUse anno = WsImportFacetsPlugin.getAnnotation(var, Facets.class);
                Class<?> typeClazz = Constants.FACET_TYPES.get(fName);
                if (typeClazz == Long.TYPE) {
                    anno.param(fValue.getName(), Long.parseLong(fValue.getValue().value));
                    continue;
                }
                if (typeClazz == String.class) {
                    anno.param(fValue.getName(), fValue.getValue().value);
                    continue;
                }
                if (typeClazz == Facets.WhiteSpace.class) {
                    anno.param(fValue.getName(), (Enum)Facets.WhiteSpace.valueOf((String)fValue.getValue().value));
                    continue;
                }
                if (typeClazz != String[].class) continue;
            }
        }
    }

    public static void addXsdAnnotation(ClassOutlineImpl ci, XSComponent schemaEl) {
        String doc;
        AnnotationImpl annoImpl;
        BindInfo annoInfo;
        XSAnnotation anno = schemaEl.getAnnotation();
        if (anno != null && (annoInfo = (BindInfo)(annoImpl = (AnnotationImpl)anno).getAnnotation()) != null && (doc = annoInfo.getDocumentation()) != null) {
            JAnnotationUse jAnno = WsImportFacetsPlugin.getAnnotation(ci.implClass, Annotation.class);
            JAnnotationUse annoUse = jAnno.annotationParam("documentation", Documentation.class);
            annoUse.param("value", doc);
        }
    }

    private static JAnnotationUse getAnnotation(JDefinedClass clazz, Class<? extends java.lang.annotation.Annotation> annoClass) {
        for (JAnnotationUse a : clazz.annotations()) {
            if (!a.getAnnotationClass().fullName().equals(annoClass.getName())) continue;
            return a;
        }
        JAnnotationUse jAnno = clazz.annotate(annoClass);
        return jAnno;
    }

    private static JAnnotationUse getAnnotation(JFieldVar var, Class<? extends java.lang.annotation.Annotation> annoClass) {
        for (JAnnotationUse a : var.annotations()) {
            if (!a.getAnnotationClass().fullName().equals(annoClass.getName())) continue;
            return a;
        }
        JAnnotationUse jAnno = var.annotate(annoClass);
        return jAnno;
    }
}

