/*
 * Decompiled with CFR 0.152.
 */
package at.ac.tuwien.infosys.jaxb;

import at.ac.tuwien.infosys.jaxb.AnnotationUtils;
import at.ac.tuwien.infosys.jaxb.Constants;
import at.ac.tuwien.infosys.jaxb.DOMtoTXW;
import at.ac.tuwien.infosys.jaxb.SchemagenUtil;
import at.ac.tuwien.infosys.jaxb.ValidationFacetsFilter;
import com.sun.tools.javac.code.Type;
import com.sun.xml.bind.v2.model.core.ArrayInfo;
import com.sun.xml.bind.v2.model.core.AttributePropertyInfo;
import com.sun.xml.bind.v2.model.core.ClassInfo;
import com.sun.xml.bind.v2.model.core.ElementPropertyInfo;
import com.sun.xml.bind.v2.model.core.EnumConstant;
import com.sun.xml.bind.v2.model.core.EnumLeafInfo;
import com.sun.xml.bind.v2.model.core.ID;
import com.sun.xml.bind.v2.model.core.PropertyInfo;
import com.sun.xml.bind.v2.model.core.TypeRef;
import com.sun.xml.bind.v2.model.core.ValuePropertyInfo;
import com.sun.xml.bind.v2.schemagen.xmlschema.LocalAttribute;
import com.sun.xml.bind.v2.schemagen.xmlschema.LocalElement;
import com.sun.xml.bind.v2.schemagen.xmlschema.Particle;
import com.sun.xml.bind.v2.schemagen.xmlschema.SimpleRestrictionModel;
import com.sun.xml.txw2.TypedXmlWriter;
import com.sun.xml.txw2.output.ResultFactory;
import com.sun.xml.txw2.output.TXWResult;
import com.sun.xml.txw2.output.TXWSerializer;
import java.io.ByteArrayInputStream;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.annotation.Annotation;
import javax.xml.bind.annotation.AnnotationLocation;
import javax.xml.bind.annotation.AppInfo;
import javax.xml.bind.annotation.Assert;
import javax.xml.bind.annotation.Attribute;
import javax.xml.bind.annotation.Documentation;
import javax.xml.bind.annotation.Facets;
import javax.xml.bind.annotation.MaxOccurs;
import javax.xml.bind.annotation.MinOccurs;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;

public class XmlSchemaEnhancer {
    public static final String NS_XSD = "http://www.w3.org/2001/XMLSchema";
    public static final String NS_XML = "http://www.w3.org/XML/1998/namespace";
    private static ValidationFacetsFilter facetFilter = new ValidationFacetsFilter();
    private static final DocumentBuilderFactory XML_FACTORY = DocumentBuilderFactory.newInstance();
    private static final List<Class<? extends java.lang.annotation.Annotation>> EXT_ANNO_CLASSES_AT_START = new ArrayList<Class<? extends java.lang.annotation.Annotation>>();
    private static final List<Class<? extends java.lang.annotation.Annotation>> EXT_ANNO_CLASSES_AT_END = new ArrayList<Class<? extends java.lang.annotation.Annotation>>();
    public static final AtomicBoolean XSD_11_ENABLED;
    public static final Logger logger;

    public static <T, C> boolean hasExtendedAnnotations(TypeRef<T, C> t) {
        return XmlSchemaEnhancer.hasFacets(t) || XmlSchemaEnhancer.hasXsdExtensions(t);
    }

    public static <T, C> boolean hasExtendedAnnotations(AttributePropertyInfo<T, C> info) {
        return XmlSchemaEnhancer.hasFacets(info) || XmlSchemaEnhancer.hasXsdExtensions(info);
    }

    public static <T, C> void addFacets(ValuePropertyInfo<T, C> vp, SimpleRestrictionModel restriction) {
        if (!XmlSchemaEnhancer.hasFacets(vp)) {
            return;
        }
        Facets facetsAnno = XmlSchemaEnhancer.getFacetsAnnotation(vp);
        XmlSchemaEnhancer.addFacets(facetsAnno, (TypedXmlWriter)restriction, vp.getSource().getSchemaType());
    }

    public static <T, C> void addFacets(EnumLeafInfo<T, C> e, SimpleRestrictionModel restriction) {
        Object type = e.getType();
        if (type instanceof Class) {
            Facets facets = ((Class)type).getAnnotation(Facets.class);
            XmlSchemaEnhancer.addFacets(facets, (TypedXmlWriter)restriction, (Class)type);
        } else if (type.getClass().getName().endsWith("ClassType")) {
            Facets facets = SchemagenUtil.extractAnnotation(type, Facets.class);
            XmlSchemaEnhancer.addFacets(facets, (TypedXmlWriter)restriction, (Class)null);
        }
    }

    public static <T, C> void addFacets(TypeRef<T, C> t, LocalElement e) {
        if (!XmlSchemaEnhancer.hasFacets(t)) {
            return;
        }
        Facets facetsAnno = XmlSchemaEnhancer.getFacetsAnnotation(t);
        TypedXmlWriter restriction = XmlSchemaEnhancer.getRestriction(t, (TypedXmlWriter)e, null);
        if (t.getTarget().getType() instanceof Class) {
            XmlSchemaEnhancer.addFacets(facetsAnno, restriction, (Class)t.getTarget().getType());
        } else if (t.getTarget().getType() instanceof Type.ClassType) {
            Type.ClassType ct = (Type.ClassType)t.getTarget().getType();
            XmlSchemaEnhancer.addFacets(facetsAnno, restriction, (Class)null);
        }
    }

    public static <T, C> void addFacets(AttributePropertyInfo<T, C> info, LocalAttribute attr) {
        if (!XmlSchemaEnhancer.hasFacets(info)) {
            return;
        }
        Facets facetsAnno = XmlSchemaEnhancer.getFacetsAnnotation(info);
        TypedXmlWriter restriction = XmlSchemaEnhancer.getRestriction(info, (TypedXmlWriter)attr, null);
        XmlSchemaEnhancer.addFacets(facetsAnno, restriction, info.getSource().getSchemaType());
    }

    public static <T, C> void addFacets(Facets facetsAnno, TypedXmlWriter restriction, QName baseType) {
        XmlSchemaEnhancer.addFacets(facetsAnno, restriction, baseType == null ? null : Constants.FACET_TYPES.get(baseType.getLocalPart()));
    }

    public static <T, C> void addFacets(Facets facetsAnno, TypedXmlWriter restriction, Class<?> baseType) {
        SortedMap<String, List<String>> facets = null;
        try {
            facets = XmlSchemaEnhancer.getDefinedFacets(facetsAnno);
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, "Unable to add XSD Facets in Schema generated by JAXB.", ex);
            return;
        }
        XmlSchemaEnhancer.checkFacetsValidity(baseType, facets);
        for (String facetName : facets.keySet()) {
            for (String facetValue : (List)facets.get(facetName)) {
                logger.fine("Adding XSD-Facets schema restriction: " + new QName(NS_XSD, facetName));
                restriction._element(new QName(NS_XSD, facetName), TypedXmlWriter.class)._attribute("value", (Object)facetValue);
            }
        }
    }

    private static void checkFacetsValidity(Class<?> baseType, Map<String, List<String>> facets) {
        if (baseType == null) {
            return;
        }
        Set<String> allowed = Constants.FACETS_BY_TYPE.get(baseType);
        if (allowed == null && Enum.class.isAssignableFrom(baseType)) {
            allowed = Constants.FACETS_BY_TYPE.get(Enum.class);
        }
        if (allowed == null) {
            logger.fine("Cannot determine allowed facets for base type " + baseType);
        } else {
            for (String facetName : facets.keySet()) {
                if (allowed.contains(facetName)) continue;
                logger.info("Facet '" + facetName + "' not in allowed facets " + allowed + " for base type " + baseType);
            }
        }
    }

    public static <T, C> boolean hasFacets(ValuePropertyInfo<T, C> vp) {
        Facets facets = XmlSchemaEnhancer.getFacetsAnnotation(vp);
        return XmlSchemaEnhancer.hasFacets(facets);
    }

    public static <T, C> boolean hasFacets(TypeRef<T, C> t) {
        Facets facets = XmlSchemaEnhancer.getFacetsAnnotation(t);
        return XmlSchemaEnhancer.hasFacets(facets);
    }

    public static <T, C> boolean hasFacets(AttributePropertyInfo<T, C> ap) {
        Facets facets = XmlSchemaEnhancer.getFacetsAnnotation(ap);
        return XmlSchemaEnhancer.hasFacets(facets);
    }

    public static <T, C> boolean hasFacets(Facets facets) {
        if (facets == null) {
            return false;
        }
        try {
            SortedMap<String, List<String>> definedFacets = XmlSchemaEnhancer.getDefinedFacets(facets);
            return definedFacets.size() > 0;
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Unable to get defined XSD Facets", e);
            return false;
        }
    }

    public static <T, C> void addXsdExtensions(Set<ClassInfo<T, C>> classes, Set<EnumLeafInfo<T, C>> enums, Set<ArrayInfo<T, C>> arrays, TypedXmlWriter w) {
        HashSet<Package> annotatedPackages = new HashSet<Package>();
        for (ClassInfo<T, C> classInfo : classes) {
            annotatedPackages.addAll(XmlSchemaEnhancer.extractPackage(classInfo.getType()));
        }
        for (EnumLeafInfo enumLeafInfo : enums) {
            annotatedPackages.addAll(XmlSchemaEnhancer.extractPackage(enumLeafInfo.getType()));
        }
        for (ArrayInfo arrayInfo : arrays) {
            annotatedPackages.addAll(XmlSchemaEnhancer.extractPackage(arrayInfo.getType()));
        }
        for (Package package_ : annotatedPackages) {
            XmlSchemaEnhancer.addXsdExtensionsAtStart(package_, w);
        }
    }

    public static <T> void addXsdExtensionsAtStart(T type, TypedXmlWriter w) {
        for (Class<? extends java.lang.annotation.Annotation> c : EXT_ANNO_CLASSES_AT_START) {
            if (!XmlSchemaEnhancer.hasXsdExtension(type, c)) continue;
            java.lang.annotation.Annotation anno = XmlSchemaEnhancer.getXsdExtensionAnnotation(type, c);
            XmlSchemaEnhancer.addXsdExtensionInsideElement(anno, w);
        }
    }

    public static <T, C> void addXsdExtensionsAtStart(ClassInfo<T, C> ci, TypedXmlWriter w) {
        for (Class<? extends java.lang.annotation.Annotation> c : EXT_ANNO_CLASSES_AT_START) {
            if (!XmlSchemaEnhancer.hasXsdExtension(ci, c)) continue;
            java.lang.annotation.Annotation anno = XmlSchemaEnhancer.getXsdExtensionAnnotation(ci, c);
            XmlSchemaEnhancer.addXsdExtensionInsideElement(anno, w);
        }
    }

    public static <T, C> void addXsdExtensionsAtStart(AttributePropertyInfo<T, C> _info, LocalAttribute _attr) {
        for (Class<? extends java.lang.annotation.Annotation> c : EXT_ANNO_CLASSES_AT_START) {
            if (!XmlSchemaEnhancer.hasXsdExtension(_info, c)) continue;
            java.lang.annotation.Annotation anno = XmlSchemaEnhancer.getXsdExtensionAnnotation(_info, c);
            XmlSchemaEnhancer.addXsdExtensionInsideElement(anno, _attr);
        }
    }

    public static <T, C> void addXsdExtensionsAtStart(TypeRef<T, C> t, LocalElement e) {
        for (Class<? extends java.lang.annotation.Annotation> c : EXT_ANNO_CLASSES_AT_START) {
            if (!XmlSchemaEnhancer.hasXsdExtension(t, c)) continue;
            java.lang.annotation.Annotation anno = XmlSchemaEnhancer.getXsdExtensionAnnotation(t, c);
            XmlSchemaEnhancer.addXsdExtensionInsideElement(anno, e);
        }
    }

    public static <T, C> void addXsdExtensionsAtEnd(ClassInfo<T, C> type, TypedXmlWriter w) {
        for (Class<? extends java.lang.annotation.Annotation> c : EXT_ANNO_CLASSES_AT_END) {
            if (!XmlSchemaEnhancer.hasXsdExtension(type, c)) continue;
            java.lang.annotation.Annotation anno = XmlSchemaEnhancer.getXsdExtensionAnnotation(type, c);
            XmlSchemaEnhancer.addXsdExtensionInsideElement(anno, w);
        }
    }

    public static <T, C> void addXsdExtensionsAtEnd(PropertyInfo<T, C> elementInfo, TypedXmlWriter w) {
        for (Class<? extends java.lang.annotation.Annotation> c : EXT_ANNO_CLASSES_AT_END) {
            java.lang.annotation.Annotation anno = elementInfo.readAnnotation(c);
            if (anno == null) continue;
            XmlSchemaEnhancer.addXsdExtensionInsideElement(anno, w);
        }
    }

    public static <T, C> void addXsdAnnotationsOutsideElement(ElementPropertyInfo<T, C> elementInfo, LocalElement el) {
        Annotation anno = elementInfo.readAnnotation(Annotation.class);
        if (anno != null && anno.location() == AnnotationLocation.OUTSIDE_ELEMENT) {
            XmlSchemaEnhancer.addXsdExtension((java.lang.annotation.Annotation)anno, el);
        }
    }

    public static <T, C> void addXsdAnnotationsOutsideElement(PropertyInfo<T, C> elementInfo, Particle c) {
        Annotation anno = elementInfo.readAnnotation(Annotation.class);
        if (anno != null && anno.location() == AnnotationLocation.OUTSIDE_ELEMENT) {
            XmlSchemaEnhancer.addXsdExtension((java.lang.annotation.Annotation)anno, c);
        }
    }

    private static <T, C> void addXsdExtensionInsideElement(java.lang.annotation.Annotation anno, TypedXmlWriter obj) {
        if (XmlSchemaEnhancer.instanceOf(anno, Annotation.class)) {
            Annotation annoCast = (Annotation)anno;
            if (annoCast.location() == AnnotationLocation.INSIDE_ELEMENT) {
                XmlSchemaEnhancer.addXsdExtension(anno, obj);
            }
        } else if (XmlSchemaEnhancer.instanceOf(anno, Assert.class)) {
            XmlSchemaEnhancer.addXsdExtension(anno, obj);
        } else {
            logger.warning("Unexpected annotation type: " + anno.getClass());
        }
    }

    public static <T, C> void addXsdExtension(java.lang.annotation.Annotation annoInst, TypedXmlWriter obj) {
        if (XmlSchemaEnhancer.instanceOf(annoInst, Annotation.class)) {
            TypedXmlWriter w;
            Annotation anno = (Annotation)annoInst;
            TypedXmlWriter annoEl = XmlSchemaEnhancer.writeXsdAnnotationElement(obj, anno.id(), anno.attributes());
            for (AppInfo appInfo : anno.appinfo()) {
                w = annoEl._element(new QName(NS_XSD, "appinfo"), TypedXmlWriter.class);
                if (appInfo.source() != null && !appInfo.source().equals("")) {
                    w._attribute(new QName("source"), (Object)appInfo.source());
                }
                XmlSchemaEnhancer.writeXMLOrPCData(w, appInfo.value());
            }
            for (AppInfo appInfo : anno.documentation()) {
                w = annoEl._element(new QName(NS_XSD, "documentation"), TypedXmlWriter.class);
                if (appInfo.source() != null && !appInfo.source().equals("")) {
                    w._attribute(new QName("source"), (Object)appInfo.source());
                }
                if (appInfo.lang() != null && !appInfo.lang().equals("")) {
                    w._attribute(new QName(NS_XML, "lang"), (Object)appInfo.lang());
                }
                XmlSchemaEnhancer.writeXMLOrPCData(w, appInfo.value());
            }
        } else if (XmlSchemaEnhancer.instanceOf(annoInst, Assert.class)) {
            Assert anno = (Assert)annoInst;
            if (XmlSchemaEnhancer.checkXSD11Enabled()) {
                XmlSchemaEnhancer.writeXsdAssertElement(obj, anno.id(), anno.test(), anno.attributes());
                if (anno.annotation() != null && anno.annotation().length > 0) {
                    for (Annotation xsdAnno : anno.annotation()) {
                        XmlSchemaEnhancer.addXsdExtension((java.lang.annotation.Annotation)xsdAnno, obj);
                    }
                }
            }
        } else {
            logger.warning("Unexpected annotation instance: " + annoInst);
        }
    }

    private static Document parseValueAsXML(String value) {
        try {
            if (value == null || !value.trim().startsWith("<")) {
                return null;
            }
            DocumentBuilder dBuilder = XML_FACTORY.newDocumentBuilder();
            Document doc = dBuilder.parse(new ByteArrayInputStream(value.getBytes()));
            doc.getDocumentElement().normalize();
            logger.fine("Treating string as valid XML: '" + value + "'");
            return doc;
        }
        catch (Exception e) {
            logger.fine("Cannot parse value as XML, treating as regular string: '" + value + "'");
            return null;
        }
    }

    private static void writeXMLOrPCData(TypedXmlWriter w, String value) {
        Document doc = XmlSchemaEnhancer.parseValueAsXML(value);
        if (doc == null) {
            w._pcdata(value);
            return;
        }
        try {
            XmlSchemaEnhancer.writeXML(w, value);
        }
        catch (Exception e) {
            logger.info("Unable to write XML data to TXW2 serializer: " + e);
            w._pcdata(value);
        }
    }

    private static void writeXML(TypedXmlWriter w, String value) throws Exception {
        TXWSerializer ser = (TXWSerializer)ResultFactory.createSerializer(new TXWResult(w));
        new DOMtoTXW(w).convert(value);
    }

    public static <T, C> boolean hasXsdExtensions(ClassInfo<T, C> ci) {
        for (Class<? extends java.lang.annotation.Annotation> c : EXT_ANNO_CLASSES_AT_START) {
            if (!XmlSchemaEnhancer.hasXsdExtension(ci, c)) continue;
            return true;
        }
        return false;
    }

    public static <T, C> boolean hasXsdExtensions(TypeRef<T, C> t) {
        for (Class<? extends java.lang.annotation.Annotation> c : EXT_ANNO_CLASSES_AT_START) {
            if (!XmlSchemaEnhancer.hasXsdExtension(t, c)) continue;
            return true;
        }
        return false;
    }

    public static <T, C> boolean hasXsdExtensions(AttributePropertyInfo<T, C> info) {
        for (Class<? extends java.lang.annotation.Annotation> c : EXT_ANNO_CLASSES_AT_START) {
            if (!XmlSchemaEnhancer.hasXsdExtension(info, c)) continue;
            return true;
        }
        return false;
    }

    public static <T, C> boolean hasXsdExtension(ClassInfo<T, C> ci, Class<? extends java.lang.annotation.Annotation> annoClass) {
        java.lang.annotation.Annotation anno = XmlSchemaEnhancer.getXsdExtensionAnnotation(ci, annoClass);
        return anno != null;
    }

    public static <T> boolean hasXsdExtension(T type, Class<? extends java.lang.annotation.Annotation> annoClass) {
        java.lang.annotation.Annotation anno = XmlSchemaEnhancer.getXsdExtensionAnnotation(type, annoClass);
        return anno != null;
    }

    public static <T, C> boolean hasXsdExtension(TypeRef<T, C> t, Class<? extends java.lang.annotation.Annotation> annoClass) {
        java.lang.annotation.Annotation anno = XmlSchemaEnhancer.getXsdExtensionAnnotation(t, annoClass);
        return anno != null;
    }

    public static <T, C> boolean hasXsdExtension(AttributePropertyInfo<T, C> ap, Class<? extends java.lang.annotation.Annotation> annoClass) {
        java.lang.annotation.Annotation anno = XmlSchemaEnhancer.getXsdExtensionAnnotation(ap, annoClass);
        return anno != null;
    }

    public static <T, C> boolean writeCustomOccurs(TypeRef<T, C> t, LocalElement e, boolean isOptional, boolean repeated) {
        MaxOccurs max = null;
        MinOccurs min = null;
        try {
            max = (MaxOccurs)XmlSchemaEnhancer.getAnnotationOfProperty(t.getSource(), MaxOccurs.class);
        }
        catch (Exception e2) {
            logger.log(Level.WARNING, "Unable to get @MaxOccurs annotation from type " + t, e2);
        }
        try {
            min = (MinOccurs)XmlSchemaEnhancer.getAnnotationOfProperty(t.getSource(), MinOccurs.class);
        }
        catch (Exception e2) {
            logger.log(Level.WARNING, "Unable to get @MinOccurs annotation from type " + t, e2);
        }
        if (min == null && max == null) {
            return false;
        }
        if (min != null) {
            int value = (int)min.value();
            e.minOccurs(value);
        } else if (isOptional) {
            e.minOccurs(0);
        }
        if (max != null) {
            int value = (int)max.value();
            e.maxOccurs(value);
        } else if (repeated) {
            e.maxOccurs("unbounded");
        }
        return true;
    }

    private static boolean checkXSD11Enabled() {
        return XSD_11_ENABLED.get();
    }

    private static <T> Set<Package> extractPackage(T type) {
        HashSet<Package> packages = new HashSet<Package>();
        if (type instanceof Class) {
            Class cl = (Class)type;
            Package pkg = cl.getPackage();
            packages.add(pkg);
        } else {
            try {
                String className = type.toString();
                String packageName = className.substring(0, className.lastIndexOf("."));
                Package pkg = Package.getPackage(packageName);
                if (pkg != null) {
                    packages.add(pkg);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.log(Level.WARNING, "Unable to derive package name from class type: " + type, e);
            }
        }
        return packages;
    }

    private static boolean instanceOf(java.lang.annotation.Annotation annoInst, Class<? extends java.lang.annotation.Annotation> clazz) {
        AnnotationUtils.AnnotationInvocationHandler h;
        if (annoInst == null) {
            return false;
        }
        if (Proxy.isProxyClass(annoInst.getClass()) && (h = AnnotationUtils.PROXY_HANDLERS.get(annoInst)) != null) {
            return XmlSchemaEnhancer.isAssignableFrom(clazz, h.annoClass);
        }
        return XmlSchemaEnhancer.isAssignableFrom(clazz, annoInst.getClass());
    }

    private static boolean isAssignableFrom(Class<?> clazz1, Class<?> clazz2) {
        if (clazz1.getName().equals(clazz2.getName())) {
            return true;
        }
        return clazz1.isAssignableFrom(clazz2);
    }

    private static <T, C, AnnoT extends java.lang.annotation.Annotation> AnnoT getXsdExtensionAnnotation(ClassInfo<T, C> ci, Class<AnnoT> annoClass) {
        return XmlSchemaEnhancer.getXsdExtensionAnnotation(ci.getType(), annoClass);
    }

    private static <T, C, AnnoT extends java.lang.annotation.Annotation> AnnoT getXsdExtensionAnnotation(EnumConstant c, Class<AnnoT> annoClass) {
        if (XmlSchemaEnhancer.isAssignableFrom(Annotation.class, annoClass)) {
            Documentation doc = AnnotationUtils.getAnnoFromEnum(c, Documentation.class);
            return (AnnoT)XmlSchemaEnhancer.getXsdAnnotationAnnotation(null, doc, null);
        }
        if (XmlSchemaEnhancer.isAssignableFrom(Assert.class, annoClass)) {
            return AnnotationUtils.getAnnoFromEnum(c, annoClass);
        }
        throw new IllegalArgumentException();
    }

    private static <T, C, AnnoT extends java.lang.annotation.Annotation> AnnoT getXsdExtensionAnnotation(Class<?> clazz, Class<AnnoT> annoClass) {
        if (XmlSchemaEnhancer.isAssignableFrom(Annotation.class, annoClass)) {
            Annotation anno = clazz.getAnnotation(Annotation.class);
            AppInfo appinfo = clazz.getAnnotation(AppInfo.class);
            Documentation doc = clazz.getAnnotation(Documentation.class);
            return (AnnoT)XmlSchemaEnhancer.getXsdAnnotationAnnotation(anno, doc, appinfo);
        }
        throw new IllegalArgumentException("" + annoClass);
    }

    private static <T, AnnoT extends java.lang.annotation.Annotation> AnnoT getXsdExtensionAnnotation(T type, Class<AnnoT> annoClass) {
        Object anno = null;
        if (type instanceof Class) {
            Class clazz = (Class)type;
            anno = clazz.getAnnotation(annoClass);
            if (XmlSchemaEnhancer.isAssignableFrom(Annotation.class, annoClass)) {
                AppInfo appinfo = clazz.getAnnotation(AppInfo.class);
                Documentation doc = clazz.getAnnotation(Documentation.class);
                return (AnnoT)XmlSchemaEnhancer.getXsdAnnotationAnnotation(anno, doc, appinfo);
            }
            if (XmlSchemaEnhancer.isAssignableFrom(Assert.class, annoClass)) {
                return (AnnoT)clazz.getAnnotation(Assert.class);
            }
            throw new IllegalArgumentException("" + annoClass);
        }
        if (type instanceof Package) {
            Package pkg = (Package)type;
            anno = pkg.getAnnotation(annoClass);
            if (XmlSchemaEnhancer.isAssignableFrom(Annotation.class, annoClass)) {
                AppInfo appinfo = pkg.getAnnotation(AppInfo.class);
                Documentation doc = pkg.getAnnotation(Documentation.class);
                return (AnnoT)XmlSchemaEnhancer.getXsdAnnotationAnnotation(anno, doc, appinfo);
            }
            if (XmlSchemaEnhancer.isAssignableFrom(Assert.class, annoClass)) {
                return (AnnoT)pkg.getAnnotation(Assert.class);
            }
            throw new IllegalArgumentException("" + annoClass);
        }
        if (type instanceof EnumConstant) {
            if (XmlSchemaEnhancer.isAssignableFrom(Annotation.class, annoClass)) {
                Documentation doc = AnnotationUtils.getAnnoFromEnum((EnumConstant)type, Documentation.class);
                return (AnnoT)XmlSchemaEnhancer.getXsdAnnotationAnnotation(null, doc, null);
            }
            if (XmlSchemaEnhancer.isAssignableFrom(Assert.class, annoClass)) {
                return (AnnoT)AnnotationUtils.getAnnoFromEnum((EnumConstant)type, Assert.class);
            }
            throw new IllegalArgumentException("" + annoClass);
        }
        if (type.getClass().getName().endsWith("ClassType")) {
            anno = SchemagenUtil.extractAnnotation(type, annoClass);
            if (XmlSchemaEnhancer.isAssignableFrom(Annotation.class, annoClass)) {
                AppInfo appinfo = SchemagenUtil.extractAnnotation(type, AppInfo.class);
                Documentation doc = SchemagenUtil.extractAnnotation(type, Documentation.class);
                return (AnnoT)XmlSchemaEnhancer.getXsdAnnotationAnnotation(anno, doc, appinfo);
            }
            if (XmlSchemaEnhancer.isAssignableFrom(Assert.class, annoClass)) {
                return (AnnoT)SchemagenUtil.extractAnnotation(type, Assert.class);
            }
            throw new IllegalArgumentException("" + annoClass);
        }
        logger.warning("Cannot get annotation '@" + annoClass + "' for unknown type '" + type + "'");
        return null;
    }

    private static <T, C, AnnoT extends java.lang.annotation.Annotation> AnnoT getXsdExtensionAnnotation(TypeRef<T, C> t, Class<AnnoT> annoClass) {
        return XmlSchemaEnhancer.getXsdExtensionAnnotation(t.getSource(), annoClass);
    }

    private static <T, C, AnnoT extends java.lang.annotation.Annotation> AnnoT getXsdExtensionAnnotation(AttributePropertyInfo<T, C> t, Class<AnnoT> annoClass) {
        return XmlSchemaEnhancer.getXsdExtensionAnnotation(t.getSource(), annoClass);
    }

    private static <T, C, AnnoT extends java.lang.annotation.Annotation> AnnoT getXsdExtensionAnnotation(PropertyInfo<T, C> propInfo, Class<AnnoT> annoClass) {
        if (XmlSchemaEnhancer.isAssignableFrom(Annotation.class, annoClass)) {
            Object value;
            Annotation anno = null;
            AppInfo appinfo = null;
            Documentation doc = null;
            try {
                value = XmlSchemaEnhancer.getAnnotationOfProperty(propInfo, Annotation.class);
                if (value instanceof Annotation) {
                    anno = (Annotation)value;
                }
            }
            catch (Exception e2) {
                logger.log(Level.WARNING, "Unable to get XSD Annotation annotation from type " + propInfo, e2);
            }
            try {
                value = XmlSchemaEnhancer.getAnnotationOfProperty(propInfo, AppInfo.class);
                if (value instanceof AppInfo) {
                    appinfo = (AppInfo)value;
                }
            }
            catch (Exception e2) {
                logger.log(Level.WARNING, "Unable to get XSD AppInfo annotation from type " + propInfo, e2);
            }
            try {
                value = XmlSchemaEnhancer.getAnnotationOfProperty(propInfo, Documentation.class);
                if (value instanceof Documentation) {
                    doc = (Documentation)value;
                }
            }
            catch (Exception e2) {
                logger.log(Level.WARNING, "Unable to get XSD Documentation annotation from type " + propInfo, e2);
            }
            Annotation result = XmlSchemaEnhancer.getXsdAnnotationAnnotation(anno, doc, appinfo);
            return (AnnoT)result;
        }
        if (XmlSchemaEnhancer.isAssignableFrom(Assert.class, annoClass)) {
            try {
                return (AnnoT)((java.lang.annotation.Annotation)XmlSchemaEnhancer.getAnnotationOfProperty(propInfo, Assert.class));
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Unable to get @javax.xml.bind.annotation.Assert annotation from type " + propInfo, e);
            }
        }
        throw new IllegalArgumentException("" + annoClass);
    }

    private static ClassLoader selectClassLoader(Object ... objects) {
        ClassLoader cl = null;
        for (Object o : objects) {
            if (o == null) continue;
            cl = o.getClass().getClassLoader();
            break;
        }
        if (cl == null) {
            cl = ClassLoader.getSystemClassLoader();
        }
        return cl;
    }

    protected static <T, C> Assert getXsdAssertAnnotation(String id, String test, String xpathDefaultNamespace, Attribute[] attributes, java.lang.annotation.Annotation[] annotation) {
        HashMap<String, Object> annoValues = new HashMap<String, Object>();
        annoValues.put("id", id);
        annoValues.put("test", test);
        annoValues.put("xpathDefaultNamespace", xpathDefaultNamespace);
        annoValues.put("attributes", attributes);
        annoValues.put("annotation", annotation);
        annoValues.put("xpathDefaultNamespace", xpathDefaultNamespace);
        ClassLoader cl = XmlSchemaEnhancer.selectClassLoader(new Object[0]);
        Assert anno = AnnotationUtils.createAnnotationProxy(Assert.class, annoValues, cl);
        return anno;
    }

    protected static <T, C> Annotation getXsdAnnotationAnnotation(Annotation _anno, Documentation _doc, AppInfo _appinfo) {
        if (_anno == null && _doc == null && _appinfo == null) {
            return null;
        }
        ClassLoader cl = XmlSchemaEnhancer.selectClassLoader(_anno, _doc, _appinfo);
        HashMap<String, Object> annoValues = new HashMap<String, Object>();
        annoValues.put("id", "");
        annoValues.put("appinfo", new AppInfo[0]);
        annoValues.put("attributes", new Attribute[0]);
        annoValues.put("documentation", new Documentation[0]);
        annoValues.put("location", AnnotationLocation.INSIDE_ELEMENT);
        boolean hasAnno = false;
        try {
            if (_anno instanceof Annotation) {
                annoValues.put("id", _anno.id());
                annoValues.put("appinfo", _anno.appinfo());
                annoValues.put("attributes", _anno.attributes());
                annoValues.put("documentation", _anno.documentation());
                annoValues.put("location", _anno.location());
                hasAnno = true;
            }
        }
        catch (Exception e2) {
            logger.log(Level.WARNING, "Unable to get XSD Annotation annotation from type " + _anno, e2);
        }
        try {
            if (_appinfo instanceof AppInfo) {
                AppInfo[] appinfos = (AppInfo[])annoValues.get("appinfo");
                annoValues.put("appinfo", XmlSchemaEnhancer.concat(appinfos, _appinfo));
                hasAnno = true;
            }
        }
        catch (Exception e2) {
            logger.log(Level.WARNING, "Unable to get XSD AppInfo annotation from type " + _appinfo, e2);
        }
        try {
            if (_doc instanceof Documentation) {
                Documentation[] docs = (Documentation[])annoValues.get("documentation");
                annoValues.put("documentation", XmlSchemaEnhancer.concat(docs, _doc));
                hasAnno = true;
            }
        }
        catch (Exception e2) {
            logger.log(Level.WARNING, "Unable to get XSD Documentation annotation from type " + _doc, e2);
        }
        Annotation anno = AnnotationUtils.createAnnotationProxy(Annotation.class, annoValues, cl);
        return hasAnno ? anno : null;
    }

    private static <T, C> Facets getFacetsAnnotation(TypeRef<T, C> t) {
        if (!t.getTarget().isSimpleType()) {
            return null;
        }
        try {
            Object value = XmlSchemaEnhancer.getAnnotationOfProperty(t.getSource(), Facets.class);
            if (value instanceof Facets) {
                return (Facets)value;
            }
        }
        catch (Exception e2) {
            logger.log(Level.WARNING, "Unable to get Facets annotation from type " + t, e2);
        }
        return null;
    }

    private static <T, C> Facets getFacetsAnnotation(ValuePropertyInfo<T, C> vp) {
        if (!vp.getTarget().isSimpleType()) {
            return null;
        }
        try {
            Object value = XmlSchemaEnhancer.getAnnotationOfProperty(vp.getSource(), Facets.class);
            if (value instanceof Facets) {
                return (Facets)value;
            }
        }
        catch (Exception e2) {
            logger.log(Level.WARNING, "Unable to get Facets annotation from type " + vp, e2);
        }
        return null;
    }

    private static <T, C> Facets getFacetsAnnotation(AttributePropertyInfo<T, C> t) {
        if (!t.getTarget().isSimpleType() && t.getSource().id() != ID.IDREF) {
            return null;
        }
        try {
            Object value = XmlSchemaEnhancer.getAnnotationOfProperty(t.getSource(), Facets.class);
            if (value instanceof Facets) {
                return (Facets)value;
            }
        }
        catch (Exception e2) {
            logger.log(Level.WARNING, "Unable to get Facets annotation from type " + t, e2);
        }
        return null;
    }

    private static <T, C> Object getAnnotationOfProperty(PropertyInfo<T, C> info, Class<? extends java.lang.annotation.Annotation> annoClass) throws Exception {
        java.lang.annotation.Annotation result;
        if (annoClass == Facets.class) {
            result = facetFilter.filterAnnotation(annoClass, (java.lang.annotation.Annotation)info.readAnnotation(Facets.class), info);
            if (result != null) {
                return result;
            }
        } else {
            if (annoClass == MaxOccurs.class && info.hasAnnotation(MaxOccurs.class)) {
                return info.readAnnotation(MaxOccurs.class);
            }
            if (annoClass == MinOccurs.class) {
                result = facetFilter.filterAnnotation(annoClass, (java.lang.annotation.Annotation)info.readAnnotation(MinOccurs.class), info);
                if (result != null) {
                    return result;
                }
            } else {
                if (annoClass == Documentation.class && info.hasAnnotation(Documentation.class)) {
                    return info.readAnnotation(Documentation.class);
                }
                if (annoClass == AppInfo.class && info.hasAnnotation(AppInfo.class)) {
                    return info.readAnnotation(AppInfo.class);
                }
                if (info.parent() == null) {
                    return null;
                }
                if (!(info.parent().getType() instanceof Class)) {
                    return null;
                }
            }
        }
        String name = info.getName();
        T type = info.parent().getType();
        if (info.parent().getType() instanceof Type.ClassType) {
            return null;
        }
        if (type instanceof Class) {
            Class parent = (Class)info.parent().getType();
            return XmlSchemaEnhancer.getAnnotationOfProperty(parent, name, annoClass);
        }
        throw new RuntimeException("Unexpected type of property parent: " + info.parent().getType());
    }

    protected static <T extends java.lang.annotation.Annotation> T getAnnotationOfProperty(Class<?> parent, String fieldName, Class<T> annoClass) throws Exception {
        try {
            Field field = XmlSchemaEnhancer.findAnnotatedField(parent, fieldName);
            if (field == null) {
                return null;
            }
            java.lang.annotation.Annotation a = facetFilter.filterAnnotation((Class<? extends java.lang.annotation.Annotation>)annoClass, (java.lang.annotation.Annotation)XmlSchemaEnhancer.getAnnotation(field, annoClass), field);
            return (T)a;
        }
        catch (Exception e) {
            throw new RuntimeException("Could not get annotation '" + annoClass.getSimpleName() + "' of field " + fieldName + " of class " + parent, e);
        }
    }

    private static Field findAnnotatedField(Class<?> parent, String fieldName) {
        Field field = null;
        for (Field f : parent.getDeclaredFields()) {
            XmlAttribute a;
            XmlElement e;
            if (f.getName().equals(fieldName)) {
                field = f;
                break;
            }
            if (XmlSchemaEnhancer.getAnnotation(f, XmlElement.class) != null && fieldName.equals((e = XmlSchemaEnhancer.getAnnotation(f, XmlElement.class)).name())) {
                field = f;
                break;
            }
            if (XmlSchemaEnhancer.getAnnotation(f, XmlAttribute.class) == null || !fieldName.equals((a = XmlSchemaEnhancer.getAnnotation(f, XmlAttribute.class)).name())) continue;
            field = f;
            break;
        }
        return field;
    }

    protected static <T extends java.lang.annotation.Annotation> T getAnnotation(AccessibleObject field, Class<T> annoClass) {
        for (java.lang.annotation.Annotation anno : field.getAnnotations()) {
            try {
                return (T)((java.lang.annotation.Annotation)annoClass.cast(anno));
            }
            catch (Exception exception) {
                if (anno instanceof Proxy) {
                    try {
                        InvocationHandler handler = Proxy.getInvocationHandler(anno);
                        if (handler instanceof InvocationHandler) {
                            T annoObj = XmlSchemaEnhancer.convertToAnnotation(handler, annoClass);
                            return annoObj;
                        }
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                }
                if (!annoClass.equals(anno.getClass()) && !annoClass.isAssignableFrom(anno.getClass())) continue;
                return (T)anno;
            }
        }
        return null;
    }

    private static <T extends java.lang.annotation.Annotation> T convertToAnnotation(final InvocationHandler handler, final Class<T> expectedClass) {
        try {
            Field f = InvocationHandler.class.getDeclaredField("memberValues");
            f.setAccessible(true);
            Map memberValues = (Map)f.get(handler);
            Field f1 = InvocationHandler.class.getDeclaredField("type");
            f1.setAccessible(true);
            Class type = (Class)f1.get(handler);
            if (!expectedClass.getName().equals(type.getName())) {
                throw new RuntimeException("Not the expected annotation type: " + type + " != " + expectedClass);
            }
            java.lang.annotation.Annotation anno = (java.lang.annotation.Annotation)Proxy.newProxyInstance(expectedClass.getClassLoader(), new Class[]{expectedClass}, new InvocationHandler(){

                @Override
                public Object invoke(Object proxy, Method method, Object[] args) {
                    Object o = null;
                    try {
                        o = handler.invoke(proxy, method, args);
                        if (o != null) {
                            String name;
                            ClassLoader cl;
                            Class<?> componentClass = o.getClass();
                            if (componentClass.isArray()) {
                                componentClass = componentClass.getComponentType();
                            }
                            if (!componentClass.isPrimitive() && !componentClass.getName().startsWith("java.lang") && (cl = expectedClass.getClassLoader() != null ? expectedClass.getClassLoader() : ClassLoader.getSystemClassLoader()).loadClass(name = componentClass.getName()) != componentClass) {
                                if (componentClass.getName().endsWith("WhiteSpace")) {
                                    o = Facets.WhiteSpace.valueOf((String)o.toString());
                                } else {
                                    logger.warning("Unknown/Unexpected class " + componentClass);
                                }
                            }
                        }
                    }
                    catch (Throwable e) {
                        logger.log(Level.WARNING, "", e);
                    }
                    return o;
                }
            });
            return (T)anno;
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to convert AnnotationInvocationHandler to annotation.", e);
        }
    }

    private static <T, C> TypedXmlWriter getRestriction(AttributePropertyInfo<T, C> info, TypedXmlWriter obj) {
        return XmlSchemaEnhancer.getRestriction(info, obj, null);
    }

    private static <T, C> TypedXmlWriter getRestriction(AttributePropertyInfo<T, C> info, TypedXmlWriter obj, TypedXmlWriter w) {
        QName restrName = info.getTarget().getTypeName();
        if (info.getSource().id() == ID.ID) {
            restrName = new QName(NS_XSD, "ID");
        } else if (info.getSource().id() == ID.IDREF) {
            restrName = new QName(NS_XSD, "IDREF");
        }
        return XmlSchemaEnhancer.getRestriction(restrName, obj, w);
    }

    private static <T, C> TypedXmlWriter getRestriction(ValuePropertyInfo<T, C> info, TypedXmlWriter obj, TypedXmlWriter w) {
        return XmlSchemaEnhancer.getRestriction(info.getTarget().getTypeName(), obj, w);
    }

    private static <T, C> TypedXmlWriter getRestriction(TypeRef<T, C> t, TypedXmlWriter obj, TypedXmlWriter w) {
        QName schemaType;
        if (w != null) {
            return w;
        }
        QName qName = schemaType = t.getSource() == null ? null : t.getSource().getSchemaType();
        if (schemaType == null) {
            schemaType = t.getTarget().getTypeName();
        }
        return XmlSchemaEnhancer.getRestriction(schemaType, obj, w);
    }

    private static <T, C> TypedXmlWriter getRestriction(QName typeName, TypedXmlWriter obj, TypedXmlWriter w) {
        if (w != null) {
            return w;
        }
        TypedXmlWriter st = obj._element(new QName(NS_XSD, "simpleType"), TypedXmlWriter.class);
        TypedXmlWriter r = st._element(new QName(NS_XSD, "restriction"), TypedXmlWriter.class);
        r._attribute("base", (Object)typeName);
        return r;
    }

    private static <T, C> TypedXmlWriter writeXsdAnnotationElement(TypedXmlWriter obj, String annoID, Attribute[] otherAttributes) {
        TypedXmlWriter anno = obj._element(new QName(NS_XSD, "annotation"), TypedXmlWriter.class);
        if (annoID != null && !annoID.trim().isEmpty()) {
            anno._attribute(new QName("id"), (Object)annoID);
        }
        if (otherAttributes != null && otherAttributes.length > 0) {
            for (Attribute attr : otherAttributes) {
                QName attrName = new QName(attr.namespace(), attr.name());
                anno._attribute(attrName, (Object)attr.value());
            }
        }
        return anno;
    }

    private static <T, C> TypedXmlWriter writeXsdAssertElement(TypedXmlWriter obj, String id, String test, Attribute[] otherAttributes) {
        TypedXmlWriter ass = obj._element(new QName(NS_XSD, "assert"), TypedXmlWriter.class);
        if (id != null && !id.trim().isEmpty()) {
            ass._attribute(new QName("id"), (Object)id);
        }
        if (test != null && !test.trim().isEmpty()) {
            ass._attribute(new QName("test"), (Object)test);
        }
        if (otherAttributes != null && otherAttributes.length > 0) {
            for (Attribute attr : otherAttributes) {
                QName attrName = new QName(attr.namespace(), attr.name());
                ass._attribute(attrName, (Object)attr.value());
            }
        }
        return ass;
    }

    protected static SortedMap<String, List<String>> getDefinedFacets(Facets facetsAnnotation) throws Exception {
        LinkedList<Method> annoMethods = new LinkedList<Method>();
        TreeMap<String, List<String>> result = new TreeMap<String, List<String>>();
        if (facetsAnnotation == null) {
            return result;
        }
        for (Method m : Facets.class.getDeclaredMethods()) {
            if (!m.isAnnotationPresent(Facets.FacetDefinition.class)) continue;
            annoMethods.add(m);
        }
        for (Method m : annoMethods) {
            Facets.FacetDefinition facetDefinition = m.getAnnotation(Facets.FacetDefinition.class);
            String facetName = m.getName();
            if (facetDefinition.xsdAttributeName() != null && facetDefinition.xsdAttributeName().length() > 0) {
                facetName = facetDefinition.xsdAttributeName();
            }
            Object value = null;
            try {
                value = m.invoke((Object)facetsAnnotation, new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            Object defaultValue = m.getDefaultValue();
            if (value == null || value.equals(defaultValue)) continue;
            if (!result.containsKey(facetName)) {
                result.put(facetName, new LinkedList());
            }
            if (value instanceof String[]) {
                for (String s : (String[])value) {
                    ((List)result.get(facetName)).add(s);
                }
                continue;
            }
            ((List)result.get(facetName)).add("" + value);
        }
        return result;
    }

    public static <T> T[] concat(T[] first, T[] second) {
        T[] result = Arrays.copyOf(first, first.length + second.length);
        System.arraycopy(second, 0, result, first.length, second.length);
        return result;
    }

    public static <T> T[] concat(T[] first, T second) {
        T[] result = Arrays.copyOf(first, first.length + 1);
        System.arraycopy(first, 0, result, 0, first.length);
        result[result.length - 1] = second;
        return result;
    }

    static {
        EXT_ANNO_CLASSES_AT_START.add(Annotation.class);
        EXT_ANNO_CLASSES_AT_END.add(Assert.class);
        XSD_11_ENABLED = new AtomicBoolean(true);
        logger = Logger.getLogger(XmlSchemaEnhancer.class.getName());
    }
}

