/*
 * Decompiled with CFR 0.152.
 */
package kz.gov.pki.kalkan.crypto.digests;

import java.io.ByteArrayOutputStream;
import kz.gov.pki.kalkan.crypto.Digest;

public class NullDigest
implements Digest {
    private ByteArrayOutputStream bOut = new ByteArrayOutputStream();

    public NullDigest() {
        this.reset();
    }

    public NullDigest(NullDigest t) {
        this.bOut = t.bOut;
    }

    public String getAlgorithmName() {
        return "NULL";
    }

    public int getDigestSize() {
        return this.bOut.size();
    }

    public void update(byte in) {
        this.bOut.write(in);
    }

    public void update(byte[] in, int inOff, int len) {
        this.bOut.write(in, inOff, len);
    }

    public int doFinal(byte[] out, int outOff) {
        byte[] res = this.bOut.toByteArray();
        System.arraycopy(res, 0, out, outOff, res.length);
        this.reset();
        return res.length;
    }

    public void reset() {
        this.bOut.reset();
    }
}

