/*
 * Decompiled with CFR 0.152.
 */
package kz.gov.pki.kalkan.jce.provider.cms;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import javax.crypto.Cipher;
import kz.gov.pki.kalkan.asn1.ASN1InputStream;
import kz.gov.pki.kalkan.asn1.ASN1Null;
import kz.gov.pki.kalkan.asn1.ASN1OctetString;
import kz.gov.pki.kalkan.asn1.ASN1OutputStream;
import kz.gov.pki.kalkan.asn1.ASN1Sequence;
import kz.gov.pki.kalkan.asn1.ASN1Set;
import kz.gov.pki.kalkan.asn1.DEREncodable;
import kz.gov.pki.kalkan.asn1.DERNull;
import kz.gov.pki.kalkan.asn1.DERObject;
import kz.gov.pki.kalkan.asn1.DERObjectIdentifier;
import kz.gov.pki.kalkan.asn1.DEROutputStream;
import kz.gov.pki.kalkan.asn1.DERSet;
import kz.gov.pki.kalkan.asn1.cms.Attribute;
import kz.gov.pki.kalkan.asn1.cms.AttributeTable;
import kz.gov.pki.kalkan.asn1.cms.CMSAttributes;
import kz.gov.pki.kalkan.asn1.cms.IssuerAndSerialNumber;
import kz.gov.pki.kalkan.asn1.cms.SignerIdentifier;
import kz.gov.pki.kalkan.asn1.cms.SignerInfo;
import kz.gov.pki.kalkan.asn1.cms.Time;
import kz.gov.pki.kalkan.asn1.x509.AlgorithmIdentifier;
import kz.gov.pki.kalkan.asn1.x509.DigestInfo;
import kz.gov.pki.kalkan.jce.provider.cms.CMSException;
import kz.gov.pki.kalkan.jce.provider.cms.CMSProcessable;
import kz.gov.pki.kalkan.jce.provider.cms.CMSSignedDataGenerator;
import kz.gov.pki.kalkan.jce.provider.cms.CMSSignedHelper;
import kz.gov.pki.kalkan.jce.provider.cms.SignerId;

public class SignerInformation {
    private SignerId sid;
    private SignerInfo info;
    private AlgorithmIdentifier digestAlgorithm;
    private AlgorithmIdentifier encryptionAlgorithm;
    private ASN1Set signedAttributes;
    private ASN1Set unsignedAttributes;
    private CMSProcessable content;
    private byte[] signature;
    private DERObjectIdentifier contentType;
    private byte[] _digest;
    private byte[] _resultDigest;

    SignerInformation(SignerInfo info, DERObjectIdentifier contentType, CMSProcessable content, byte[] digest) {
        this.info = info;
        this.sid = new SignerId();
        this.contentType = contentType;
        try {
            SignerIdentifier s = info.getSID();
            if (s.isTagged()) {
                ASN1OctetString octs = ASN1OctetString.getInstance(s.getId());
                this.sid.setSubjectKeyIdentifier(octs.getOctets());
            } else {
                IssuerAndSerialNumber iAnds = IssuerAndSerialNumber.getInstance(s.getId());
                ByteArrayOutputStream bOut = new ByteArrayOutputStream();
                ASN1OutputStream aOut = new ASN1OutputStream(bOut);
                aOut.writeObject(iAnds.getName());
                this.sid.setIssuer(bOut.toByteArray());
                this.sid.setSerialNumber(iAnds.getSerialNumber().getValue());
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException("invalid sid in SignerInfo");
        }
        this.digestAlgorithm = info.getDigestAlgorithm();
        this.signedAttributes = info.getAuthenticatedAttributes();
        this.unsignedAttributes = info.getUnauthenticatedAttributes();
        this.encryptionAlgorithm = info.getDigestEncryptionAlgorithm();
        this.signature = info.getEncryptedDigest().getOctets();
        this.content = content;
        this._digest = digest;
    }

    private byte[] encodeObj(DEREncodable obj) throws IOException {
        if (obj != null) {
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            ASN1OutputStream aOut = new ASN1OutputStream(bOut);
            aOut.writeObject(obj);
            return bOut.toByteArray();
        }
        return null;
    }

    public SignerId getSID() {
        return this.sid;
    }

    public int getVersion() {
        return this.info.getVersion().getValue().intValue();
    }

    public String getDigestAlgOID() {
        return this.digestAlgorithm.getObjectId().getId();
    }

    public byte[] getDigestAlgParams() {
        try {
            return this.encodeObj(this.digestAlgorithm.getParameters());
        }
        catch (Exception e) {
            throw new RuntimeException("exception getting digest parameters " + e);
        }
    }

    public byte[] getContentDigest() {
        if (this._resultDigest == null) {
            throw new IllegalStateException("method can only be called after verify.");
        }
        return (byte[])this._resultDigest.clone();
    }

    public String getEncryptionAlgOID() {
        return this.encryptionAlgorithm.getObjectId().getId();
    }

    public byte[] getEncryptionAlgParams() {
        try {
            return this.encodeObj(this.encryptionAlgorithm.getParameters());
        }
        catch (Exception e) {
            throw new RuntimeException("exception getting encryption parameters " + e);
        }
    }

    public AttributeTable getSignedAttributes() {
        if (this.signedAttributes == null) {
            return null;
        }
        return new AttributeTable(this.signedAttributes);
    }

    public AttributeTable getUnsignedAttributes() {
        if (this.unsignedAttributes == null) {
            return null;
        }
        return new AttributeTable(this.unsignedAttributes);
    }

    public byte[] getSignature() {
        return (byte[])this.signature.clone();
    }

    public byte[] getEncodedSignedAttributes() throws IOException {
        if (this.signedAttributes != null) {
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            DEROutputStream aOut = new DEROutputStream(bOut);
            aOut.writeObject(this.signedAttributes);
            return bOut.toByteArray();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean doVerify(PublicKey key, AttributeTable signedAttrTable, String sigProvider) throws CMSException, NoSuchAlgorithmException, NoSuchProviderException {
        String digestName = CMSSignedHelper.INSTANCE.getDigestAlgName(this.getDigestAlgOID());
        String signatureName = digestName + "with" + CMSSignedHelper.INSTANCE.getEncryptionAlgName(this.getEncryptionAlgOID());
        Signature sig = CMSSignedHelper.INSTANCE.getSignatureInstance(signatureName, sigProvider);
        MessageDigest digest = CMSSignedHelper.INSTANCE.getDigestInstance(digestName, sigProvider);
        try {
            DERObjectIdentifier typeOID;
            byte[] hash;
            sig.initVerify(key);
            if (this.signedAttributes == null) {
                if (this.content != null) {
                    this.content.write(new CMSSignedDataGenerator.SigOutputStream(sig));
                    this.content.write(new CMSSignedDataGenerator.DigOutputStream(digest));
                    this._resultDigest = digest.digest();
                    return sig.verify(this.getSignature());
                }
                this._resultDigest = this._digest;
                return this.verifyDigest(this._digest, key, this.getSignature(), sigProvider);
            }
            if (this.content != null) {
                this.content.write(new CMSSignedDataGenerator.DigOutputStream(digest));
                hash = digest.digest();
            } else {
                hash = this._digest;
            }
            this._resultDigest = hash;
            Attribute dig = signedAttrTable.get(CMSAttributes.messageDigest);
            Attribute type = signedAttrTable.get(CMSAttributes.contentType);
            if (dig == null) {
                throw new SignatureException("no hash for content found in signed attributes");
            }
            if (type == null) {
                throw new SignatureException("no content type id found in signed attributes");
            }
            DERObject hashObj = dig.getAttrValues().getObjectAt(0).getDERObject();
            if (hashObj instanceof ASN1OctetString) {
                byte[] signedHash = ((ASN1OctetString)hashObj).getOctets();
                if (!MessageDigest.isEqual(hash, signedHash)) {
                    throw new SignatureException("content hash found in signed attributes different");
                }
            } else if (hashObj instanceof DERNull && hash != null) {
                throw new SignatureException("NULL hash found in signed attributes when one expected");
            }
            if (!(typeOID = (DERObjectIdentifier)type.getAttrValues().getObjectAt(0)).equals(this.contentType)) {
                throw new SignatureException("contentType in signed attributes different");
            }
            sig.update(this.getEncodedSignedAttributes());
            return sig.verify(this.getSignature());
        }
        catch (InvalidKeyException e) {
            throw new CMSException("key not appropriate to signature in message.", e);
        }
        catch (IOException e) {
            throw new CMSException("can't process mime object to create signature.", e);
        }
        catch (SignatureException e) {
            throw new CMSException("invalid signature format in message: " + e.getMessage(), e);
        }
    }

    private boolean isNull(DEREncodable o) {
        return o instanceof ASN1Null || o == null;
    }

    private DigestInfo derDecode(byte[] encoding) throws IOException {
        if (encoding[0] != 48) {
            throw new IOException("not a digest info object");
        }
        ASN1InputStream aIn = new ASN1InputStream(encoding);
        return new DigestInfo((ASN1Sequence)aIn.readObject());
    }

    private boolean verifyDigest(byte[] digest, PublicKey key, byte[] signature, String sigProvider) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException {
        String algorithm = CMSSignedHelper.INSTANCE.getEncryptionAlgName(this.getEncryptionAlgOID());
        try {
            if (algorithm.equals("RSA")) {
                Cipher c = sigProvider != null ? Cipher.getInstance("RSA/ECB/PKCS1Padding", sigProvider) : Cipher.getInstance("RSA/ECB/PKCS1Padding");
                c.init(2, key);
                DigestInfo digInfo = this.derDecode(c.doFinal(signature));
                if (!digInfo.getAlgorithmId().getObjectId().equals(this.digestAlgorithm.getObjectId())) {
                    return false;
                }
                if (!this.isNull(digInfo.getAlgorithmId().getParameters())) {
                    return false;
                }
                byte[] sigHash = digInfo.getDigest();
                return MessageDigest.isEqual(digest, sigHash);
            }
            if (algorithm.equals("DSA")) {
                Signature sig = sigProvider != null ? Signature.getInstance("NONEwithDSA", sigProvider) : Signature.getInstance("NONEwithDSA", sigProvider);
                sig.initVerify(key);
                sig.update(digest);
                return sig.verify(signature);
            }
            throw new CMSException("algorithm: " + algorithm + " not supported in base signatures.");
        }
        catch (NoSuchAlgorithmException e) {
            throw e;
        }
        catch (NoSuchProviderException e) {
            throw e;
        }
        catch (GeneralSecurityException e) {
            throw new CMSException("Exception processing signature: " + e, e);
        }
        catch (IOException e) {
            throw new CMSException("Exception decoding signature: " + e, e);
        }
    }

    public boolean verify(PublicKey key, String sigProvider) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException {
        return this.doVerify(key, this.getSignedAttributes(), sigProvider);
    }

    public boolean verify(X509Certificate cert, String sigProvider) throws NoSuchAlgorithmException, NoSuchProviderException, CertificateExpiredException, CertificateNotYetValidException, CMSException {
        Attribute t;
        AttributeTable attr = this.getSignedAttributes();
        if (attr != null && (t = attr.get(CMSAttributes.signingTime)) != null) {
            Time time = Time.getInstance(t.getAttrValues().getObjectAt(0).getDERObject());
            cert.checkValidity(time.getDate());
        }
        return this.doVerify(cert.getPublicKey(), attr, sigProvider);
    }

    public SignerInfo toSignerInfo() {
        return this.info;
    }

    public static SignerInformation replaceUnsignedAttributes(SignerInformation signerInformation, AttributeTable unsignedAttributes) {
        SignerInfo sInfo = signerInformation.info;
        DERSet unsignedAttr = null;
        if (unsignedAttributes != null) {
            unsignedAttr = new DERSet(unsignedAttributes.toASN1EncodableVector());
        }
        return new SignerInformation(new SignerInfo(sInfo.getSID(), sInfo.getDigestAlgorithm(), sInfo.getAuthenticatedAttributes(), sInfo.getDigestEncryptionAlgorithm(), sInfo.getEncryptedDigest(), unsignedAttr), signerInformation.contentType, signerInformation.content, null);
    }
}

