/*
 * Decompiled with CFR 0.152.
 */
package kz.gov.pki.kalkan.pcsc.parsers;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapFileParser {
    private static final byte[] MAPFILE_HEADER = new byte[]{1, 0, 0, 16};
    private HashMap<Byte, String> mapFile = null;
    private HashMap<String, Byte> revMapFile = null;
    private byte lastId = 0;
    private byte newId = 0;
    private short size = 0;
    private byte[] mapData = null;

    public MapFileParser(byte[] map) {
        int offset = 4;
        this.mapFile = new HashMap();
        this.revMapFile = new HashMap();
        if (map == null) {
            map = MAPFILE_HEADER;
        }
        this.mapData = map;
        this.size = (short)map.length;
        for (int i = 4; i < map.length; ++i) {
            if (map[i] != 0) continue;
            this.mapFile.put(map[offset], new String(map, offset + 1, i - offset - 1));
            this.revMapFile.put(new String(map, offset + 1, i - offset - 1), map[offset]);
            this.lastId = map[offset];
            offset = i + 1;
        }
        this.newId = (byte)(this.lastId + 1);
    }

    public byte getLastId() {
        return this.lastId;
    }

    public byte getNewId() {
        return this.newId;
    }

    public short getSize() {
        return this.size;
    }

    public byte[] getMapData() {
        return this.mapData;
    }

    public HashMap<Byte, String> getMapFile() {
        return this.mapFile;
    }

    public HashMap<String, Byte> getRevMapFile() {
        return this.revMapFile;
    }

    public byte[] updateData(String alias, boolean isRemoval) throws IOException {
        ByteArrayOutputStream newMap = new ByteArrayOutputStream();
        if (isRemoval) {
            this.mapFile.remove(this.revMapFile.get(alias));
            this.revMapFile.remove(alias);
            newMap.write(MAPFILE_HEADER);
            for (Map.Entry<Byte, String> entry : this.mapFile.entrySet()) {
                newMap.write(entry.getKey().byteValue());
                newMap.write(entry.getValue().getBytes());
                newMap.write(0);
            }
        } else {
            newMap.write(this.getMapData());
            newMap.write(this.getNewId());
            newMap.write(alias.getBytes());
            newMap.write(0);
            newMap.close();
        }
        this.mapData = newMap.toByteArray();
        this.size = (short)this.mapData.length;
        return this.getMapData();
    }
}

