/*
 * Decompiled with CFR 0.152.
 */
package kz.gov.pki.kalkan.tsp;

import kz.gov.pki.kalkan.asn1.ASN1Encodable;
import kz.gov.pki.kalkan.asn1.ASN1EncodableVector;
import kz.gov.pki.kalkan.asn1.ASN1Sequence;
import kz.gov.pki.kalkan.asn1.ASN1TaggedObject;
import kz.gov.pki.kalkan.asn1.DERBoolean;
import kz.gov.pki.kalkan.asn1.DERInteger;
import kz.gov.pki.kalkan.asn1.DERObject;
import kz.gov.pki.kalkan.asn1.DERObjectIdentifier;
import kz.gov.pki.kalkan.asn1.DERSequence;
import kz.gov.pki.kalkan.asn1.DERTaggedObject;
import kz.gov.pki.kalkan.asn1.x509.X509Extensions;
import kz.gov.pki.kalkan.tsp.MessageImprint;

public class TimeStampReq
extends ASN1Encodable {
    DERInteger version;
    MessageImprint messageImprint;
    DERObjectIdentifier tsaPolicy;
    DERInteger nonce;
    DERBoolean certReq;
    X509Extensions extensions;

    public static TimeStampReq getInstance(Object o) {
        if (o == null || o instanceof TimeStampReq) {
            return (TimeStampReq)o;
        }
        if (o instanceof ASN1Sequence) {
            return new TimeStampReq((ASN1Sequence)o);
        }
        throw new IllegalArgumentException("Unknown object in 'TimeStampReq' factory : " + o.getClass().getName() + ".");
    }

    public TimeStampReq(ASN1Sequence seq) {
        int nbObjects = seq.size();
        int seqStart = 0;
        this.version = DERInteger.getInstance(seq.getObjectAt(seqStart));
        this.messageImprint = MessageImprint.getInstance(seq.getObjectAt(++seqStart));
        for (int opt = ++seqStart; opt < nbObjects; ++opt) {
            ASN1TaggedObject tagged;
            if (seq.getObjectAt(opt) instanceof DERObjectIdentifier) {
                this.tsaPolicy = DERObjectIdentifier.getInstance(seq.getObjectAt(opt));
                continue;
            }
            if (seq.getObjectAt(opt) instanceof DERInteger) {
                this.nonce = DERInteger.getInstance(seq.getObjectAt(opt));
                continue;
            }
            if (seq.getObjectAt(opt) instanceof DERBoolean) {
                this.certReq = DERBoolean.getInstance(seq.getObjectAt(opt));
                continue;
            }
            if (!(seq.getObjectAt(opt) instanceof ASN1TaggedObject) || (tagged = (ASN1TaggedObject)seq.getObjectAt(opt)).getTagNo() != 0) continue;
            this.extensions = X509Extensions.getInstance(tagged, false);
        }
    }

    public TimeStampReq(MessageImprint messageImprint, DERObjectIdentifier tsaPolicy, DERInteger nonce, DERBoolean certReq, X509Extensions extensions) {
        this.version = new DERInteger(1);
        this.messageImprint = messageImprint;
        this.tsaPolicy = tsaPolicy;
        this.nonce = nonce;
        this.certReq = certReq;
        this.extensions = extensions;
    }

    public DERInteger getVersion() {
        return this.version;
    }

    public MessageImprint getMessageImprint() {
        return this.messageImprint;
    }

    public DERObjectIdentifier getReqPolicy() {
        return this.tsaPolicy;
    }

    public DERInteger getNonce() {
        return this.nonce;
    }

    public DERBoolean getCertReq() {
        return this.certReq;
    }

    public X509Extensions getExtensions() {
        return this.extensions;
    }

    public DERObject toASN1Object() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(this.version);
        v.add(this.messageImprint);
        if (this.tsaPolicy != null) {
            v.add(this.tsaPolicy);
        }
        if (this.nonce != null) {
            v.add(this.nonce);
        }
        if (this.certReq != null && this.certReq.isTrue()) {
            v.add(this.certReq);
        }
        if (this.extensions != null) {
            v.add(new DERTaggedObject(false, 0, this.extensions));
        }
        return new DERSequence(v);
    }
}

