/*
 * Decompiled with CFR 0.152.
 */
package checkers.basetype;

import checkers.basetype.BaseTypeVisitor;
import checkers.quals.PolymorphicQualifier;
import checkers.quals.SubtypeOf;
import checkers.quals.TypeQualifiers;
import checkers.quals.Unqualified;
import checkers.source.SourceChecker;
import checkers.types.AnnotatedTypeFactory;
import checkers.types.AnnotatedTypeMirror;
import checkers.types.BasicAnnotatedTypeFactory;
import checkers.types.QualifierHierarchy;
import checkers.types.TypeHierarchy;
import checkers.util.AnnotationUtils;
import checkers.util.GraphQualifierHierarchy;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.Tree;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseTypeChecker
extends SourceChecker {
    private Set<Class<? extends Annotation>> supportedQuals;
    private QualifierHierarchy qualHierarchy;
    private TypeHierarchy typeHierarchy;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.supportedQuals = this.createSupportedTypeQualifiers();
        this.qualHierarchy = this.createQualifierHierarchy();
        this.typeHierarchy = this.createTypeHierarchy();
    }

    protected Set<Class<? extends Annotation>> createSupportedTypeQualifiers() {
        Class<?> classType = this.getClass();
        TypeQualifiers typeQualifiersAnnotation = classType.getAnnotation(TypeQualifiers.class);
        if (typeQualifiersAnnotation == null) {
            return Collections.emptySet();
        }
        HashSet<Class<? extends Annotation>> typeQualifiers = new HashSet<Class<? extends Annotation>>();
        for (Class<? extends Annotation> qualifier : typeQualifiersAnnotation.value()) {
            typeQualifiers.add(qualifier);
        }
        return Collections.unmodifiableSet(typeQualifiers);
    }

    public final Set<Class<? extends Annotation>> getSupportedTypeQualifiers() {
        if (this.supportedQuals == null) {
            this.supportedQuals = this.createSupportedTypeQualifiers();
        }
        return this.supportedQuals;
    }

    protected QualifierHierarchy createQualifierHierarchy() {
        AnnotationUtils annoFactory = AnnotationUtils.getInstance(this.env);
        GraphQualifierHierarchy.Factory factory = new GraphQualifierHierarchy.Factory();
        for (Class<? extends Annotation> typeQualifier : this.getSupportedTypeQualifiers()) {
            Class<? extends Annotation>[] superQualifiers;
            if (typeQualifier.equals(Unqualified.class)) {
                factory.addQualifier(null);
                continue;
            }
            AnnotationMirror typeQualifierAnno = annoFactory.fromClass(typeQualifier);
            assert (typeQualifierAnno != null) : "Loading annotation \"" + typeQualifier + "\" failed!";
            factory.addQualifier(typeQualifierAnno);
            if (typeQualifier.getAnnotation(SubtypeOf.class) == null) {
                if (typeQualifier.getAnnotation(PolymorphicQualifier.class) == null) {
                    throw new AssertionError((Object)(typeQualifier + " does not specify its super qualifiers"));
                }
                continue;
            }
            for (Class<? extends Annotation> superQualifier : superQualifiers = typeQualifier.getAnnotation(SubtypeOf.class).value()) {
                AnnotationMirror superAnno = null;
                if (superQualifier != Unqualified.class) {
                    superAnno = annoFactory.fromClass(superQualifier);
                }
                factory.addSubtype(typeQualifierAnno, superAnno);
            }
        }
        GraphQualifierHierarchy hierarchy = factory.build();
        if (((QualifierHierarchy)hierarchy).getTypeQualifiers().size() < 2) {
            throw new IllegalStateException("Invalid qualifier hierarchy: hierarchy requires at least two annotations: " + ((QualifierHierarchy)hierarchy).getTypeQualifiers());
        }
        return hierarchy;
    }

    public final QualifierHierarchy getQualifierHierarchy() {
        if (this.qualHierarchy == null) {
            this.qualHierarchy = this.createQualifierHierarchy();
        }
        return this.qualHierarchy;
    }

    protected TypeHierarchy createTypeHierarchy() {
        return new TypeHierarchy(this.getQualifierHierarchy());
    }

    protected BaseTypeVisitor<?, ?> createSourceVisitor(CompilationUnitTree root) {
        for (Class<?> checkerClass = this.getClass(); checkerClass != BaseTypeChecker.class; checkerClass = checkerClass.getSuperclass()) {
            String classToLoad = checkerClass.getName().replace("Checker", "Visitor").replace("Subchecker", "Visitor");
            BaseTypeVisitor result = (BaseTypeVisitor)BaseTypeChecker.invokeConstructorFor(classToLoad, new Class[]{this.getClass(), CompilationUnitTree.class}, new Object[]{this, root});
            if (result == null) continue;
            return result;
        }
        return new BaseTypeVisitor(this, root);
    }

    @Override
    public AnnotatedTypeFactory createFactory(CompilationUnitTree root) {
        for (Class<?> checkerClass = this.getClass(); checkerClass != BaseTypeChecker.class; checkerClass = checkerClass.getSuperclass()) {
            String classToLoad = checkerClass.getName().replace("Checker", "AnnotatedTypeFactory").replace("Subchecker", "AnnotatedTypeFactory");
            AnnotatedTypeFactory result = (AnnotatedTypeFactory)BaseTypeChecker.invokeConstructorFor(classToLoad, new Class[]{this.getClass(), CompilationUnitTree.class}, new Object[]{this, root});
            if (result == null) continue;
            return result;
        }
        return new BasicAnnotatedTypeFactory<BaseTypeChecker>(this, root);
    }

    public boolean isSubtype(AnnotatedTypeMirror sub, AnnotatedTypeMirror sup) {
        return this.typeHierarchy.isSubtype(sub, sup);
    }

    public boolean isValidUse(AnnotatedTypeMirror.AnnotatedDeclaredType declarationType, AnnotatedTypeMirror.AnnotatedDeclaredType useType) {
        return this.isSubtype(useType.getErased(), declarationType.getErased());
    }

    public boolean isAssignable(AnnotatedTypeMirror varType, AnnotatedTypeMirror receiverType, Tree variable) {
        return true;
    }

    @Override
    public Set<String> getSupportedLintOptions() {
        HashSet<String> lintSet = new HashSet<String>(super.getSupportedLintOptions());
        lintSet.add("cast");
        lintSet.add("cast:redundant");
        lintSet.add("cast:unsafe");
        return lintSet;
    }

    private static <T> T invokeConstructorFor(String name, Class<?>[] paramTypes, Object[] args) {
        Class<?> cls = null;
        try {
            cls = Class.forName(name);
        }
        catch (Exception e) {
            return null;
        }
        assert (cls != null);
        try {
            Constructor<?> ctor = cls.getConstructor(paramTypes);
            return (T)ctor.newInstance(args);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e.getCause());
        }
        return null;
    }
}

