/*
 * Decompiled with CFR 0.152.
 */
package checkers.fenum;

import checkers.basetype.BaseTypeChecker;
import checkers.fenum.quals.Fenum;
import checkers.fenum.quals.FenumBottom;
import checkers.fenum.quals.FenumTop;
import checkers.fenum.quals.FenumUnqualified;
import checkers.source.SupportedLintOptions;
import checkers.types.AnnotatedTypeMirror;
import checkers.types.QualifierHierarchy;
import checkers.util.AnnotationUtils;
import checkers.util.GraphQualifierHierarchy;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.processing.SupportedOptions;
import javax.lang.model.element.AnnotationMirror;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@SupportedOptions(value={"quals"})
@SupportedLintOptions(value={"flowinference"})
public class FenumChecker
extends BaseTypeChecker {
    @Override
    protected Set<Class<? extends Annotation>> createSupportedTypeQualifiers() {
        HashSet qualSet = new HashSet();
        String qualNames = this.env.getOptions().get("quals");
        if (qualNames == null) {
            qualSet.add(FenumTop.class);
            qualSet.add(Fenum.class);
            qualSet.add(FenumUnqualified.class);
            qualSet.add(FenumBottom.class);
        } else {
            try {
                for (String qualName : qualNames.split(",")) {
                    Class<?> q = Class.forName(qualName);
                    qualSet.add(q);
                }
            }
            catch (ClassNotFoundException e) {
                throw new Error(e);
            }
            qualSet.add(FenumTop.class);
            qualSet.add(Fenum.class);
            qualSet.add(FenumUnqualified.class);
            qualSet.add(FenumBottom.class);
        }
        return Collections.unmodifiableSet(qualSet);
    }

    @Override
    public Collection<String> getSuppressWarningsKey() {
        HashSet<String> swKeys = new HashSet<String>();
        Set<Class<? extends Annotation>> annos = this.getSupportedTypeQualifiers();
        if (annos.isEmpty()) {
            return super.getSuppressWarningsKey();
        }
        for (Class<? extends Annotation> anno : annos) {
            swKeys.add(anno.getSimpleName().toLowerCase());
        }
        return swKeys;
    }

    @Override
    public boolean isValidUse(AnnotatedTypeMirror.AnnotatedDeclaredType declarationType, AnnotatedTypeMirror.AnnotatedDeclaredType useType) {
        return true;
    }

    @Override
    protected QualifierHierarchy createQualifierHierarchy() {
        return new FenumQualifierHierarchy((GraphQualifierHierarchy)super.createQualifierHierarchy());
    }

    private final class FenumQualifierHierarchy
    extends GraphQualifierHierarchy {
        public FenumQualifierHierarchy(GraphQualifierHierarchy hierarchy) {
            super(hierarchy);
        }

        public boolean isSubtype(AnnotationMirror anno1, AnnotationMirror anno2) {
            if (AnnotationUtils.getInstance(FenumChecker.this.env).fromClass(FenumBottom.class).equals(anno1)) {
                return true;
            }
            return super.isSubtype(anno1, anno2);
        }

        public AnnotationMirror getBottomQualifier() {
            return AnnotationUtils.getInstance(FenumChecker.this.env).fromClass(FenumBottom.class);
        }
    }
}

