/*
 * Decompiled with CFR 0.152.
 */
package checkers.flow;

import checkers.basetype.BaseTypeChecker;
import checkers.flow.GenKillBits;
import checkers.nullness.quals.Pure;
import checkers.source.SourceChecker;
import checkers.types.AnnotatedTypeFactory;
import checkers.types.AnnotatedTypeMirror;
import checkers.types.AnnotatedTypes;
import checkers.types.QualifierHierarchy;
import checkers.types.VisitorState;
import checkers.util.ElementUtils;
import checkers.util.InternalUtils;
import checkers.util.TreeUtils;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.AssertTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.BreakTree;
import com.sun.source.tree.CatchTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ConditionalExpressionTree;
import com.sun.source.tree.ContinueTree;
import com.sun.source.tree.DoWhileLoopTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.ForLoopTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.ThrowTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TryTree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.tree.WhileLoopTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Flow
extends TreePathScanner<Void, Void> {
    protected PrintStream debug = null;
    protected final SourceChecker checker;
    protected final ProcessingEnvironment env;
    protected final CompilationUnitTree root;
    protected final Set<AnnotationMirror> annotations;
    protected final AnnotatedTypeFactory factory;
    protected final AnnotatedTypes atypes;
    protected final Map<Tree, AnnotationMirror> flowResults;
    protected List<VariableElement> vars;
    protected GenKillBits<AnnotationMirror> annos;
    protected boolean alive = true;
    private final Deque<GenKillBits<AnnotationMirror>> tryBits;
    private final VisitorState visitorState;
    protected final QualifierHierarchy annoRelations;
    protected final Elements elements;
    private Map<Element, Boolean> annotatedVarDefs = new HashMap<Element, Boolean>();

    public Flow(BaseTypeChecker checker, CompilationUnitTree root, Set<AnnotationMirror> annotations, AnnotatedTypeFactory factory) {
        this.checker = checker;
        this.env = checker.getProcessingEnvironment();
        this.root = root;
        this.annotations = annotations;
        this.factory = factory == null ? new AnnotatedTypeFactory(checker, root) : factory;
        this.atypes = new AnnotatedTypes(this.env, factory);
        this.visitorState = this.factory.getVisitorState();
        this.vars = new ArrayList<VariableElement>();
        this.flowResults = new IdentityHashMap<Tree, AnnotationMirror>();
        this.annos = new GenKillBits<AnnotationMirror>(this.annotations);
        this.tryBits = new LinkedList<GenKillBits<AnnotationMirror>>();
        this.annoRelations = checker.getQualifierHierarchy();
        this.elements = this.env.getElementUtils();
    }

    public void setDebug(PrintStream debug) {
        this.debug = debug;
    }

    @Override
    public Void scan(Tree tree, Void p) {
        if (tree != null && tree.getKind() == Tree.Kind.COMPILATION_UNIT) {
            return (Void)this.scan(this.checker.currentPath, p);
        }
        if (tree != null && this.getCurrentPath() != null) {
            this.visitorState.setPath(new TreePath(this.getCurrentPath(), tree));
        }
        return (Void)super.scan(tree, p);
    }

    public AnnotationMirror test(Tree tree) {
        while (tree.getKind() == Tree.Kind.ASSIGNMENT) {
            tree = ((AssignmentTree)tree).getVariable();
        }
        if (!this.flowResults.containsKey(tree)) {
            return null;
        }
        AnnotationMirror flowResult = this.flowResults.get(tree);
        return flowResult;
    }

    void newVar(VariableTree tree) {
        VariableElement var = TreeUtils.elementFromDeclaration(tree);
        assert (var != null) : "no symbol from tree";
        if (this.vars.contains(var)) {
            if (this.debug != null) {
                this.debug.println("Flow: newVar(" + tree + ") reusing index");
            }
            return;
        }
        int idx = this.vars.size();
        this.vars.add(var);
        AnnotatedTypeMirror type = this.factory.getAnnotatedType(tree);
        assert (type != null) : "no type from symbol";
        if (this.debug != null) {
            this.debug.println("Flow: newVar(" + tree + ") -- " + type);
        }
        for (AnnotationMirror annotation : this.annotations) {
            if (this.hasAnnotation(type, annotation)) {
                this.annos.set(annotation, idx);
                continue;
            }
            this.annos.clear(annotation, idx);
        }
    }

    private boolean hasAnnotation(AnnotatedTypeMirror type, AnnotationMirror annotation) {
        if (!(type instanceof AnnotatedTypeMirror.AnnotatedWildcardType)) {
            return type.hasAnnotation(annotation);
        }
        AnnotatedTypeMirror.AnnotatedWildcardType wc = (AnnotatedTypeMirror.AnnotatedWildcardType)type;
        AnnotatedTypeMirror bound = wc.getExtendsBound();
        return bound != null && bound.hasAnnotation(annotation);
    }

    void propagate(Tree lhs, ExpressionTree rhs) {
        if (this.debug != null) {
            this.debug.println("Flow: try propagate from " + rhs);
        }
        if (lhs.getKind() == Tree.Kind.ARRAY_ACCESS) {
            return;
        }
        Element elt = InternalUtils.symbol(lhs);
        assert (elt != null);
        AnnotatedTypeMirror eltType = this.factory.getAnnotatedType(elt);
        AnnotatedTypeMirror type = this.factory.getAnnotatedType(rhs);
        if (TreeUtils.skipParens(rhs).getKind() == Tree.Kind.ARRAY_ACCESS) {
            this.propagateFromType(lhs, type);
            return;
        }
        assert (type != null);
        int idx = this.vars.indexOf(elt);
        if (idx < 0) {
            return;
        }
        Element rElt = InternalUtils.symbol(rhs);
        int rIdx = this.vars.indexOf(rElt);
        if (eltType.isAnnotated() && type.isAnnotated() && !this.annoRelations.isSubtype(type.getAnnotations(), eltType.getAnnotations())) {
            return;
        }
        for (AnnotationMirror annotation : this.annotations) {
            if (this.hasAnnotation(type, annotation) && this.annoRelations.isSubtype(type.getAnnotations(), eltType.getAnnotations())) {
                this.annos.set(annotation, idx);
                for (AnnotationMirror other : this.annotations) {
                    if (other.equals(annotation) || !this.annos.contains(other)) continue;
                    this.annos.clear(other, idx);
                }
                continue;
            }
            if (rIdx >= 0 && this.annos.get(annotation, rIdx)) {
                this.annos.set(annotation, idx);
                continue;
            }
            this.annos.clear(annotation, idx);
        }
        this.annos.valid();
    }

    void propagateFromType(Tree lhs, AnnotatedTypeMirror rhs) {
        if (lhs.getKind() == Tree.Kind.ARRAY_ACCESS) {
            return;
        }
        Element elt = InternalUtils.symbol(lhs);
        int idx = this.vars.indexOf(elt);
        if (idx < 0) {
            return;
        }
        for (AnnotationMirror annotation : this.annotations) {
            if (this.hasAnnotation(rhs, annotation)) {
                this.annos.set(annotation, idx);
                continue;
            }
            this.annos.clear(annotation, idx);
        }
    }

    private boolean isLValue(TreePath path) {
        Tree last = null;
        for (Tree tree : path) {
            if (tree.getKind() == Tree.Kind.IDENTIFIER) break;
            if (tree instanceof AssignmentTree) {
                return last == ((AssignmentTree)tree).getVariable();
            }
            if (tree instanceof CompoundAssignmentTree) {
                return last == ((CompoundAssignmentTree)tree).getVariable();
            }
            if (last != null) break;
            last = tree;
        }
        return false;
    }

    protected void recordBits(TreePath path) {
        Element elt;
        if (this.isLValue(path)) {
            return;
        }
        Tree tree = path.getLeaf();
        if (tree instanceof MemberSelectTree) {
            elt = TreeUtils.elementFromUse((MemberSelectTree)tree);
        } else if (tree instanceof IdentifierTree) {
            elt = TreeUtils.elementFromUse((IdentifierTree)tree);
        } else if (tree instanceof VariableTree) {
            elt = TreeUtils.elementFromDeclaration((VariableTree)tree);
        } else {
            return;
        }
        int idx = this.vars.indexOf(elt);
        if (idx < 0 && elt instanceof VariableElement) {
            idx = this.vars.size();
            this.vars.add((VariableElement)elt);
        }
        if (idx >= 0) {
            for (AnnotationMirror annotation : this.annotations) {
                if (this.debug != null) {
                    this.debug.println("Flow: recordBits(" + tree + ") + " + annotation + " " + this.annos.get(annotation, idx) + " as " + (Object)((Object)tree.getKind()));
                }
                if (this.annos.get(annotation, idx)) {
                    AnnotationMirror existing = this.flowResults.get(tree);
                    if (existing != null && !this.annoRelations.isSubtype(existing, annotation)) continue;
                    this.flowResults.put(tree, annotation);
                    continue;
                }
                if (this.flowResults.get(tree) != annotation) continue;
                this.flowResults.remove(tree);
            }
        }
    }

    protected void scanDef(Tree tree) {
        this.alive = true;
        this.scan(tree, null);
    }

    protected void scanStat(StatementTree tree) {
        this.alive = true;
        this.scan((Tree)tree, null);
    }

    protected void scanStats(List<? extends StatementTree> trees) {
        this.scan(trees, null);
    }

    protected SplitTuple scanCond(Tree tree) {
        this.alive = true;
        if (tree != null) {
            this.scan(tree, null);
        }
        if (this.annos != null) {
            SplitTuple res = this.split();
            return res;
        }
        return new SplitTuple();
    }

    protected SplitTuple split() {
        SplitTuple res = new SplitTuple();
        res.annosWhenFalse = GenKillBits.copy(this.annos);
        res.annosWhenTrue = this.annos;
        this.annos = null;
        return res;
    }

    protected void scanExpr(ExpressionTree tree) {
        this.alive = true;
        this.scan((Tree)tree, null);
        assert (this.annos != null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visitClass(ClassTree node, Void p) {
        AnnotatedTypeMirror.AnnotatedDeclaredType preClassType = this.visitorState.getClassType();
        ClassTree preClassTree = this.visitorState.getClassTree();
        AnnotatedTypeMirror.AnnotatedDeclaredType preAMT = this.visitorState.getMethodReceiver();
        MethodTree preMT = this.visitorState.getMethodTree();
        this.visitorState.setClassType(this.factory.getAnnotatedType(node));
        this.visitorState.setClassTree(node);
        this.visitorState.setMethodReceiver(null);
        this.visitorState.setMethodTree(null);
        try {
            this.scan((Tree)node.getModifiers(), p);
            this.scan(node.getTypeParameters(), p);
            this.scan(node.getExtendsClause(), p);
            this.scan(node.getImplementsClause(), p);
            for (Tree tree : node.getMembers()) {
                if (tree.getKind() == Tree.Kind.METHOD) continue;
                this.scan(tree, p);
            }
            for (Tree tree : node.getMembers()) {
                if (tree.getKind() != Tree.Kind.METHOD) continue;
                this.scan(tree, p);
            }
            Void void_ = null;
            return void_;
        }
        finally {
            this.visitorState.setClassType(preClassType);
            this.visitorState.setClassTree(preClassTree);
            this.visitorState.setMethodReceiver(preAMT);
            this.visitorState.setMethodTree(preMT);
        }
    }

    @Override
    public Void visitImport(ImportTree tree, Void p) {
        return null;
    }

    @Override
    public Void visitTypeCast(TypeCastTree node, Void p) {
        super.visitTypeCast(node, p);
        if (this.factory.fromTypeTree(node.getType()).isAnnotated()) {
            return null;
        }
        AnnotatedTypeMirror t = this.factory.getAnnotatedType(node.getExpression());
        for (AnnotationMirror a : this.annotations) {
            if (!this.hasAnnotation(t, a)) continue;
            this.flowResults.put(node, a);
        }
        return null;
    }

    @Override
    public Void visitAnnotation(AnnotationTree tree, Void p) {
        return null;
    }

    @Override
    public Void visitIdentifier(IdentifierTree node, Void p) {
        super.visitIdentifier(node, p);
        this.recordBits(this.getCurrentPath());
        return null;
    }

    @Override
    public Void visitMemberSelect(MemberSelectTree node, Void p) {
        super.visitMemberSelect(node, p);
        this.recordBits(this.getCurrentPath());
        return null;
    }

    @Override
    public Void visitVariable(VariableTree node, Void p) {
        this.newVar(node);
        ExpressionTree init = node.getInitializer();
        if (init != null) {
            this.scanExpr(init);
            VariableElement elem = TreeUtils.elementFromDeclaration(node);
            AnnotatedTypeMirror type = this.factory.fromMember(node);
            if (!Flow.isNonFinalField(elem) && !type.isAnnotated()) {
                this.propagate(node, init);
                this.recordBits(this.getCurrentPath());
            }
        }
        return null;
    }

    @Override
    public Void visitAssignment(AssignmentTree node, Void p) {
        ExpressionTree var = node.getVariable();
        ExpressionTree expr = node.getExpression();
        if (!(var instanceof IdentifierTree)) {
            this.scanExpr(var);
        }
        this.scanExpr(expr);
        this.propagate(var, expr);
        if (var instanceof IdentifierTree) {
            this.scan((Tree)var, p);
        }
        return null;
    }

    @Override
    public Void visitCompoundAssignment(CompoundAssignmentTree node, Void p) {
        ExpressionTree var = node.getVariable();
        ExpressionTree expr = node.getExpression();
        this.scanExpr(var);
        this.scanExpr(expr);
        this.propagate(var, node);
        AnnotatedTypeMirror t = this.factory.getAnnotatedType(var);
        for (AnnotationMirror a : this.annotations) {
            if (!this.hasAnnotation(t, a)) continue;
            this.flowResults.put(node, a);
        }
        return null;
    }

    @Override
    public Void visitEnhancedForLoop(EnhancedForLoopTree node, Void p) {
        this.scan((Tree)node.getVariable(), p);
        VariableTree var = node.getVariable();
        this.newVar(var);
        ExpressionTree expr = node.getExpression();
        this.scanExpr(expr);
        AnnotatedTypeMirror rhs = this.factory.getAnnotatedType(expr);
        AnnotatedTypeMirror iter = this.atypes.getIteratedType(rhs);
        if (iter != null) {
            this.propagateFromType(var, iter);
        }
        this.scanStat(node.getStatement());
        return null;
    }

    protected static boolean containsKey(Tree tree, Collection<String> keys) {
        if (tree == null) {
            return false;
        }
        String treeStr = tree.toString();
        for (String key : keys) {
            if (!treeStr.contains(key)) continue;
            return true;
        }
        return false;
    }

    protected void pushNewLevel() {
    }

    protected void popLastLevel() {
    }

    @Override
    public Void visitAssert(AssertTree node, Void p) {
        boolean inferFromAsserts = Flow.containsKey(node.getDetail(), this.checker.getSuppressWarningsKey());
        GenKillBits<AnnotationMirror> annosAfterAssert = GenKillBits.copy(this.annos);
        this.pushNewLevel();
        SplitTuple split = this.scanCond(node.getCondition());
        if (inferFromAsserts) {
            annosAfterAssert = GenKillBits.copy(split.annosWhenTrue);
        }
        this.annos = GenKillBits.copy(split.annosWhenFalse);
        this.scanExpr(node.getDetail());
        this.annos = annosAfterAssert;
        this.popLastLevel();
        return null;
    }

    protected void whenConditionFalse(ExpressionTree condition, Void p) {
    }

    @Override
    public Void visitIf(IfTree node, Void p) {
        this.pushNewLevel();
        SplitTuple split = this.scanCond(node.getCondition());
        GenKillBits<AnnotationMirror> annosBeforeElse = split.annosWhenFalse;
        this.annos = split.annosWhenTrue;
        boolean aliveBeforeThen = this.alive;
        this.scanStat(node.getThenStatement());
        this.popLastLevel();
        this.pushNewLevel();
        StatementTree elseStmt = node.getElseStatement();
        if (elseStmt != null) {
            this.whenConditionFalse(node.getCondition(), p);
            boolean aliveAfterThen = this.alive;
            this.alive = aliveBeforeThen;
            GenKillBits<AnnotationMirror> annosAfterThen = GenKillBits.copy(this.annos);
            this.annos = annosBeforeElse;
            this.scanStat(elseStmt);
            if (!this.alive) {
                this.alive = aliveAfterThen;
                GenKillBits.orlub(annosAfterThen, this.annos, this.annoRelations);
                this.annos = GenKillBits.copy(annosAfterThen);
            } else if (aliveAfterThen) {
                GenKillBits.andlub(this.annos, annosAfterThen, this.annoRelations);
            }
        } else if (!this.alive) {
            this.annos = GenKillBits.copy(annosBeforeElse);
        } else {
            GenKillBits.andlub(this.annos, annosBeforeElse, this.annoRelations);
        }
        this.popLastLevel();
        return null;
    }

    @Override
    public Void visitConditionalExpression(ConditionalExpressionTree node, Void p) {
        SplitTuple split = this.scanCond(node.getCondition());
        GenKillBits<AnnotationMirror> before = split.annosWhenFalse;
        this.annos = split.annosWhenTrue;
        this.scanExpr(node.getTrueExpression());
        GenKillBits<AnnotationMirror> after = GenKillBits.copy(this.annos);
        this.annos = before;
        this.scanExpr(node.getFalseExpression());
        GenKillBits.andlub(this.annos, after, this.annoRelations);
        return null;
    }

    @Override
    public Void visitWhileLoop(WhileLoopTree node, Void p) {
        GenKillBits<AnnotationMirror> annoEntry = GenKillBits.copy(this.annos);
        SplitTuple split = this.scanCond(node.getCondition());
        GenKillBits<AnnotationMirror> annoCond = split.annosWhenFalse;
        GenKillBits<AnnotationMirror> annoCondTrue = split.annosWhenTrue;
        this.annos = split.annosWhenTrue;
        this.scanStat(node.getStatement());
        GenKillBits.andlub(annoCondTrue, annoEntry, this.annoRelations);
        GenKillBits.andlub(this.annos, annoEntry, this.annoRelations);
        annoEntry = GenKillBits.copy(this.annos);
        split = this.scanCond(node.getCondition());
        annoCond = split.annosWhenFalse;
        this.annos = split.annosWhenTrue;
        this.scanStat(node.getStatement());
        this.annos = annoCond;
        return null;
    }

    @Override
    public Void visitDoWhileLoop(DoWhileLoopTree node, Void p) {
        GenKillBits<AnnotationMirror> annoCond;
        boolean pass = false;
        while (true) {
            GenKillBits<AnnotationMirror> annoEntry = GenKillBits.copy(this.annos);
            this.scanStat(node.getStatement());
            SplitTuple split = this.scanCond(node.getCondition());
            annoCond = split.annosWhenFalse;
            this.annos = split.annosWhenTrue;
            if (pass) break;
            GenKillBits.andlub(split.annosWhenTrue, annoEntry, this.annoRelations);
            pass = true;
        }
        this.annos = annoCond;
        return null;
    }

    @Override
    public Void visitForLoop(ForLoopTree node, Void p) {
        GenKillBits<AnnotationMirror> annoCond;
        boolean pass = false;
        for (StatementTree statementTree : node.getInitializer()) {
            this.scanStat(statementTree);
        }
        while (true) {
            GenKillBits<AnnotationMirror> annoEntry = GenKillBits.copy(this.annos);
            SplitTuple split = this.scanCond(node.getCondition());
            annoCond = split.annosWhenFalse;
            this.annos = split.annosWhenTrue;
            GenKillBits<AnnotationMirror> genKillBits = split.annosWhenTrue;
            this.scanStat(node.getStatement());
            for (StatementTree statementTree : node.getUpdate()) {
                this.scanStat(statementTree);
            }
            if (pass) break;
            GenKillBits.andlub(genKillBits, annoEntry, this.annoRelations);
            GenKillBits.andlub(this.annos, annoEntry, this.annoRelations);
            pass = true;
        }
        this.annos = annoCond;
        return null;
    }

    @Override
    public Void visitBreak(BreakTree node, Void p) {
        this.alive = false;
        return null;
    }

    @Override
    public Void visitContinue(ContinueTree node, Void p) {
        this.alive = false;
        return null;
    }

    @Override
    public Void visitReturn(ReturnTree node, Void p) {
        if (node.getExpression() != null) {
            this.scanExpr(node.getExpression());
        }
        this.alive = false;
        return null;
    }

    @Override
    public Void visitThrow(ThrowTree node, Void p) {
        this.scanExpr(node.getExpression());
        this.alive = false;
        return null;
    }

    @Override
    public Void visitTry(TryTree node, Void p) {
        this.tryBits.push(GenKillBits.copy(this.annos));
        this.scan((Tree)node.getBlock(), p);
        GenKillBits<AnnotationMirror> annoAfterBlock = GenKillBits.copy(this.annos);
        this.pushNewLevel();
        GenKillBits<AnnotationMirror> result = this.tryBits.pop();
        GenKillBits.andlub(this.annos, result, this.annoRelations);
        this.popLastLevel();
        if (node.getCatches() != null) {
            boolean catchAlive = false;
            for (CatchTree catchTree : node.getCatches()) {
                this.scan((Tree)catchTree, p);
                catchAlive |= this.alive;
            }
            if (!catchAlive && node.getFinallyBlock() == null) {
                this.annos = GenKillBits.copy(annoAfterBlock);
            }
        }
        this.scan((Tree)node.getFinallyBlock(), p);
        return null;
    }

    @Override
    public Void visitMethodInvocation(MethodInvocationTree node, Void p) {
        String methodPackage;
        super.visitMethodInvocation(node, p);
        ExecutableElement method = TreeUtils.elementFromUse(node);
        if (method.getSimpleName().contentEquals("exit") && method.getEnclosingElement().getSimpleName().contentEquals("System")) {
            this.alive = false;
        }
        boolean isJDKMethod = (methodPackage = this.elements.getPackageOf(method).getQualifiedName().toString()).startsWith("java") || methodPackage.startsWith("com.sun");
        boolean isPure = method.getAnnotation(Pure.class) != null;
        for (int i = 0; i < this.vars.size(); ++i) {
            Element var = this.vars.get(i);
            for (AnnotationMirror a : this.annotations) {
                if (isJDKMethod || !Flow.isNonFinalField(var) || this.varDefHasAnnotation(a, var) || isPure) continue;
                this.annos.clear(a, i);
            }
        }
        List<? extends TypeMirror> thrown = method.getThrownTypes();
        if (!thrown.isEmpty() && TreeUtils.enclosingOfKind(this.getCurrentPath(), Tree.Kind.TRY) != null && !this.tryBits.isEmpty()) {
            GenKillBits.andlub(this.tryBits.peek(), this.annos, this.annoRelations);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visitBlock(BlockTree node, Void p) {
        if (node.isStatic()) {
            this.pushNewLevel();
            GenKillBits<AnnotationMirror> prev = GenKillBits.copy(this.annos);
            ArrayList<VariableElement> prevVars = new ArrayList<VariableElement>(this.vars);
            try {
                super.visitBlock(node, p);
                Void void_ = null;
                return void_;
            }
            finally {
                this.annos = prev;
                this.vars = prevVars;
                this.popLastLevel();
            }
        }
        return (Void)super.visitBlock(node, p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visitMethod(MethodTree node, Void p) {
        AnnotatedTypeMirror.AnnotatedDeclaredType preMRT = this.visitorState.getMethodReceiver();
        MethodTree preMT = this.visitorState.getMethodTree();
        this.visitorState.setMethodReceiver(this.factory.getAnnotatedType(node).getReceiverType());
        this.visitorState.setMethodTree(node);
        GenKillBits<AnnotationMirror> prev = GenKillBits.copy(this.annos);
        ArrayList<VariableElement> prevVars = new ArrayList<VariableElement>(this.vars);
        try {
            super.visitMethod(node, p);
            Void void_ = null;
            return void_;
        }
        finally {
            this.visitMethodEndCallback(node);
            this.annos = prev;
            this.vars = prevVars;
            this.visitorState.setMethodReceiver(preMRT);
            this.visitorState.setMethodTree(preMT);
        }
    }

    public void visitMethodEndCallback(MethodTree node) {
    }

    private boolean varDefHasAnnotation(AnnotationMirror annotation, Element var) {
        if (this.annotatedVarDefs.containsKey(var)) {
            return this.annotatedVarDefs.get(var);
        }
        boolean result = this.hasAnnotation(this.factory.getAnnotatedType(var), annotation);
        this.annotatedVarDefs.put(var, result);
        return result;
    }

    private static final boolean isNonFinalField(Element element) {
        return element.getKind().isField() && !ElementUtils.isFinal(element);
    }

    public static class SplitTuple {
        public GenKillBits<AnnotationMirror> annosWhenTrue;
        public GenKillBits<AnnotationMirror> annosWhenFalse;
    }
}

