/*
 * Decompiled with CFR 0.152.
 */
package checkers.igj;

import checkers.igj.IGJChecker;
import checkers.igj.quals.I;
import checkers.types.AnnotatedTypeMirror;
import checkers.types.BasicAnnotatedTypeFactory;
import checkers.types.TreeAnnotator;
import checkers.types.TypeAnnotator;
import checkers.types.visitors.AnnotatedTypeScanner;
import checkers.types.visitors.SimpleAnnotatedTypeVisitor;
import checkers.util.AnnotationUtils;
import checkers.util.ElementUtils;
import checkers.util.TreeUtils;
import checkers.util.TypesUtils;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeCastTree;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeVariable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IGJAnnotatedTypeFactory
extends BasicAnnotatedTypeFactory<IGJChecker> {
    private final AnnotationMirror READONLY;
    private final AnnotationMirror MUTABLE;
    private final AnnotationMirror IMMUTABLE;
    private final AnnotationMirror I;
    private final AnnotationMirror BOTTOM_QUAL;
    private final AnnotationMirror ASSIGNS_FIELDS;
    protected static final String IMMUTABILITY_KEY = "value";

    public IGJAnnotatedTypeFactory(IGJChecker checker, CompilationUnitTree root) {
        super(checker, root);
        this.READONLY = checker.READONLY;
        this.MUTABLE = checker.MUTABLE;
        this.IMMUTABLE = checker.IMMUTABLE;
        this.I = checker.I;
        this.BOTTOM_QUAL = checker.BOTTOM_QUAL;
        this.ASSIGNS_FIELDS = checker.ASSIGNS_FIELDS;
    }

    @Override
    protected Set<AnnotationMirror> createFlowQualifiers(IGJChecker checker) {
        AnnotationUtils annoFactory = AnnotationUtils.getInstance(this.env);
        HashSet<AnnotationMirror> flowQuals = new HashSet<AnnotationMirror>();
        for (Class<? extends Annotation> cl : checker.getSupportedTypeQualifiers()) {
            if (I.class.equals(cl)) continue;
            flowQuals.add(annoFactory.fromClass(cl));
        }
        return flowQuals;
    }

    @Override
    protected TreeAnnotator createTreeAnnotator(IGJChecker checker) {
        return new IGJTreePreAnnotator(checker);
    }

    @Override
    protected TypeAnnotator createTypeAnnotator(IGJChecker checker) {
        return new IGJTypePostAnnotator(checker);
    }

    @Override
    protected AnnotatedTypeMirror.AnnotatedDeclaredType getImplicitReceiverType(Tree tree) {
        AnnotatedTypeMirror.AnnotatedDeclaredType receiver = super.getImplicitReceiverType(tree);
        if (receiver != null && !this.isMostEnclosingThisDeref(tree)) {
            receiver.removeAnnotation(this.ASSIGNS_FIELDS);
            receiver.addAnnotation(this.READONLY);
        }
        return receiver;
    }

    @Override
    public AnnotatedTypeMirror.AnnotatedDeclaredType getSelfType(Tree tree) {
        AnnotatedTypeMirror.AnnotatedDeclaredType act = this.getCurrentClassType(tree);
        AnnotatedTypeMirror.AnnotatedDeclaredType methodReceiver = this.getCurrentMethodReceiver(tree);
        if (methodReceiver == null) {
            return act;
        }
        if (this.isWithinConstructor(tree) && !methodReceiver.hasAnnotation(this.MUTABLE)) {
            methodReceiver.clearAnnotations();
            methodReceiver.addAnnotation(this.ASSIGNS_FIELDS);
        }
        if (methodReceiver.hasAnnotation(this.MUTABLE) || methodReceiver.hasAnnotation(this.IMMUTABLE)) {
            return methodReceiver;
        }
        if (act.hasAnnotation(this.I) || act.hasAnnotation(this.IMMUTABLE)) {
            if (methodReceiver.hasAnnotation(this.ASSIGNS_FIELDS)) {
                act.addAnnotation(this.ASSIGNS_FIELDS);
            }
            return act;
        }
        return methodReceiver;
    }

    @Override
    protected void postDirectSuperTypes(AnnotatedTypeMirror type, List<? extends AnnotatedTypeMirror> supertypes) {
        super.postDirectSuperTypes(type, supertypes);
        Map templateMapping = (Map)new ImmutabilityTemplateCollector().visit(type);
        new ImmutabilityResolver().visit(supertypes, templateMapping);
        for (AnnotatedTypeMirror annotatedTypeMirror : supertypes) {
            this.typeAnnotator.visit(annotatedTypeMirror, ElementKind.OTHER);
        }
    }

    @Override
    public void postAsMemberOf(AnnotatedTypeMirror elementType, AnnotatedTypeMirror owner, Element element) {
        this.resolveImmutabilityTypeVar(elementType, owner);
    }

    @Override
    public AnnotatedTypeMirror.AnnotatedExecutableType methodFromUse(MethodInvocationTree tree) {
        List<AnnotatedTypeMirror> requiredArgs;
        AnnotatedTypeMirror.AnnotatedExecutableType type = super.methodFromUse(tree);
        ImmutabilityTemplateCollector collector = new ImmutabilityTemplateCollector();
        List<AnnotatedTypeMirror> arguments = this.atypes.getAnnotatedTypes(tree.getArguments());
        Map<String, AnnotationMirror> matchingMapping = collector.visit(arguments, requiredArgs = this.atypes.expandVarArgs(type, tree.getArguments()));
        if (!matchingMapping.isEmpty()) {
            new ImmutabilityResolver().visit(type, matchingMapping);
        }
        Map fromReceiver = (Map)collector.visit(this.getReceiver(tree));
        final Map<String, AnnotationMirror> mapping = collector.reduce(matchingMapping, fromReceiver);
        new AnnotatedTypeScanner<Void, Void>(){

            @Override
            public Void visitDeclared(AnnotatedTypeMirror.AnnotatedDeclaredType type, Void p) {
                AnnotationMirror anno;
                if (type.hasAnnotation(IGJAnnotatedTypeFactory.this.I) && !mapping.containsValue(anno = type.getAnnotation(I.class.getCanonicalName()))) {
                    type.removeAnnotation(IGJAnnotatedTypeFactory.this.I);
                    type.addAnnotation(IGJAnnotatedTypeFactory.this.BOTTOM_QUAL);
                }
                return (Void)super.visitDeclared(type, p);
            }
        }.visit(type);
        return type;
    }

    private boolean resolveImmutabilityTypeVar(AnnotatedTypeMirror type, AnnotatedTypeMirror ... provided) {
        ImmutabilityTemplateCollector collector = new ImmutabilityTemplateCollector();
        Map<String, AnnotationMirror> templateMapping = Collections.emptyMap();
        for (AnnotatedTypeMirror pt : provided) {
            templateMapping = collector.reduce(templateMapping, (Map)collector.visit(pt));
        }
        if (templateMapping.isEmpty()) {
            return false;
        }
        new ImmutabilityResolver().visit(type, templateMapping);
        return true;
    }

    private AnnotationMirror getImmutabilityAnnotation(AnnotatedTypeMirror type) {
        if (type.hasAnnotation(this.I)) {
            return type.getAnnotation(I.class.getCanonicalName());
        }
        return type.getAnnotations().iterator().next();
    }

    private boolean hasImmutabilityAnnotation(AnnotatedTypeMirror type) {
        return type.isAnnotated();
    }

    static {
        FLOW_BY_DEFAULT = true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ImmutabilityTemplateCollector
    extends SimpleAnnotatedTypeVisitor<Map<String, AnnotationMirror>, AnnotatedTypeMirror> {
        private Set<TypeVariable> typeVar = new HashSet<TypeVariable>();

        private ImmutabilityTemplateCollector() {
        }

        public Map<String, AnnotationMirror> reduce(Map<String, AnnotationMirror> r1, Map<String, AnnotationMirror> r2) {
            HashMap<String, AnnotationMirror> result = new HashMap<String, AnnotationMirror>();
            if (r1 != null) {
                result.putAll(r1);
            }
            if (r2 != null) {
                for (String key : r2.keySet()) {
                    if (!result.containsKey(key)) {
                        result.put(key, r2.get(key));
                        continue;
                    }
                    if (AnnotationUtils.areSame((AnnotationMirror)result.get(key), r2.get(key))) continue;
                    result.put(key, IGJAnnotatedTypeFactory.this.READONLY);
                }
            }
            return result;
        }

        public Map<String, AnnotationMirror> visit(Iterable<? extends AnnotatedTypeMirror> types, Iterable<? extends AnnotatedTypeMirror> actualTypes) {
            Map<String, AnnotationMirror> result = new HashMap<String, AnnotationMirror>();
            Iterator<? extends AnnotatedTypeMirror> itert = types.iterator();
            Iterator<? extends AnnotatedTypeMirror> itera = actualTypes.iterator();
            while (itert.hasNext() && itera.hasNext()) {
                AnnotatedTypeMirror type = itert.next();
                AnnotatedTypeMirror actualType = itera.next();
                result = this.reduce(result, (Map)this.visit(type, actualType));
            }
            return result;
        }

        @Override
        public Map<String, AnnotationMirror> visitDeclared(AnnotatedTypeMirror.AnnotatedDeclaredType type, AnnotatedTypeMirror actualType) {
            if (actualType == null) {
                TypeElement elem = (TypeElement)type.getUnderlyingType().asElement();
                actualType = IGJAnnotatedTypeFactory.this.getAnnotatedType(elem);
            }
            if (actualType.getKind() == TypeKind.TYPEVAR) {
                if (this.typeVar.contains(actualType.getUnderlyingType())) {
                    return Collections.emptyMap();
                }
                this.typeVar.add((TypeVariable)actualType.getUnderlyingType());
                Map result = (Map)this.visit(type, ((AnnotatedTypeMirror.AnnotatedTypeVariable)actualType).getUpperBound());
                this.typeVar.remove(actualType.getUnderlyingType());
                return result;
            }
            if (actualType.getKind() == TypeKind.WILDCARD) {
                return (Map)this.visit(type, ((AnnotatedTypeMirror.AnnotatedWildcardType)actualType).getExtendsBound());
            }
            if (actualType.getKind() != type.getKind()) {
                return Collections.emptyMap();
            }
            assert (actualType.getKind() == type.getKind());
            type = (AnnotatedTypeMirror.AnnotatedDeclaredType)IGJAnnotatedTypeFactory.this.atypes.asSuper(type, actualType);
            if (type == null) {
                return Collections.emptyMap();
            }
            AnnotatedTypeMirror.AnnotatedDeclaredType dcType = (AnnotatedTypeMirror.AnnotatedDeclaredType)actualType;
            Map<String, AnnotationMirror> result = new HashMap<String, AnnotationMirror>();
            if (dcType.hasAnnotation(IGJAnnotatedTypeFactory.this.I)) {
                String immutableString = AnnotationUtils.parseStringValue(IGJAnnotatedTypeFactory.this.getImmutabilityAnnotation(dcType), IGJAnnotatedTypeFactory.IMMUTABILITY_KEY);
                AnnotationMirror immutability = IGJAnnotatedTypeFactory.this.getImmutabilityAnnotation(type);
                assert (immutability != null);
                if (!immutability.equals(IGJAnnotatedTypeFactory.this.ASSIGNS_FIELDS)) {
                    result.put(immutableString, immutability);
                }
            }
            if (type != dcType && type.isParameterized() && dcType.isParameterized()) {
                result = this.reduce(result, this.visit(type.getTypeArguments(), dcType.getTypeArguments()));
            }
            return result;
        }

        @Override
        public Map<String, AnnotationMirror> visitArray(AnnotatedTypeMirror.AnnotatedArrayType type, AnnotatedTypeMirror actualType) {
            if (actualType == null) {
                return (Map)this.visit(type.getComponentType(), null);
            }
            if (actualType.getKind() == TypeKind.DECLARED) {
                return (Map)this.visit(IGJAnnotatedTypeFactory.this.atypes.asSuper(type, actualType), actualType);
            }
            if (actualType.getKind() == TypeKind.TYPEVAR) {
                if (this.typeVar.contains(actualType.getUnderlyingType())) {
                    return Collections.emptyMap();
                }
                this.typeVar.add((TypeVariable)actualType.getUnderlyingType());
                Map result = (Map)this.visit(type, ((AnnotatedTypeMirror.AnnotatedTypeVariable)actualType).getUpperBound());
                this.typeVar.remove(actualType.getUnderlyingType());
                return result;
            }
            if (actualType.getKind() == TypeKind.WILDCARD) {
                return (Map)this.visit(type, ((AnnotatedTypeMirror.AnnotatedWildcardType)actualType).getExtendsBound());
            }
            if (type.getKind() != actualType.getKind()) {
                return (Map)this.visit(type, null);
            }
            assert (type.getKind() == actualType.getKind());
            AnnotatedTypeMirror.AnnotatedArrayType arType = (AnnotatedTypeMirror.AnnotatedArrayType)actualType;
            Map<String, AnnotationMirror> result = new HashMap<String, AnnotationMirror>();
            if (arType.hasAnnotation(IGJAnnotatedTypeFactory.this.I)) {
                String immutableString = AnnotationUtils.parseStringValue(IGJAnnotatedTypeFactory.this.getImmutabilityAnnotation(arType), IGJAnnotatedTypeFactory.IMMUTABILITY_KEY);
                AnnotationMirror immutability = IGJAnnotatedTypeFactory.this.getImmutabilityAnnotation(type);
                assert (immutability != null);
                if (!type.hasAnnotation(IGJAnnotatedTypeFactory.this.ASSIGNS_FIELDS)) {
                    result.put(immutableString, immutability);
                }
            }
            result = this.reduce(result, (Map)this.visit(type.getComponentType(), arType.getComponentType()));
            return result;
        }

        @Override
        public Map<String, AnnotationMirror> visitTypeVariable(AnnotatedTypeMirror.AnnotatedTypeVariable type, AnnotatedTypeMirror actualType) {
            AnnotatedTypeMirror typeSuper;
            if (actualType == null) {
                return Collections.emptyMap();
            }
            if (actualType.getKind() == TypeKind.WILDCARD && ((AnnotatedTypeMirror.AnnotatedWildcardType)actualType).getSuperBound() != null) {
                actualType = ((AnnotatedTypeMirror.AnnotatedWildcardType)actualType).getSuperBound();
            }
            if ((typeSuper = this.findType(type, actualType)).getKind() != TypeKind.TYPEVAR) {
                return (Map)this.visit(typeSuper, actualType);
            }
            assert (typeSuper.getKind() == actualType.getKind()) : actualType;
            assert (type.getKind() == actualType.getKind()) : actualType;
            AnnotatedTypeMirror.AnnotatedTypeVariable tvType = (AnnotatedTypeMirror.AnnotatedTypeVariable)typeSuper;
            this.typeVar.add(type.getUnderlyingType());
            Map result = (Map)this.visit(type.getUpperBound(), tvType.getUpperBound());
            this.typeVar.remove(type.getUnderlyingType());
            return result;
        }

        @Override
        public Map<String, AnnotationMirror> visitWildcard(AnnotatedTypeMirror.AnnotatedWildcardType type, AnnotatedTypeMirror actualType) {
            if (actualType == null) {
                return Collections.emptyMap();
            }
            AnnotatedTypeMirror typeSuper = this.findType(type, actualType);
            if (typeSuper.getKind() != TypeKind.WILDCARD) {
                return (Map)this.visit(typeSuper, actualType);
            }
            if (typeSuper.getKind() != actualType.getKind()) {
                return Collections.emptyMap();
            }
            assert (typeSuper.getKind() == actualType.getKind()) : actualType;
            AnnotatedTypeMirror.AnnotatedWildcardType wcType = (AnnotatedTypeMirror.AnnotatedWildcardType)typeSuper;
            if (type.getExtendsBound() != null && wcType.getExtendsBound() != null) {
                return (Map)this.visit(type.getExtendsBound(), wcType.getExtendsBound());
            }
            if (type.getSuperBound() != null && wcType.getSuperBound() != null) {
                return (Map)this.visit(type.getSuperBound(), wcType.getSuperBound());
            }
            return new HashMap<String, AnnotationMirror>();
        }

        private AnnotatedTypeMirror findType(AnnotatedTypeMirror type, AnnotatedTypeMirror actualType) {
            AnnotatedTypeMirror result = IGJAnnotatedTypeFactory.this.atypes.asSuper(type, actualType);
            return result != null ? result : type;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ImmutabilityResolver
    extends AnnotatedTypeScanner<Void, Map<String, AnnotationMirror>> {
        private ImmutabilityResolver() {
        }

        public void visit(Iterable<? extends AnnotatedTypeMirror> types, Map<String, AnnotationMirror> templateMapping) {
            if (templateMapping != null && !templateMapping.isEmpty()) {
                for (AnnotatedTypeMirror annotatedTypeMirror : types) {
                    this.visit(annotatedTypeMirror, templateMapping);
                }
            }
        }

        @Override
        public Void visitDeclared(AnnotatedTypeMirror.AnnotatedDeclaredType type, Map<String, AnnotationMirror> p) {
            String immutableString;
            if (type.hasAnnotation(IGJAnnotatedTypeFactory.this.I) && p.containsKey(immutableString = AnnotationUtils.parseStringValue(IGJAnnotatedTypeFactory.this.getImmutabilityAnnotation(type), IGJAnnotatedTypeFactory.IMMUTABILITY_KEY))) {
                type.removeAnnotation(IGJAnnotatedTypeFactory.this.I);
                type.addAnnotation(p.get(immutableString));
            }
            return (Void)super.visitDeclared(type, p);
        }
    }

    private class IGJTreePreAnnotator
    extends TreeAnnotator {
        public IGJTreePreAnnotator(IGJChecker checker) {
            super(checker, IGJAnnotatedTypeFactory.this);
        }

        public Void visitNewClass(NewClassTree node, AnnotatedTypeMirror p) {
            if (!IGJAnnotatedTypeFactory.this.hasImmutabilityAnnotation(p)) {
                AnnotatedTypeMirror ct = IGJAnnotatedTypeFactory.this.fromElement(((AnnotatedTypeMirror.AnnotatedDeclaredType)p).getUnderlyingType().asElement());
                if (!IGJAnnotatedTypeFactory.this.hasImmutabilityAnnotation(ct) || ct.hasAnnotation(IGJAnnotatedTypeFactory.this.I)) {
                    AnnotatedTypeMirror.AnnotatedExecutableType con = IGJAnnotatedTypeFactory.this.getAnnotatedType(TreeUtils.elementFromUse(node));
                    if (con.getReceiverType().hasAnnotation(IGJAnnotatedTypeFactory.this.IMMUTABLE)) {
                        p.addAnnotation(IGJAnnotatedTypeFactory.this.IMMUTABLE);
                    } else {
                        p.addAnnotation(IGJAnnotatedTypeFactory.this.MUTABLE);
                    }
                } else {
                    p.addAnnotations(ct.getAnnotations());
                }
            }
            return null;
        }

        public Void visitTypeCast(TypeCastTree node, AnnotatedTypeMirror p) {
            if (!IGJAnnotatedTypeFactory.this.hasImmutabilityAnnotation(p)) {
                AnnotatedTypeMirror castedType = IGJAnnotatedTypeFactory.this.getAnnotatedType(node.getExpression());
                p.addAnnotations(castedType.getAnnotations());
            }
            return null;
        }
    }

    private class IGJTypePostAnnotator
    extends TypeAnnotator {
        public IGJTypePostAnnotator(IGJChecker checker) {
            super(checker);
        }

        public Void visitDeclared(AnnotatedTypeMirror.AnnotatedDeclaredType type, ElementKind p) {
            if (!IGJAnnotatedTypeFactory.this.hasImmutabilityAnnotation(type)) {
                TypeElement element = (TypeElement)type.getUnderlyingType().asElement();
                AnnotatedTypeMirror.AnnotatedDeclaredType elementType = IGJAnnotatedTypeFactory.this.fromElement(element);
                if (TypesUtils.isBoxedPrimitive(type.getUnderlyingType()) || element.getQualifiedName().contentEquals("java.lang.String") || ElementUtils.isObject(element)) {
                    type.addAnnotation(IGJAnnotatedTypeFactory.this.BOTTOM_QUAL);
                } else if (elementType.hasAnnotation(IGJAnnotatedTypeFactory.this.IMMUTABLE)) {
                    type.addAnnotation(IGJAnnotatedTypeFactory.this.IMMUTABLE);
                } else if (p == ElementKind.LOCAL_VARIABLE) {
                    type.addAnnotation(IGJAnnotatedTypeFactory.this.READONLY);
                } else if (elementType.hasAnnotation(IGJAnnotatedTypeFactory.this.MUTABLE)) {
                    type.addAnnotation(IGJAnnotatedTypeFactory.this.MUTABLE);
                } else if (p.isClass() || p.isInterface()) {
                    type.addAnnotation(IGJAnnotatedTypeFactory.this.BOTTOM_QUAL);
                } else if (p.isField() && type.getElement() != null && IGJAnnotatedTypeFactory.this.getAnnotatedType(ElementUtils.enclosingClass(type.getElement())).hasAnnotation(IGJAnnotatedTypeFactory.this.IMMUTABLE)) {
                    type.addAnnotation(IGJAnnotatedTypeFactory.this.IMMUTABLE);
                } else if (element.getKind().isClass() || element.getKind().isInterface()) {
                    type.addAnnotation(IGJAnnotatedTypeFactory.this.MUTABLE);
                } else assert (false) : "shouldn't be here!";
            }
            return (Void)super.visitDeclared(type, p == ElementKind.LOCAL_VARIABLE || p == ElementKind.FIELD ? ElementKind.OTHER : p);
        }

        public Void visitExecutable(AnnotatedTypeMirror.AnnotatedExecutableType type, ElementKind p) {
            if (IGJAnnotatedTypeFactory.this.hasImmutabilityAnnotation(type.getReceiverType())) {
                return super.visitExecutable(type, p);
            }
            AnnotatedTypeMirror.AnnotatedDeclaredType receiver = type.getReceiverType();
            TypeElement ownerElement = ElementUtils.enclosingClass(type.getElement());
            AnnotatedTypeMirror.AnnotatedDeclaredType ownerType = IGJAnnotatedTypeFactory.this.getAnnotatedType(ownerElement);
            if (type.getElement().getKind() == ElementKind.CONSTRUCTOR) {
                if (ownerType.hasAnnotation(IGJAnnotatedTypeFactory.this.MUTABLE) || ownerType.hasAnnotation(IGJAnnotatedTypeFactory.this.BOTTOM_QUAL)) {
                    receiver.addAnnotation(IGJAnnotatedTypeFactory.this.MUTABLE);
                } else {
                    receiver.addAnnotation(IGJAnnotatedTypeFactory.this.ASSIGNS_FIELDS);
                }
            } else if (ElementUtils.isObject(ownerElement) || ownerType.hasAnnotation(IGJAnnotatedTypeFactory.this.IMMUTABLE)) {
                receiver.addAnnotation(IGJAnnotatedTypeFactory.this.BOTTOM_QUAL);
            } else {
                receiver.addAnnotation(IGJAnnotatedTypeFactory.this.MUTABLE);
            }
            return super.visitExecutable(type, p);
        }

        public Void visitTypeVariable(AnnotatedTypeMirror.AnnotatedTypeVariable type, ElementKind p) {
            if (type.getUpperBound() != null && !IGJAnnotatedTypeFactory.this.hasImmutabilityAnnotation(type.getUpperBound())) {
                if (p.isClass() || p.isInterface() || p == ElementKind.CONSTRUCTOR || p == ElementKind.METHOD) {
                    type.getUpperBound().addAnnotation(IGJAnnotatedTypeFactory.this.READONLY);
                } else if (TypesUtils.isObject(type.getUnderlyingType())) {
                    type.getUpperBound().addAnnotation(IGJAnnotatedTypeFactory.this.MUTABLE);
                }
            }
            return (Void)super.visitTypeVariable(type, p);
        }

        public Void visitWildcard(AnnotatedTypeMirror.AnnotatedWildcardType type, ElementKind p) {
            if (type.getExtendsBound() != null && !IGJAnnotatedTypeFactory.this.hasImmutabilityAnnotation(type.getExtendsBound())) {
                if (p.isClass() || p.isInterface() || p == ElementKind.CONSTRUCTOR || p == ElementKind.METHOD) {
                    type.getExtendsBound().addAnnotation(IGJAnnotatedTypeFactory.this.READONLY);
                } else if (TypesUtils.isObject(type.getUnderlyingType())) {
                    type.getExtendsBound().addAnnotation(IGJAnnotatedTypeFactory.this.MUTABLE);
                }
            }
            return (Void)super.visitWildcard(type, p);
        }
    }
}

