/*
 * Decompiled with CFR 0.152.
 */
package checkers.igj;

import checkers.basetype.BaseTypeChecker;
import checkers.igj.IGJBottom;
import checkers.igj.quals.Assignable;
import checkers.igj.quals.AssignsFields;
import checkers.igj.quals.I;
import checkers.igj.quals.Immutable;
import checkers.igj.quals.Mutable;
import checkers.igj.quals.ReadOnly;
import checkers.quals.TypeQualifiers;
import checkers.types.AnnotatedTypeMirror;
import checkers.types.QualifierHierarchy;
import checkers.types.TypeHierarchy;
import checkers.util.AnnotationUtils;
import checkers.util.ElementUtils;
import checkers.util.GraphQualifierHierarchy;
import checkers.util.InternalUtils;
import checkers.util.TreeUtils;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.Tree;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;

@TypeQualifiers(value={ReadOnly.class, Mutable.class, Immutable.class, I.class, AssignsFields.class, IGJBottom.class})
public class IGJChecker
extends BaseTypeChecker {
    protected AnnotationMirror READONLY;
    protected AnnotationMirror MUTABLE;
    protected AnnotationMirror IMMUTABLE;
    protected AnnotationMirror I;
    protected AnnotationMirror ASSIGNS_FIELDS;
    protected AnnotationMirror BOTTOM_QUAL;

    public synchronized void init(ProcessingEnvironment env) {
        AnnotationUtils annoFactory = AnnotationUtils.getInstance(env);
        this.READONLY = annoFactory.fromClass(ReadOnly.class);
        this.MUTABLE = annoFactory.fromClass(Mutable.class);
        this.IMMUTABLE = annoFactory.fromClass(Immutable.class);
        this.I = annoFactory.fromClass(I.class);
        this.ASSIGNS_FIELDS = annoFactory.fromClass(AssignsFields.class);
        this.BOTTOM_QUAL = annoFactory.fromClass(IGJBottom.class);
        super.init(env);
    }

    public boolean isAssignable(AnnotatedTypeMirror varType, AnnotatedTypeMirror receiverType, Tree varTree) {
        if (!(varTree instanceof ExpressionTree)) {
            return true;
        }
        Element varElement = InternalUtils.symbol(varTree);
        if (varTree.getKind() != Tree.Kind.ARRAY_ACCESS && (varElement == null || !varElement.getKind().isField() || ElementUtils.isStatic(varElement) || varElement.getAnnotation(Assignable.class) != null)) {
            return true;
        }
        assert (receiverType != null);
        boolean isAssignable = receiverType.hasAnnotation(this.MUTABLE) || receiverType.hasAnnotation(this.BOTTOM_QUAL) || receiverType.hasAnnotation(this.ASSIGNS_FIELDS) && TreeUtils.isSelfAccess((ExpressionTree)varTree);
        return isAssignable;
    }

    public boolean isValidUse(AnnotatedTypeMirror.AnnotatedDeclaredType elemType, AnnotatedTypeMirror.AnnotatedDeclaredType use) {
        if (elemType.hasAnnotation(this.I) || use.hasAnnotation(this.READONLY)) {
            return true;
        }
        return super.isValidUse(elemType, use);
    }

    protected QualifierHierarchy createQualifierHierarchy() {
        return new IGJQualifierHierarchy((GraphQualifierHierarchy)super.createQualifierHierarchy());
    }

    protected TypeHierarchy createTypeHierarchy() {
        return new IGJTypeHierarchy(this.getQualifierHierarchy());
    }

    private final class IGJTypeHierarchy
    extends TypeHierarchy {
        public IGJTypeHierarchy(QualifierHierarchy qualifierHierarchy) {
            super(qualifierHierarchy);
        }

        protected boolean isSubtypeAsTypeArgument(AnnotatedTypeMirror rhs, AnnotatedTypeMirror lhs) {
            return lhs.hasAnnotation(IGJChecker.this.BOTTOM_QUAL) || rhs.hasAnnotation(IGJChecker.this.BOTTOM_QUAL) || super.isSubtypeAsTypeArgument(rhs, lhs);
        }

        protected boolean isSubtypeTypeArguments(AnnotatedTypeMirror.AnnotatedDeclaredType rhs, AnnotatedTypeMirror.AnnotatedDeclaredType lhs) {
            if (lhs.hasAnnotation(IGJChecker.this.MUTABLE)) {
                return super.isSubtypeTypeArguments(rhs, lhs);
            }
            if (!lhs.getTypeArguments().isEmpty() && !rhs.getTypeArguments().isEmpty()) {
                assert (lhs.getTypeArguments().size() == rhs.getTypeArguments().size());
                for (int i = 0; i < lhs.getTypeArguments().size(); ++i) {
                    if (this.isSubtype(rhs.getTypeArguments().get(i), lhs.getTypeArguments().get(i))) continue;
                    return false;
                }
            }
            return true;
        }
    }

    private final class IGJQualifierHierarchy
    extends GraphQualifierHierarchy {
        public IGJQualifierHierarchy(GraphQualifierHierarchy hierarchy) {
            super(hierarchy);
        }

        public boolean isSubtype(AnnotationMirror rhs, AnnotationMirror lhs) {
            return AnnotationUtils.areSame(rhs, IGJChecker.this.BOTTOM_QUAL) || AnnotationUtils.areSame(lhs, IGJChecker.this.BOTTOM_QUAL) || super.isSubtype(rhs, lhs);
        }
    }
}

