/*
 * Decompiled with CFR 0.152.
 */
package checkers.interning;

import checkers.basetype.BaseTypeChecker;
import checkers.interning.InterningChecker;
import checkers.interning.quals.Interned;
import checkers.javari.quals.Mutable;
import checkers.types.AnnotatedTypeFactory;
import checkers.types.AnnotatedTypeMirror;
import checkers.types.BasicAnnotatedTypeFactory;
import checkers.types.TreeAnnotator;
import checkers.types.TypeAnnotator;
import checkers.util.ElementUtils;
import checkers.util.TreeUtils;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.CompilationUnitTree;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterningAnnotatedTypeFactory
extends BasicAnnotatedTypeFactory<InterningChecker> {
    final AnnotationMirror INTERNED;

    public InterningAnnotatedTypeFactory(InterningChecker checker, CompilationUnitTree root) {
        super(checker, root);
        this.INTERNED = this.annotations.fromClass(Interned.class);
        this.addAliasedAnnotation(com.sun.istack.Interned.class, this.INTERNED);
    }

    @Override
    protected TreeAnnotator createTreeAnnotator(InterningChecker checker) {
        return new InterningTreeAnnotator(checker);
    }

    @Override
    protected TypeAnnotator createTypeAnnotator(InterningChecker checker) {
        return new InterningTypeAnnotator(checker);
    }

    @Override
    protected void annotateImplicit(Element element, AnnotatedTypeMirror type) {
        if (!type.isAnnotated() && ElementUtils.isCompileTimeConstant(element)) {
            type.addAnnotation(this.INTERNED);
        }
        super.annotateImplicit(element, type);
    }

    @Override
    public AnnotatedTypeMirror.AnnotatedPrimitiveType getUnboxedType(AnnotatedTypeMirror.AnnotatedDeclaredType type) {
        AnnotatedTypeMirror.AnnotatedPrimitiveType primitive = super.getUnboxedType(type);
        primitive.addAnnotation(this.INTERNED);
        return primitive;
    }

    @Override
    protected void annotateInheritedFromClass(@Mutable AnnotatedTypeMirror type) {
        AnnotatedTypeFactory.InheritedFromClassAnnotator.INSTANCE.visit(type, this);
    }

    private class InterningTypeAnnotator
    extends TypeAnnotator {
        InterningTypeAnnotator(BaseTypeChecker checker) {
            super(checker);
        }

        public Void visitDeclared(AnnotatedTypeMirror.AnnotatedDeclaredType t, ElementKind p) {
            Element elt = t.getUnderlyingType().asElement();
            assert (elt != null);
            if (elt.getKind() == ElementKind.ENUM) {
                t.addAnnotation(InterningAnnotatedTypeFactory.this.INTERNED);
            }
            return (Void)super.visitDeclared(t, p);
        }
    }

    private class InterningTreeAnnotator
    extends TreeAnnotator {
        InterningTreeAnnotator(BaseTypeChecker checker) {
            super(checker, InterningAnnotatedTypeFactory.this);
        }

        public Void visitBinary(BinaryTree node, AnnotatedTypeMirror type) {
            if (TreeUtils.isCompileTimeString(node)) {
                type.addAnnotation(InterningAnnotatedTypeFactory.this.INTERNED);
            }
            return (Void)super.visitBinary(node, type);
        }
    }
}

