/*
 * Decompiled with CFR 0.152.
 */
package checkers.interning;

import checkers.basetype.BaseTypeVisitor;
import checkers.interning.InterningChecker;
import checkers.interning.quals.Interned;
import checkers.source.Result;
import checkers.types.AnnotatedTypeMirror;
import checkers.util.Heuristics;
import checkers.util.InternalUtils;
import checkers.util.TreeUtils;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ConditionalExpressionTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.Scope;
import com.sun.source.tree.Tree;
import java.util.Comparator;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.ElementFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InterningVisitor
extends BaseTypeVisitor<Void, Void> {
    private final AnnotationMirror INTERNED;
    private final DeclaredType typeToCheck;

    public InterningVisitor(InterningChecker checker, CompilationUnitTree root) {
        super(checker, root);
        this.INTERNED = this.annoFactory.fromClass(Interned.class);
        this.typeToCheck = checker.typeToCheck();
    }

    private boolean shouldCheckFor(ExpressionTree tree) {
        if (this.typeToCheck == null) {
            return true;
        }
        TypeMirror type = InternalUtils.typeOf(tree);
        return this.types.isSubtype(type, this.typeToCheck) || this.types.isSubtype(this.typeToCheck, type);
    }

    @Override
    public Void visitBinary(BinaryTree node, Void p) {
        if (node.getKind() != Tree.Kind.EQUAL_TO && node.getKind() != Tree.Kind.NOT_EQUAL_TO) {
            return (Void)super.visitBinary(node, p);
        }
        ExpressionTree leftOp = node.getLeftOperand();
        ExpressionTree rightOp = node.getRightOperand();
        if (leftOp.getKind() == Tree.Kind.NULL_LITERAL || rightOp.getKind() == Tree.Kind.NULL_LITERAL) {
            return (Void)super.visitBinary(node, p);
        }
        AnnotatedTypeMirror left = this.atypeFactory.getAnnotatedType(leftOp);
        AnnotatedTypeMirror right = this.atypeFactory.getAnnotatedType(rightOp);
        if (left.getKind().isPrimitive() || right.getKind().isPrimitive()) {
            return (Void)super.visitBinary(node, p);
        }
        if (!this.shouldCheckFor(leftOp) || !this.shouldCheckFor(rightOp)) {
            return (Void)super.visitBinary(node, p);
        }
        if (this.suppressInsideComparison(node)) {
            return (Void)super.visitBinary(node, p);
        }
        if (this.suppressEarlyEquals(node)) {
            return (Void)super.visitBinary(node, p);
        }
        if (this.suppressEarlyCompareTo(node)) {
            return (Void)super.visitBinary(node, p);
        }
        if (this.suppressClassAnnotation(left, right)) {
            return (Void)super.visitBinary(node, p);
        }
        if (!left.hasAnnotation(this.INTERNED)) {
            this.checker.report(Result.failure("not.interned", left), leftOp);
        }
        if (!right.hasAnnotation(this.INTERNED)) {
            this.checker.report(Result.failure("not.interned", right), rightOp);
        }
        return (Void)super.visitBinary(node, p);
    }

    @Override
    public Void visitMethodInvocation(MethodInvocationTree node, Void p) {
        if (this.isInvocationOfEquals(node)) {
            AnnotatedTypeMirror recv = this.atypeFactory.getReceiver(node);
            AnnotatedTypeMirror comp = this.atypeFactory.getAnnotatedType(node.getArguments().get(0));
            if (this.checker.getLintOption("dotequals", true) && recv.hasAnnotation(this.INTERNED) && comp.hasAnnotation(this.INTERNED)) {
                this.checker.report(Result.warning("unnecessary.equals", new Object[0]), node);
            }
        }
        return (Void)super.visitMethodInvocation(node, p);
    }

    private boolean isInvocationOfEquals(MethodInvocationTree node) {
        ExecutableElement method = TreeUtils.elementFromUse(node);
        return method.getParameters().size() == 1 && method.getReturnType().getKind() == TypeKind.BOOLEAN && method.getSimpleName().contentEquals("equals");
    }

    private boolean isInvocationOfCompareTo(MethodInvocationTree node) {
        ExecutableElement method = TreeUtils.elementFromUse(node);
        return method.getParameters().size() == 1 && method.getReturnType().getKind() == TypeKind.INT && method.getSimpleName().contentEquals("compareTo");
    }

    private boolean suppressInsideComparison(BinaryTree node) {
        if (node.getKind() != Tree.Kind.EQUAL_TO) {
            return false;
        }
        ExpressionTree left = node.getLeftOperand();
        ExpressionTree right = node.getRightOperand();
        if (left.getKind() != Tree.Kind.IDENTIFIER || right.getKind() != Tree.Kind.IDENTIFIER) {
            return false;
        }
        if (!Heuristics.matchParents(this.getCurrentPath(), Tree.Kind.IF, Tree.Kind.METHOD)) {
            return false;
        }
        ExecutableElement enclosing = TreeUtils.elementFromDeclaration(this.visitorState.getMethodTree());
        assert (enclosing != null);
        Element lhs = TreeUtils.elementFromUse((IdentifierTree)left);
        Element rhs = TreeUtils.elementFromUse((IdentifierTree)right);
        Heuristics.Matcher matcher = new Heuristics.Matcher(){

            public Boolean visitIf(IfTree tree, Void p) {
                return (Boolean)this.visit(tree.getThenStatement(), p);
            }

            public Boolean visitBlock(BlockTree tree, Void p) {
                if (tree.getStatements().size() > 0) {
                    return (Boolean)this.visit(tree.getStatements().get(0), p);
                }
                return false;
            }

            public Boolean visitReturn(ReturnTree tree, Void p) {
                ExpressionTree expr = tree.getExpression();
                return expr != null && expr.getKind() == Tree.Kind.INT_LITERAL && ((LiteralTree)expr).getValue().equals(0);
            }
        };
        if (this.overrides(enclosing, Comparator.class, "compare")) {
            boolean returnsZero = Heuristics.Matchers.withIn(Heuristics.Matchers.ofKind(Tree.Kind.IF, matcher)).match(this.getCurrentPath());
            if (!returnsZero) {
                return false;
            }
            assert (enclosing.getParameters().size() == 2);
            Element p1 = enclosing.getParameters().get(0);
            Element p2 = enclosing.getParameters().get(1);
            return p1.equals(lhs) && p2.equals(rhs) || p2.equals(lhs) && p1.equals(rhs);
        }
        if (this.overrides(enclosing, Object.class, "equals")) {
            assert (enclosing.getParameters().size() == 1);
            Element param = enclosing.getParameters().get(0);
            Element thisElt = this.getThis(this.trees.getScope(this.getCurrentPath()));
            assert (thisElt != null);
            return thisElt.equals(lhs) && param.equals(rhs) || param.equals(lhs) && thisElt.equals(rhs);
        }
        if (this.overrides(enclosing, Comparable.class, "compareTo")) {
            boolean returnsZero = Heuristics.Matchers.withIn(Heuristics.Matchers.ofKind(Tree.Kind.IF, matcher)).match(this.getCurrentPath());
            if (!returnsZero) {
                return false;
            }
            assert (enclosing.getParameters().size() == 1);
            Element param = enclosing.getParameters().get(0);
            Element thisElt = this.getThis(this.trees.getScope(this.getCurrentPath()));
            assert (thisElt != null);
            return thisElt.equals(lhs) && param.equals(rhs) || param.equals(lhs) && thisElt.equals(rhs);
        }
        return false;
    }

    private static ExpressionTree unparenthesize(ExpressionTree t) {
        while (t.getKind() == Tree.Kind.PARENTHESIZED) {
            t = ((ParenthesizedTree)t).getExpression();
        }
        return t;
    }

    private static boolean sameTree(ExpressionTree a, ExpressionTree b) {
        return InterningVisitor.unparenthesize(a).toString().equals(InterningVisitor.unparenthesize(b).toString());
    }

    private boolean suppressEarlyEquals(final BinaryTree node) {
        if (node.getKind() != Tree.Kind.EQUAL_TO) {
            return false;
        }
        final ExpressionTree left = InterningVisitor.unparenthesize(node.getLeftOperand());
        final ExpressionTree right = InterningVisitor.unparenthesize(node.getRightOperand());
        Heuristics.Matcher matcher = new Heuristics.Matcher(){

            private boolean isNeqNull(ExpressionTree e, ExpressionTree e1, ExpressionTree e2) {
                if ((e = InterningVisitor.unparenthesize(e)).getKind() != Tree.Kind.NOT_EQUAL_TO) {
                    return false;
                }
                ExpressionTree neqLeft = ((BinaryTree)e).getLeftOperand();
                ExpressionTree neqRight = ((BinaryTree)e).getRightOperand();
                return (InterningVisitor.sameTree(neqLeft, e1) || InterningVisitor.sameTree(neqLeft, e2)) && neqRight.getKind() == Tree.Kind.NULL_LITERAL || (InterningVisitor.sameTree(neqRight, e1) || InterningVisitor.sameTree(neqRight, e2)) && neqLeft.getKind() == Tree.Kind.NULL_LITERAL;
            }

            public Boolean visitBinary(BinaryTree tree, Void p) {
                ExpressionTree leftTree = tree.getLeftOperand();
                ExpressionTree rightTree = tree.getRightOperand();
                if (tree.getKind() == Tree.Kind.CONDITIONAL_OR) {
                    if (InterningVisitor.sameTree(leftTree, node)) {
                        return (Boolean)this.visit(rightTree, p);
                    }
                    return false;
                }
                if (tree.getKind() == Tree.Kind.CONDITIONAL_AND) {
                    if (this.isNeqNull(leftTree, left, right)) {
                        return (Boolean)this.visit(rightTree, p);
                    }
                    return false;
                }
                return false;
            }

            public Boolean visitConditionalExpression(ConditionalExpressionTree tree, Void p) {
                ExpressionTree cond = tree.getCondition();
                ExpressionTree trueExp = tree.getTrueExpression();
                ExpressionTree falseExp = tree.getFalseExpression();
                if (this.isNeqNull(cond, left, right) && falseExp.getKind() == Tree.Kind.BOOLEAN_LITERAL && ((LiteralTree)falseExp).getValue().equals(false)) {
                    return (Boolean)this.visit(trueExp, p);
                }
                return false;
            }

            public Boolean visitMethodInvocation(MethodInvocationTree tree, Void p) {
                if (!InterningVisitor.this.isInvocationOfEquals(tree)) {
                    return false;
                }
                List<? extends ExpressionTree> args = tree.getArguments();
                if (args.size() != 1) {
                    return false;
                }
                ExpressionTree arg = args.get(0);
                ExpressionTree exp = tree.getMethodSelect();
                if (exp.getKind() != Tree.Kind.MEMBER_SELECT) {
                    return false;
                }
                MemberSelectTree member = (MemberSelectTree)exp;
                ExpressionTree receiver = member.getExpression();
                if (InterningVisitor.sameTree(receiver, left) && InterningVisitor.sameTree(arg, right)) {
                    return true;
                }
                if (InterningVisitor.sameTree(receiver, right) && InterningVisitor.sameTree(arg, left)) {
                    return true;
                }
                return false;
            }
        };
        boolean okay = Heuristics.Matchers.withIn(Heuristics.Matchers.ofKind(Tree.Kind.CONDITIONAL_OR, matcher)).match(this.getCurrentPath());
        return okay;
    }

    private boolean suppressEarlyCompareTo(final BinaryTree node) {
        if (node.getKind() != Tree.Kind.EQUAL_TO) {
            return false;
        }
        ExpressionTree left = node.getLeftOperand();
        ExpressionTree right = node.getRightOperand();
        if (left.getKind() != Tree.Kind.IDENTIFIER || right.getKind() != Tree.Kind.IDENTIFIER) {
            return false;
        }
        final Element lhs = TreeUtils.elementFromUse((IdentifierTree)left);
        final Element rhs = TreeUtils.elementFromUse((IdentifierTree)right);
        Heuristics.Matcher matcher = new Heuristics.Matcher(){

            public Boolean visitBinary(BinaryTree tree, Void p) {
                if (tree.getKind() == Tree.Kind.EQUAL_TO) {
                    ExpressionTree leftTree = tree.getLeftOperand();
                    ExpressionTree rightTree = tree.getRightOperand();
                    if (rightTree.getKind() != Tree.Kind.INT_LITERAL) {
                        return false;
                    }
                    LiteralTree rightLiteral = (LiteralTree)rightTree;
                    if (!rightLiteral.getValue().equals(0)) {
                        return false;
                    }
                    return (Boolean)this.visit(leftTree, p);
                }
                ExpressionTree leftTree = tree.getLeftOperand();
                ExpressionTree rightTree = tree.getRightOperand();
                if (leftTree != node) {
                    return false;
                }
                if (rightTree.getKind() != Tree.Kind.EQUAL_TO) {
                    return false;
                }
                return (Boolean)this.visit(rightTree, p);
            }

            public Boolean visitMethodInvocation(MethodInvocationTree tree, Void p) {
                if (!InterningVisitor.this.isInvocationOfCompareTo(tree)) {
                    return false;
                }
                List<? extends ExpressionTree> args = tree.getArguments();
                if (args.size() != 1) {
                    return false;
                }
                ExpressionTree arg = args.get(0);
                if (arg.getKind() != Tree.Kind.IDENTIFIER) {
                    return false;
                }
                Element argElt = TreeUtils.elementFromUse((IdentifierTree)arg);
                ExpressionTree exp = tree.getMethodSelect();
                if (exp.getKind() != Tree.Kind.MEMBER_SELECT) {
                    return false;
                }
                MemberSelectTree member = (MemberSelectTree)exp;
                if (member.getExpression().getKind() != Tree.Kind.IDENTIFIER) {
                    return false;
                }
                Element refElt = TreeUtils.elementFromUse((IdentifierTree)member.getExpression());
                if (!(refElt.equals(lhs) && argElt.equals(rhs) || refElt.equals(rhs) && argElt.equals(lhs))) {
                    return false;
                }
                return true;
            }
        };
        boolean okay = Heuristics.Matchers.withIn(Heuristics.Matchers.ofKind(Tree.Kind.CONDITIONAL_OR, matcher)).match(this.getCurrentPath());
        return okay;
    }

    private boolean suppressClassAnnotation(AnnotatedTypeMirror left, AnnotatedTypeMirror right) {
        return this.classIsAnnotated(left) || this.classIsAnnotated(right);
    }

    private boolean classIsAnnotated(AnnotatedTypeMirror type) {
        Element classElt;
        TypeMirror tm = type.getUnderlyingType();
        if (tm instanceof TypeVariable) {
            tm = ((TypeVariable)tm).getUpperBound();
        }
        if (tm instanceof WildcardType) {
            tm = ((WildcardType)tm).getExtendsBound();
        }
        if (tm == null) {
            return false;
        }
        if (tm instanceof ArrayType) {
            return false;
        }
        if (!(tm instanceof DeclaredType)) {
            System.out.printf("InterningVisitor.classIsAnnotated: tm = %s (%s)%n", tm, tm.getClass());
        }
        if ((classElt = ((DeclaredType)tm).asElement()) == null) {
            System.out.printf("InterningVisitor.classIsAnnotated: classElt = null for tm = %s (%s)%n", tm, tm.getClass());
        }
        if (classElt != null) {
            AnnotatedTypeMirror classType = this.atypeFactory.fromElement(classElt);
            assert (classType != null);
            for (AnnotationMirror anno : classType.getAnnotations()) {
                if (!anno.equals(this.INTERNED)) continue;
                return true;
            }
        }
        return false;
    }

    private Element getThis(Scope scope) {
        for (Element element : scope.getLocalElements()) {
            if (!element.getSimpleName().contentEquals("this")) continue;
            return element;
        }
        return null;
    }

    private boolean overrides(ExecutableElement e, Class<?> clazz, String method) {
        TypeElement clazzElt = this.elements.getTypeElement(clazz.getCanonicalName());
        assert (clazzElt != null);
        for (ExecutableElement elt : ElementFilter.methodsIn(clazzElt.getEnclosedElements())) {
            if (!elt.getSimpleName().contentEquals(method) || !this.elements.overrides(e, elt, clazzElt)) continue;
            return true;
        }
        return false;
    }
}

