/*
 * Decompiled with CFR 0.152.
 */
package checkers.javari;

import checkers.javari.JavariChecker;
import checkers.javari.quals.Mutable;
import checkers.javari.quals.PolyRead;
import checkers.javari.quals.QReadOnly;
import checkers.javari.quals.ReadOnly;
import checkers.types.AnnotatedTypeFactory;
import checkers.types.AnnotatedTypeMirror;
import checkers.types.visitors.AnnotatedTypeScanner;
import checkers.types.visitors.SimpleAnnotatedTypeScanner;
import checkers.util.AnnotationUtils;
import checkers.util.InternalUtils;
import checkers.util.TreeUtils;
import checkers.util.TypesUtils;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.SimpleTreeVisitor;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavariAnnotatedTypeFactory
extends AnnotatedTypeFactory {
    private final JavariTreePreAnnotator treePre = new JavariTreePreAnnotator();
    private final JavariTypePostAnnotator typePost = new JavariTypePostAnnotator();
    private final AnnotationMirror READONLY;
    private final AnnotationMirror THISMUTABLE;
    private final AnnotationMirror MUTABLE;
    private final AnnotationMirror POLYREAD;
    private final AnnotationMirror QREADONLY;

    public JavariAnnotatedTypeFactory(JavariChecker checker, CompilationUnitTree root) {
        super(checker, root);
        this.READONLY = checker.READONLY;
        this.THISMUTABLE = checker.THISMUTABLE;
        this.MUTABLE = checker.MUTABLE;
        this.POLYREAD = checker.POLYREAD;
        this.QREADONLY = checker.QREADONLY;
        this.postInit();
    }

    private AnnotationMirror getImmutabilityAnnotation(@ReadOnly AnnotatedTypeMirror type) {
        if (!type.isAnnotated()) {
            return null;
        }
        return type.getAnnotations().iterator().next();
    }

    public boolean hasImmutabilityAnnotation(@ReadOnly AnnotatedTypeMirror type) {
        return type != null && this.getImmutabilityAnnotation(type) != null;
    }

    @Override
    protected void annotateImplicit(Tree tree, @Mutable AnnotatedTypeMirror type) {
        AnnotatedTypeMirror.AnnotatedDeclaredType selfType;
        if (type.getKind().isPrimitive() && !this.hasImmutabilityAnnotation(type)) {
            type.addAnnotation(this.MUTABLE);
            return;
        }
        this.treePre.visit(tree, type);
        Element elt = InternalUtils.symbol(tree);
        this.typePost.visit(type, elt != null ? elt.getKind() : ElementKind.OTHER);
        if (type.hasAnnotation(this.THISMUTABLE) && (selfType = this.getSelfType(tree)) != null) {
            if (selfType.hasAnnotation(this.POLYREAD)) {
                new AnnotatedTypeReplacer(this.THISMUTABLE, this.POLYREAD).visit(type);
            } else if (selfType.hasAnnotation(this.MUTABLE)) {
                new AnnotatedTypeReplacer(this.THISMUTABLE, this.MUTABLE).visit(type);
            }
        }
    }

    protected void annotateImplicit(Iterable<? extends Tree> trees, Iterable<? extends AnnotatedTypeMirror> types) {
        Iterator<? extends Tree> iTree = trees.iterator();
        Iterator<? extends AnnotatedTypeMirror> iType = types.iterator();
        while (iTree.hasNext()) {
            assert (iType.hasNext());
            this.annotateImplicit(iTree.next(), iType.next());
        }
        assert (!iType.hasNext());
    }

    @Override
    protected void annotateImplicit(Element element, @Mutable AnnotatedTypeMirror type) {
        if ((element.getKind().isClass() || element.getKind().isInterface()) && !this.hasImmutabilityAnnotation(type)) {
            type.addAnnotation(this.MUTABLE);
        }
        this.typePost.visit(type, element.getKind());
    }

    @Override
    protected void postDirectSuperTypes(AnnotatedTypeMirror type, List<? extends AnnotatedTypeMirror> supertypes) {
        super.postDirectSuperTypes(type, supertypes);
        for (AnnotatedTypeMirror annotatedTypeMirror : supertypes) {
            this.typePost.visit(annotatedTypeMirror, ElementKind.OTHER);
        }
    }

    @Override
    public Collection<AnnotationMirror> unify(Collection<AnnotationMirror> c1, Collection<AnnotationMirror> c2) {
        HashMap<String, AnnotationMirror> ann = new HashMap<String, AnnotationMirror>();
        for (AnnotationMirror anno : c1) {
            ann.put(AnnotationUtils.annotationName(anno).toString(), anno);
        }
        for (AnnotationMirror anno : c2) {
            ann.put(AnnotationUtils.annotationName(anno).toString(), anno);
        }
        if (ann.containsKey(QReadOnly.class.getCanonicalName())) {
            return Collections.singleton(this.QREADONLY);
        }
        if (ann.containsKey(ReadOnly.class.getCanonicalName())) {
            return Collections.singleton(this.READONLY);
        }
        if (ann.containsKey(PolyRead.class.getCanonicalName())) {
            return Collections.singleton(this.POLYREAD);
        }
        return Collections.singleton(this.MUTABLE);
    }

    @Override
    public AnnotatedTypeMirror.AnnotatedExecutableType constructorFromUse(NewClassTree tree) {
        AnnotatedTypeMirror.AnnotatedExecutableType exType = super.constructorFromUse(tree);
        List<AnnotatedTypeMirror> argumentTypes = this.atypes.getAnnotatedTypes(tree.getArguments());
        List<AnnotatedTypeMirror> parameterTypes = this.atypes.expandVarArgs(exType, tree.getArguments());
        boolean allMutable = true;
        boolean allPolyRead = true;
        boolean allThisMutable = true;
        for (int i = 0; i < parameterTypes.size(); ++i) {
            AnnotatedTypeMirror pType = parameterTypes.get(i);
            if (!pType.hasAnnotation(this.POLYREAD)) continue;
            AnnotatedTypeMirror aType = argumentTypes.get(i);
            if (aType.hasAnnotation(this.THISMUTABLE) || aType.hasAnnotation(this.POLYREAD)) {
                allMutable = false;
            }
            if (aType.hasAnnotation(this.READONLY) || aType.hasAnnotation(this.QREADONLY)) {
                allMutable = false;
                allThisMutable = false;
            }
            if (aType.hasAnnotation(this.POLYREAD) && !aType.hasAnnotation(this.READONLY) && !aType.hasAnnotation(this.THISMUTABLE) && !aType.hasAnnotation(this.QREADONLY)) continue;
            allPolyRead = false;
        }
        AnnotationMirror replacement = allMutable ? this.MUTABLE : (allThisMutable ? this.THISMUTABLE : (allPolyRead ? this.POLYREAD : this.READONLY));
        if (replacement != this.POLYREAD) {
            new AnnotatedTypeReplacer(this.POLYREAD, replacement).visit(exType);
        }
        return exType;
    }

    @Override
    public AnnotatedTypeMirror.AnnotatedExecutableType methodFromUse(MethodInvocationTree tree) {
        AnnotationMirror replacement;
        AnnotatedTypeMirror.AnnotatedExecutableType type = super.methodFromUse(tree);
        ExecutableElement executableElt = type.getElement();
        AnnotatedTypeMirror returnType = type.getReturnType();
        List<AnnotatedTypeMirror> argumentTypes = this.atypes.getAnnotatedTypes(tree.getArguments());
        List<AnnotatedTypeMirror> parameterTypes = this.atypes.expandVarArgs(type, tree.getArguments());
        AnnotatedTypeMirror.AnnotatedDeclaredType receiverType = type.getReceiverType();
        boolean allMutable = true;
        boolean allPolyRead = true;
        boolean allThisMutable = true;
        for (int i = 0; i < parameterTypes.size(); ++i) {
            AnnotatedTypeMirror pType = parameterTypes.get(i);
            if (!pType.hasAnnotation(this.POLYREAD)) continue;
            AnnotatedTypeMirror aType = argumentTypes.get(i);
            if (aType.hasAnnotation(this.THISMUTABLE) || aType.hasAnnotation(this.POLYREAD)) {
                allMutable = false;
            }
            if (aType.hasAnnotation(this.READONLY) || aType.hasAnnotation(this.QREADONLY)) {
                allMutable = false;
                allThisMutable = false;
            }
            if (aType.hasAnnotation(this.POLYREAD) && !aType.hasAnnotation(this.READONLY) && !aType.hasAnnotation(this.THISMUTABLE) && !aType.hasAnnotation(this.QREADONLY)) continue;
            allPolyRead = false;
        }
        if (receiverType.hasAnnotation(this.POLYREAD)) {
            ExpressionTree exprTree = tree.getMethodSelect();
            AnnotatedTypeMirror exprReceiver = this.getReceiver(exprTree);
            if (exprReceiver.hasAnnotation(this.READONLY)) {
                allMutable = false;
                allThisMutable = false;
                allPolyRead = false;
            } else if (exprReceiver.hasAnnotation(this.POLYREAD)) {
                allMutable = false;
            }
        }
        if ((replacement = allMutable ? this.MUTABLE : (allThisMutable ? this.THISMUTABLE : (allPolyRead ? this.POLYREAD : this.READONLY))) != this.POLYREAD && returnType.hasAnnotation(this.POLYREAD)) {
            new AnnotatedTypeReplacer(this.POLYREAD, replacement).visit(type);
        }
        return type;
    }

    @Override
    public void postAsMemberOf(AnnotatedTypeMirror type, AnnotatedTypeMirror owner, Element element) {
        AnnotationMirror ownerAnno;
        if (!owner.hasAnnotation(this.READONLY) && (ownerAnno = this.getImmutabilityAnnotation(owner)) != this.THISMUTABLE) {
            new AnnotatedTypeReplacer(this.THISMUTABLE, ownerAnno).visit(type);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AnnotatedTypeReplacer
    extends SimpleAnnotatedTypeScanner<Void, Void> {
        private AnnotationMirror oldAnnotation;
        private AnnotationMirror newAnnotation;

        AnnotatedTypeReplacer(AnnotationMirror oldAnnotation, AnnotationMirror newAnnotation) {
            this.oldAnnotation = oldAnnotation;
            this.newAnnotation = newAnnotation;
        }

        @Override
        protected Void defaultAction(AnnotatedTypeMirror type, Void p) {
            if (type.hasAnnotation(this.oldAnnotation)) {
                type.removeAnnotation(this.oldAnnotation);
                type.addAnnotation(this.newAnnotation);
            }
            return (Void)super.defaultAction(type, p);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class JavariTypePostAnnotator
    extends AnnotatedTypeScanner<Void, ElementKind> {
        private JavariTypePostAnnotator() {
        }

        @Override
        public Void scan(AnnotatedTypeMirror type, ElementKind p) {
            if (type != null && type.getElement() != null && !JavariAnnotatedTypeFactory.this.hasImmutabilityAnnotation(type) && type.getElement().getKind().isField()) {
                type.addAnnotation(JavariAnnotatedTypeFactory.this.THISMUTABLE);
            }
            return (Void)super.scan(type, p);
        }

        @Override
        public Void visitExecutable(AnnotatedTypeMirror.AnnotatedExecutableType type, ElementKind p) {
            AnnotatedTypeMirror returnType;
            AnnotatedTypeMirror.AnnotatedDeclaredType receiver = type.getReceiverType();
            if (!JavariAnnotatedTypeFactory.this.hasImmutabilityAnnotation(receiver)) {
                AnnotatedTypeMirror.AnnotatedDeclaredType owner = (AnnotatedTypeMirror.AnnotatedDeclaredType)JavariAnnotatedTypeFactory.this.getAnnotatedType(type.getElement().getEnclosingElement());
                assert (JavariAnnotatedTypeFactory.this.hasImmutabilityAnnotation(owner));
                receiver.addAnnotation(JavariAnnotatedTypeFactory.this.getImmutabilityAnnotation(owner));
            }
            if (!JavariAnnotatedTypeFactory.this.hasImmutabilityAnnotation(returnType = type.getReturnType()) && !returnType.getKind().isPrimitive() && returnType.getKind() != TypeKind.VOID && returnType.getKind() != TypeKind.TYPEVAR) {
                returnType.addAnnotation(JavariAnnotatedTypeFactory.this.MUTABLE);
            }
            return (Void)super.visitExecutable(type, p);
        }

        @Override
        public Void visitDeclared(AnnotatedTypeMirror.AnnotatedDeclaredType type, ElementKind p) {
            if (!JavariAnnotatedTypeFactory.this.hasImmutabilityAnnotation(type)) {
                TypeElement tElt = (TypeElement)type.getUnderlyingType().asElement();
                AnnotatedTypeMirror.AnnotatedDeclaredType tType = JavariAnnotatedTypeFactory.this.fromElement(tElt);
                if (JavariAnnotatedTypeFactory.this.hasImmutabilityAnnotation(tType)) {
                    type.addAnnotation(JavariAnnotatedTypeFactory.this.getImmutabilityAnnotation(tType));
                } else {
                    type.addAnnotation(JavariAnnotatedTypeFactory.this.MUTABLE);
                }
            }
            return (Void)super.visitDeclared(type, p);
        }

        @Override
        public Void visitArray(AnnotatedTypeMirror.AnnotatedArrayType type, ElementKind p) {
            if (!JavariAnnotatedTypeFactory.this.hasImmutabilityAnnotation(type)) {
                type.addAnnotation(JavariAnnotatedTypeFactory.this.MUTABLE);
            }
            return (Void)super.visitArray(type, p);
        }

        @Override
        public Void visitTypeVariable(AnnotatedTypeMirror.AnnotatedTypeVariable type, ElementKind p) {
            if (type.getUpperBound() != null && !JavariAnnotatedTypeFactory.this.hasImmutabilityAnnotation(type.getUpperBound())) {
                if (p.isClass() || p.isInterface() || p == ElementKind.CONSTRUCTOR || p == ElementKind.METHOD) {
                    type.getUpperBound().addAnnotation(JavariAnnotatedTypeFactory.this.READONLY);
                } else if (TypesUtils.isObject(type.getUnderlyingType())) {
                    type.getUpperBound().addAnnotation(JavariAnnotatedTypeFactory.this.MUTABLE);
                }
            }
            return (Void)super.visitTypeVariable(type, p);
        }

        @Override
        public Void visitWildcard(AnnotatedTypeMirror.AnnotatedWildcardType type, ElementKind p) {
            if (type.getExtendsBound() != null && !JavariAnnotatedTypeFactory.this.hasImmutabilityAnnotation(type.getExtendsBound())) {
                if (p.isClass() || p.isInterface() || p == ElementKind.CONSTRUCTOR || p == ElementKind.METHOD) {
                    type.getExtendsBound().addAnnotation(JavariAnnotatedTypeFactory.this.READONLY);
                } else if (TypesUtils.isObject(type.getUnderlyingType())) {
                    type.getExtendsBound().addAnnotation(JavariAnnotatedTypeFactory.this.MUTABLE);
                }
            }
            return (Void)super.visitWildcard(type, p);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class JavariTreePreAnnotator
    extends SimpleTreeVisitor<Void, AnnotatedTypeMirror> {
        private JavariTreePreAnnotator() {
        }

        @Override
        public Void visitMemberSelect(MemberSelectTree node, AnnotatedTypeMirror p) {
            AnnotatedTypeMirror exType = JavariAnnotatedTypeFactory.this.getAnnotatedType(node.getExpression());
            AnnotatedTypeMirror idType = JavariAnnotatedTypeFactory.this.fromElement(TreeUtils.elementFromUse(node));
            p.removeAnnotations(p.getAnnotations());
            if (idType.hasAnnotation(JavariAnnotatedTypeFactory.this.READONLY)) {
                p.addAnnotation(JavariAnnotatedTypeFactory.this.READONLY);
            } else if (idType.hasAnnotation(JavariAnnotatedTypeFactory.this.MUTABLE)) {
                p.addAnnotation(JavariAnnotatedTypeFactory.this.MUTABLE);
            } else if (JavariAnnotatedTypeFactory.this.hasImmutabilityAnnotation(exType)) {
                p.addAnnotation(JavariAnnotatedTypeFactory.this.getImmutabilityAnnotation(exType));
            } else {
                p.addAnnotation(JavariAnnotatedTypeFactory.this.THISMUTABLE);
            }
            return (Void)super.visitMemberSelect(node, p);
        }

        @Override
        public Void visitLiteral(LiteralTree node, AnnotatedTypeMirror p) {
            if (node.getKind() == Tree.Kind.NULL_LITERAL) {
                p.addAnnotation(JavariAnnotatedTypeFactory.this.MUTABLE);
            }
            return (Void)super.visitLiteral(node, p);
        }

        @Override
        public Void visitNewClass(NewClassTree node, AnnotatedTypeMirror p) {
            assert (p.getKind() == TypeKind.DECLARED);
            if (!JavariAnnotatedTypeFactory.this.hasImmutabilityAnnotation(p)) {
                p.addAnnotation(JavariAnnotatedTypeFactory.this.MUTABLE);
            }
            return (Void)super.visitNewClass(node, p);
        }

        @Override
        public Void visitClass(ClassTree node, AnnotatedTypeMirror p) {
            if (!JavariAnnotatedTypeFactory.this.hasImmutabilityAnnotation(p)) {
                p.addAnnotation(JavariAnnotatedTypeFactory.this.MUTABLE);
            }
            return (Void)super.visitClass(node, p);
        }
    }
}

