/*
 * Decompiled with CFR 0.152.
 */
package checkers.linear;

import checkers.basetype.BaseTypeChecker;
import checkers.flow.Flow;
import checkers.linear.LinearChecker;
import checkers.linear.LinearVisitor;
import checkers.linear.quals.Linear;
import checkers.linear.quals.Unusable;
import checkers.types.AnnotatedTypeFactory;
import checkers.types.AnnotatedTypeMirror;
import checkers.types.BasicAnnotatedTypeFactory;
import checkers.util.AnnotationUtils;
import checkers.util.TreeUtils;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinearAnnotatedTypeFactory
extends BasicAnnotatedTypeFactory<LinearChecker> {
    public LinearAnnotatedTypeFactory(LinearChecker checker, CompilationUnitTree root) {
        super(checker, root);
    }

    @Override
    public void annotateImplicit(Element elt, AnnotatedTypeMirror type) {
        if (!type.isAnnotated() && elt.getKind().isClass()) {
            type.addAnnotation(Unusable.class);
        }
        super.annotateImplicit(elt, type);
    }

    @Override
    public Flow createFlow(LinearChecker checker, CompilationUnitTree tree, Set<AnnotationMirror> flowQuals) {
        return new LinearFlow(checker, tree, flowQuals, this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LinearFlow
    extends Flow {
        private final AnnotationMirror LINEAR;
        private final AnnotationMirror UNUSABLE;

        public LinearFlow(BaseTypeChecker checker, CompilationUnitTree root, Set<AnnotationMirror> annotations, AnnotatedTypeFactory factory) {
            super(checker, root, annotations, factory);
            AnnotationUtils annoFactory = AnnotationUtils.getInstance(checker.getProcessingEnvironment());
            this.LINEAR = annoFactory.fromClass(Linear.class);
            this.UNUSABLE = annoFactory.fromClass(Unusable.class);
        }

        @Override
        public Void visitIdentifier(IdentifierTree node, Void p) {
            super.visitIdentifier(node, p);
            this.markAsUnusableIfLinear(node);
            return null;
        }

        private void markAsUnusableIfLinear(ExpressionTree node) {
            int idx;
            if (!LinearVisitor.isLocalVarOrParam(node)) {
                return;
            }
            Element elem = TreeUtils.elementFromUse(node);
            assert (elem != null);
            if (this.vars.contains(elem) && this.annos.get(this.LINEAR, idx = this.vars.indexOf(elem))) {
                this.annos.set(this.UNUSABLE, idx);
                this.annos.clear(this.LINEAR, idx);
            }
        }
    }
}

