/*
 * Decompiled with CFR 0.152.
 */
package checkers.lock;

import checkers.basetype.BaseTypeVisitor;
import checkers.lock.LockAnnotatedTypeFactory;
import checkers.lock.LockChecker;
import checkers.lock.quals.Holding;
import checkers.source.Result;
import checkers.types.AnnotatedTypeMirror;
import checkers.util.TreeUtils;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.SynchronizedTree;
import com.sun.source.tree.Tree;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import net.jcip.annotations.GuardedBy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LockVisitor
extends BaseTypeVisitor<Void, Void> {
    LockAnnotatedTypeFactory atypeFactory;

    public LockVisitor(LockChecker checker, CompilationUnitTree root) {
        super(checker, root);
        this.atypeFactory = (LockAnnotatedTypeFactory)((BaseTypeVisitor)this).atypeFactory;
    }

    @Override
    public Void visitIdentifier(IdentifierTree node, Void p) {
        AnnotatedTypeMirror type = this.atypeFactory.getAnnotatedType(node);
        if (type.isAnnotated()) {
            this.checker.report(Result.failure("unguarded.access", node, type), node);
        }
        return (Void)super.visitIdentifier(node, p);
    }

    @Override
    public Void visitMemberSelect(MemberSelectTree node, Void p) {
        AnnotatedTypeMirror type = this.atypeFactory.getAnnotatedType(node);
        if (type.isAnnotated()) {
            this.checker.report(Result.failure("unguarded.access", node, type), node);
        }
        return (Void)super.visitMemberSelect(node, p);
    }

    private <T> List<T> append(List<T> lst, T o) {
        if (o == null) {
            return lst;
        }
        ArrayList<T> newList = new ArrayList<T>(lst.size() + 1);
        newList.addAll(lst);
        newList.add(o);
        return newList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visitSynchronized(SynchronizedTree node, Void p) {
        List<String> prevLocks = this.atypeFactory.getHeldLock();
        try {
            List<String> locks = this.append(prevLocks, TreeUtils.skipParens(node.getExpression()).toString());
            this.atypeFactory.setHeldLocks(locks);
            Void void_ = (Void)super.visitSynchronized(node, p);
            return void_;
        }
        finally {
            this.atypeFactory.setHeldLocks(prevLocks);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visitMethod(MethodTree node, Void p) {
        List<String> prevLocks;
        List<String> locks = prevLocks = this.atypeFactory.getHeldLock();
        try {
            List<String> methodLocks;
            ExecutableElement method = TreeUtils.elementFromDeclaration(node);
            if (method.getModifiers().contains((Object)Modifier.SYNCHRONIZED) || method.getKind() == ElementKind.CONSTRUCTOR) {
                if (method.getModifiers().contains((Object)Modifier.STATIC)) {
                    String enclosingClass = method.getEnclosingElement().getSimpleName().toString();
                    locks = this.append(locks, enclosingClass + ".class");
                } else {
                    locks = this.append(locks, "this");
                }
            }
            if (!(methodLocks = this.methodHolding(method)).isEmpty()) {
                locks = new ArrayList<String>(locks);
                locks.addAll(methodLocks);
            }
            this.atypeFactory.setHeldLocks(locks);
            Void void_ = (Void)super.visitMethod(node, p);
            return void_;
        }
        finally {
            this.atypeFactory.setHeldLocks(prevLocks);
        }
    }

    private static String receiver(ExpressionTree methodSel) {
        if (methodSel.getKind() == Tree.Kind.IDENTIFIER) {
            return "this";
        }
        if (methodSel.getKind() == Tree.Kind.MEMBER_SELECT) {
            return ((MemberSelectTree)methodSel).getExpression().toString();
        }
        throw new IllegalArgumentException("Unknown tree type: " + methodSel);
    }

    @Override
    public Void visitMethodInvocation(MethodInvocationTree node, Void p) {
        List<String> locks;
        ExecutableElement methodElt = TreeUtils.elementFromUse(node);
        String lock = LockVisitor.receiver(node.getMethodSelect());
        if (methodElt.getSimpleName().contentEquals("lock")) {
            locks = this.append(this.atypeFactory.getHeldLock(), lock);
            this.atypeFactory.setHeldLocks(locks);
        } else if (methodElt.getSimpleName().contentEquals("unlock")) {
            locks = new ArrayList<String>(this.atypeFactory.getHeldLock());
            locks.remove(lock);
            this.atypeFactory.setHeldLocks(locks);
        }
        List<String> methodLocks = this.methodHolding(methodElt);
        if (!methodLocks.isEmpty() && !this.atypeFactory.getHeldLock().containsAll(methodLocks)) {
            this.checker.report(Result.failure("unguarded.invocation", methodElt, methodLocks), node);
        }
        return (Void)super.visitMethodInvocation(node, p);
    }

    @Override
    protected boolean checkOverride(MethodTree overriderTree, AnnotatedTypeMirror.AnnotatedDeclaredType enclosingType, AnnotatedTypeMirror.AnnotatedExecutableType overridden, AnnotatedTypeMirror.AnnotatedDeclaredType overriddenType, Void p) {
        List<String> overriderLocks = this.methodHolding(TreeUtils.elementFromDeclaration(overriderTree));
        List<String> overriddenLocks = this.methodHolding(overridden.getElement());
        boolean isValid = overriddenLocks.containsAll(overriderLocks);
        if (!isValid) {
            this.checker.report(Result.failure("override.holding.invalid", TreeUtils.elementFromDeclaration(overriderTree), enclosingType.getElement(), overridden.getElement(), overriddenType.getElement(), overriderLocks, overriddenLocks), overriderTree);
        }
        return super.checkOverride(overriderTree, enclosingType, overridden, overriddenType, p) && isValid;
    }

    @Override
    protected boolean checkMethodInvocability(AnnotatedTypeMirror.AnnotatedExecutableType method, MethodInvocationTree node) {
        return true;
    }

    protected List<String> methodHolding(ExecutableElement element) {
        Holding holding = element.getAnnotation(Holding.class);
        GuardedBy guardedBy = element.getAnnotation(GuardedBy.class);
        if (holding == null && guardedBy == null) {
            return Collections.emptyList();
        }
        ArrayList<String> locks = new ArrayList<String>();
        if (holding != null) {
            locks.addAll(Arrays.asList(holding.value()));
        }
        if (guardedBy != null) {
            locks.add(guardedBy.value());
        }
        return locks;
    }
}

