/*
 * Decompiled with CFR 0.152.
 */
package checkers.nullness;

import checkers.nullness.KeyForSubchecker;
import checkers.nullness.quals.KeyFor;
import checkers.types.AnnotatedTypeMirror;
import checkers.types.BasicAnnotatedTypeFactory;
import checkers.util.AnnotationUtils;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.type.TypeKind;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyForAnnotatedTypeFactory
extends BasicAnnotatedTypeFactory<KeyForSubchecker> {
    private static final Pattern parameterPtn = Pattern.compile("#(\\d+)");

    public KeyForAnnotatedTypeFactory(KeyForSubchecker checker, CompilationUnitTree root) {
        super(checker, root, false);
    }

    @Override
    public AnnotatedTypeMirror.AnnotatedExecutableType methodFromUse(MethodInvocationTree call) {
        assert (call != null);
        AnnotatedTypeMirror method = super.methodFromUse(call);
        HashMap<AnnotatedTypeMirror, AnnotatedTypeMirror> mappings = new HashMap<AnnotatedTypeMirror, AnnotatedTypeMirror>();
        List<AnnotatedTypeMirror> params = method.getParameterTypes();
        for (AnnotatedTypeMirror param : params) {
            AnnotatedTypeMirror subst = this.substituteCall(call, param);
            mappings.put(param, subst);
        }
        AnnotatedTypeMirror returnType = method.getReturnType();
        if (returnType.getKind() != TypeKind.VOID) {
            AnnotatedTypeMirror subst = this.substituteCall(call, returnType);
            mappings.put(returnType, subst);
        }
        method = method.substitute(mappings);
        return method;
    }

    private String receiver(MethodInvocationTree node) {
        ExpressionTree sel = node.getMethodSelect();
        if (sel.getKind() == Tree.Kind.IDENTIFIER) {
            return "";
        }
        if (sel.getKind() == Tree.Kind.MEMBER_SELECT) {
            return ((MemberSelectTree)sel).getExpression().toString();
        }
        throw new AssertionError((Object)"Cannot be here");
    }

    private AnnotatedTypeMirror substituteCall(MethodInvocationTree call, AnnotatedTypeMirror inType) {
        AnnotatedTypeMirror outType = inType.getCopy(true);
        if (inType.getAnnotation(KeyFor.class) != null) {
            AnnotationMirror anno = inType.getAnnotation(KeyFor.class);
            List<String> inMaps = AnnotationUtils.parseStringArrayValue(anno, "value");
            ArrayList<String> outMaps = new ArrayList<String>();
            String receiver = this.receiver(call);
            for (String inMapName : inMaps) {
                if (parameterPtn.matcher(inMapName).matches()) {
                    int param = Integer.valueOf(inMapName.substring(1));
                    if (param >= call.getArguments().size()) continue;
                    String res = call.getArguments().get(param).toString();
                    outMaps.add(res);
                    continue;
                }
                if (inMapName.equals("this")) {
                    outMaps.add(receiver);
                    continue;
                }
                outMaps.add(inMapName);
            }
            AnnotationUtils.AnnotationBuilder builder = new AnnotationUtils.AnnotationBuilder(this.env, KeyFor.class);
            builder.setValue((CharSequence)"value", outMaps);
            AnnotationMirror newAnno = builder.build();
            outType.removeAnnotation(KeyFor.class);
            outType.addAnnotation(newAnno);
        }
        if (outType.getKind() == TypeKind.DECLARED) {
            AnnotatedTypeMirror.AnnotatedDeclaredType declaredType = (AnnotatedTypeMirror.AnnotatedDeclaredType)outType;
            HashMap<AnnotatedTypeMirror, AnnotatedTypeMirror> mapping = new HashMap<AnnotatedTypeMirror, AnnotatedTypeMirror>();
            for (AnnotatedTypeMirror typeArgument : declaredType.getTypeArguments()) {
                AnnotatedTypeMirror substTypeArgument = this.substituteCall(call, typeArgument);
                mapping.put(typeArgument, substTypeArgument);
            }
            outType = declaredType.substitute(mapping);
        } else if (outType.getKind() == TypeKind.ARRAY) {
            AnnotatedTypeMirror.AnnotatedArrayType arrayType = (AnnotatedTypeMirror.AnnotatedArrayType)outType;
            AnnotatedTypeMirror elemType = arrayType.getComponentType();
            AnnotatedTypeMirror substElemType = this.substituteCall(call, elemType);
            arrayType.setComponentType(substElemType);
        } else if (outType.getKind().isPrimitive() || outType.getKind() == TypeKind.WILDCARD || outType.getKind() == TypeKind.TYPEVAR) {
            // empty if block
        }
        return outType;
    }
}

