/*
 * Decompiled with CFR 0.152.
 */
package checkers.nullness;

import checkers.basetype.BaseTypeChecker;
import checkers.flow.Flow;
import checkers.nullness.CollectionToArrayHeuristics;
import checkers.nullness.MapGetHeuristics;
import checkers.nullness.NullnessFlow;
import checkers.nullness.NullnessSubchecker;
import checkers.nullness.RawnessSubchecker;
import checkers.nullness.quals.LazyNonNull;
import checkers.nullness.quals.NonNull;
import checkers.nullness.quals.Nullable;
import checkers.nullness.quals.PolyNull;
import checkers.nullness.quals.Raw;
import checkers.quals.DefaultLocation;
import checkers.quals.Unused;
import checkers.types.AnnotatedTypeFactory;
import checkers.types.AnnotatedTypeMirror;
import checkers.types.TreeAnnotator;
import checkers.types.TypeAnnotator;
import checkers.types.visitors.AnnotatedTypeScanner;
import checkers.util.DependentTypes;
import checkers.util.ElementUtils;
import checkers.util.InternalUtils;
import checkers.util.QualifierDefaults;
import checkers.util.QualifierPolymorphism;
import checkers.util.TreeUtils;
import checkers.util.TypesUtils;
import com.sun.source.tree.CatchTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import edu.umd.cs.findbugs.annotations.UnknownNullness;
import java.util.Collections;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.type.TypeKind;
import javax.validation.constraints.NotNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.annotations.common.NullUnknown;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NullnessAnnotatedTypeFactory
extends AnnotatedTypeFactory {
    private final Flow flow;
    private final QualifierDefaults defaults;
    private final TypeAnnotator typeAnnotator;
    private final TreeAnnotator treeAnnotator;
    private final QualifierPolymorphism poly;
    private final DependentTypes dependentTypes;
    final AnnotatedTypeFactory rawnessFactory;
    private final AnnotatedTypeFactory plainFactory;
    private final AnnotationCompleter completer = new AnnotationCompleter();
    protected final AnnotationMirror POLYNULL;
    protected final AnnotationMirror NONNULL;
    protected final AnnotationMirror RAW;
    protected final AnnotationMirror NULLABLE;
    protected final AnnotationMirror LAZYNONNULL;
    protected final AnnotationMirror UNUSED;
    private final MapGetHeuristics mapGetHeuristics;
    private final CollectionToArrayHeuristics collectionToArrayHeuristics;

    public NullnessAnnotatedTypeFactory(NullnessSubchecker checker, CompilationUnitTree root) {
        super(checker, root);
        this.plainFactory = new AnnotatedTypeFactory(checker.getProcessingEnvironment(), null, root, null);
        this.typeAnnotator = new NonNullTypeAnnotator(checker);
        this.treeAnnotator = new NonNullTreeAnnotator(checker);
        this.mapGetHeuristics = new MapGetHeuristics(this.env, this, new AnnotatedTypeFactory(checker.getProcessingEnvironment(), null, root, null));
        this.POLYNULL = this.annotations.fromClass(PolyNull.class);
        this.NONNULL = this.annotations.fromClass(NonNull.class);
        this.RAW = this.annotations.fromClass(Raw.class);
        this.NULLABLE = this.annotations.fromClass(Nullable.class);
        this.LAZYNONNULL = this.annotations.fromClass(LazyNonNull.class);
        this.UNUSED = this.annotations.fromClass(Unused.class);
        this.addAliasedAnnotation(com.sun.istack.NotNull.class, this.NONNULL);
        this.addAliasedAnnotation(edu.umd.cs.findbugs.annotations.NonNull.class, this.NONNULL);
        this.addAliasedAnnotation(Nonnull.class, this.NONNULL);
        this.addAliasedAnnotation(NotNull.class, this.NONNULL);
        this.addAliasedAnnotation(org.jetbrains.annotations.NotNull.class, this.NONNULL);
        this.addAliasedAnnotation(org.netbeans.api.annotations.common.NonNull.class, this.NONNULL);
        this.addAliasedAnnotation(com.sun.istack.Nullable.class, this.NULLABLE);
        this.addAliasedAnnotation(edu.umd.cs.findbugs.annotations.CheckForNull.class, this.NULLABLE);
        this.addAliasedAnnotation(edu.umd.cs.findbugs.annotations.Nullable.class, this.NULLABLE);
        this.addAliasedAnnotation(UnknownNullness.class, this.NULLABLE);
        this.addAliasedAnnotation(CheckForNull.class, this.NULLABLE);
        this.addAliasedAnnotation(javax.annotation.Nullable.class, this.NULLABLE);
        this.addAliasedAnnotation(org.jetbrains.annotations.Nullable.class, this.NULLABLE);
        this.addAliasedAnnotation(org.netbeans.api.annotations.common.CheckForNull.class, this.NULLABLE);
        this.addAliasedAnnotation(NullAllowed.class, this.NULLABLE);
        this.addAliasedAnnotation(NullUnknown.class, this.NULLABLE);
        this.collectionToArrayHeuristics = new CollectionToArrayHeuristics(this.env, this);
        this.defaults = new QualifierDefaults(this, this.annotations);
        this.defaults.setAbsoluteDefaults(this.NONNULL, Collections.singleton(DefaultLocation.ALL_EXCEPT_LOCALS));
        this.poly = new QualifierPolymorphism(checker, this);
        this.dependentTypes = new DependentTypes(checker.getProcessingEnvironment(), root);
        RawnessSubchecker rawness = new RawnessSubchecker();
        rawness.currentPath = checker.currentPath;
        rawness.init(checker.getProcessingEnvironment());
        this.rawnessFactory = rawness.createFactory(root);
        this.flow = new NullnessFlow(checker, root, this);
        this.postInit();
    }

    @Override
    protected void postInit() {
        super.postInit();
        this.flow.scan((Tree)this.root, null);
    }

    @Override
    protected void annotateImplicit(Element elt, AnnotatedTypeMirror type) {
        if (elt instanceof VariableElement) {
            this.annotateIfStatic(elt, type);
        }
        this.typeAnnotator.visit(type);
        this.defaults.annotate(elt, type);
        if (elt instanceof TypeElement) {
            type.clearAnnotations();
        }
        this.completer.visit(type);
    }

    @Override
    protected void annotateImplicit(Tree tree, AnnotatedTypeMirror type) {
        this.treeAnnotator.visit(tree, type);
        this.typeAnnotator.visit(type);
        this.defaults.annotate(tree, type);
        this.substituteRaw(tree, type);
        this.substituteUnused(tree, type);
        this.dependentTypes.handle(tree, type);
        AnnotationMirror inferred = this.flow.test(tree);
        if (inferred != null) {
            type.clearAnnotations();
            type.addAnnotation(inferred);
        }
        this.completer.visit(type);
    }

    @Override
    protected AnnotatedTypeMirror.AnnotatedDeclaredType getImplicitReceiverType(Tree tree) {
        AnnotatedTypeMirror.AnnotatedDeclaredType type = super.getImplicitReceiverType(tree);
        return type;
    }

    @Override
    public final AnnotatedTypeMirror.AnnotatedDeclaredType getEnclosingType(TypeElement element, Tree tree) {
        AnnotatedTypeMirror.AnnotatedDeclaredType dt = super.getEnclosingType(element, tree);
        if (dt != null && dt.hasAnnotation(this.NULLABLE)) {
            dt.removeAnnotation(this.NULLABLE);
            dt.addAnnotation(this.NONNULL);
        }
        return dt;
    }

    @Override
    protected void postDirectSuperTypes(AnnotatedTypeMirror type, List<? extends AnnotatedTypeMirror> supertypes) {
        super.postDirectSuperTypes(type, supertypes);
        for (AnnotatedTypeMirror annotatedTypeMirror : supertypes) {
            this.typeAnnotator.visit(annotatedTypeMirror);
            if (annotatedTypeMirror.getKind() == TypeKind.DECLARED) {
                this.defaults.annotateTypeElement((TypeElement)((AnnotatedTypeMirror.AnnotatedDeclaredType)annotatedTypeMirror).getUnderlyingType().asElement(), annotatedTypeMirror);
            }
            this.completer.visit(annotatedTypeMirror);
        }
    }

    @Override
    public AnnotatedTypeMirror.AnnotatedExecutableType methodFromUse(MethodInvocationTree tree) {
        AnnotatedTypeMirror.AnnotatedExecutableType method = super.methodFromUse(tree);
        this.poly.annotate(tree, method);
        this.mapGetHeuristics.handle(tree, method);
        this.collectionToArrayHeuristics.handle(tree, method);
        return method;
    }

    @Override
    public AnnotatedTypeMirror.AnnotatedExecutableType constructorFromUse(NewClassTree tree) {
        AnnotatedTypeMirror.AnnotatedExecutableType constructor = super.constructorFromUse(tree);
        this.dependentTypes.handleConstructor(tree, constructor);
        return constructor;
    }

    private boolean substituteUnused(Tree tree, AnnotatedTypeMirror type) {
        if (tree.getKind() != Tree.Kind.MEMBER_SELECT && tree.getKind() != Tree.Kind.IDENTIFIER) {
            return false;
        }
        Element field = InternalUtils.symbol(tree);
        if (field == null || field.getKind() != ElementKind.FIELD) {
            return false;
        }
        Unused unused = field.getAnnotation(Unused.class);
        if (unused == null) {
            return false;
        }
        try {
            unused.when();
            assert (false) : "Cannot be here";
            return false;
        }
        catch (MirroredTypeException exp) {
            Name whenName = TypesUtils.getQualifiedName((DeclaredType)exp.getTypeMirror());
            AnnotatedTypeMirror receiver = this.plainFactory.getReceiver((ExpressionTree)tree);
            if (receiver == null || receiver.getAnnotation(whenName) == null) {
                return false;
            }
            type.clearAnnotations();
            type.addAnnotation(this.NULLABLE);
            return true;
        }
    }

    private boolean substituteRaw(Tree tree, AnnotatedTypeMirror type) {
        AnnotatedTypeMirror select;
        if (tree.getKind() != Tree.Kind.MEMBER_SELECT && tree.getKind() != Tree.Kind.IDENTIFIER) {
            return false;
        }
        if (tree instanceof IdentifierTree) {
            Element elt = TreeUtils.elementFromUse((IdentifierTree)tree);
            if (elt == null || !elt.getKind().isField()) {
                return false;
            }
            Tree decl = this.declarationFromElement(elt);
            if (decl != null && decl instanceof VariableTree && ((VariableTree)decl).getInitializer() != null && this.getAnnotatedType(((VariableTree)decl).getInitializer()).hasAnnotation(this.NONNULL)) {
                return false;
            }
        }
        if ((select = this.rawnessFactory.getReceiver((ExpressionTree)tree)) != null && select.hasAnnotation(this.RAW) && !type.hasAnnotation(this.NULLABLE) && !type.getKind().isPrimitive()) {
            boolean wasNN = type.hasAnnotation(this.NONNULL);
            type.clearAnnotations();
            type.addAnnotation(this.LAZYNONNULL);
            return wasNN;
        }
        return false;
    }

    private void annotateIfStatic(Element elt, AnnotatedTypeMirror type) {
        if (elt == null) {
            return;
        }
        if (elt.getKind().isClass() || elt.getKind().isInterface() || this.isSystemField(elt)) {
            type.clearAnnotations();
            type.addAnnotation(this.NONNULL);
        }
    }

    private boolean isSystemField(Element elt) {
        if (!elt.getKind().isField()) {
            return false;
        }
        if (!ElementUtils.isStatic(elt) || !ElementUtils.isFinal(elt)) {
            return false;
        }
        VariableElement var = (VariableElement)elt;
        boolean inJavaPackage = ElementUtils.getQualifiedClassName(var).toString().startsWith("java.");
        return var.getConstantValue() != null || var.getSimpleName().contentEquals("class") || inJavaPackage;
    }

    private class NonNullTreeAnnotator
    extends TreeAnnotator {
        NonNullTreeAnnotator(BaseTypeChecker checker) {
            super(checker, NullnessAnnotatedTypeFactory.this);
        }

        public Void visitMemberSelect(MemberSelectTree node, AnnotatedTypeMirror type) {
            Element elt = TreeUtils.elementFromUse(node);
            assert (elt != null);
            NullnessAnnotatedTypeFactory.this.annotateIfStatic(elt, type);
            return (Void)super.visitMemberSelect(node, type);
        }

        public Void visitIdentifier(IdentifierTree node, AnnotatedTypeMirror type) {
            Element elt = TreeUtils.elementFromUse(node);
            assert (elt != null);
            NullnessAnnotatedTypeFactory.this.annotateIfStatic(elt, type);
            if (this.isExceptionParameter(node)) {
                type.addAnnotation(NullnessAnnotatedTypeFactory.this.NONNULL);
            }
            return (Void)super.visitIdentifier(node, type);
        }

        public Void visitTypeCast(TypeCastTree node, AnnotatedTypeMirror type) {
            if (!type.isAnnotated()) {
                AnnotatedTypeMirror exprType = NullnessAnnotatedTypeFactory.this.getAnnotatedType(node.getExpression());
                type.addAnnotations(exprType.getAnnotations());
            }
            return (Void)super.visitTypeCast(node, type);
        }

        public Void visitMethod(MethodTree node, AnnotatedTypeMirror type) {
            AnnotatedTypeMirror.AnnotatedExecutableType execType = (AnnotatedTypeMirror.AnnotatedExecutableType)type;
            if (!execType.getReceiverType().isAnnotated() && TreeUtils.containsThisConstructorInvocation(node)) {
                execType.getReceiverType().addAnnotation(NullnessAnnotatedTypeFactory.this.NONNULL);
            }
            return (Void)super.visitMethod(node, type);
        }

        private boolean isExceptionParameter(IdentifierTree node) {
            Element elt = TreeUtils.elementFromUse(node);
            assert (elt != null);
            if (elt.getKind() != ElementKind.PARAMETER || !TypesUtils.isThrowable(elt.asType())) {
                return false;
            }
            TreePath path = NullnessAnnotatedTypeFactory.this.getPath(node);
            CatchTree ct = (CatchTree)TreeUtils.enclosingOfKind(path, Tree.Kind.CATCH);
            if (ct == null) {
                return false;
            }
            VariableTree catchParamTree = ct.getParameter();
            VariableElement catchParamElt = TreeUtils.elementFromDeclaration(catchParamTree);
            return elt.equals(catchParamElt);
        }
    }

    private class NonNullTypeAnnotator
    extends TypeAnnotator {
        NonNullTypeAnnotator(BaseTypeChecker checker) {
            super(checker);
        }

        public Void visitExecutable(AnnotatedTypeMirror.AnnotatedExecutableType type, ElementKind p) {
            if (type.getReceiverType().isAnnotated()) {
                return super.visitExecutable(type, p);
            }
            ExecutableElement elt = type.getElement();
            assert (elt != null);
            if (elt.getKind() == ElementKind.CONSTRUCTOR) {
                type.getReceiverType().addAnnotation(NullnessAnnotatedTypeFactory.this.RAW);
            } else if (!ElementUtils.isStatic(elt)) {
                type.getReceiverType().addAnnotation(NullnessAnnotatedTypeFactory.this.NONNULL);
            }
            return super.visitExecutable(type, p);
        }

        public Void visitDeclared(AnnotatedTypeMirror.AnnotatedDeclaredType type, ElementKind p) {
            if (TypesUtils.isDeclaredOfName(type.getUnderlyingType(), "java.lang.Void") && (type.getElement() == null || !type.getElement().getKind().isClass())) {
                type.addAnnotation(NullnessAnnotatedTypeFactory.this.NULLABLE);
            }
            return (Void)super.visitDeclared(type, p);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AnnotationCompleter
    extends AnnotatedTypeScanner<Void, Void> {
        private AnnotationCompleter() {
        }

        @Override
        protected Void scan(AnnotatedTypeMirror type, Void p) {
            if (type == null) {
                return (Void)super.scan(type, p);
            }
            if (type.getKind() == TypeKind.TYPEVAR && !type.isAnnotated()) {
                return (Void)super.scan(type, p);
            }
            if (!type.isAnnotated()) {
                type.addAnnotation(NullnessAnnotatedTypeFactory.this.NULLABLE);
            } else if (type.hasAnnotation(NullnessAnnotatedTypeFactory.this.RAW)) {
                type.removeAnnotation(NullnessAnnotatedTypeFactory.this.NONNULL);
            } else if (type.hasAnnotation(NullnessAnnotatedTypeFactory.this.NONNULL)) {
                type.removeAnnotation(NullnessAnnotatedTypeFactory.this.NULLABLE);
            }
            assert (type.isAnnotated()) : type;
            return (Void)super.scan(type, p);
        }
    }
}

