/*
 * Decompiled with CFR 0.152.
 */
package checkers.nullness;

import checkers.flow.Flow;
import checkers.flow.GenKillBits;
import checkers.nullness.NullnessAnnotatedTypeFactory;
import checkers.nullness.NullnessSubchecker;
import checkers.nullness.quals.AssertNonNullAfter;
import checkers.nullness.quals.AssertNonNullIfFalse;
import checkers.nullness.quals.AssertNonNullIfTrue;
import checkers.nullness.quals.AssertParametersNonNull;
import checkers.nullness.quals.LazyNonNull;
import checkers.nullness.quals.NonNullOnEntry;
import checkers.nullness.quals.PolyNull;
import checkers.nullness.quals.Pure;
import checkers.source.Result;
import checkers.types.AnnotatedTypeFactory;
import checkers.types.AnnotatedTypeMirror;
import checkers.util.ElementUtils;
import checkers.util.TreeUtils;
import com.sun.source.tree.ArrayAccessTree;
import com.sun.source.tree.AssertTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ConditionalExpressionTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.InstanceOfTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.SimpleTreeVisitor;
import com.sun.source.util.TreeScanner;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class NullnessFlow
extends Flow {
    private final AnnotationMirror POLYNULL;
    private final AnnotationMirror RAW;
    private final AnnotationMirror NONNULL;
    private boolean isNullPolyNull;
    private List<String> nnExprs;
    private List<String> nnExprsWhenTrue;
    private List<String> nnExprsWhenFalse;
    private final AnnotatedTypeFactory rawFactory;
    private Stack<List<String>> levelnnExprs = new Stack();
    private static final Pattern parameterPtn = Pattern.compile("#(\\d+)");

    public NullnessFlow(NullnessSubchecker checker, CompilationUnitTree root, NullnessAnnotatedTypeFactory factory) {
        super(checker, root, Collections.singleton(factory.NONNULL), factory);
        this.POLYNULL = factory.POLYNULL;
        this.RAW = factory.RAW;
        this.NONNULL = factory.NONNULL;
        this.isNullPolyNull = false;
        this.rawFactory = factory.rawnessFactory;
        this.nnExprs = new ArrayList<String>();
        this.nnExprsWhenFalse = null;
        this.nnExprsWhenTrue = null;
    }

    private static boolean isFlippableLogic(Tree tree) {
        tree = TreeUtils.skipParens(tree);
        switch (tree.getKind()) {
            case EQUAL_TO: 
            case NOT_EQUAL_TO: 
            case INSTANCE_OF: 
            case CONDITIONAL_OR: {
                return true;
            }
            case LOGICAL_COMPLEMENT: {
                return NullnessFlow.isFlippableLogic(((UnaryTree)tree).getExpression());
            }
        }
        return false;
    }

    @Override
    protected Flow.SplitTuple split() {
        Flow.SplitTuple res = super.split();
        this.nnExprsWhenFalse = new ArrayList<String>(this.nnExprs);
        this.nnExprsWhenTrue = this.nnExprs;
        return res;
    }

    @Override
    protected void pushNewLevel() {
        this.levelnnExprs.push(this.nnExprs);
        this.nnExprs = new ArrayList<String>(this.nnExprs);
    }

    @Override
    protected void popLastLevel() {
        this.nnExprs = this.levelnnExprs.pop();
    }

    @Override
    protected Flow.SplitTuple scanCond(Tree tree) {
        int idx;
        Flow.SplitTuple res = super.scanCond(tree);
        if (tree == null) {
            return res;
        }
        GenKillBits<AnnotationMirror> before = GenKillBits.copy(res.annosWhenFalse);
        Conditions conds = new Conditions();
        conds.visit(tree, null);
        boolean flippable = NullnessFlow.isFlippableLogic(tree);
        for (VariableElement elt : conds.getNonnullElements()) {
            idx = this.vars.indexOf(elt);
            if (idx < 0) continue;
            res.annosWhenTrue.set(this.NONNULL, idx);
            if (!flippable || conds.excludes.contains(elt)) continue;
            res.annosWhenFalse.clear(this.NONNULL, idx);
        }
        for (VariableElement elt : conds.getNullableElements()) {
            idx = this.vars.indexOf(elt);
            if (idx < 0 || !flippable || conds.excludes.contains(elt)) continue;
            res.annosWhenFalse.set(this.NONNULL, idx);
        }
        GenKillBits.orlub(res.annosWhenFalse, before, this.annoRelations);
        this.isNullPolyNull = conds.isNullPolyNull;
        this.nnExprsWhenTrue.addAll(conds.nonnullExpressions);
        this.nnExprsWhenFalse.addAll(conds.nullableExpressions);
        return res;
    }

    @Override
    public Void visitBinary(BinaryTree node, Void p) {
        if (node.getKind() == Tree.Kind.CONDITIONAL_AND || node.getKind() == Tree.Kind.CONDITIONAL_OR) {
            this.scan((Tree)node.getLeftOperand(), p);
            GenKillBits before = GenKillBits.copy(this.annos);
            this.scan((Tree)node.getRightOperand(), p);
            this.annos = before;
        } else {
            this.scan((Tree)node.getLeftOperand(), p);
            this.scan((Tree)node.getRightOperand(), p);
        }
        Conditions conds = new Conditions();
        conds.visit(node, null);
        return null;
    }

    private static String receiver(MethodInvocationTree node) {
        ExpressionTree sel = node.getMethodSelect();
        if (sel.getKind() == Tree.Kind.IDENTIFIER) {
            return "";
        }
        if (sel.getKind() == Tree.Kind.MEMBER_SELECT) {
            return ((MemberSelectTree)sel).getExpression().toString() + ".";
        }
        throw new AssertionError((Object)"Cannot be here");
    }

    private List<String> shouldInferNullness(ExpressionTree node) {
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(this.shouldInferNullnessIfTrue(node));
        result.addAll(this.shouldInferNullnessIfFalse(node));
        result.addAll(this.shouldInferNullnessPureNegation(node));
        return result;
    }

    private List<String> substitutePatternsDecl(MethodTree method, String[] annoValues) {
        List<? extends VariableTree> paramTrees = method.getParameters();
        ArrayList<String> params = new ArrayList<String>(paramTrees.size());
        for (VariableTree variableTree : paramTrees) {
            params.add(variableTree.getName().toString());
        }
        return this.substitutePatternsGeneric(method, null, params, annoValues);
    }

    private List<String> substitutePatternsCall(MethodInvocationTree methodInvok, String[] annoValues) {
        String receiver = NullnessFlow.receiver(methodInvok);
        List<? extends ExpressionTree> argExps = methodInvok.getArguments();
        ArrayList<String> args = new ArrayList<String>(argExps.size());
        for (ExpressionTree expressionTree : argExps) {
            args.add(expressionTree.toString());
        }
        return this.substitutePatternsGeneric(methodInvok, receiver, args, annoValues);
    }

    private List<String> substitutePatternsGeneric(Tree node, String receiver, List<String> argparams, String[] annoValues) {
        ArrayList<String> asserts = new ArrayList<String>();
        block0: for (String s : annoValues) {
            if (parameterPtn.matcher(s).matches()) {
                int param = Integer.valueOf(s.substring(1));
                if (param < argparams.size()) {
                    asserts.add(argparams.get(param).toString());
                    continue;
                }
                this.checker.report(Result.failure("param.index.nullness.parse.error", s), node);
                continue;
            }
            if (parameterPtn.matcher(s).find()) {
                Matcher matcher = parameterPtn.matcher(s);
                StringBuffer sb = new StringBuffer();
                while (matcher.find()) {
                    int param = Integer.valueOf(matcher.group(1));
                    if (param < argparams.size()) {
                        String rep = argparams.get(param).toString();
                        matcher.appendReplacement(sb, rep);
                        continue;
                    }
                    this.checker.report(Result.failure("param.index.nullness.parse.error", s), node);
                    continue block0;
                }
                matcher.appendTail(sb);
                if (receiver != null) {
                    asserts.add(receiver + sb.toString());
                    continue;
                }
                asserts.add(sb.toString());
                continue;
            }
            if (receiver != null) {
                asserts.add(receiver + s);
                continue;
            }
            asserts.add(s);
        }
        return asserts;
    }

    private List<String> shouldInferNullnessIfTrue(ExpressionTree node) {
        List<String> asserts;
        if ((node = TreeUtils.skipParens(node)).getKind() == Tree.Kind.CONDITIONAL_AND) {
            BinaryTree bin = (BinaryTree)node;
            ArrayList<String> asserts2 = new ArrayList<String>();
            asserts2.addAll(this.shouldInferNullnessIfTrue(bin.getLeftOperand()));
            asserts2.addAll(this.shouldInferNullnessIfTrue(bin.getRightOperand()));
            return asserts2;
        }
        if (node.getKind() != Tree.Kind.METHOD_INVOCATION) {
            return Collections.emptyList();
        }
        MethodInvocationTree methodInvok = (MethodInvocationTree)node;
        ExecutableElement method = TreeUtils.elementFromUse(methodInvok);
        if (method.getAnnotation(AssertNonNullIfTrue.class) != null) {
            AssertNonNullIfTrue anno = method.getAnnotation(AssertNonNullIfTrue.class);
            asserts = this.substitutePatternsCall(methodInvok, anno.value());
        } else {
            asserts = Collections.emptyList();
        }
        return asserts;
    }

    private List<String> shouldInferNullnessAfter(ExpressionTree node) {
        List<String> asserts;
        if ((node = TreeUtils.skipParens(node)).getKind() == Tree.Kind.CONDITIONAL_AND) {
            BinaryTree bin = (BinaryTree)node;
            ArrayList<String> asserts2 = new ArrayList<String>();
            asserts2.addAll(this.shouldInferNullnessAfter(bin.getLeftOperand()));
            asserts2.addAll(this.shouldInferNullnessAfter(bin.getRightOperand()));
            return asserts2;
        }
        if (node.getKind() != Tree.Kind.METHOD_INVOCATION) {
            return Collections.emptyList();
        }
        MethodInvocationTree methodInvok = (MethodInvocationTree)node;
        ExecutableElement method = TreeUtils.elementFromUse(methodInvok);
        if (method.getAnnotation(AssertNonNullAfter.class) != null) {
            AssertNonNullAfter anno = method.getAnnotation(AssertNonNullAfter.class);
            asserts = this.substitutePatternsCall(methodInvok, anno.value());
        } else {
            asserts = Collections.emptyList();
        }
        return asserts;
    }

    private List<String> shouldInferNullnessIfFalse(ExpressionTree node) {
        List<String> asserts;
        if (node.getKind() != Tree.Kind.LOGICAL_COMPLEMENT || ((UnaryTree)node).getExpression().getKind() != Tree.Kind.METHOD_INVOCATION) {
            return Collections.emptyList();
        }
        MethodInvocationTree methodInvok = (MethodInvocationTree)((UnaryTree)node).getExpression();
        ExecutableElement method = TreeUtils.elementFromUse(methodInvok);
        if (method.getAnnotation(AssertNonNullIfFalse.class) != null) {
            AssertNonNullIfFalse anno = method.getAnnotation(AssertNonNullIfFalse.class);
            asserts = this.substitutePatternsCall(methodInvok, anno.value());
        } else {
            asserts = Collections.emptyList();
        }
        return asserts;
    }

    private List<String> shouldInferNullnessIfFalseNullable(ExpressionTree node) {
        List<String> asserts;
        if ((node = TreeUtils.skipParens(node)).getKind() != Tree.Kind.METHOD_INVOCATION) {
            return Collections.emptyList();
        }
        MethodInvocationTree methodInvok = (MethodInvocationTree)node;
        ExecutableElement method = TreeUtils.elementFromUse(methodInvok);
        if (method.getAnnotation(AssertNonNullIfFalse.class) != null) {
            AssertNonNullIfFalse anno = method.getAnnotation(AssertNonNullIfFalse.class);
            asserts = this.substitutePatternsCall(methodInvok, anno.value());
        } else {
            asserts = Collections.emptyList();
        }
        return asserts;
    }

    private List<String> shouldInferNullnessPureNegation(ExpressionTree node) {
        if (node.getKind() == Tree.Kind.EQUAL_TO) {
            BinaryTree binary = (BinaryTree)node;
            if (!this.isNull(binary.getLeftOperand()) && !this.isNull(binary.getRightOperand())) {
                return Collections.emptyList();
            }
            if (this.isNull(binary.getLeftOperand()) && this.isPure(binary.getRightOperand())) {
                return Collections.singletonList(binary.getRightOperand().toString());
            }
            if (this.isNull(binary.getRightOperand()) && this.isPure(binary.getLeftOperand())) {
                return Collections.singletonList(binary.getLeftOperand().toString());
            }
            return Collections.emptyList();
        }
        if (node.getKind() == Tree.Kind.LOGICAL_COMPLEMENT && TreeUtils.skipParens(((UnaryTree)node).getExpression()).getKind() == Tree.Kind.INSTANCE_OF) {
            InstanceOfTree ioTree = (InstanceOfTree)TreeUtils.skipParens(((UnaryTree)node).getExpression());
            if (this.isPure(ioTree.getExpression())) {
                return Collections.singletonList(ioTree.getExpression().toString());
            }
            return Collections.emptyList();
        }
        return Collections.emptyList();
    }

    @Override
    public Void visitAssert(AssertTree node, Void p) {
        ExpressionTree expr;
        String s;
        ExpressionTree cond = TreeUtils.skipParens(node.getCondition());
        this.nnExprs.addAll(this.shouldInferNullness(cond));
        this.nnExprs.addAll(this.shouldInferNullnessIfFalseNullable(cond));
        if (NullnessFlow.containsKey(node.getDetail(), this.checker.getSuppressWarningsKey()) && cond.getKind() == Tree.Kind.NOT_EQUAL_TO && ((BinaryTree)cond).getRightOperand().getKind() == Tree.Kind.NULL_LITERAL && !this.nnExprs.contains(s = TreeUtils.skipParens(expr = ((BinaryTree)cond).getLeftOperand()).toString())) {
            this.nnExprs.add(s);
        }
        super.visitAssert(node, p);
        return null;
    }

    @Override
    public Void visitAssignment(AssignmentTree node, Void p) {
        String var = node.getVariable().toString();
        Iterator<String> iter = this.nnExprs.iterator();
        while (iter.hasNext()) {
            String nnExp = iter.next();
            if (!var.equals(nnExp) && !nnExp.contains("(" + var + ")") && !nnExp.contains("(" + var + ", ") && !nnExp.contains(", " + var + ")") && !nnExp.contains(", " + var + ", ") && !nnExp.contains("." + var) && !nnExp.contains(var + ".")) continue;
            iter.remove();
        }
        return super.visitAssignment(node, p);
    }

    @Override
    public Void visitCompoundAssignment(CompoundAssignmentTree node, Void p) {
        super.visitCompoundAssignment(node, p);
        this.inferNullness(node.getVariable());
        return null;
    }

    private boolean isTerminating(BlockTree stmt) {
        for (StatementTree statementTree : stmt.getStatements()) {
            if (!this.isTerminating(statementTree)) continue;
            return true;
        }
        return false;
    }

    private boolean isTerminating(StatementTree stmt) {
        if (stmt instanceof BlockTree) {
            return this.isTerminating((BlockTree)stmt);
        }
        switch (stmt.getKind()) {
            case THROW: 
            case RETURN: 
            case BREAK: 
            case CONTINUE: {
                return true;
            }
        }
        return false;
    }

    @Override
    protected void whenConditionFalse(ExpressionTree node, Void p) {
        node = TreeUtils.skipParens(node);
        this.nnExprs.addAll(this.shouldInferNullnessIfFalseNullable(node));
        if (node.getKind() == Tree.Kind.LOGICAL_COMPLEMENT) {
            ExpressionTree unary = ((UnaryTree)node).getExpression();
            this.nnExprs.addAll(this.shouldInferNullnessAfter(unary));
            this.nnExprs.addAll(this.shouldInferNullnessIfTrue(unary));
        }
    }

    @Override
    public Void visitIf(IfTree node, Void p) {
        super.visitIf(node, p);
        ExpressionTree cond = TreeUtils.skipParens(node.getCondition());
        if (this.isTerminating(node.getThenStatement())) {
            if (cond.getKind() == Tree.Kind.LOGICAL_COMPLEMENT) {
                this.nnExprs.addAll(this.shouldInferNullness(((UnaryTree)cond).getExpression()));
            }
            this.nnExprs.addAll(this.shouldInferNullnessIfFalseNullable(cond));
            this.nnExprs.addAll(this.shouldInferNullnessPureNegation(cond));
        }
        return null;
    }

    @Override
    public Void visitMemberSelect(MemberSelectTree node, Void p) {
        super.visitMemberSelect(node, p);
        this.inferNullness(node.getExpression());
        if (this.nnExprs.contains(node.toString())) {
            this.markTree(node, this.NONNULL);
        }
        return null;
    }

    @Override
    public Void visitIdentifier(IdentifierTree node, Void p) {
        super.visitIdentifier(node, p);
        if (this.nnExprs.contains(node.toString())) {
            this.markTree(node, this.NONNULL);
        }
        return null;
    }

    @Override
    public Void visitArrayAccess(ArrayAccessTree node, Void p) {
        super.visitArrayAccess(node, p);
        if (this.nnExprs.contains(node.toString())) {
            this.markTree(node, this.NONNULL);
        }
        return null;
    }

    @Override
    public Void visitMethodInvocation(MethodInvocationTree node, Void p) {
        int i;
        GenKillBits<AnnotationMirror> prev = GenKillBits.copy(this.annos);
        this.checkNonNullOnEntry(node);
        super.visitMethodInvocation(node, p);
        ExecutableElement method = TreeUtils.elementFromUse(node);
        if (method.getAnnotation(AssertParametersNonNull.class) != null) {
            for (ExpressionTree expressionTree : node.getArguments()) {
                this.inferNullness(expressionTree);
            }
        }
        AnnotatedTypeMirror.AnnotatedExecutableType methodType = this.factory.getAnnotatedType(method);
        List<AnnotatedTypeMirror> list = methodType.getParameterTypes();
        List<? extends ExpressionTree> methodArgs = node.getArguments();
        for (i = 0; i < list.size() && i < methodArgs.size(); ++i) {
            if (!list.get(i).hasAnnotation(this.NONNULL)) continue;
            this.inferNullness(methodArgs.get(i));
        }
        for (i = 0; i < this.vars.size(); ++i) {
            Element elem = (Element)this.vars.get(i);
            if (elem.getKind() != ElementKind.FIELD || elem.getAnnotation(LazyNonNull.class) == null || !prev.get(this.NONNULL, i)) continue;
            this.annos.set(this.NONNULL, i);
        }
        this.nnExprs.addAll(this.shouldInferNullnessAfter(node));
        if (this.nnExprs.contains(node.toString())) {
            this.markTree(node, this.NONNULL);
        }
        return null;
    }

    private void markTree(Tree node, AnnotationMirror anno) {
        this.flowResults.put(node, anno);
    }

    @Override
    public Void visitLiteral(LiteralTree node, Void p) {
        super.visitLiteral(node, p);
        if (this.isNullPolyNull && node.getKind() == Tree.Kind.NULL_LITERAL) {
            this.markTree(node, this.POLYNULL);
        }
        return null;
    }

    void inferNullness(ExpressionTree expr) {
        Element elt = this.var(expr);
        if (expr instanceof IdentifierTree) {
            elt = TreeUtils.elementFromUse((IdentifierTree)expr);
        } else if (expr instanceof MemberSelectTree) {
            elt = TreeUtils.elementFromUse((MemberSelectTree)expr);
        }
        if (elt != null && this.vars.contains(elt)) {
            int idx = this.vars.indexOf(elt);
            this.annos.set(this.NONNULL, idx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visitMethod(MethodTree meth, Void p) {
        GenKillBits prev = GenKillBits.copy(this.annos);
        if (this.hasRawReceiver(meth)) {
            for (int i = 0; i < this.vars.size(); ++i) {
                Element var = (Element)this.vars.get(i);
                if (var.getKind() != ElementKind.FIELD) continue;
                this.annos.clear(this.NONNULL, i);
            }
        }
        ArrayList<String> prevNnExprs = new ArrayList<String>(this.nnExprs);
        ExecutableElement elem = TreeUtils.elementFromDeclaration(meth);
        if (elem.getAnnotation(NonNullOnEntry.class) != null || elem.getAnnotation(AssertNonNullIfTrue.class) != null || elem.getAnnotation(AssertNonNullIfFalse.class) != null || elem.getAnnotation(AssertNonNullAfter.class) != null) {
            AnnotatedTypeMirror.AnnotatedDeclaredType myType = this.factory.getAnnotatedType(TreeUtils.enclosingClass(this.factory.getPath(meth)));
            if (!(myType instanceof AnnotatedTypeMirror.AnnotatedDeclaredType)) {
                System.err.println("NullnessFlow::visitMethod: What's wrong with: " + myType);
                return null;
            }
            Element myElem = myType.getUnderlyingType().asElement();
            List<VariableElement> myFieldElems = NullnessFlow.allFields(myElem);
            if (elem.getAnnotation(NonNullOnEntry.class) != null) {
                String[] fields = elem.getAnnotation(NonNullOnEntry.class).value();
                List<String> fieldsList = this.validateNonNullOnEntry(meth, myFieldElems, fields);
                this.nnExprs.addAll(fieldsList);
            }
            if ((elem.getAnnotation(AssertNonNullIfTrue.class) != null || elem.getAnnotation(AssertNonNullIfFalse.class) != null) && this.factory.getAnnotatedType(meth.getReturnType()).getKind() != TypeKind.BOOLEAN) {
                this.checker.report(Result.failure("assertifxxx.only.on.boolean", new Object[0]), meth);
            }
        }
        try {
            Void void_ = super.visitMethod(meth, p);
            return void_;
        }
        finally {
            this.annos = prev;
            this.nnExprs = prevNnExprs;
        }
    }

    @Override
    public void visitMethodEndCallback(MethodTree meth) {
        ExecutableElement methElem = TreeUtils.elementFromDeclaration(meth);
        TypeMirror retType = methElem.getReturnType();
        if (retType.getKind() == TypeKind.VOID && methElem.getAnnotation(AssertNonNullAfter.class) != null) {
            this.checkAssertNonNullAfter(meth, methElem);
        }
    }

    private void checkAssertNonNullAfter(MethodTree meth, ExecutableElement methElem) {
        String[] annoValues;
        for (String annoVal : annoValues = methElem.getAnnotation(AssertNonNullAfter.class).value()) {
            List<VariableElement> elemsToSearch;
            String fieldName;
            boolean found = false;
            boolean error = false;
            if (parameterPtn.matcher(annoVal).find()) {
                this.checker.report(Result.warning("nullness.parse.error", annoVal), meth);
                continue;
            }
            if (annoVal.contains(".")) {
                Element findClass;
                String[] parts = annoVal.split("\\.");
                if (parts.length != 2) {
                    this.checker.report(Result.failure("nullness.parse.error", annoVal), meth);
                    continue;
                }
                String string = parts[0];
                fieldName = parts[1];
                for (findClass = methElem; findClass != null && !findClass.getSimpleName().toString().equals(string); findClass = findClass.getEnclosingElement()) {
                }
                if (findClass == null) {
                    this.checker.report(Result.failure("class.not.found.nullness.parse.error", annoVal), meth);
                    continue;
                }
                elemsToSearch = NullnessFlow.allFields(findClass);
            } else {
                fieldName = annoVal;
                elemsToSearch = NullnessFlow.allFields(ElementUtils.enclosingClass(methElem));
            }
            for (Element element : elemsToSearch) {
                String elName = element.getSimpleName().toString();
                String elClass = element.getEnclosingElement().getSimpleName().toString();
                if (!fieldName.equals(elName)) continue;
                if (found) {
                    this.checker.report(Result.failure("nonnull.hiding.violated", annoVal), meth);
                    continue;
                }
                found = true;
                int index = this.vars.indexOf(element);
                if (index != -1 && this.annos.get(this.NONNULL, index) || this.nnExprs.contains(elName) || this.nnExprs.contains(elClass + "." + elName)) continue;
                error = true;
            }
            if (found && !error) continue;
            this.checker.report(Result.failure("assert.postcondition.not.satisfied", annoVal), meth);
        }
    }

    private void checkAssertNonNullIfTrue(MethodTree meth, ExecutableElement methElem, ReturnTree ret) {
        String[] annoValues = methElem.getAnnotation(AssertNonNullIfTrue.class).value();
        this.checkAssertNonNullIfXXX(meth, methElem, ret, annoValues, true);
    }

    private void checkAssertNonNullIfFalse(MethodTree meth, ExecutableElement methElem, ReturnTree ret) {
        String[] annoValues = methElem.getAnnotation(AssertNonNullIfFalse.class).value();
        this.checkAssertNonNullIfXXX(meth, methElem, ret, annoValues, false);
    }

    private void checkAssertNonNullIfXXX(MethodTree meth, ExecutableElement methElem, ReturnTree ret, String[] annoValues, boolean ifTrue) {
        ExpressionTree retExp = ret.getExpression();
        if (this.factory.getAnnotatedType(retExp).getKind() != TypeKind.BOOLEAN) {
            this.checker.report(Result.failure("assertifxxx.only.on.boolean", new Object[0]), meth);
            return;
        }
        List<String> toCheck = this.substitutePatternsDecl(meth, annoValues);
        Conditions conds = new Conditions();
        conds.visit(retExp, null);
        retExp = TreeUtils.skipParens(retExp);
        if (retExp.getKind() == Tree.Kind.BOOLEAN_LITERAL) {
            LiteralTree b = (LiteralTree)retExp;
            boolean val = (Boolean)b.getValue();
            if (ifTrue && val || !ifTrue && !val) {
                for (String check : toCheck) {
                    boolean found = false;
                    for (VariableElement ve : this.vars) {
                        if (!ve.getSimpleName().toString().equals(check)) continue;
                        found = true;
                        if (this.annos.get(this.NONNULL, this.vars.indexOf(ve)) || this.nnExprs.contains(check)) continue;
                        if (ifTrue) {
                            this.checker.report(Result.failure("assertiftrue.postcondition.not.satisfied", check), ret);
                            continue;
                        }
                        this.checker.report(Result.failure("assertiffalse.postcondition.not.satisfied", check), ret);
                    }
                    if (found) continue;
                    if (ifTrue) {
                        this.checker.report(Result.failure("assertiftrue.postcondition.not.satisfied", check), ret);
                        continue;
                    }
                    this.checker.report(Result.failure("assertiffalse.postcondition.not.satisfied", check), ret);
                }
            }
            return;
        }
        Stack<ExpressionTree> worklist = new Stack<ExpressionTree>();
        worklist.push(retExp);
        boolean checkedAll = true;
        for (String check : toCheck) {
            boolean checked = false;
            for (VariableElement ve : this.vars) {
                if (!ve.getSimpleName().toString().equals(check)) continue;
                if (!this.annos.get(this.NONNULL, this.vars.indexOf(ve)) && !this.nnExprs.contains(check)) break;
                checked = true;
                break;
            }
            if (checked) continue;
            checkedAll = false;
        }
        if (checkedAll) {
            return;
        }
        while (!worklist.isEmpty()) {
            BinaryTree bin;
            ExpressionTree cond = (ExpressionTree)worklist.pop();
            if (cond.getKind() == Tree.Kind.CONDITIONAL_AND) {
                if (!ifTrue) {
                    this.checker.report(Result.failure("assertiffalse.nullness.condition.error", new Object[0]), ret);
                }
                bin = (BinaryTree)cond;
                worklist.push(bin.getLeftOperand());
                worklist.push(bin.getRightOperand());
            }
            if (cond.getKind() != Tree.Kind.CONDITIONAL_OR) continue;
            if (ifTrue) {
                this.checker.report(Result.failure("assertiftrue.nullness.condition.error", new Object[0]), ret);
            }
            bin = (BinaryTree)cond;
            worklist.push(bin.getLeftOperand());
            worklist.push(bin.getRightOperand());
        }
        for (String check : toCheck) {
            boolean found = false;
            if (ifTrue) {
                for (VariableElement ve : conds.getNonnullElements()) {
                    if (!ve.getSimpleName().toString().equals(check)) continue;
                    found = true;
                }
            } else {
                for (VariableElement ve : conds.getNullableElements()) {
                    if (!ve.getSimpleName().toString().equals(check)) continue;
                    found = true;
                }
            }
            if (found) continue;
            if (ifTrue) {
                this.checker.report(Result.failure("assertiftrue.postcondition.not.satisfied", check), ret);
                continue;
            }
            this.checker.report(Result.failure("assertiffalse.postcondition.not.satisfied", check), ret);
        }
    }

    private void checkNonNullOnEntry(MethodInvocationTree call) {
        ExecutableElement method = TreeUtils.elementFromUse(call);
        if (method.getAnnotation(NonNullOnEntry.class) != null) {
            String[] fields;
            ExpressionTree recv;
            AnnotatedTypeMirror recvType;
            if (this.debug != null) {
                this.debug.println("NullnessFlow::checkNonNullOnEntry: Looking at call: " + call);
            }
            if (!((recvType = (recv = TreeUtils.getReceiverTree(call)) == null ? this.factory.getAnnotatedType(TreeUtils.enclosingClass(this.factory.getPath(call))) : this.factory.getAnnotatedType(recv)) instanceof AnnotatedTypeMirror.AnnotatedDeclaredType)) {
                System.err.println("What's wrong with: " + recvType);
                return;
            }
            Element recvElem = ((AnnotatedTypeMirror.AnnotatedDeclaredType)recvType).getUnderlyingType().asElement();
            List<VariableElement> recvFieldElems = NullnessFlow.allFields(recvElem);
            for (String field : fields = method.getAnnotation(NonNullOnEntry.class).value()) {
                Element el = this.findElementInCall(recvElem, recvFieldElems, call, field);
                if (el == null) continue;
                String elName = el.getSimpleName().toString();
                String elClass = el.getEnclosingElement().getSimpleName().toString();
                int index = this.vars.indexOf(el);
                if (index != -1 && this.annos.get(this.NONNULL, index) || this.nnExprs.contains(elName) || this.nnExprs.contains(elClass + "." + elName)) continue;
                this.checker.report(Result.failure("nonnullonentry.precondition.not.satisfied", field), call);
            }
        }
    }

    private Element findElementInCall(Element recvElem, List<? extends Element> recvFieldElems, MethodInvocationTree call, String field) {
        List<? extends Element> elemsToSearch;
        String fieldName;
        if (field.contains(".")) {
            Element findClass;
            String[] parts = field.split("\\.");
            if (parts.length != 2) {
                this.checker.report(Result.failure("nullness.parse.error", field), call);
                return null;
            }
            String className = parts[0];
            fieldName = parts[1];
            for (findClass = recvElem; findClass != null && !findClass.getSimpleName().toString().equals(className); findClass = findClass.getEnclosingElement()) {
            }
            if (findClass == null) {
                this.checker.report(Result.failure("class.not.found.nullness.parse.error", field), call);
                return null;
            }
            elemsToSearch = NullnessFlow.allFields(findClass);
        } else {
            fieldName = field;
            elemsToSearch = recvFieldElems;
        }
        boolean found = false;
        Element res = null;
        for (Element element : elemsToSearch) {
            String elName = element.getSimpleName().toString();
            if (!fieldName.equals(elName)) continue;
            if (found) {
                this.checker.report(Result.failure("nonnull.hiding.violated", field), call);
                return null;
            }
            found = true;
            res = element;
        }
        if (!found) {
            this.checker.report(Result.failure("nullness.parse.error", field), call);
        }
        return res;
    }

    private static List<VariableElement> allFields(Element el) {
        if (!(el instanceof TypeElement)) {
            System.err.println("NullnessFlow::allFields: the argument should be a TypeElement; it is a: " + el != null ? el.getClass() : null);
            return null;
        }
        TypeElement tyel = (TypeElement)el;
        ArrayList<VariableElement> res = new ArrayList<VariableElement>();
        boolean inSuper = false;
        while (tyel != null && !ElementUtils.isObject(tyel)) {
            List<VariableElement> toAdd = ElementFilter.fieldsIn(tyel.getEnclosedElements());
            if (inSuper) {
                Iterator<VariableElement> it = toAdd.iterator();
                while (it.hasNext()) {
                    VariableElement newel = it.next();
                    if (!newel.getModifiers().contains((Object)Modifier.PRIVATE)) continue;
                    it.remove();
                }
            }
            res.addAll(toAdd);
            TypeMirror suty = tyel.getSuperclass();
            inSuper = true;
            if (suty instanceof DeclaredType) {
                DeclaredType dtsuty = (DeclaredType)suty;
                tyel = (TypeElement)dtsuty.asElement();
                continue;
            }
            System.out.println("What's happening here?? " + el);
            break;
        }
        return res;
    }

    private List<String> validateNonNullOnEntry(MethodTree meth, List<? extends Element> myFieldElems, String[] fields) {
        LinkedList<String> res = new LinkedList<String>();
        for (String field : fields) {
            List<? extends Element> elemsToSearch;
            boolean found = false;
            if (field.contains(".")) {
                Element findClass;
                String[] parts = field.split("\\.");
                if (parts.length != 2) {
                    this.checker.report(Result.failure("nullness.parse.error", field), meth);
                    res.add(field);
                    continue;
                }
                String string = parts[0];
                for (findClass = ElementUtils.enclosingClass(TreeUtils.elementFromDeclaration(meth)); findClass != null && !findClass.getSimpleName().toString().equals(string); findClass = findClass.getEnclosingElement()) {
                }
                if (findClass == null) {
                    this.checker.report(Result.failure("class.not.found.nullness.parse.error", field), meth);
                    res.add(field);
                    continue;
                }
                elemsToSearch = NullnessFlow.allFields(findClass);
            } else {
                elemsToSearch = myFieldElems;
            }
            for (Element element : elemsToSearch) {
                boolean matched = false;
                String elName = element.getSimpleName().toString();
                String elClass = element.getEnclosingElement().getSimpleName().toString();
                if (field.equals(elName)) {
                    if (element.getModifiers().contains((Object)Modifier.STATIC)) {
                        res.add(elClass + "." + elName);
                    }
                    res.add(elName);
                    matched = true;
                } else if (field.equals("this." + elName)) {
                    res.add(elName);
                    matched = true;
                } else if (field.equals(elClass + "." + elName)) {
                    if (!element.getModifiers().contains((Object)Modifier.STATIC)) {
                        this.checker.report(Result.failure("nonnull.nonstatic.with.class", field), meth);
                        res.add(field);
                        continue;
                    }
                    res.add(field);
                    res.add(elName);
                    matched = true;
                }
                if (!matched) continue;
                if (found) {
                    this.checker.report(Result.failure("nonnull.hiding.violated", field), meth);
                    continue;
                }
                found = true;
            }
            if (found) continue;
            this.checker.report(Result.failure("field.not.found.nullness.parse.error", field), meth);
            res.add(field);
        }
        return res;
    }

    @Override
    public Void visitReturn(ReturnTree node, Void p) {
        super.visitReturn(node, p);
        this.checkAssertsOnReturn(node);
        return null;
    }

    private void checkAssertsOnReturn(ReturnTree ret) {
        MethodTree meth = TreeUtils.enclosingMethod(this.factory.getPath(ret));
        ExecutableElement methElem = TreeUtils.elementFromDeclaration(meth);
        if (methElem.getAnnotation(AssertNonNullAfter.class) != null) {
            this.checkAssertNonNullAfter(meth, methElem);
        }
        if (methElem.getAnnotation(AssertNonNullIfTrue.class) != null) {
            this.checkAssertNonNullIfTrue(meth, methElem, ret);
        }
        if (methElem.getAnnotation(AssertNonNullIfFalse.class) != null) {
            this.checkAssertNonNullIfFalse(meth, methElem, ret);
        }
    }

    private final boolean hasRawReceiver(MethodTree node) {
        return this.rawFactory.getAnnotatedType(node).getReceiverType().hasAnnotation(this.RAW);
    }

    private final boolean isNull(Tree tree) {
        return tree != null && tree.getKind() == Tree.Kind.NULL_LITERAL;
    }

    private final boolean hasVar(Tree tree) {
        Tree tr = TreeUtils.skipParens(tree);
        if (tr.getKind() == Tree.Kind.ASSIGNMENT) {
            tr = ((AssignmentTree)tr).getVariable();
        }
        return tr.getKind() == Tree.Kind.IDENTIFIER || tr.getKind() == Tree.Kind.MEMBER_SELECT;
    }

    private final Element var(Tree tree) {
        tree = TreeUtils.skipParens(tree);
        switch (tree.getKind()) {
            case IDENTIFIER: {
                return TreeUtils.elementFromUse((IdentifierTree)tree);
            }
            case MEMBER_SELECT: {
                return TreeUtils.elementFromUse((MemberSelectTree)tree);
            }
            case ASSIGNMENT: {
                return this.var(((AssignmentTree)tree).getVariable());
            }
        }
        return null;
    }

    private boolean isPure(Tree tree) {
        if ((tree = TreeUtils.skipParens(tree)).getKind() != Tree.Kind.METHOD_INVOCATION) {
            return false;
        }
        ExecutableElement method = TreeUtils.elementFromUse((MethodInvocationTree)tree);
        return method.getAnnotation(Pure.class) != null;
    }

    @Override
    public Void visitConditionalExpression(ConditionalExpressionTree node, Void p) {
        Flow.SplitTuple res = this.scanCond(node.getCondition());
        ArrayList<String> prevNNExprs = new ArrayList<String>(this.nnExprs);
        GenKillBits<AnnotationMirror> before = res.annosWhenFalse;
        this.annos = res.annosWhenTrue;
        this.nnExprs = this.nnExprsWhenTrue;
        this.scanExpr(node.getTrueExpression());
        GenKillBits<AnnotationMirror> after = GenKillBits.copy(this.annos);
        this.annos = before;
        this.nnExprs = this.nnExprsWhenFalse;
        this.scanExpr(node.getFalseExpression());
        GenKillBits.andlub(this.annos, after, this.annoRelations);
        this.nnExprs = prevNNExprs;
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Conditions
    extends SimpleTreeVisitor<Void, Void> {
        private BitSet nonnull = new BitSet(0);
        private BitSet nullable = new BitSet(0);
        public boolean isNullPolyNull = false;
        public List<String> nonnullExpressions = new LinkedList<String>();
        public List<String> nullableExpressions = new LinkedList<String>();
        private final List<VariableElement> vars = new LinkedList<VariableElement>();
        final Set<Element> excludes = new HashSet<Element>();

        Conditions() {
        }

        public Set<VariableElement> getNonnullElements() {
            return this.getElements(true);
        }

        public Set<VariableElement> getNullableElements() {
            return this.getElements(false);
        }

        private Set<VariableElement> getElements(boolean isNN) {
            HashSet<VariableElement> result = new HashSet<VariableElement>();
            for (int i = 0; i < this.vars.size(); ++i) {
                if ((!isNN || !this.nonnull.get(i) || this.nullable.get(i)) && (isNN || !this.nullable.get(i) || this.nonnull.get(i))) continue;
                result.add(this.vars.get(i));
            }
            return Collections.unmodifiableSet(result);
        }

        @Override
        public Void visitUnary(UnaryTree node, Void p) {
            this.visit(node.getExpression(), p);
            if (node.getKind() != Tree.Kind.LOGICAL_COMPLEMENT) {
                return null;
            }
            if (this.nonnull.cardinality() + this.nullable.cardinality() == 1) {
                this.nonnull.xor(this.nullable);
                this.nullable.xor(this.nonnull);
                this.nonnull.xor(this.nullable);
            } else {
                this.nonnull.clear();
                this.nullable.clear();
            }
            this.isNullPolyNull = false;
            if (TreeUtils.skipParens(node.getExpression()).getKind() == Tree.Kind.INSTANCE_OF) {
                ExpressionTree expr = ((InstanceOfTree)TreeUtils.skipParens(node.getExpression())).getExpression();
                this.excludes.remove(NullnessFlow.this.var(expr));
            }
            NullnessFlow.this.nnExprs.addAll(NullnessFlow.this.shouldInferNullness(node));
            return null;
        }

        @Override
        public Void visitInstanceOf(InstanceOfTree node, Void p) {
            ExpressionTree expr = node.getExpression();
            this.visit(expr, p);
            if (NullnessFlow.this.hasVar(expr)) {
                int idx = this.vars.indexOf(NullnessFlow.this.var(expr));
                this.nonnull.set(idx);
                this.nullable.clear(idx);
                this.excludes.add(NullnessFlow.this.var(expr));
            }
            return (Void)super.visitInstanceOf(node, p);
        }

        private void splitAndMerge(Tree left, Tree right, final boolean mergeAnd) {
            BitSet nonnullOld = (BitSet)this.nonnull.clone();
            BitSet nullableOld = (BitSet)this.nullable.clone();
            this.visit(left, null);
            final BitSet nonnullSplit = (BitSet)this.nonnull.clone();
            final BitSet nullableSplit = (BitSet)this.nullable.clone();
            new TreeScanner<Void, Void>(){

                private void record(Element e, Tree node) {
                    int idx = Conditions.this.vars.indexOf(e);
                    if (idx >= 0 && (mergeAnd ? nullableSplit.get(idx) : nonnullSplit.get(idx))) {
                        NullnessFlow.this.markTree(node, NullnessFlow.this.NONNULL);
                    }
                    if ((mergeAnd ? Conditions.this.nullableExpressions : Conditions.this.nonnullExpressions).contains(node.toString())) {
                        NullnessFlow.this.markTree(node, NullnessFlow.this.NONNULL);
                    }
                }

                @Override
                public Void visitIdentifier(IdentifierTree node, Void p) {
                    Element e = TreeUtils.elementFromUse(node);
                    this.record(e, node);
                    return (Void)super.visitIdentifier(node, p);
                }

                @Override
                public Void visitMemberSelect(MemberSelectTree node, Void p) {
                    Element e = TreeUtils.elementFromUse(node);
                    this.record(e, node);
                    return (Void)super.visitMemberSelect(node, p);
                }

                @Override
                public Void visitMethodInvocation(MethodInvocationTree node, Void p) {
                    if ((mergeAnd ? Conditions.this.nullableExpressions : Conditions.this.nonnullExpressions).contains(node.toString())) {
                        NullnessFlow.this.markTree(node, NullnessFlow.this.NONNULL);
                    }
                    return (Void)super.visitMethodInvocation(node, p);
                }
            }.scan(right, null);
            this.nonnull = (BitSet)nonnullOld.clone();
            this.nullable = (BitSet)nullableOld.clone();
            this.visit(right, null);
            if (mergeAnd) {
                nonnullSplit.and(this.nonnull);
                nullableSplit.or(this.nullable);
            } else {
                nonnullSplit.or(this.nonnull);
                nullableSplit.or(this.nullable);
            }
            this.nonnull = nonnullOld;
            this.nullable = nullableOld;
            this.nonnull.or(nonnullSplit);
            this.nullable.or(nullableSplit);
            this.nullable.andNot(this.nonnull);
        }

        @Override
        public Void visitConditionalExpression(ConditionalExpressionTree node, Void p) {
            BitSet nonnullOld = (BitSet)this.nonnull.clone();
            BitSet nullableOld = (BitSet)this.nullable.clone();
            this.splitAndMerge(node.getCondition(), node.getTrueExpression(), false);
            BitSet nonnullSplit = (BitSet)this.nonnull.clone();
            BitSet nullableSplit = (BitSet)this.nullable.clone();
            this.visit(node.getFalseExpression(), p);
            nonnullSplit.and(this.nonnull);
            nullableSplit.and(this.nullable);
            this.nonnull = nonnullOld;
            this.nullable = nullableOld;
            this.nonnull.or(nonnullSplit);
            this.nullable.or(nullableSplit);
            return (Void)super.visitConditionalExpression(node, p);
        }

        private void mark(Element var, boolean isNonnull) {
            if (var == null) {
                return;
            }
            int idx = this.vars.indexOf(var);
            if (isNonnull) {
                this.nonnull.set(idx);
                this.nullable.clear(idx);
            } else {
                this.nullable.set(idx);
                this.nonnull.clear(idx);
            }
        }

        @Override
        public Void visitBinary(BinaryTree node, Void p) {
            ExpressionTree left = node.getLeftOperand();
            ExpressionTree right = node.getRightOperand();
            Tree.Kind oper = node.getKind();
            if (oper == Tree.Kind.CONDITIONAL_AND) {
                this.splitAndMerge(left, right, false);
            } else if (oper == Tree.Kind.CONDITIONAL_OR) {
                this.splitAndMerge(left, right, true);
            } else if (oper == Tree.Kind.EQUAL_TO) {
                this.visit(left, p);
                this.visit(right, p);
                Element var = null;
                if (NullnessFlow.this.hasVar(left) && NullnessFlow.this.isNull(right)) {
                    var = NullnessFlow.this.var(left);
                } else if (NullnessFlow.this.isNull(left) && NullnessFlow.this.hasVar(right)) {
                    var = NullnessFlow.this.var(right);
                }
                this.mark(var, false);
                if (var != null) {
                    if (NullnessFlow.this.factory.getAnnotatedType(var).getAnnotation(PolyNull.class.getName()) != null) {
                        this.isNullPolyNull = true;
                    }
                } else {
                    AnnotatedTypeMirror leftType = NullnessFlow.this.factory.getAnnotatedType((Tree)left);
                    AnnotatedTypeMirror rightType = NullnessFlow.this.factory.getAnnotatedType((Tree)right);
                    if (leftType.hasAnnotation(NullnessFlow.this.NONNULL) && !rightType.hasAnnotation(NullnessFlow.this.NONNULL)) {
                        this.mark(NullnessFlow.this.var(right), true);
                    }
                    if (rightType.hasAnnotation(NullnessFlow.this.NONNULL) && !leftType.hasAnnotation(NullnessFlow.this.NONNULL)) {
                        this.mark(NullnessFlow.this.var(left), true);
                    }
                }
                if (NullnessFlow.this.isNull(right) && NullnessFlow.this.isPure(left)) {
                    this.nullableExpressions.add(left.toString());
                } else if (NullnessFlow.this.isNull(left) && NullnessFlow.this.isPure(right)) {
                    this.nullableExpressions.add(right.toString());
                }
            } else if (oper == Tree.Kind.NOT_EQUAL_TO) {
                this.visit(left, p);
                this.visit(right, p);
                Element var = null;
                if (NullnessFlow.this.hasVar(left) && NullnessFlow.this.isNull(right)) {
                    var = NullnessFlow.this.var(left);
                } else if (NullnessFlow.this.isNull(left) && NullnessFlow.this.hasVar(right)) {
                    var = NullnessFlow.this.var(right);
                }
                this.mark(var, true);
                if (NullnessFlow.this.isNull(right) && NullnessFlow.this.isPure(left)) {
                    this.nonnullExpressions.add(left.toString());
                } else if (NullnessFlow.this.isNull(left) && NullnessFlow.this.isPure(right)) {
                    this.nonnullExpressions.add(right.toString());
                }
            }
            return null;
        }

        @Override
        public Void visitIdentifier(IdentifierTree node, Void p) {
            Element e = TreeUtils.elementFromUse(node);
            assert (e instanceof VariableElement);
            if (!this.vars.contains(e)) {
                this.vars.add((VariableElement)e);
            }
            return (Void)super.visitIdentifier(node, p);
        }

        @Override
        public Void visitMemberSelect(MemberSelectTree node, Void p) {
            Element e = TreeUtils.elementFromUse(node);
            assert (e instanceof VariableElement);
            if (!this.vars.contains(e)) {
                this.vars.add((VariableElement)e);
            }
            if (NullnessFlow.this.nnExprs.contains(node.toString())) {
                NullnessFlow.this.markTree(node, NullnessFlow.this.NONNULL);
            }
            return (Void)super.visitMemberSelect(node, p);
        }

        @Override
        public Void visitParenthesized(ParenthesizedTree node, Void p) {
            return (Void)this.visit(node.getExpression(), p);
        }

        @Override
        public Void visitAssignment(AssignmentTree node, Void p) {
            this.visit(node.getVariable(), p);
            this.visit(node.getExpression(), p);
            return null;
        }

        @Override
        public Void visitMethodInvocation(MethodInvocationTree node, Void p) {
            super.visitMethodInvocation(node, p);
            this.nonnullExpressions.addAll(NullnessFlow.this.shouldInferNullness(node));
            return null;
        }
    }
}

