/*
 * Decompiled with CFR 0.152.
 */
package checkers.types;

import checkers.basetype.BaseTypeChecker;
import checkers.javari.quals.Mutable;
import checkers.nullness.quals.Nullable;
import checkers.source.SourceChecker;
import checkers.types.AnnotatedTypeMirror;
import checkers.types.AnnotatedTypes;
import checkers.types.QualifierHierarchy;
import checkers.types.TypeFromElement;
import checkers.types.TypeFromTree;
import checkers.types.VisitorState;
import checkers.types.visitors.AnnotatedTypeScanner;
import checkers.util.AnnotationUtils;
import checkers.util.ElementUtils;
import checkers.util.InternalUtils;
import checkers.util.TreeUtils;
import checkers.util.stub.StubParser;
import checkers.util.stub.StubUtil;
import com.sun.source.tree.AnnotatedTypeTree;
import com.sun.source.tree.ArrayAccessTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.PrimitiveTypeTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotatedTypeFactory {
    protected final Trees trees;
    @Nullable
    protected final CompilationUnitTree root;
    protected final ProcessingEnvironment env;
    protected final AnnotationUtils annotations;
    protected final Elements elements;
    protected final Types types;
    protected final AnnotatedTypes atypes;
    protected final VisitorState visitorState;
    @Nullable
    protected final QualifierHierarchy qualHierarchy;
    private Map<Element, AnnotatedTypeMirror> indexTypes;
    private Class<? extends SourceChecker> checkerClass;
    private final boolean annotatedTypeParams;
    private Map<String, AnnotationMirror> aliases = new HashMap<String, AnnotationMirror>();
    private static int uidCounter = 0;
    public final int uid;
    private static final boolean SHOULD_CACHE = true;
    private static final int CACHE_SIZE = 50;
    private Map<Tree, AnnotatedTypeMirror> treeCache = AnnotatedTypeFactory.createLRUCache(50);
    private Map<Element, AnnotatedTypeMirror> elementCache = AnnotatedTypeFactory.createLRUCache(50);
    private Map<Element, Tree> elementToTreeCache = AnnotatedTypeFactory.createLRUCache(50);
    protected Map<Tree, AnnotatedTypeMirror> fromTreeCache = AnnotatedTypeFactory.createLRUCache(50);
    private final Set<Name> supportedQuals;

    public AnnotatedTypeFactory(SourceChecker checker, @Nullable CompilationUnitTree root) {
        this(checker.getProcessingEnvironment(), checker instanceof BaseTypeChecker ? ((BaseTypeChecker)checker).getQualifierHierarchy() : null, root, checker == null ? null : checker.getClass());
    }

    public AnnotatedTypeFactory(ProcessingEnvironment env, @Nullable QualifierHierarchy qualHierarchy, @Nullable CompilationUnitTree root, Class<? extends SourceChecker> checkerClass) {
        this.uid = ++uidCounter;
        this.env = env;
        this.root = root;
        this.checkerClass = checkerClass;
        this.trees = Trees.instance(env);
        this.annotations = AnnotationUtils.getInstance(env);
        this.elements = env.getElementUtils();
        this.types = env.getTypeUtils();
        this.atypes = new AnnotatedTypes(env, this);
        this.visitorState = new VisitorState();
        this.qualHierarchy = qualHierarchy;
        this.supportedQuals = this.getSupportedQualifiers();
        this.indexTypes = null;
        this.annotatedTypeParams = true;
    }

    protected void postInit() {
        this.indexTypes = this.buildIndexTypes();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "#" + this.uid;
    }

    public boolean canHaveAnnotatedTypeParameters() {
        return this.annotatedTypeParams;
    }

    public AnnotatedTypeMirror getAnnotatedType(Element elt) {
        if (elt == null) {
            throw new IllegalArgumentException("null element");
        }
        AnnotatedTypeMirror type = this.fromElement(elt);
        this.annotateImplicit(elt, type);
        return type;
    }

    public AnnotatedTypeMirror getAnnotatedType(Tree tree) {
        AnnotatedTypeMirror type;
        if (tree == null) {
            throw new IllegalArgumentException("null tree");
        }
        if (this.treeCache.containsKey(tree)) {
            return this.atypes.deepCopy(this.treeCache.get(tree));
        }
        switch (tree.getKind()) {
            case CLASS: {
                type = this.fromClass((ClassTree)tree);
                break;
            }
            case METHOD: 
            case VARIABLE: {
                type = this.fromMember(tree);
                break;
            }
            default: {
                if (tree instanceof ExpressionTree) {
                    type = this.fromExpression((ExpressionTree)tree);
                    break;
                }
                throw new UnsupportedOperationException("query of annotated type for tree " + (Object)((Object)tree.getKind()));
            }
        }
        this.annotateImplicit(TreeUtils.skipParens(tree), type);
        switch (tree.getKind()) {
            case CLASS: 
            case METHOD: {
                this.treeCache.put(tree, this.atypes.deepCopy(type));
            }
        }
        return type;
    }

    public AnnotatedTypeMirror getAnnotatedTypeFromTypeTree(Tree tree) {
        if (tree == null) {
            throw new IllegalArgumentException("null tree");
        }
        AnnotatedTypeMirror type = this.fromTypeTree(tree);
        this.annotateImplicit(tree, type);
        return type;
    }

    public AnnotatedTypeMirror fromElement(Element elt) {
        AnnotatedTypeMirror type;
        if (this.elementCache.containsKey(elt)) {
            return this.atypes.deepCopy(this.elementCache.get(elt));
        }
        if (elt.getKind() == ElementKind.PACKAGE) {
            return this.toAnnotatedType(elt.asType());
        }
        Tree decl = this.declarationFromElement(elt);
        if (decl == null && this.indexTypes != null && this.indexTypes.containsKey(elt)) {
            type = this.indexTypes.get(elt);
        } else if (!(decl != null || this.indexTypes != null && this.indexTypes.containsKey(elt))) {
            type = this.toAnnotatedType(elt.asType());
            type.setElement(elt);
            TypeFromElement.annotate(type, elt);
            if (elt instanceof ExecutableElement || elt instanceof VariableElement) {
                this.annotateInheritedFromClass(type);
            }
        } else if (decl instanceof ClassTree) {
            type = this.fromClass((ClassTree)decl);
        } else if (decl instanceof VariableTree) {
            type = this.fromMember(decl);
        } else if (decl instanceof MethodTree) {
            type = this.fromMember(decl);
        } else {
            throw new AssertionError((Object)("Cannot be here " + (Object)((Object)decl.getKind()) + " " + elt));
        }
        if (this.indexTypes != null) {
            this.elementCache.put(elt, this.atypes.deepCopy(type));
        }
        return type;
    }

    public AnnotatedTypeMirror.AnnotatedDeclaredType fromClass(ClassTree tree) {
        AnnotatedTypeMirror.AnnotatedDeclaredType result = (AnnotatedTypeMirror.AnnotatedDeclaredType)this.fromTreeWithVisitor(TypeFromTree.TypeFromClass.INSTANCE, tree);
        return result;
    }

    public AnnotatedTypeMirror fromMember(Tree tree) {
        if (!(tree instanceof MethodTree) && !(tree instanceof VariableTree)) {
            throw new IllegalArgumentException("not a method or variable declaration");
        }
        if (this.fromTreeCache.containsKey(tree)) {
            return this.atypes.deepCopy(this.fromTreeCache.get(tree));
        }
        AnnotatedTypeMirror result = this.fromTreeWithVisitor(TypeFromTree.TypeFromMember.INSTANCE, tree);
        this.annotateInheritedFromClass(result);
        this.fromTreeCache.put(tree, this.atypes.deepCopy(result));
        return result;
    }

    public AnnotatedTypeMirror fromExpression(ExpressionTree tree) {
        if (this.fromTreeCache.containsKey(tree)) {
            return this.atypes.deepCopy(this.fromTreeCache.get(tree));
        }
        AnnotatedTypeMirror result = this.fromTreeWithVisitor(TypeFromTree.TypeFromExpression.INSTANCE, tree);
        this.annotateInheritedFromClass(result);
        this.fromTreeCache.put(tree, this.atypes.deepCopy(result));
        return result;
    }

    public AnnotatedTypeMirror fromTypeTree(Tree tree) {
        AnnotatedTypeMirror.AnnotatedDeclaredType dt;
        if (this.fromTreeCache.containsKey(tree)) {
            return this.atypes.deepCopy(this.fromTreeCache.get(tree));
        }
        AnnotatedTypeMirror result = this.fromTreeWithVisitor(TypeFromTree.TypeFromTypeTree.INSTANCE, tree);
        if (result.getKind() == TypeKind.DECLARED && (dt = (AnnotatedTypeMirror.AnnotatedDeclaredType)result).getTypeArguments().isEmpty() && !((TypeElement)dt.getUnderlyingType().asElement()).getTypeParameters().isEmpty()) {
            ArrayList<AnnotatedTypeMirror> typeArgs = new ArrayList<AnnotatedTypeMirror>();
            AnnotatedTypeMirror.AnnotatedDeclaredType declaration = this.fromElement((TypeElement)dt.getUnderlyingType().asElement());
            for (AnnotatedTypeMirror typeParam : declaration.getTypeArguments()) {
                AnnotatedTypeMirror.AnnotatedTypeVariable typeParamVar = (AnnotatedTypeMirror.AnnotatedTypeVariable)typeParam;
                AnnotatedTypeMirror upperBound = typeParamVar.getUpperBound();
                while (upperBound.getKind() == TypeKind.TYPEVAR) {
                    upperBound = ((AnnotatedTypeMirror.AnnotatedTypeVariable)upperBound).getUpperBound();
                }
                typeArgs.add(upperBound.getCopy(false));
            }
            dt.setTypeArguments(typeArgs);
        }
        this.annotateInheritedFromClass(result);
        this.fromTreeCache.put(tree, this.atypes.deepCopy(result));
        return result;
    }

    private AnnotatedTypeMirror fromTreeWithVisitor(TypeFromTree converter, Tree tree) {
        if (tree == null) {
            throw new IllegalArgumentException("null tree");
        }
        if (converter == null) {
            throw new IllegalArgumentException("null visitor");
        }
        AnnotatedTypeMirror result = (AnnotatedTypeMirror)converter.visit(tree, this);
        this.checkRep(result);
        return result;
    }

    protected void annotateImplicit(Tree tree, @Mutable AnnotatedTypeMirror type) {
    }

    protected void annotateImplicit(Element elt, @Mutable AnnotatedTypeMirror type) {
    }

    protected void postDirectSuperTypes(AnnotatedTypeMirror type, List<? extends AnnotatedTypeMirror> supertypes) {
        Set<AnnotationMirror> annotations = type.getAnnotations();
        for (AnnotatedTypeMirror annotatedTypeMirror : supertypes) {
            if (annotations.equals(annotatedTypeMirror.getAnnotations())) continue;
            annotatedTypeMirror.clearAnnotations();
            annotatedTypeMirror.addAnnotations(annotations);
        }
    }

    protected void postAsMemberOf(AnnotatedTypeMirror type, AnnotatedTypeMirror owner, Element element) {
        this.annotateImplicit(element, type);
    }

    protected void annotateInheritedFromClass(@Mutable AnnotatedTypeMirror type) {
        InheritedFromClassAnnotator.INSTANCE.visit(type, this);
    }

    protected AnnotatedTypeMirror.AnnotatedDeclaredType getImplicitReceiverType(Tree tree) {
        assert (tree.getKind() == Tree.Kind.IDENTIFIER || tree.getKind() == Tree.Kind.MEMBER_SELECT || tree.getKind() == Tree.Kind.METHOD_INVOCATION || tree.getKind() == Tree.Kind.NEW_CLASS);
        Element element = InternalUtils.symbol(tree);
        assert (element != null);
        if (ElementUtils.isStatic(element) || element.getKind() == ElementKind.PACKAGE) {
            return null;
        }
        if (this.isMostEnclosingThisDeref(tree)) {
            return this.getSelfType(tree);
        }
        TypeElement typeElt = ElementUtils.enclosingClass(element);
        if (typeElt == null) {
            throw new AssertionError((Object)("enclosingClass()=>null for element=" + element));
        }
        return this.getEnclosingType(typeElt, tree);
    }

    protected final boolean isMostEnclosingThisDeref(Tree tree) {
        Element element = InternalUtils.symbol(tree);
        if (element == null) {
            return true;
        }
        if (ElementUtils.isStatic(element)) {
            return false;
        }
        if (element.getKind() == ElementKind.LOCAL_VARIABLE || element.getKind() == ElementKind.PARAMETER) {
            return !ElementUtils.isStatic(element.getEnclosingElement());
        }
        if (this.isThisDereference(tree)) {
            return true;
        }
        TypeElement typeElt = ElementUtils.enclosingClass(element);
        ClassTree enclosingClass = this.visitorState.getClassTree();
        if (enclosingClass == null) {
            enclosingClass = TreeUtils.enclosingClass(this.getPath(tree));
        }
        return enclosingClass != null && this.isSubtype(TreeUtils.elementFromDeclaration(enclosingClass), typeElt);
    }

    private final boolean isThisDereference(Tree tree) {
        if (tree.getKind() != Tree.Kind.MEMBER_SELECT) {
            return false;
        }
        MemberSelectTree memSelTree = (MemberSelectTree)tree;
        return memSelTree.getExpression().getKind() == Tree.Kind.IDENTIFIER && ((IdentifierTree)memSelTree.getExpression()).getName().contentEquals("this");
    }

    public AnnotatedTypeMirror.AnnotatedDeclaredType getSelfType(Tree tree) {
        AnnotatedTypeMirror.AnnotatedDeclaredType type = this.getCurrentClassType(tree);
        AnnotatedTypeMirror.AnnotatedDeclaredType methodReceiver = this.getCurrentMethodReceiver(tree);
        if (methodReceiver != null) {
            type.clearAnnotations();
            type.addAnnotations(methodReceiver.getAnnotations());
        }
        return type;
    }

    public AnnotatedTypeMirror.AnnotatedDeclaredType getEnclosingType(TypeElement element, Tree tree) {
        for (Element enclosingElt = this.getMostInnerClassOrMethod(tree); enclosingElt != null; enclosingElt = enclosingElt.getEnclosingElement()) {
            if (enclosingElt instanceof ExecutableElement) {
                ExecutableElement method = (ExecutableElement)enclosingElt;
                if (method.asType() == null || !this.isSubtype((TypeElement)method.getEnclosingElement(), element)) continue;
                if (ElementUtils.isStatic(method)) {
                    return null;
                }
                return this.getAnnotatedType(method).getReceiverType();
            }
            if (!(enclosingElt instanceof TypeElement) || !this.isSubtype((TypeElement)enclosingElt, element)) continue;
            return this.getAnnotatedType(element);
        }
        return null;
    }

    private boolean isSubtype(TypeElement a1, TypeElement a2) {
        return a1.equals(a2) || this.types.isSubtype(this.types.erasure(a1.asType()), this.types.erasure(a2.asType()));
    }

    public final AnnotatedTypeMirror getReceiver(ExpressionTree expression) {
        if (expression.getKind() != Tree.Kind.METHOD_INVOCATION && expression.getKind() != Tree.Kind.MEMBER_SELECT && expression.getKind() != Tree.Kind.IDENTIFIER && expression.getKind() != Tree.Kind.ARRAY_ACCESS) {
            return null;
        }
        if (expression.getKind() == Tree.Kind.IDENTIFIER && "this".equals(expression.toString())) {
            return null;
        }
        ExpressionTree receiver = TreeUtils.skipParens(expression);
        if (receiver.getKind() == Tree.Kind.ARRAY_ACCESS) {
            return this.getAnnotatedType(((ArrayAccessTree)receiver).getExpression());
        }
        Element elem = InternalUtils.symbol(expression);
        if (elem == null || ElementUtils.isStatic(elem)) {
            return null;
        }
        if (expression.getKind() == Tree.Kind.MEMBER_SELECT && ((MemberSelectTree)expression).getExpression() instanceof PrimitiveTypeTree) {
            return null;
        }
        if (TreeUtils.isSelfAccess(expression)) {
            return this.getImplicitReceiverType(expression);
        }
        if (receiver.getKind() == Tree.Kind.METHOD_INVOCATION) {
            receiver = ((MethodInvocationTree)receiver).getMethodSelect();
        }
        receiver = TreeUtils.skipParens(receiver);
        assert (receiver.getKind() == Tree.Kind.MEMBER_SELECT);
        if (receiver.getKind() == Tree.Kind.MEMBER_SELECT) {
            receiver = ((MemberSelectTree)receiver).getExpression();
        }
        return this.getAnnotatedType(receiver);
    }

    public AnnotatedTypeMirror.AnnotatedExecutableType methodFromUse(MethodInvocationTree tree) {
        ExecutableElement methodElt = TreeUtils.elementFromUse(tree);
        AnnotatedTypeMirror type = this.getReceiver(tree);
        AnnotatedTypeMirror methodType = this.atypes.asMemberOf(type, methodElt);
        Map<AnnotatedTypeMirror.AnnotatedTypeVariable, AnnotatedTypeMirror> typeVarMapping = this.atypes.findTypeArguments(tree);
        if (!typeVarMapping.isEmpty()) {
            methodType = methodType.substitute(typeVarMapping);
        }
        return methodType;
    }

    public AnnotatedTypeMirror.AnnotatedExecutableType constructorFromUse(NewClassTree tree) {
        ExecutableElement ctor = InternalUtils.constructor(tree);
        AnnotatedTypeMirror.AnnotatedDeclaredType type = this.fromNewClass(tree);
        this.annotateImplicit(tree.getIdentifier(), (AnnotatedTypeMirror)type);
        AnnotatedTypeMirror.AnnotatedExecutableType con = this.atypes.asMemberOf((AnnotatedTypeMirror)type, ctor);
        if (tree.getArguments().size() == con.getParameterTypes().size() + 1 && this.isSyntheticArgument(tree.getArguments().get(0))) {
            ArrayList<AnnotatedTypeMirror> actualParams = new ArrayList<AnnotatedTypeMirror>();
            actualParams.add(this.getAnnotatedType(tree.getArguments().get(0)));
            actualParams.addAll(con.getParameterTypes());
            con.setParameterTypes(actualParams);
        }
        return con;
    }

    private boolean isSyntheticArgument(Tree tree) {
        return tree.toString().contains("<*nullchk*>");
    }

    public AnnotatedTypeMirror.AnnotatedDeclaredType fromNewClass(NewClassTree tree) {
        if (!TreeUtils.isDiamondTree(tree)) {
            return (AnnotatedTypeMirror.AnnotatedDeclaredType)this.fromTypeTree(tree.getIdentifier());
        }
        AnnotatedTypeMirror.AnnotatedDeclaredType type = (AnnotatedTypeMirror.AnnotatedDeclaredType)this.toAnnotatedType(((JCTree)((Object)tree)).type);
        if (tree.getIdentifier().getKind() == Tree.Kind.ANNOTATED_TYPE) {
            type.addAnnotations(InternalUtils.annotationsFromTree((AnnotatedTypeTree)((Object)tree)));
        }
        return type;
    }

    public AnnotatedTypeMirror.AnnotatedDeclaredType getBoxedType(AnnotatedTypeMirror.AnnotatedPrimitiveType type) {
        TypeElement typeElt = this.types.boxedClass(type.getUnderlyingType());
        AnnotatedTypeMirror.AnnotatedDeclaredType dt = this.fromElement(typeElt);
        dt.addAnnotations(type.getAnnotations());
        return dt;
    }

    public AnnotatedTypeMirror.AnnotatedPrimitiveType getUnboxedType(AnnotatedTypeMirror.AnnotatedDeclaredType type) throws IllegalArgumentException {
        PrimitiveType primitiveType = this.env.getTypeUtils().unboxedType(type.getUnderlyingType());
        AnnotatedTypeMirror.AnnotatedPrimitiveType pt = (AnnotatedTypeMirror.AnnotatedPrimitiveType)AnnotatedTypeMirror.createType(primitiveType, this.env, this);
        pt.addAnnotations(type.getAnnotations());
        return pt;
    }

    public VisitorState getVisitorState() {
        return this.visitorState;
    }

    public final AnnotatedTypeMirror.AnnotatedDeclaredType getAnnotatedType(ClassTree tree) {
        return (AnnotatedTypeMirror.AnnotatedDeclaredType)this.getAnnotatedType((Tree)tree);
    }

    public final AnnotatedTypeMirror.AnnotatedDeclaredType getAnnotatedType(NewClassTree tree) {
        return (AnnotatedTypeMirror.AnnotatedDeclaredType)this.getAnnotatedType((Tree)tree);
    }

    public final AnnotatedTypeMirror.AnnotatedArrayType getAnnotatedType(NewArrayTree tree) {
        return (AnnotatedTypeMirror.AnnotatedArrayType)this.getAnnotatedType((Tree)tree);
    }

    public final AnnotatedTypeMirror.AnnotatedExecutableType getAnnotatedType(MethodTree tree) {
        return (AnnotatedTypeMirror.AnnotatedExecutableType)this.getAnnotatedType((Tree)tree);
    }

    public final AnnotatedTypeMirror getAnnotatedType(VariableTree tree) {
        return this.getAnnotatedType((Tree)tree);
    }

    public final AnnotatedTypeMirror getAnnotatedType(ExpressionTree tree) {
        return this.getAnnotatedType((Tree)tree);
    }

    public final AnnotatedTypeMirror.AnnotatedDeclaredType getAnnotatedType(TypeElement elt) {
        return (AnnotatedTypeMirror.AnnotatedDeclaredType)this.getAnnotatedType((Element)elt);
    }

    public final AnnotatedTypeMirror.AnnotatedExecutableType getAnnotatedType(ExecutableElement elt) {
        return (AnnotatedTypeMirror.AnnotatedExecutableType)this.getAnnotatedType((Element)elt);
    }

    public final AnnotatedTypeMirror.AnnotatedDeclaredType fromElement(TypeElement elt) {
        return (AnnotatedTypeMirror.AnnotatedDeclaredType)this.fromElement((Element)elt);
    }

    public final AnnotatedTypeMirror.AnnotatedExecutableType fromElement(ExecutableElement elt) {
        return (AnnotatedTypeMirror.AnnotatedExecutableType)this.fromElement((Element)elt);
    }

    private Set<Name> getSupportedQualifiers() {
        if (this.qualHierarchy != null) {
            return this.qualHierarchy.getTypeQualifiers();
        }
        return Collections.emptySet();
    }

    boolean isSupportedQualifier(AnnotationMirror a) {
        if (this.supportedQuals.isEmpty()) {
            TypeElement elt = (TypeElement)a.getAnnotationType().asElement();
            Retention retention = elt.getAnnotation(Retention.class);
            return retention == null || retention.value() != RetentionPolicy.SOURCE;
        }
        Name name = AnnotationUtils.annotationName(a);
        return this.supportedQuals.contains(name);
    }

    protected void addAliasedAnnotation(Class<?> clazz, AnnotationMirror type) {
        this.aliases.put(clazz.getCanonicalName(), type);
    }

    protected AnnotationMirror aliasedAnnotation(AnnotationMirror a) {
        TypeElement elem = (TypeElement)a.getAnnotationType().asElement();
        String qualName = elem.getQualifiedName().toString();
        return this.aliases.get(qualName);
    }

    public final AnnotatedTypeMirror toAnnotatedType(TypeMirror t) {
        return AnnotatedTypeMirror.createType(t, this.env, this);
    }

    AnnotatedTypeMirror type(Tree node) {
        if (((JCTree)node).type != null) {
            AnnotatedTypeMirror result = this.toAnnotatedType(((JCTree)node).type);
            return result;
        }
        TreePath path = this.getPath(node);
        assert (path != null) : "no path or type in tree";
        TypeMirror t = this.trees.getTypeMirror(path);
        assert (AnnotatedTypeFactory.validType(t)) : node + " --> " + t;
        return this.toAnnotatedType(t);
    }

    protected Collection<AnnotationMirror> unify(Collection<AnnotationMirror> c1, Collection<AnnotationMirror> c2) {
        if (this.qualHierarchy == null) {
            Set<AnnotationMirror> intersection = AnnotationUtils.createAnnotationSet();
            intersection.addAll(c1);
            intersection.retainAll(c2);
            return intersection;
        }
        return this.qualHierarchy.leastUpperBound(c1, c2);
    }

    public QualifierHierarchy getQualifierHierarchy() {
        return this.qualHierarchy;
    }

    protected final Tree declarationFromElement(Element elt) {
        Tree fromElt;
        if (this.root == null) {
            return null;
        }
        if (this.elementToTreeCache.containsKey(elt)) {
            return this.elementToTreeCache.get(elt);
        }
        switch (elt.getKind()) {
            case CLASS: 
            case ENUM: 
            case INTERFACE: 
            case ANNOTATION_TYPE: 
            case FIELD: 
            case ENUM_CONSTANT: 
            case METHOD: 
            case CONSTRUCTOR: {
                fromElt = this.trees.getTree(elt);
                break;
            }
            default: {
                fromElt = TreeInfo.declarationFor((Symbol)elt, (JCTree)((Object)this.root));
            }
        }
        this.elementToTreeCache.put(elt, fromElt);
        return fromElt;
    }

    protected final AnnotatedTypeMirror.AnnotatedDeclaredType getCurrentClassType(Tree tree) {
        if (this.visitorState.getClassType() != null) {
            return this.visitorState.getClassType();
        }
        ClassTree enclosingClass = TreeUtils.enclosingClass(this.getPath(tree));
        return this.getAnnotatedType(enclosingClass);
    }

    protected final AnnotatedTypeMirror.AnnotatedDeclaredType getCurrentMethodReceiver(Tree tree) {
        if (this.visitorState.getClassType() != null) {
            return this.visitorState.getMethodReceiver();
        }
        MethodTree enclosingMethod = TreeUtils.enclosingMethod(this.getPath(tree));
        if (enclosingMethod == null) {
            return null;
        }
        AnnotatedTypeMirror.AnnotatedExecutableType method = this.getAnnotatedType(enclosingMethod);
        return method.getReceiverType();
    }

    protected final boolean isWithinConstructor(Tree tree) {
        if (this.visitorState.getClassType() != null) {
            return this.visitorState.getMethodTree() != null && TreeUtils.isConstructor(this.visitorState.getMethodTree());
        }
        MethodTree enclosingMethod = TreeUtils.enclosingMethod(this.getPath(tree));
        return enclosingMethod != null && TreeUtils.isConstructor(enclosingMethod);
    }

    private final Element getMostInnerClassOrMethod(Tree tree) {
        if (this.visitorState.getMethodTree() != null) {
            return TreeUtils.elementFromDeclaration(this.visitorState.getMethodTree());
        }
        if (this.visitorState.getClassTree() != null) {
            return TreeUtils.elementFromDeclaration(this.visitorState.getClassTree());
        }
        TreePath path = this.getPath(tree);
        if (path == null) {
            throw new AssertionError((Object)String.format("getPath(tree)=>null%n  TreePath.getPath(root, tree)=>%s\n  for tree (%s) = %s%n  root=%s", TreePath.getPath(this.root, tree), tree.getClass(), tree, this.root));
        }
        for (Tree pathTree : path) {
            if (pathTree instanceof MethodTree) {
                return TreeUtils.elementFromDeclaration((MethodTree)pathTree);
            }
            if (!(pathTree instanceof ClassTree)) continue;
            return TreeUtils.elementFromDeclaration((ClassTree)pathTree);
        }
        throw new AssertionError((Object)"Cannot be here!");
    }

    public final TreePath getPath(Tree node) {
        assert (this.root != null) : "root needs to be set when used on trees";
        if (node == null) {
            return null;
        }
        TreePath currentPath = this.visitorState.getPath();
        if (currentPath == null) {
            return TreePath.getPath(this.root, node);
        }
        if (currentPath.getLeaf() == node) {
            return currentPath;
        }
        if (currentPath.getParentPath() != null) {
            currentPath = currentPath.getParentPath();
        }
        if (currentPath.getLeaf() == node) {
            return currentPath;
        }
        if (currentPath.getParentPath() != null) {
            currentPath = currentPath.getParentPath();
        }
        if (currentPath.getLeaf() == node) {
            return currentPath;
        }
        TreePath pathWithinSubtree = TreePath.getPath(currentPath, node);
        if (pathWithinSubtree != null) {
            return pathWithinSubtree;
        }
        for (TreePath current = currentPath; current != null; current = current.getParentPath()) {
            if (current.getLeaf() != node) continue;
            return current;
        }
        return TreePath.getPath(this.root, node);
    }

    private void checkRep(AnnotatedTypeMirror type) {
        new AnnotatedTypeScanner<Void, Void>(){

            @Override
            public Void visitDeclared(AnnotatedTypeMirror.AnnotatedDeclaredType type, Void p) {
                return (Void)super.visitDeclared(type, p);
            }

            @Override
            public Void visitExecutable(AnnotatedTypeMirror.AnnotatedExecutableType type, Void p) {
                assert (type.getElement() != null);
                return (Void)super.visitExecutable(type, p);
            }
        }.visit(type);
    }

    static final boolean validAnnotatedType(AnnotatedTypeMirror type) {
        if (type == null) {
            return false;
        }
        if (type.getUnderlyingType() == null) {
            return true;
        }
        return AnnotatedTypeFactory.validType(type.getUnderlyingType());
    }

    private static final boolean validType(TypeMirror type) {
        if (type == null) {
            return false;
        }
        switch (type.getKind()) {
            case ERROR: 
            case OTHER: 
            case PACKAGE: {
                return false;
            }
        }
        return true;
    }

    protected static <K, V> Map<K, V> createLRUCache(final int size) {
        return new LinkedHashMap<K, V>(){
            private static final long serialVersionUID = 5261489276168775084L;

            @Override
            protected boolean removeEldestEntry(Map.Entry<K, V> entry) {
                return this.size() > size;
            }
        };
    }

    private Map<Element, AnnotatedTypeMirror> buildIndexTypes() {
        String[] stubArray;
        String stubFiles;
        HashMap<Element, AnnotatedTypeMirror> result = new HashMap<Element, AnnotatedTypeMirror>();
        InputStream in = null;
        if (this.checkerClass != null) {
            in = this.checkerClass.getResourceAsStream("jdk.astub");
        }
        if (in != null) {
            StubParser stubParser = new StubParser("jdk.astub", in, this, this.env);
            stubParser.parse(result);
        }
        if ((stubFiles = this.env.getOptions().get("stubs")) == null) {
            stubFiles = System.getProperty("stubs");
        }
        if (stubFiles == null) {
            stubFiles = System.getenv("stubs");
        }
        if (stubFiles == null) {
            return result;
        }
        for (String stubPath : stubArray = stubFiles.split(File.pathSeparator)) {
            try {
                String base = System.getProperty("test.src");
                if (base != null) {
                    stubPath = base + "/" + stubPath;
                }
                List<File> stubs = StubUtil.allStubFiles(stubPath);
                for (File f : stubs) {
                    FileInputStream stubStream = new FileInputStream(f);
                    StubParser stubParser = new StubParser(f.getAbsolutePath(), stubStream, this, this.env);
                    stubParser.parse(result);
                }
            }
            catch (FileNotFoundException e) {
                System.err.println("Couldn't find stub file named: " + stubPath);
            }
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class InheritedFromClassAnnotator
    extends AnnotatedTypeScanner<Void, AnnotatedTypeFactory> {
        public static final InheritedFromClassAnnotator INSTANCE = new InheritedFromClassAnnotator();

        private InheritedFromClassAnnotator() {
        }

        @Override
        public Void visitExecutable(AnnotatedTypeMirror.AnnotatedExecutableType type, AnnotatedTypeFactory p) {
            this.scan(type.getReturnType(), p);
            this.scanAndReduce(type.getParameterTypes(), p, null);
            this.scanAndReduce(type.getThrownTypes(), p, null);
            this.scanAndReduce(type.getTypeVariables(), p, null);
            return null;
        }

        @Override
        public Void visitDeclared(AnnotatedTypeMirror.AnnotatedDeclaredType type, AnnotatedTypeFactory p) {
            Element classElt = type.getUnderlyingType().asElement();
            if (classElt != null && !type.isAnnotated()) {
                AnnotatedTypeMirror classType = p.fromElement(classElt);
                assert (classType != null);
                for (AnnotationMirror anno : classType.getAnnotations()) {
                    if (!AnnotationUtils.hasInheritiedMeta(anno)) continue;
                    type.addAnnotation(anno);
                }
            }
            return (Void)super.visitDeclared(type, p);
        }
    }
}

