/*
 * Decompiled with CFR 0.152.
 */
package checkers.types;

import checkers.nullness.quals.NonNull;
import checkers.types.AnnotatedTypeFactory;
import checkers.types.TypeFromElement;
import checkers.types.visitors.AnnotatedTypeScanner;
import checkers.types.visitors.AnnotatedTypeVisitor;
import checkers.types.visitors.SimpleAnnotatedTypeVisitor;
import checkers.util.AnnotationUtils;
import checkers.util.ElementUtils;
import checkers.util.TreeUtils;
import checkers.util.TypesUtils;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.Tree;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.NullType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AnnotatedTypeMirror {
    protected final ProcessingEnvironment env;
    protected final AnnotationUtils annotationFactory;
    protected final AnnotatedTypeFactory typeFactory;
    protected final TypeMirror actualType;
    protected Element element;
    protected AnnotatedTypeMirror enclosingType;
    protected final Set<AnnotationMirror> annotations = AnnotationUtils.createAnnotationSet();
    private static int uidCounter = 0;
    public int uid;
    private static SuperTypeFinder superTypeFinder;
    private static AnnotatedTypeScanner<Void, Map<TypeParameterElement, AnnotatedTypeMirror>> replacer;

    public static AnnotatedTypeMirror createType(TypeMirror type, ProcessingEnvironment env, AnnotatedTypeFactory typeFactory) {
        if (type == null) {
            return null;
        }
        if (replacer == null) {
            replacer = new Replacer(typeFactory.types);
        }
        switch (type.getKind()) {
            case ARRAY: {
                return new AnnotatedArrayType((ArrayType)type, env, typeFactory);
            }
            case DECLARED: {
                return new AnnotatedDeclaredType((DeclaredType)type, env, typeFactory);
            }
            case ERROR: {
                throw new AssertionError((Object)"Input should type-checked already...");
            }
            case EXECUTABLE: {
                return new AnnotatedExecutableType((ExecutableType)type, env, typeFactory);
            }
            case VOID: 
            case PACKAGE: 
            case NONE: {
                return new AnnotatedNoType((NoType)type, env, typeFactory);
            }
            case NULL: {
                return new AnnotatedNullType((NullType)type, env, typeFactory);
            }
            case TYPEVAR: {
                AnnotatedTypeVariable atype = new AnnotatedTypeVariable((TypeVariable)type, env, typeFactory);
                return atype;
            }
            case WILDCARD: {
                AnnotatedWildcardType atype = new AnnotatedWildcardType((WildcardType)type, env, typeFactory);
                return atype;
            }
        }
        if (type.getKind().isPrimitive()) {
            return new AnnotatedPrimitiveType((PrimitiveType)type, env, typeFactory);
        }
        throw new AssertionError((Object)("Unidentified type " + type));
    }

    public List<? extends AnnotatedTypeMirror> directSuperTypes() {
        return this.directSuperTypes(this);
    }

    private AnnotatedTypeMirror(TypeMirror type, ProcessingEnvironment env, AnnotatedTypeFactory typeFactory) {
        this.actualType = type;
        this.env = env;
        this.annotationFactory = AnnotationUtils.getInstance(env);
        assert (typeFactory != null);
        this.typeFactory = typeFactory;
        this.uid = ++uidCounter;
    }

    public boolean equals(Object o) {
        if (!(o instanceof AnnotatedTypeMirror)) {
            return false;
        }
        AnnotatedTypeMirror t = (AnnotatedTypeMirror)o;
        return this.env.getTypeUtils().isSameType(this.actualType, t.actualType) && AnnotationUtils.areSame(this.getAnnotations(), t.getAnnotations());
    }

    public int hashCode() {
        return this.annotations.toString().hashCode() * 17 + this.actualType.toString().hashCode() * 13;
    }

    public abstract <R, P> R accept(AnnotatedTypeVisitor<R, P> var1, P var2);

    public TypeKind getKind() {
        return this.actualType.getKind();
    }

    public TypeMirror getUnderlyingType() {
        return this.actualType;
    }

    void setEnclosingType(AnnotatedTypeMirror enclosingType) {
        this.enclosingType = enclosingType;
    }

    public AnnotatedTypeMirror getEnclosingType() {
        return this.enclosingType;
    }

    public boolean isAnnotated() {
        return !this.annotations.isEmpty();
    }

    public Set<AnnotationMirror> getAnnotations() {
        return Collections.unmodifiableSet(this.annotations);
    }

    public AnnotationMirror getAnnotation(String annotationName) {
        assert (annotationName != null) : annotationName + " cannot be null";
        Name name = this.env.getElementUtils().getName(annotationName);
        return this.getAnnotation(name);
    }

    public AnnotationMirror getAnnotation(Name annotationName) {
        assert (annotationName != null) : annotationName + " cannot be null";
        for (AnnotationMirror anno : this.getAnnotations()) {
            if (!AnnotationUtils.annotationName(anno).equals(annotationName)) continue;
            return anno;
        }
        return null;
    }

    public AnnotationMirror getAnnotation(Class<? extends Annotation> anno) {
        return this.getAnnotation(anno.getCanonicalName());
    }

    public boolean hasAnnotation(AnnotationMirror a) {
        return this.getAnnotations().contains(a);
    }

    public boolean hasAnnotation(Class<? extends Annotation> a) {
        return this.getAnnotation(a) != null;
    }

    public void addAnnotation(AnnotationMirror a) {
        if (a == null) {
            return;
        }
        if (this.typeFactory.isSupportedQualifier(a)) {
            this.annotations.add(a);
        } else {
            AnnotationMirror aliased = this.typeFactory.aliasedAnnotation(a);
            this.addAnnotation(aliased);
        }
    }

    public void addAnnotation(Class<? extends Annotation> a) {
        AnnotationMirror anno = this.annotationFactory.fromClass(a);
        this.addAnnotation(anno);
    }

    public void addAnnotations(Iterable<? extends AnnotationMirror> annotations) {
        for (AnnotationMirror annotationMirror : annotations) {
            this.addAnnotation(annotationMirror);
        }
    }

    public boolean removeAnnotation(AnnotationMirror a) {
        return this.annotations.remove(this.getAnnotation(AnnotationUtils.annotationName(a)));
    }

    public boolean removeAnnotation(Class<? extends Annotation> a) {
        return this.removeAnnotation(this.annotationFactory.fromClass(a));
    }

    public boolean removeAnnotations(Iterable<? extends AnnotationMirror> annotations) {
        boolean changed = false;
        for (AnnotationMirror annotationMirror : annotations) {
            changed |= this.removeAnnotation(annotationMirror);
        }
        return changed;
    }

    public void clearAnnotations() {
        this.annotations.clear();
    }

    protected static final String formatAnnotationString(Collection<? extends AnnotationMirror> lst) {
        StringBuilder sb = new StringBuilder();
        for (AnnotationMirror annotationMirror : lst) {
            if (!annotationMirror.getElementValues().isEmpty()) {
                sb.append(annotationMirror.toString());
                sb.append(" ");
                continue;
            }
            sb.append("@");
            sb.append(annotationMirror.getAnnotationType().asElement().getSimpleName());
            sb.append(" ");
        }
        return sb.toString();
    }

    public String toString() {
        return AnnotatedTypeMirror.formatAnnotationString(this.getAnnotations()) + this.actualType;
    }

    public String toStringDebug() {
        return this.toString() + " " + this.getClass().getSimpleName() + "#" + this.uid;
    }

    void setElement(Element elem) {
        this.element = elem;
    }

    public Element getElement() {
        return this.element;
    }

    public AnnotatedTypeMirror getErased() {
        return this;
    }

    protected AnnotatedTypeMirror copyFields(AnnotatedTypeMirror type, boolean annotation) {
        type.setElement(this.getElement());
        type.setEnclosingType(this.getEnclosingType());
        if (annotation) {
            type.addAnnotations(this.annotations);
        }
        return type;
    }

    public abstract AnnotatedTypeMirror getCopy(boolean var1);

    protected static AnnotatedDeclaredType createTypeOfObject(AnnotatedTypeFactory typeFactory) {
        AnnotatedDeclaredType objectType = typeFactory.fromElement(typeFactory.elements.getTypeElement(Object.class.getCanonicalName()));
        return objectType;
    }

    public AnnotatedTypeMirror substitute(Map<? extends AnnotatedTypeMirror, ? extends AnnotatedTypeMirror> mappings) {
        if (mappings.containsKey(this)) {
            return mappings.get(this).getCopy(true);
        }
        return this.getCopy(true);
    }

    protected final List<AnnotatedDeclaredType> directSuperTypes(AnnotatedDeclaredType type) {
        AnnotatedTypeMirror.setSuperTypeFinder(type.typeFactory);
        List<AnnotatedDeclaredType> supertypes = superTypeFinder.visitDeclared(type, null);
        this.typeFactory.postDirectSuperTypes(type, supertypes);
        return supertypes;
    }

    private final List<? extends AnnotatedTypeMirror> directSuperTypes(AnnotatedTypeMirror type) {
        AnnotatedTypeMirror.setSuperTypeFinder(type.typeFactory);
        List supertypes = (List)superTypeFinder.visit(type, null);
        this.typeFactory.postDirectSuperTypes(type, supertypes);
        return supertypes;
    }

    private static void setSuperTypeFinder(AnnotatedTypeFactory factory) {
        if (superTypeFinder == null || superTypeFinder.typeFactory != factory) {
            superTypeFinder = new SuperTypeFinder(factory);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Replacer
    extends AnnotatedTypeScanner<Void, Map<TypeParameterElement, AnnotatedTypeMirror>> {
        final Types types;

        public Replacer(Types types) {
            this.types = types;
        }

        @Override
        public Void visitDeclared(AnnotatedDeclaredType type, Map<TypeParameterElement, AnnotatedTypeMirror> mapping) {
            ArrayList<AnnotatedTypeMirror> args = new ArrayList<AnnotatedTypeMirror>();
            for (AnnotatedTypeMirror arg : type.getTypeArguments()) {
                Element elem = this.types.asElement(arg.getUnderlyingType());
                if (elem != null && elem.getKind() == ElementKind.TYPE_PARAMETER && mapping.containsKey(elem)) {
                    AnnotatedTypeMirror other = mapping.get(elem);
                    if (!arg.annotations.isEmpty()) {
                        other.clearAnnotations();
                        other.addAnnotations(arg.annotations);
                    }
                    args.add(other);
                    continue;
                }
                args.add(arg);
            }
            type.setTypeArguments(args);
            return (Void)super.visitDeclared(type, mapping);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SuperTypeFinder
    extends SimpleAnnotatedTypeVisitor<List<? extends AnnotatedTypeMirror>, Void> {
        private Types types;
        private final AnnotatedTypeFactory typeFactory;

        SuperTypeFinder(AnnotatedTypeFactory typeFactory) {
            this.typeFactory = typeFactory;
            this.types = typeFactory.env.getTypeUtils();
        }

        @Override
        public List<AnnotatedTypeMirror> defaultAction(AnnotatedTypeMirror t, Void p) {
            return new ArrayList<AnnotatedTypeMirror>();
        }

        @Override
        public List<AnnotatedTypeMirror> visitPrimitive(AnnotatedPrimitiveType type, Void p) {
            ArrayList<AnnotatedTypeMirror> superTypes = new ArrayList<AnnotatedTypeMirror>();
            Set<AnnotationMirror> annotations = type.getAnnotations();
            TypeElement boxed = this.types.boxedClass(type.getUnderlyingType());
            AnnotatedDeclaredType boxedType = this.typeFactory.getAnnotatedType(boxed);
            if (!annotations.isEmpty()) {
                boxedType.clearAnnotations();
            }
            boxedType.addAnnotations(annotations);
            superTypes.add(boxedType);
            TypeKind superPrimitiveType = null;
            if (type.getKind() != TypeKind.BOOLEAN) {
                if (type.getKind() == TypeKind.BYTE) {
                    superPrimitiveType = TypeKind.SHORT;
                } else if (type.getKind() == TypeKind.CHAR) {
                    superPrimitiveType = TypeKind.INT;
                } else if (type.getKind() != TypeKind.DOUBLE) {
                    if (type.getKind() == TypeKind.FLOAT) {
                        superPrimitiveType = TypeKind.DOUBLE;
                    } else if (type.getKind() == TypeKind.INT) {
                        superPrimitiveType = TypeKind.LONG;
                    } else if (type.getKind() == TypeKind.LONG) {
                        superPrimitiveType = TypeKind.FLOAT;
                    } else if (type.getKind() == TypeKind.SHORT) {
                        superPrimitiveType = TypeKind.INT;
                    } else assert (false) : "Forgot the primitive " + type;
                }
            }
            if (superPrimitiveType != null) {
                AnnotatedPrimitiveType superPrimitive = (AnnotatedPrimitiveType)this.typeFactory.toAnnotatedType(this.types.getPrimitiveType(superPrimitiveType));
                superPrimitive.addAnnotations(annotations);
                superTypes.add(superPrimitive);
            }
            return superTypes;
        }

        @Override
        public List<AnnotatedDeclaredType> visitDeclared(AnnotatedDeclaredType type, Void p) {
            ArrayList<AnnotatedDeclaredType> supertypes = new ArrayList<AnnotatedDeclaredType>();
            Set<AnnotationMirror> annotations = type.getAnnotations();
            TypeElement typeElement = (TypeElement)type.getUnderlyingType().asElement();
            HashMap<TypeParameterElement, AnnotatedTypeMirror> mapping = new HashMap<TypeParameterElement, AnnotatedTypeMirror>();
            boolean isRaw = !type.isParameterized() && type.isGeneric();
            for (int i = 0; i < typeElement.getTypeParameters().size() && i < type.getTypeArguments().size(); ++i) {
                mapping.put(typeElement.getTypeParameters().get(i), type.getTypeArguments().get(i));
            }
            ClassTree classTree = this.typeFactory.trees.getTree(typeElement);
            if (classTree != null) {
                supertypes.addAll(this.supertypesFromTree(classTree));
            } else {
                supertypes.addAll(this.supertypesFromElement(typeElement));
                Element elem = type.getElement() == null ? typeElement : type.getElement();
            }
            for (AnnotatedDeclaredType dt : supertypes) {
                if (isRaw) {
                    dt.setTypeArguments(Collections.emptyList());
                    continue;
                }
                if (mapping.isEmpty()) continue;
                replacer.visit(dt, mapping);
            }
            return supertypes;
        }

        private List<AnnotatedDeclaredType> supertypesFromElement(TypeElement typeElement) {
            ArrayList<AnnotatedDeclaredType> supertypes = new ArrayList<AnnotatedDeclaredType>();
            if (typeElement.getSuperclass().getKind() != TypeKind.NONE) {
                DeclaredType superClass = (DeclaredType)typeElement.getSuperclass();
                AnnotatedDeclaredType annotatedDeclaredType = (AnnotatedDeclaredType)this.typeFactory.toAnnotatedType(superClass);
                supertypes.add(annotatedDeclaredType);
            } else if (!ElementUtils.isObject(typeElement)) {
                supertypes.add(AnnotatedTypeMirror.createTypeOfObject(this.typeFactory));
            }
            for (TypeMirror typeMirror : typeElement.getInterfaces()) {
                AnnotatedDeclaredType ast = (AnnotatedDeclaredType)this.typeFactory.toAnnotatedType(typeMirror);
                supertypes.add(ast);
            }
            TypeFromElement.annotateSupers(supertypes, typeElement);
            return supertypes;
        }

        private List<AnnotatedDeclaredType> supertypesFromTree(ClassTree classTree) {
            AnnotatedDeclaredType adt;
            ArrayList<AnnotatedDeclaredType> supertypes = new ArrayList<AnnotatedDeclaredType>();
            if (classTree.getExtendsClause() != null) {
                AnnotatedDeclaredType adt2 = (AnnotatedDeclaredType)this.typeFactory.fromTypeTree(classTree.getExtendsClause());
                supertypes.add(adt2);
            } else if (!ElementUtils.isObject(TreeUtils.elementFromDeclaration(classTree))) {
                supertypes.add(AnnotatedTypeMirror.createTypeOfObject(this.typeFactory));
            }
            for (Tree tree : classTree.getImplementsClause()) {
                adt = (AnnotatedDeclaredType)this.typeFactory.getAnnotatedTypeFromTypeTree(tree);
                supertypes.add(adt);
            }
            TypeElement elem = TreeUtils.elementFromDeclaration(classTree);
            if (elem.getKind() == ElementKind.ENUM) {
                DeclaredType declaredType = (DeclaredType)elem.getSuperclass();
                adt = (AnnotatedDeclaredType)this.typeFactory.toAnnotatedType(declaredType);
                supertypes.add(adt);
            } else if (elem.getKind() == ElementKind.ANNOTATION_TYPE) {
                DeclaredType declaredType = (DeclaredType)this.typeFactory.elements.getTypeElement("java.lang.annotation.Annotation").asType();
                adt = (AnnotatedDeclaredType)this.typeFactory.toAnnotatedType(declaredType);
                supertypes.add(adt);
            }
            return supertypes;
        }

        @Override
        public List<AnnotatedTypeMirror> visitArray(AnnotatedArrayType type, Void p) {
            ArrayList<AnnotatedTypeMirror> superTypes = new ArrayList<AnnotatedTypeMirror>();
            Set<AnnotationMirror> annotations = type.getAnnotations();
            Elements elements = this.typeFactory.elements;
            AnnotatedDeclaredType objectType = this.typeFactory.getAnnotatedType(elements.getTypeElement("java.lang.Object"));
            objectType.addAnnotations(annotations);
            superTypes.add(objectType);
            AnnotatedDeclaredType cloneableType = this.typeFactory.getAnnotatedType(elements.getTypeElement("java.lang.Cloneable"));
            cloneableType.addAnnotations(annotations);
            superTypes.add(cloneableType);
            AnnotatedDeclaredType serializableType = this.typeFactory.getAnnotatedType(elements.getTypeElement("java.io.Serializable"));
            serializableType.addAnnotations(annotations);
            superTypes.add(serializableType);
            if (type.getComponentType() instanceof AnnotatedReferenceType) {
                for (AnnotatedTypeMirror annotatedTypeMirror : type.getComponentType().directSuperTypes()) {
                    ArrayType arrType = this.typeFactory.types.getArrayType(annotatedTypeMirror.getUnderlyingType());
                    AnnotatedArrayType aarrType = (AnnotatedArrayType)this.typeFactory.toAnnotatedType(arrType);
                    aarrType.setComponentType(annotatedTypeMirror);
                    aarrType.addAnnotations(annotations);
                    superTypes.add(aarrType);
                }
            }
            return superTypes;
        }

        @Override
        public List<AnnotatedTypeMirror> visitTypeVariable(AnnotatedTypeVariable type, Void p) {
            ArrayList<AnnotatedTypeMirror> superTypes = new ArrayList<AnnotatedTypeMirror>();
            if (type.getUpperBound() != null) {
                superTypes.add(type.getUpperBound());
            }
            return superTypes;
        }

        @Override
        public List<AnnotatedTypeMirror> visitWildcard(AnnotatedWildcardType type, Void p) {
            ArrayList<AnnotatedTypeMirror> superTypes = new ArrayList<AnnotatedTypeMirror>();
            if (type.getExtendsBound() != null) {
                superTypes.add(type.getExtendsBound());
            }
            return superTypes;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AnnotatedWildcardType
    extends AnnotatedTypeMirror {
        private AnnotatedTypeMirror superBound;
        private AnnotatedTypeMirror extendsBound;
        private final WildcardType actualType;
        boolean isPrintingBound = false;

        @Deprecated
        AnnotatedWildcardType(WildcardType type, ProcessingEnvironment env, AnnotatedTypeFactory factory) {
            super(type, env, factory);
            this.actualType = type;
        }

        void setSuperBound(AnnotatedTypeMirror type) {
            this.superBound = type;
        }

        public AnnotatedTypeMirror getSuperBound() {
            if (this.superBound == null && this.actualType.getSuperBound() != null) {
                this.setSuperBound(AnnotatedWildcardType.createType(this.actualType.getSuperBound(), this.env, this.typeFactory));
            }
            return this.superBound;
        }

        void setExtendsBound(AnnotatedTypeMirror type) {
            this.extendsBound = type;
        }

        public AnnotatedTypeMirror getExtendsBound() {
            if (this.extendsBound == null) {
                TypeMirror superType = this.actualType.getExtendsBound();
                if (superType == null) {
                    superType = this.env.getElementUtils().getTypeElement("java.lang.Object").asType();
                }
                this.setExtendsBound(AnnotatedWildcardType.createType(superType, this.env, this.typeFactory));
            }
            return this.extendsBound;
        }

        @Override
        public <R, P> R accept(AnnotatedTypeVisitor<R, P> v, P p) {
            return v.visitWildcard(this, p);
        }

        @Override
        public WildcardType getUnderlyingType() {
            return this.actualType;
        }

        @Override
        public AnnotatedWildcardType getCopy(boolean copyAnnotations) {
            AnnotatedWildcardType type = new AnnotatedWildcardType(this.actualType, this.env, this.typeFactory);
            this.copyFields(type, copyAnnotations);
            type.setExtendsBound(this.getExtendsBound());
            type.setSuperBound(this.getSuperBound());
            return type;
        }

        @Override
        public AnnotatedTypeMirror substitute(Map<? extends AnnotatedTypeMirror, ? extends AnnotatedTypeMirror> mappings) {
            if (mappings.containsKey(this)) {
                return mappings.get(this);
            }
            AnnotatedWildcardType type = this.getCopy(true);
            HashMap<? extends AnnotatedTypeMirror, ? extends AnnotatedTypeMirror> newMapping = new HashMap<AnnotatedTypeMirror, AnnotatedTypeMirror>(mappings);
            newMapping.put(this, type);
            if (this.getExtendsBound() != null) {
                type.setExtendsBound(this.getExtendsBound().substitute(newMapping));
            }
            if (this.getSuperBound() != null) {
                type.setSuperBound(this.getSuperBound().substitute(newMapping));
            }
            return type;
        }

        @Override
        public AnnotatedTypeMirror getErased() {
            if (this.getExtendsBound() != null) {
                return this.getExtendsBound().getErased();
            }
            return AnnotatedWildcardType.createTypeOfObject(this.typeFactory);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("?");
            if (!this.isPrintingBound) {
                try {
                    this.isPrintingBound = true;
                    if (this.getExtendsBound() != null && this.getExtendsBound().getKind() != TypeKind.NONE) {
                        sb.append(" extends ");
                        sb.append(this.getExtendsBound());
                    }
                    if (this.getSuperBound() != null && this.getSuperBound().getKind() != TypeKind.NULL) {
                        sb.append(" super ");
                        sb.append(this.getSuperBound());
                    }
                }
                finally {
                    this.isPrintingBound = false;
                }
            }
            return sb.toString();
        }

        @Override
        public boolean isAnnotated() {
            return super.isAnnotated() || this.getExtendsBound() != null && this.getExtendsBound().isAnnotated();
        }

        @Override
        public Set<AnnotationMirror> getAnnotations() {
            if (!super.isAnnotated() && this.getExtendsBound() != null) {
                return this.getExtendsBound().getAnnotations();
            }
            return super.getAnnotations();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AnnotatedPrimitiveType
    extends AnnotatedTypeMirror
    implements AnnotatedReferenceType {
        private final PrimitiveType actualType;

        AnnotatedPrimitiveType(PrimitiveType type, ProcessingEnvironment env, AnnotatedTypeFactory factory) {
            super(type, env, factory);
            this.actualType = type;
        }

        @Override
        public <R, P> R accept(AnnotatedTypeVisitor<R, P> v, P p) {
            return v.visitPrimitive(this, p);
        }

        @Override
        public PrimitiveType getUnderlyingType() {
            return this.actualType;
        }

        @Override
        public AnnotatedPrimitiveType getCopy(boolean copyAnnotations) {
            AnnotatedPrimitiveType type = new AnnotatedPrimitiveType(this.actualType, this.env, this.typeFactory);
            this.copyFields(type, copyAnnotations);
            return type;
        }

        @Override
        public AnnotatedTypeMirror substitute(Map<? extends AnnotatedTypeMirror, ? extends AnnotatedTypeMirror> mappings) {
            if (mappings.containsKey(this)) {
                return mappings.get(this);
            }
            return this.getCopy(true);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AnnotatedNullType
    extends AnnotatedTypeMirror
    implements AnnotatedReferenceType {
        private final NullType actualType;

        AnnotatedNullType(NullType type, ProcessingEnvironment env, AnnotatedTypeFactory factory) {
            super(type, env, factory);
            this.actualType = type;
        }

        @Override
        public <R, P> R accept(AnnotatedTypeVisitor<R, P> v, P p) {
            return v.visitNull(this, p);
        }

        @Override
        public NullType getUnderlyingType() {
            return this.actualType;
        }

        @Override
        public AnnotatedNullType getCopy(boolean copyAnnotations) {
            AnnotatedNullType type = new AnnotatedNullType(this.actualType, this.env, this.typeFactory);
            this.copyFields(type, copyAnnotations);
            return type;
        }

        @Override
        public AnnotatedTypeMirror substitute(Map<? extends AnnotatedTypeMirror, ? extends AnnotatedTypeMirror> mappings) {
            return this.getCopy(true);
        }

        @Override
        public String toString() {
            return "null";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AnnotatedNoType
    extends AnnotatedTypeMirror {
        private final NoType actualType;

        AnnotatedNoType(NoType type, ProcessingEnvironment env, AnnotatedTypeFactory factory) {
            super(type, env, factory);
            this.actualType = type;
        }

        @Override
        public <R, P> R accept(AnnotatedTypeVisitor<R, P> v, P p) {
            return v.visitNoType(this, p);
        }

        @Override
        public NoType getUnderlyingType() {
            return this.actualType;
        }

        @Override
        public AnnotatedNoType getCopy(boolean copyAnnotations) {
            AnnotatedNoType type = new AnnotatedNoType(this.actualType, this.env, this.typeFactory);
            this.copyFields(type, copyAnnotations);
            return type;
        }

        @Override
        public AnnotatedTypeMirror substitute(Map<? extends AnnotatedTypeMirror, ? extends AnnotatedTypeMirror> mappings) {
            return this.getCopy(true);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AnnotatedTypeVariable
    extends AnnotatedTypeMirror
    implements AnnotatedReferenceType {
        private final TypeVariable actualType;
        private Element typeVarElement;
        private AnnotatedTypeMirror lowerBound;
        private AnnotatedTypeMirror upperBound;
        boolean fixedupLowerBoundAnnotations = false;
        boolean isPrintingBound = false;

        @Deprecated
        AnnotatedTypeVariable(TypeVariable type, ProcessingEnvironment env, AnnotatedTypeFactory factory) {
            super(type, env, factory);
            this.actualType = type;
        }

        @Override
        public <R, P> R accept(AnnotatedTypeVisitor<R, P> v, P p) {
            return v.visitTypeVariable(this, p);
        }

        @Override
        public TypeVariable getUnderlyingType() {
            return this.actualType;
        }

        void setTypeVariableElement(Element element) {
            this.typeVarElement = element;
        }

        public Element getTypeVariableElement() {
            return this.typeVarElement;
        }

        void setLowerBound(AnnotatedTypeMirror type) {
            this.lowerBound = type;
        }

        public AnnotatedTypeMirror getLowerBound() {
            if (this.lowerBound == null && this.actualType.getLowerBound() != null) {
                this.setLowerBound(AnnotatedTypeVariable.createType(this.actualType.getLowerBound(), this.env, this.typeFactory));
            }
            return this.lowerBound;
        }

        public Set<AnnotationMirror> getLowerBoundAnnotations() {
            Set<AnnotationMirror> result = this.annotations;
            if (result.isEmpty()) {
                this.fixupLowerBoundAnnotations();
                AnnotatedTypeMirror lb = this.getLowerBound();
                if (lb != null) {
                    result = lb.getAnnotations();
                }
            }
            return Collections.unmodifiableSet(result);
        }

        private void fixupLowerBoundAnnotations() {
            Set<AnnotationMirror> uAnnos;
            Set<AnnotationMirror> lAnnos;
            if (this.fixedupLowerBoundAnnotations) {
                return;
            }
            this.fixedupLowerBoundAnnotations = true;
            if (this.actualType.getLowerBound() instanceof NullType && !this.typeFactory.qualHierarchy.isSubtype(lAnnos = this.getLowerBound().getAnnotations(), uAnnos = this.getUpperBound().getAnnotations())) {
                if (this.typeFactory.qualHierarchy.isSubtype(uAnnos, lAnnos)) {
                    this.lowerBound.clearAnnotations();
                    this.lowerBound.addAnnotations(uAnnos);
                } else {
                    throw new Error("Default annotation on lower bound is inconsistent with explicit upper bound: " + this);
                }
            }
        }

        void setUpperBound(AnnotatedTypeMirror type) {
            AnnotatedTypeMirror upperBound;
            this.upperBound = type;
            this.upperBound = upperBound = type.substitute(Collections.singletonMap(this, this));
        }

        public AnnotatedTypeMirror getUpperBound() {
            if (this.upperBound == null && this.actualType.getUpperBound() != null) {
                this.setUpperBound(AnnotatedTypeVariable.createType(this.actualType.getUpperBound(), this.env, this.typeFactory));
            }
            return this.upperBound;
        }

        public Set<AnnotationMirror> getUpperBoundAnnotations() {
            AnnotatedTypeMirror ub;
            Set<AnnotationMirror> result = this.annotations;
            if (result.isEmpty() && (ub = this.getUpperBound()) != null) {
                result = ub.getAnnotations();
            }
            return Collections.unmodifiableSet(result);
        }

        @Override
        public AnnotatedTypeVariable getCopy(boolean copyAnnotations) {
            AnnotatedTypeVariable type = new AnnotatedTypeVariable(this.actualType, this.env, this.typeFactory);
            this.copyFields(type, copyAnnotations);
            type.setTypeVariableElement(this.getTypeVariableElement());
            if (type.getUpperBound().isAnnotated()) {
                type.setUpperBound(this.getUpperBound());
            }
            return type;
        }

        @Override
        public AnnotatedTypeMirror getErased() {
            return this.getUpperBound().getErased();
        }

        private static <K extends AnnotatedTypeMirror, V extends AnnotatedTypeMirror> V mapGetHelper(Map<K, V> mappings, AnnotatedTypeVariable key) {
            for (Map.Entry<K, V> entry : mappings.entrySet()) {
                AnnotatedTypeMirror possible = (AnnotatedTypeMirror)entry.getKey();
                AnnotatedTypeMirror possValue = (AnnotatedTypeMirror)entry.getValue();
                if (possible == key) {
                    return (V)possValue;
                }
                if (!(possible instanceof AnnotatedTypeVariable)) continue;
                AnnotatedTypeVariable other = (AnnotatedTypeVariable)possible;
                Element oElt = other.getUnderlyingType().asElement();
                if (!key.getUnderlyingType().asElement().equals(oElt)) continue;
                if (!key.annotations.isEmpty() && !AnnotationUtils.areSame(key.annotations, other.annotations)) {
                    AnnotatedTypeMirror found = possValue.getCopy(false);
                    found.addAnnotations(key.annotations);
                    return (V)found;
                }
                return (V)possValue;
            }
            return null;
        }

        @Override
        public AnnotatedTypeMirror substitute(Map<? extends AnnotatedTypeMirror, ? extends AnnotatedTypeMirror> mappings) {
            AnnotatedTypeMirror found = AnnotatedTypeVariable.mapGetHelper(mappings, this);
            if (found != null) {
                return found;
            }
            AnnotatedTypeVariable type = this.getCopy(true);
            HashMap<? extends AnnotatedTypeMirror, ? extends AnnotatedTypeMirror> newMappings = new HashMap<AnnotatedTypeMirror, AnnotatedTypeMirror>(mappings);
            newMappings.put(this, type);
            type.setLowerBound(this.getLowerBound().substitute(newMappings));
            if (this.getUpperBound() != null) {
                type.setUpperBound(this.getUpperBound().substitute(newMappings));
            }
            return type;
        }

        @Override
        public boolean isAnnotated() {
            return super.isAnnotated() || this.getUpperBound() != null && this.getUpperBound().isAnnotated();
        }

        public Set<AnnotationMirror> getAnnotationsOnTypeVar() {
            return super.getAnnotations();
        }

        @Override
        public Set<AnnotationMirror> getAnnotations() {
            if (!super.isAnnotated() && this.getUpperBound() != null) {
                return this.getUpperBound().getAnnotations();
            }
            return super.getAnnotations();
        }

        @Override
        public void addAnnotation(AnnotationMirror anno) {
            super.addAnnotation(anno);
            this.getUpperBound().addAnnotation(anno);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(AnnotatedTypeVariable.formatAnnotationString(this.annotations));
            sb.append(this.actualType);
            if (!this.isPrintingBound) {
                try {
                    this.isPrintingBound = true;
                    if (this.getLowerBound() != null && this.getLowerBound().getKind() != TypeKind.NULL) {
                        sb.append(" super ");
                        sb.append(this.getLowerBound());
                    }
                    if (this.getUpperBound() != null && this.getUpperBound().getKind() != TypeKind.NULL) {
                        sb.append(" extends ");
                        sb.append(this.getUpperBound());
                    }
                }
                finally {
                    this.isPrintingBound = false;
                }
            }
            return sb.toString();
        }

        @Override
        public int hashCode() {
            return this.getUnderlyingType().hashCode();
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof AnnotatedTypeVariable)) {
                return false;
            }
            AnnotatedTypeVariable other = (AnnotatedTypeVariable)o;
            boolean isSame = this.env.getTypeUtils().isSameType(this.getUnderlyingType(), other.getUnderlyingType()) && AnnotationUtils.areSame(this.annotations, other.annotations);
            return isSame;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AnnotatedArrayType
    extends AnnotatedTypeMirror
    implements AnnotatedReferenceType {
        private final ArrayType actualType;
        private AnnotatedTypeMirror componentType;

        AnnotatedArrayType(ArrayType type, ProcessingEnvironment env, AnnotatedTypeFactory factory) {
            super(type, env, factory);
            this.actualType = type;
        }

        @Override
        public <R, P> R accept(AnnotatedTypeVisitor<R, P> v, P p) {
            return v.visitArray(this, p);
        }

        @Override
        public ArrayType getUnderlyingType() {
            return this.actualType;
        }

        public void setComponentType(AnnotatedTypeMirror type) {
            this.componentType = type;
        }

        public AnnotatedTypeMirror getComponentType() {
            if (this.componentType == null) {
                this.setComponentType(AnnotatedArrayType.createType(this.actualType.getComponentType(), this.env, this.typeFactory));
            }
            return this.componentType;
        }

        @Override
        public AnnotatedArrayType getCopy(boolean copyAnnotations) {
            AnnotatedArrayType type = new AnnotatedArrayType(this.actualType, this.env, this.typeFactory);
            this.copyFields(type, copyAnnotations);
            type.setComponentType(this.getComponentType());
            return type;
        }

        @Override
        public AnnotatedTypeMirror substitute(Map<? extends AnnotatedTypeMirror, ? extends AnnotatedTypeMirror> mappings) {
            if (mappings.containsKey(this)) {
                return mappings.get(this);
            }
            AnnotatedArrayType type = this.getCopy(true);
            type.setComponentType(this.getComponentType().substitute(mappings));
            return type;
        }

        @Override
        public AnnotatedArrayType getErased() {
            AnnotatedArrayType at = this.getCopy(true);
            AnnotatedTypeMirror ct = at.getComponentType().getErased();
            at.setComponentType(ct);
            return at;
        }

        public String toStringAsCanonical() {
            AnnotatedTypeMirror component;
            StringBuilder sb = new StringBuilder();
            AnnotatedArrayType array = this;
            while (true) {
                component = array.getComponentType();
                if (array.getAnnotations().size() > 0) {
                    sb.append(' ');
                    sb.append(AnnotatedArrayType.formatAnnotationString(array.getAnnotations()).trim());
                    sb.append(' ');
                }
                sb.append("[]");
                if (!(component instanceof AnnotatedArrayType)) break;
                array = (AnnotatedArrayType)component;
            }
            sb.insert(0, component.getUnderlyingType().toString());
            sb.insert(0, AnnotatedArrayType.formatAnnotationString(component.getAnnotations()));
            return sb.toString();
        }

        @Override
        public String toString() {
            return this.toStringAsCanonical();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AnnotatedExecutableType
    extends AnnotatedTypeMirror {
        private final ExecutableType actualType;
        private final List<AnnotatedTypeMirror> paramTypes = new LinkedList<AnnotatedTypeMirror>();
        private AnnotatedDeclaredType receiverType;
        private AnnotatedTypeMirror returnType;
        private final List<AnnotatedTypeMirror> throwsTypes = new LinkedList<AnnotatedTypeMirror>();
        private final List<AnnotatedTypeVariable> typeVarTypes = new LinkedList<AnnotatedTypeVariable>();

        AnnotatedExecutableType(ExecutableType type, ProcessingEnvironment env, AnnotatedTypeFactory factory) {
            super(type, env, factory);
            this.actualType = type;
        }

        public boolean isVarArgs() {
            if (this.element instanceof ExecutableElement) {
                return ((ExecutableElement)this.element).isVarArgs();
            }
            return false;
        }

        @Override
        public <R, P> R accept(AnnotatedTypeVisitor<R, P> v, P p) {
            return v.visitExecutable(this, p);
        }

        @Override
        public ExecutableType getUnderlyingType() {
            return this.actualType;
        }

        void setParameterTypes(List<? extends AnnotatedTypeMirror> params) {
            this.paramTypes.clear();
            this.paramTypes.addAll(params);
        }

        public List<AnnotatedTypeMirror> getParameterTypes() {
            if (this.paramTypes.isEmpty() && !this.actualType.getParameterTypes().isEmpty()) {
                for (TypeMirror typeMirror : this.actualType.getParameterTypes()) {
                    this.paramTypes.add(AnnotatedExecutableType.createType(typeMirror, this.env, this.typeFactory));
                }
            }
            return Collections.unmodifiableList(this.paramTypes);
        }

        void setReturnType(AnnotatedTypeMirror returnType) {
            this.returnType = returnType;
        }

        public AnnotatedTypeMirror getReturnType() {
            if (this.returnType == null && this.actualType.getReturnType() != null) {
                this.returnType = AnnotatedExecutableType.createType(this.actualType.getReturnType(), this.env, this.typeFactory);
            }
            return this.returnType;
        }

        void setReceiverType(AnnotatedDeclaredType receiverType) {
            this.receiverType = receiverType;
        }

        public AnnotatedDeclaredType getReceiverType() {
            if (this.receiverType == null) {
                TypeElement encl = ElementUtils.enclosingClass(this.getElement());
                AnnotatedTypeMirror type = AnnotatedExecutableType.createType(encl.asType(), this.env, this.typeFactory);
                assert (type instanceof AnnotatedDeclaredType);
                this.receiverType = (AnnotatedDeclaredType)type;
            }
            return this.receiverType;
        }

        void setThrownTypes(List<? extends AnnotatedTypeMirror> thrownTypes) {
            this.throwsTypes.clear();
            this.throwsTypes.addAll(thrownTypes);
        }

        public List<AnnotatedTypeMirror> getThrownTypes() {
            if (this.throwsTypes.isEmpty() && !this.actualType.getThrownTypes().isEmpty()) {
                for (TypeMirror typeMirror : this.actualType.getThrownTypes()) {
                    this.throwsTypes.add(AnnotatedExecutableType.createType(typeMirror, this.env, this.typeFactory));
                }
            }
            return Collections.unmodifiableList(this.throwsTypes);
        }

        void setTypeVariables(List<AnnotatedTypeVariable> types) {
            this.typeVarTypes.clear();
            this.typeVarTypes.addAll(types);
        }

        public List<AnnotatedTypeVariable> getTypeVariables() {
            if (this.typeVarTypes.isEmpty() && !this.actualType.getTypeVariables().isEmpty()) {
                for (TypeMirror typeMirror : this.actualType.getTypeVariables()) {
                    this.typeVarTypes.add((AnnotatedTypeVariable)AnnotatedExecutableType.createType(typeMirror, this.env, this.typeFactory));
                }
            }
            return Collections.unmodifiableList(this.typeVarTypes);
        }

        @Override
        public AnnotatedExecutableType getCopy(boolean copyAnnotations) {
            AnnotatedExecutableType type = new AnnotatedExecutableType(this.getUnderlyingType(), this.env, this.typeFactory);
            this.copyFields(type, copyAnnotations);
            type.setParameterTypes(this.getParameterTypes());
            type.setReceiverType(this.getReceiverType());
            type.setReturnType(this.getReturnType());
            type.setThrownTypes(this.getThrownTypes());
            type.setTypeVariables(this.getTypeVariables());
            return type;
        }

        @Override
        @NonNull
        public ExecutableElement getElement() {
            return (ExecutableElement)super.getElement();
        }

        @Override
        public AnnotatedExecutableType getErased() {
            AnnotatedExecutableType type = new AnnotatedExecutableType((ExecutableType)this.env.getTypeUtils().erasure(this.getUnderlyingType()), this.env, this.typeFactory);
            this.copyFields(type, true);
            type.setParameterTypes(this.erasureList(this.getParameterTypes()));
            type.setReceiverType(this.getReceiverType().getErased());
            type.setReturnType(this.getReturnType().getErased());
            type.setThrownTypes(this.erasureList(this.getThrownTypes()));
            return type;
        }

        private List<AnnotatedTypeMirror> erasureList(List<? extends AnnotatedTypeMirror> lst) {
            ArrayList<AnnotatedTypeMirror> erased = new ArrayList<AnnotatedTypeMirror>();
            for (AnnotatedTypeMirror annotatedTypeMirror : lst) {
                erased.add(annotatedTypeMirror.getErased());
            }
            return erased;
        }

        @Override
        public AnnotatedExecutableType substitute(Map<? extends AnnotatedTypeMirror, ? extends AnnotatedTypeMirror> mappings) {
            AnnotatedExecutableType type = this.getCopy(true);
            ArrayList<AnnotatedTypeMirror> params = new ArrayList<AnnotatedTypeMirror>();
            for (AnnotatedTypeMirror t : this.getParameterTypes()) {
                params.add(t.substitute(mappings));
            }
            type.setParameterTypes(params);
            if (this.getReceiverType() != null) {
                type.setReceiverType((AnnotatedDeclaredType)this.getReceiverType().substitute(mappings));
            }
            type.setReturnType(this.getReturnType().substitute(mappings));
            ArrayList<AnnotatedTypeMirror> throwns = new ArrayList<AnnotatedTypeMirror>();
            for (AnnotatedTypeMirror t : this.getThrownTypes()) {
                throwns.add(t.substitute(mappings));
            }
            type.setThrownTypes(throwns);
            return type;
        }

        @Override
        public String toString() {
            return this.getReturnType() + (this.getTypeVariables().isEmpty() ? "" : " <" + this.getTypeVariables() + ">") + (this.getParameterTypes().isEmpty() ? " ()" : " (" + this.getParameterTypes() + ")") + " " + this.getReceiverType() + (this.getThrownTypes().isEmpty() ? "" : " throws " + this.getThrownTypes());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AnnotatedDeclaredType
    extends AnnotatedTypeMirror
    implements AnnotatedReferenceType {
        protected List<AnnotatedTypeMirror> typeArgs;
        @Deprecated
        protected AnnotatedDeclaredType superclass;
        @Deprecated
        protected List<AnnotatedDeclaredType> interfaces;
        boolean isGeneric = false;
        protected final DeclaredType actualType;
        protected List<AnnotatedDeclaredType> supertypes;

        AnnotatedDeclaredType(DeclaredType type, ProcessingEnvironment env, AnnotatedTypeFactory typeFactory) {
            super(type, env, typeFactory);
            this.actualType = type;
            DeclaredType elem = (DeclaredType)((TypeElement)type.asElement()).asType();
            this.isGeneric = !elem.getTypeArguments().isEmpty();
            this.interfaces = new LinkedList<AnnotatedDeclaredType>();
            this.supertypes = null;
        }

        @Override
        public String toString() {
            Element typeElt = this.getUnderlyingType().asElement();
            StringBuilder sb = new StringBuilder();
            sb.append(AnnotatedDeclaredType.formatAnnotationString(this.getAnnotations()));
            sb.append(typeElt.getSimpleName());
            if (!this.getTypeArguments().isEmpty()) {
                sb.append("<");
                boolean isFirst = true;
                for (AnnotatedTypeMirror typeArg : this.getTypeArguments()) {
                    if (!isFirst) {
                        sb.append(", ");
                    }
                    sb.append(typeArg);
                    isFirst = false;
                }
                sb.append(">");
            }
            return sb.toString();
        }

        @Override
        public <R, P> R accept(AnnotatedTypeVisitor<R, P> v, P p) {
            return v.visitDeclared(this, p);
        }

        public void setTypeArguments(List<? extends AnnotatedTypeMirror> ts) {
            this.typeArgs = Collections.unmodifiableList(new ArrayList<AnnotatedTypeMirror>(ts));
        }

        public List<AnnotatedTypeMirror> getTypeArguments() {
            if (this.typeArgs == null) {
                this.typeArgs = new ArrayList<AnnotatedTypeMirror>();
                if (!this.actualType.getTypeArguments().isEmpty()) {
                    for (TypeMirror typeMirror : this.actualType.getTypeArguments()) {
                        this.typeArgs.add(AnnotatedDeclaredType.createType(typeMirror, this.env, this.typeFactory));
                    }
                }
                this.typeArgs = Collections.unmodifiableList(this.typeArgs);
            }
            return this.typeArgs;
        }

        @Deprecated
        public AnnotatedTypeMirror getSuperclass() {
            TypeElement elt = (TypeElement)this.actualType.asElement();
            assert (elt.getSuperclass() != null);
            AnnotatedTypeMirror type = AnnotatedDeclaredType.createType(elt.asType(), this.env, this.typeFactory);
            if (type instanceof AnnotatedNoType) {
                return type.getCopy(true);
            }
            assert (type instanceof AnnotatedDeclaredType) : "not a declared type: " + type;
            AnnotatedDeclaredType at = (AnnotatedDeclaredType)type;
            at.addAnnotations(this.getAnnotations());
            return at;
        }

        public boolean isGeneric() {
            return this.isGeneric;
        }

        public boolean isParameterized() {
            return !this.getTypeArguments().isEmpty() && !this.getUnderlyingType().getTypeArguments().isEmpty();
        }

        @Deprecated
        public List<AnnotatedDeclaredType> getInterfaces() {
            TypeElement elt = (TypeElement)this.actualType.asElement();
            LinkedList<AnnotatedDeclaredType> myInterfaces = new LinkedList<AnnotatedDeclaredType>();
            for (TypeMirror typeMirror : elt.getInterfaces()) {
                AnnotatedDeclaredType at = (AnnotatedDeclaredType)AnnotatedDeclaredType.createType(typeMirror, this.env, this.typeFactory);
                at.addAnnotations(this.getAnnotations());
                myInterfaces.add(at);
            }
            return Collections.unmodifiableList(myInterfaces);
        }

        @Override
        public DeclaredType getUnderlyingType() {
            return this.actualType;
        }

        void setDirectSuperTypes(List<AnnotatedDeclaredType> supertypes) {
            this.supertypes = new ArrayList<AnnotatedDeclaredType>(supertypes);
        }

        public List<AnnotatedDeclaredType> directSuperTypes() {
            if (this.supertypes == null) {
                this.supertypes = this.directSuperTypes(this);
            }
            return Collections.unmodifiableList(this.supertypes);
        }

        @Override
        public AnnotatedDeclaredType getCopy(boolean copyAnnotations) {
            AnnotatedDeclaredType type = new AnnotatedDeclaredType(this.getUnderlyingType(), this.env, this.typeFactory);
            this.copyFields(type, copyAnnotations);
            type.setTypeArguments(this.getTypeArguments());
            return type;
        }

        @Override
        public AnnotatedTypeMirror substitute(Map<? extends AnnotatedTypeMirror, ? extends AnnotatedTypeMirror> mapping) {
            if (mapping.containsKey(this)) {
                return mapping.get(this);
            }
            AnnotatedDeclaredType type = this.getCopy(true);
            ArrayList<AnnotatedTypeMirror> typeArgs = new ArrayList<AnnotatedTypeMirror>();
            for (AnnotatedTypeMirror t : this.getTypeArguments()) {
                typeArgs.add(t.substitute(mapping));
            }
            type.setTypeArguments(typeArgs);
            if (TypesUtils.isAnonymousType(this.actualType) && this.supertypes != null) {
                ArrayList<AnnotatedDeclaredType> supertypes = new ArrayList<AnnotatedDeclaredType>();
                for (AnnotatedDeclaredType t : this.directSuperTypes()) {
                    supertypes.add((AnnotatedDeclaredType)t.substitute(mapping));
                }
                type.setDirectSuperTypes(supertypes);
            }
            return type;
        }

        @Override
        public AnnotatedDeclaredType getErased() {
            if (!this.getTypeArguments().isEmpty()) {
                AnnotatedDeclaredType rType = (AnnotatedDeclaredType)AnnotatedTypeMirror.createType(this.env.getTypeUtils().erasure(this.actualType), this.env, this.typeFactory);
                rType.addAnnotations(this.getAnnotations());
                rType.setElement(this.element);
                rType.setTypeArguments(Collections.emptyList());
                return rType.getErased();
            }
            if (this.getEnclosingType() != null && this.getEnclosingType().getKind() != TypeKind.NONE) {
                AnnotatedDeclaredType rType = this.getCopy(true);
                AnnotatedTypeMirror et = this.getEnclosingType();
                rType.setEnclosingType(et.getErased());
                return rType;
            }
            return this;
        }
    }

    public static interface AnnotatedReferenceType {
    }
}

