/*
 * Decompiled with CFR 0.152.
 */
package checkers.types;

import checkers.types.AnnotatedTypeFactory;
import checkers.types.AnnotatedTypeMirror;
import checkers.types.visitors.SimpleAnnotatedTypeVisitor;
import checkers.util.ElementUtils;
import checkers.util.InternalUtils;
import checkers.util.TreeUtils;
import checkers.util.TypesUtils;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Types;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotatedTypes {
    private ProcessingEnvironment env;
    private AnnotatedTypeFactory factory;
    static int uidCounter = 0;
    int uid;
    private SimpleAnnotatedTypeVisitor<AnnotatedTypeMirror, AnnotatedTypeMirror> asSuper = new SimpleAnnotatedTypeVisitor<AnnotatedTypeMirror, AnnotatedTypeMirror>(){

        @Override
        protected AnnotatedTypeMirror defaultAction(AnnotatedTypeMirror type, AnnotatedTypeMirror p) {
            return type;
        }

        @Override
        public AnnotatedTypeMirror visitPrimitive(AnnotatedTypeMirror.AnnotatedPrimitiveType type, AnnotatedTypeMirror p) {
            if (!p.getKind().isPrimitive()) {
                return (AnnotatedTypeMirror)this.visit(AnnotatedTypes.this.factory.getBoxedType(type), p);
            }
            AnnotatedTypeMirror.AnnotatedPrimitiveType pt = (AnnotatedTypeMirror.AnnotatedPrimitiveType)p;
            AnnotatedTypeMirror.AnnotatedPrimitiveType st = pt.getCopy(false);
            st.addAnnotations(type.getAnnotations());
            return st;
        }

        @Override
        public AnnotatedTypeMirror visitTypeVariable(AnnotatedTypeMirror.AnnotatedTypeVariable type, AnnotatedTypeMirror p) {
            if (p.getKind() == TypeKind.TYPEVAR) {
                return type;
            }
            return AnnotatedTypes.this.asSuper(type.getUpperBound(), p);
        }

        @Override
        public AnnotatedTypeMirror visitWildcard(AnnotatedTypeMirror.AnnotatedWildcardType type, AnnotatedTypeMirror p) {
            if (p.getKind() == TypeKind.WILDCARD) {
                return type;
            }
            return AnnotatedTypes.this.asSuper(type.getExtendsBound(), p);
        }

        @Override
        public AnnotatedTypeMirror visitArray(AnnotatedTypeMirror.AnnotatedArrayType type, AnnotatedTypeMirror p) {
            if (AnnotatedTypes.this.shouldStop(p, type)) {
                return type;
            }
            for (AnnotatedTypeMirror annotatedTypeMirror : type.directSuperTypes()) {
                AnnotatedTypeMirror x = AnnotatedTypes.this.asSuper(annotatedTypeMirror, p);
                if (x == null) continue;
                return AnnotatedTypes.this.isErased(x, p) ? x.getErased() : x;
            }
            return null;
        }

        @Override
        public AnnotatedTypeMirror visitDeclared(AnnotatedTypeMirror.AnnotatedDeclaredType type, AnnotatedTypeMirror p) {
            if (p.getKind().isPrimitive()) {
                return (AnnotatedTypeMirror)this.visit(AnnotatedTypes.this.factory.getUnboxedType(type), p);
            }
            if (AnnotatedTypes.this.shouldStop(p, type)) {
                return type;
            }
            for (AnnotatedTypeMirror.AnnotatedDeclaredType st : type.directSuperTypes()) {
                AnnotatedTypeMirror.AnnotatedDeclaredType x;
                if (st.getKind() != TypeKind.DECLARED || (x = (AnnotatedTypeMirror.AnnotatedDeclaredType)AnnotatedTypes.this.asSuper(st, p)) == null) continue;
                return x;
            }
            return null;
        }
    };

    public AnnotatedTypes(ProcessingEnvironment env, AnnotatedTypeFactory factory) {
        this.env = env;
        this.factory = factory;
        this.uid = ++uidCounter;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "#" + this.uid;
    }

    public AnnotatedTypeMirror asSuper(AnnotatedTypeMirror t, AnnotatedTypeMirror superType) {
        return this.asSuper.visit(t, superType);
    }

    private AnnotatedTypeMirror asOuterSuper(AnnotatedTypeMirror t, AnnotatedTypeMirror elem) {
        switch (t.getKind()) {
            case DECLARED: {
                do {
                    AnnotatedTypeMirror s;
                    if ((s = this.asSuper(t, elem)) == null) continue;
                    return s;
                } while ((t = t.getEnclosingType()) != null && t.getKind() == TypeKind.DECLARED);
                return null;
            }
            case ARRAY: 
            case TYPEVAR: 
            case WILDCARD: {
                return this.asSuper(t, elem);
            }
        }
        return null;
    }

    private boolean shouldStop(AnnotatedTypeMirror sup, AnnotatedTypeMirror sub) {
        if (sup.getKind().isPrimitive() && !sub.getKind().isPrimitive()) {
            return true;
        }
        if (sup.getKind().isPrimitive() && sub.getKind().isPrimitive()) {
            return sup.getKind() == sub.getKind();
        }
        if (sup.getKind() == TypeKind.DECLARED && sub.getKind() == TypeKind.DECLARED) {
            AnnotatedTypeMirror.AnnotatedDeclaredType supdt = (AnnotatedTypeMirror.AnnotatedDeclaredType)sup;
            AnnotatedTypeMirror.AnnotatedDeclaredType subdt = (AnnotatedTypeMirror.AnnotatedDeclaredType)sub;
            return supdt.getUnderlyingType().asElement().equals(subdt.getUnderlyingType().asElement());
        }
        if (sup.getKind() == TypeKind.ARRAY && sub.getKind() == TypeKind.ARRAY) {
            AnnotatedTypeMirror.AnnotatedArrayType supat = (AnnotatedTypeMirror.AnnotatedArrayType)sup;
            AnnotatedTypeMirror.AnnotatedArrayType subat = (AnnotatedTypeMirror.AnnotatedArrayType)sub;
            return this.shouldStop(supat.getComponentType(), subat.getComponentType());
        }
        return sup.getUnderlyingType().toString().equals(sub.getUnderlyingType().toString());
    }

    private boolean isErased(AnnotatedTypeMirror t1, AnnotatedTypeMirror t2) {
        Types types = this.env.getTypeUtils();
        return types.isSameType(types.erasure(t1.getUnderlyingType()), t2.getUnderlyingType());
    }

    public AnnotatedTypeMirror.AnnotatedExecutableType asMemberOf(AnnotatedTypeMirror t, ExecutableElement elem) {
        return (AnnotatedTypeMirror.AnnotatedExecutableType)this.asMemberOf(t, (Element)elem);
    }

    public AnnotatedTypeMirror asMemberOf(AnnotatedTypeMirror t, Element elem) {
        switch (elem.getKind()) {
            case PACKAGE: 
            case INSTANCE_INIT: 
            case OTHER: 
            case STATIC_INIT: 
            case TYPE_PARAMETER: {
                return this.factory.fromElement(elem);
            }
        }
        AnnotatedTypeMirror type = this.asMemberOfImpl(t, elem);
        if (!ElementUtils.isStatic(elem)) {
            this.factory.postAsMemberOf(type, t, elem);
        }
        return type;
    }

    private AnnotatedTypeMirror asMemberOfImpl(AnnotatedTypeMirror t, Element elem) {
        if (ElementUtils.isStatic(elem)) {
            return this.factory.getAnnotatedType(elem);
        }
        if (t.getKind() == TypeKind.TYPEVAR && ((AnnotatedTypeMirror.AnnotatedTypeVariable)t).getUpperBound() != null) {
            return this.asMemberOf(((AnnotatedTypeMirror.AnnotatedTypeVariable)t).getUpperBound(), elem);
        }
        if (t.getKind() == TypeKind.ARRAY && elem.getKind() == ElementKind.METHOD && elem.getSimpleName().contentEquals("clone")) {
            AnnotatedTypeMirror.AnnotatedExecutableType method = (AnnotatedTypeMirror.AnnotatedExecutableType)this.factory.getAnnotatedType(elem);
            return method.substitute(Collections.singletonMap(method.getReturnType(), t));
        }
        if (t.getKind() != TypeKind.DECLARED) {
            return this.factory.getAnnotatedType(elem);
        }
        TypeElement owner = ElementUtils.enclosingClass(elem);
        if (ElementUtils.isStatic(elem) || owner.getTypeParameters().isEmpty()) {
            return this.factory.getAnnotatedType(elem);
        }
        AnnotatedTypeMirror.AnnotatedDeclaredType ownerType = this.factory.getAnnotatedType(owner);
        AnnotatedTypeMirror.AnnotatedDeclaredType base = (AnnotatedTypeMirror.AnnotatedDeclaredType)this.asOuterSuper(t, ownerType);
        if (base == null) {
            return this.factory.getAnnotatedType(elem);
        }
        List<AnnotatedTypeMirror> ownerParams = ownerType.getTypeArguments();
        List<AnnotatedTypeMirror> baseParams = base.getTypeArguments();
        if (!ownerParams.isEmpty()) {
            if (baseParams.isEmpty()) {
                ArrayList<AnnotatedTypeMirror> baseParamsEr = new ArrayList<AnnotatedTypeMirror>();
                for (AnnotatedTypeMirror arg : ownerParams) {
                    baseParamsEr.add(arg.getErased());
                }
                return this.subst(this.factory.getAnnotatedType(elem), ownerParams, baseParamsEr);
            }
            return this.subst(this.factory.getAnnotatedType(elem), ownerParams, baseParams);
        }
        return this.factory.getAnnotatedType(elem);
    }

    public AnnotatedTypeMirror subst(AnnotatedTypeMirror t, List<? extends AnnotatedTypeMirror> from, List<? extends AnnotatedTypeMirror> to) {
        HashMap<AnnotatedTypeMirror, AnnotatedTypeMirror> mappings = new HashMap<AnnotatedTypeMirror, AnnotatedTypeMirror>();
        for (int i = 0; i < from.size(); ++i) {
            mappings.put(from.get(i), to.get(i));
        }
        return t.substitute(mappings);
    }

    public AnnotatedTypeMirror deepCopy(AnnotatedTypeMirror type) {
        return type.substitute(Collections.emptyMap());
    }

    public AnnotatedTypeMirror getIteratedType(AnnotatedTypeMirror iterableType) {
        if (iterableType.getKind() == TypeKind.ARRAY) {
            return ((AnnotatedTypeMirror.AnnotatedArrayType)iterableType).getComponentType();
        }
        if (iterableType.getKind() == TypeKind.WILDCARD) {
            return this.getIteratedType(((AnnotatedTypeMirror.AnnotatedWildcardType)iterableType).getExtendsBound());
        }
        if (iterableType.getKind() == TypeKind.TYPEVAR) {
            return this.getIteratedType(((AnnotatedTypeMirror.AnnotatedTypeVariable)iterableType).getUpperBound());
        }
        if (iterableType.getKind() != TypeKind.DECLARED) {
            throw new IllegalArgumentException("Not iterable type: " + iterableType);
        }
        TypeElement iterableElement = this.env.getElementUtils().getTypeElement("java.lang.Iterable");
        AnnotatedTypeMirror.AnnotatedDeclaredType iterableElmType = this.factory.getAnnotatedType(iterableElement);
        AnnotatedTypeMirror.AnnotatedDeclaredType dt = (AnnotatedTypeMirror.AnnotatedDeclaredType)this.asSuper(iterableType, iterableElmType);
        if (dt == null) {
            throw new IllegalArgumentException("Not iterable type: " + iterableType);
        }
        if (dt.getTypeArguments().isEmpty()) {
            TypeElement e = this.env.getElementUtils().getTypeElement("java.lang.Object");
            AnnotatedTypeMirror.AnnotatedDeclaredType t = this.factory.fromElement(e);
            t.clearAnnotations();
            this.factory.annotateImplicit(e, (AnnotatedTypeMirror)t);
            return t;
        }
        return dt.getTypeArguments().get(0);
    }

    public Set<AnnotatedTypeMirror.AnnotatedDeclaredType> getSuperTypes(AnnotatedTypeMirror.AnnotatedDeclaredType type) {
        HashSet<AnnotatedTypeMirror.AnnotatedDeclaredType> supertypes = new HashSet<AnnotatedTypeMirror.AnnotatedDeclaredType>();
        if (type == null) {
            return supertypes;
        }
        ArrayDeque<AnnotatedTypeMirror.AnnotatedDeclaredType> stack = new ArrayDeque<AnnotatedTypeMirror.AnnotatedDeclaredType>();
        stack.push(type);
        while (!stack.isEmpty()) {
            AnnotatedTypeMirror.AnnotatedDeclaredType current = (AnnotatedTypeMirror.AnnotatedDeclaredType)stack.pop();
            for (AnnotatedTypeMirror.AnnotatedDeclaredType supertype : current.directSuperTypes()) {
                if (supertypes.contains(supertype)) continue;
                stack.push(supertype);
                supertypes.add(supertype);
            }
        }
        return Collections.unmodifiableSet(supertypes);
    }

    public Map<AnnotatedTypeMirror.AnnotatedDeclaredType, ExecutableElement> overriddenMethods(ExecutableElement method) {
        TypeElement elem = (TypeElement)method.getEnclosingElement();
        AnnotatedTypeMirror.AnnotatedDeclaredType type = this.factory.getAnnotatedType(elem);
        Set<AnnotatedTypeMirror.AnnotatedDeclaredType> supertypes = this.getSuperTypes(type);
        return this.overriddenMethods(method, supertypes);
    }

    public Map<AnnotatedTypeMirror.AnnotatedDeclaredType, ExecutableElement> overriddenMethods(ExecutableElement method, Collection<AnnotatedTypeMirror.AnnotatedDeclaredType> supertypes) {
        HashMap<AnnotatedTypeMirror.AnnotatedDeclaredType, ExecutableElement> overrides = new HashMap<AnnotatedTypeMirror.AnnotatedDeclaredType, ExecutableElement>();
        block0: for (AnnotatedTypeMirror.AnnotatedDeclaredType supertype : supertypes) {
            TypeElement superElement = (TypeElement)supertype.getUnderlyingType().asElement();
            assert (superElement != null);
            for (ExecutableElement supermethod : ElementFilter.methodsIn(superElement.getEnclosedElements())) {
                if (!this.env.getElementUtils().overrides(method, supermethod, superElement)) continue;
                overrides.put(supertype, supermethod);
                continue block0;
            }
        }
        return Collections.unmodifiableMap(overrides);
    }

    public Map<AnnotatedTypeMirror.AnnotatedTypeVariable, AnnotatedTypeMirror> findTypeArguments(MethodInvocationTree methodInvocation) {
        HashMap<AnnotatedTypeMirror.AnnotatedTypeVariable, AnnotatedTypeMirror> typeArguments = new HashMap<AnnotatedTypeMirror.AnnotatedTypeVariable, AnnotatedTypeMirror>();
        ExecutableElement methodElt = TreeUtils.elementFromUse(methodInvocation);
        if (methodElt.getTypeParameters().isEmpty()) {
            return typeArguments;
        }
        if (!methodInvocation.getTypeArguments().isEmpty()) {
            for (int i = 0; i < methodElt.getTypeParameters().size(); ++i) {
                AnnotatedTypeMirror.AnnotatedTypeVariable typeVar = (AnnotatedTypeMirror.AnnotatedTypeVariable)this.factory.getAnnotatedType(methodElt.getTypeParameters().get(i));
                AnnotatedTypeMirror typeArg = this.factory.getAnnotatedTypeFromTypeTree(methodInvocation.getTypeArguments().get(i));
                typeArguments.put(typeVar, typeArg);
            }
            return typeArguments;
        }
        return this.inferTypeArguments(methodInvocation);
    }

    private Map<AnnotatedTypeMirror.AnnotatedTypeVariable, AnnotatedTypeMirror> inferTypeArguments(MethodInvocationTree methodInvocation) {
        HashMap<AnnotatedTypeMirror.AnnotatedTypeVariable, AnnotatedTypeMirror> typeArguments = new HashMap<AnnotatedTypeMirror.AnnotatedTypeVariable, AnnotatedTypeMirror>();
        ExecutableElement methodElt = TreeUtils.elementFromUse(methodInvocation);
        AnnotatedTypeMirror returnType = this.factory.type(methodInvocation);
        this.factory.annotateImplicit(methodInvocation, returnType);
        AnnotatedTypeMirror.AnnotatedExecutableType methodType = this.asMemberOf(this.factory.getReceiver(methodInvocation), methodElt);
        for (TypeParameterElement typeParameterElement : methodElt.getTypeParameters()) {
            AnnotatedTypeMirror.AnnotatedTypeVariable typeVar = (AnnotatedTypeMirror.AnnotatedTypeVariable)this.factory.getAnnotatedType(typeParameterElement);
            AnnotatedTypeMirror argument = this.inferTypeArgUsingParams(typeVar, returnType, methodType, methodInvocation);
            if (argument == null) {
                AnnotatedTypeMirror returnTypeBase;
                List lst;
                assert (this.factory.root != null) : "root needs to be set when used on trees";
                AnnotatedTypeMirror assigned = this.assignedTo(TreePath.getPath(this.factory.root, (Tree)methodInvocation));
                if (assigned != null && (lst = (List)new TypeResolutionFinder(typeVar).visit(returnTypeBase = this.asSuper(methodType.getReturnType(), assigned), assigned)) != null && !lst.isEmpty()) {
                    argument = (AnnotatedTypeMirror)lst.get(0);
                }
            }
            if (argument == null) {
                AnnotatedTypeMirror upperBound = typeVar.getUpperBound();
                while (upperBound.getKind() == TypeKind.TYPEVAR) {
                    upperBound = ((AnnotatedTypeMirror.AnnotatedTypeVariable)upperBound).getUpperBound();
                }
                WildcardType wc = this.env.getTypeUtils().getWildcardType(upperBound.getUnderlyingType(), null);
                AnnotatedTypeMirror.AnnotatedWildcardType wctype = new AnnotatedTypeMirror.AnnotatedWildcardType(wc, this.env, this.factory);
                wctype.setElement(typeVar.getElement());
                wctype.setExtendsBound(upperBound);
                argument = wctype;
            }
            if (argument == null) continue;
            typeArguments.put(typeVar, argument);
        }
        return typeArguments;
    }

    private AnnotatedTypeMirror inferTypeArgUsingParams(AnnotatedTypeMirror.AnnotatedTypeVariable typeVar, AnnotatedTypeMirror returnType, AnnotatedTypeMirror.AnnotatedExecutableType methodType, MethodInvocationTree methodInvocation) {
        TypeResolutionFinder finder = new TypeResolutionFinder(typeVar);
        List lubForVar = (List)finder.visit(methodType.getReturnType(), returnType);
        if (lubForVar.isEmpty()) {
            return null;
        }
        List<AnnotatedTypeMirror> requiredParams = this.expandVarArgs(methodType, methodInvocation.getArguments());
        ArrayList passedArgs = new ArrayList();
        for (int i = 0; i < requiredParams.size(); ++i) {
            AnnotatedTypeMirror requiredArg;
            AnnotatedTypeMirror passedArg = this.factory.getAnnotatedType(methodInvocation.getArguments().get(i));
            if (this.asSuper(passedArg, requiredArg = requiredParams.get(i)) != null) {
                passedArg = this.asSuper(passedArg, requiredArg);
            }
            passedArgs.addAll((Collection)finder.visit(requiredArg, passedArg));
        }
        if (passedArgs.isEmpty()) {
            return null;
        }
        AnnotatedTypeMirror[] argsArray = passedArgs.toArray(new AnnotatedTypeMirror[0]);
        this.annotateAsLub((AnnotatedTypeMirror)lubForVar.get(0), argsArray);
        return (AnnotatedTypeMirror)lubForVar.get(0);
    }

    public AnnotatedTypeMirror assignedTo(TreePath path) {
        Tree assignmentContext = TreeUtils.getAssignmentContext(path);
        if (assignmentContext == null) {
            return null;
        }
        if (assignmentContext instanceof AssignmentTree) {
            ExpressionTree variable = ((AssignmentTree)assignmentContext).getVariable();
            return this.factory.getAnnotatedType(variable);
        }
        if (assignmentContext instanceof CompoundAssignmentTree) {
            ExpressionTree variable = ((CompoundAssignmentTree)assignmentContext).getExpression();
            return this.factory.getAnnotatedType(variable);
        }
        if (assignmentContext instanceof MethodInvocationTree) {
            MethodInvocationTree methodInvocation = (MethodInvocationTree)assignmentContext;
            if (methodInvocation.getMethodSelect() instanceof MemberSelectTree && ((MemberSelectTree)methodInvocation.getMethodSelect()).getExpression() == path.getLeaf()) {
                return null;
            }
            ExecutableElement methodElt = TreeUtils.elementFromUse(methodInvocation);
            AnnotatedTypeMirror receiver = this.factory.getReceiver(methodInvocation);
            AnnotatedTypeMirror.AnnotatedExecutableType method = this.asMemberOf(receiver, methodElt);
            int treeIndex = -1;
            for (int i = 0; i < method.getParameterTypes().size(); ++i) {
                if (TreeUtils.skipParens(methodInvocation.getArguments().get(i)) != path.getLeaf()) continue;
                treeIndex = i;
                break;
            }
            if (treeIndex == -1) {
                return null;
            }
            return method.getParameterTypes().get(treeIndex);
        }
        if (assignmentContext instanceof NewArrayTree) {
            AnnotatedTypeMirror type = this.factory.getAnnotatedType((NewArrayTree)assignmentContext);
            type = AnnotatedTypes.innerMostType(type);
            return type;
        }
        if (assignmentContext instanceof NewClassTree) {
            NewClassTree newClassTree = (NewClassTree)assignmentContext;
            ExecutableElement constructorElt = InternalUtils.constructor(newClassTree);
            AnnotatedTypeMirror.AnnotatedExecutableType constructor = this.factory.getAnnotatedType(constructorElt);
            int treeIndex = -1;
            for (int i = 0; i < constructor.getParameterTypes().size(); ++i) {
                if (TreeUtils.skipParens(newClassTree.getArguments().get(i)) != path.getLeaf()) continue;
                treeIndex = i;
                break;
            }
            if (treeIndex == -1) {
                return null;
            }
            return constructor.getParameterTypes().get(treeIndex);
        }
        if (assignmentContext instanceof ReturnTree) {
            MethodTree method = TreeUtils.enclosingMethod(path);
            return this.factory.getAnnotatedType(method).getReturnType();
        }
        if (assignmentContext instanceof VariableTree) {
            return this.factory.getAnnotatedType((VariableTree)assignmentContext);
        }
        throw new AssertionError((Object)"Shouldn't be here!");
    }

    public boolean isAnonymousType(AnnotatedTypeMirror type) {
        return TypesUtils.isAnonymousType(type.getUnderlyingType());
    }

    public boolean isIntersectType(AnnotatedTypeMirror type) {
        return this.isAnonymousType(type) && type.getUnderlyingType().toString().contains("&");
    }

    public void annotateAsLub(AnnotatedTypeMirror lub, AnnotatedTypeMirror ... types) {
        if (this.isAnonymousType(lub)) {
            AnnotatedTypeMirror.AnnotatedDeclaredType adt = (AnnotatedTypeMirror.AnnotatedDeclaredType)lub;
            for (AnnotatedTypeMirror.AnnotatedDeclaredType adts : adt.directSuperTypes()) {
                AnnotatedTypeMirror[] subtypes = new AnnotatedTypeMirror[types.length];
                for (int i = 0; i < types.length; ++i) {
                    subtypes[i] = this.asSuper(types[i], adts);
                }
                this.addAnnotations(adts, subtypes);
                this.addAnnotations(lub, adts);
            }
        } else {
            AnnotatedTypeMirror[] subtypes = new AnnotatedTypeMirror[types.length];
            for (int i = 0; i < types.length; ++i) {
                AnnotatedTypeMirror type = types[i];
                if (type.getKind() == TypeKind.WILDCARD && ((AnnotatedTypeMirror.AnnotatedWildcardType)type).getSuperBound() != null) {
                    type = ((AnnotatedTypeMirror.AnnotatedWildcardType)type).getSuperBound();
                }
                if (type == null) {
                    return;
                }
                subtypes[i] = type.getKind() == TypeKind.WILDCARD ? lub.getCopy(true) : (this.asSuper(type, lub) == null ? lub.getCopy(true) : this.asSuper(type, lub));
            }
            if (subtypes.length > 0) {
                lub.clearAnnotations();
            }
            this.addAnnotations(lub, subtypes);
        }
    }

    private void addAnnotations(AnnotatedTypeMirror alub, AnnotatedTypeMirror ... types) {
        boolean isFirst = true;
        if (alub.getKind() == TypeKind.WILDCARD) {
            alub = ((AnnotatedTypeMirror.AnnotatedWildcardType)alub).getExtendsBound();
        }
        for (int i = 0; i < types.length; ++i) {
            if (types[i] == null || types[i].getKind() != TypeKind.WILDCARD) continue;
            AnnotatedTypeMirror.AnnotatedWildcardType wildcard = (AnnotatedTypeMirror.AnnotatedWildcardType)types[i];
            if (wildcard.getExtendsBound() != null) {
                types[i] = wildcard.getExtendsBound();
                continue;
            }
            if (wildcard.getSuperBound() == null) continue;
            types[i] = wildcard.getSuperBound();
        }
        Collection<Object> unification = Collections.emptySet();
        for (AnnotatedTypeMirror type : types) {
            if (type == null || type.getKind() == TypeKind.NULL && !type.isAnnotated()) continue;
            unification = isFirst ? type.getAnnotations() : this.factory.unify(unification, type.getAnnotations());
            isFirst = false;
        }
        alub.addAnnotations(unification);
        if (alub.getKind() == TypeKind.DECLARED) {
            AnnotatedTypeMirror.AnnotatedDeclaredType adt = (AnnotatedTypeMirror.AnnotatedDeclaredType)alub;
            for (int i = 0; i < adt.getTypeArguments().size(); ++i) {
                AnnotatedTypeMirror adtArg = adt.getTypeArguments().get(i);
                AnnotatedTypeMirror[] dTypesArg = new AnnotatedTypeMirror[types.length];
                for (int j = 0; j < types.length; ++j) {
                    dTypesArg[j] = types[j].getKind() == TypeKind.NULL ? types[j] : ((AnnotatedTypeMirror.AnnotatedDeclaredType)types[j]).getTypeArguments().get(i);
                }
                this.addAnnotations(adtArg, dTypesArg);
            }
        } else if (alub.getKind() == TypeKind.ARRAY) {
            AnnotatedTypeMirror.AnnotatedArrayType aat = (AnnotatedTypeMirror.AnnotatedArrayType)alub;
            AnnotatedTypeMirror[] compTypes = new AnnotatedTypeMirror[types.length];
            for (int i = 0; i < types.length; ++i) {
                compTypes[i] = types[i].getKind() == TypeKind.NULL ? types[i] : ((AnnotatedTypeMirror.AnnotatedArrayType)types[i]).getComponentType();
            }
            this.addAnnotations(aat.getComponentType(), compTypes);
        }
    }

    public List<AnnotatedTypeMirror> expandVarArgs(AnnotatedTypeMirror.AnnotatedExecutableType method, List<? extends ExpressionTree> args) {
        AnnotatedTypeMirror lastArg;
        List<AnnotatedTypeMirror> parameters = method.getParameterTypes();
        if (!method.getElement().isVarArgs()) {
            return parameters;
        }
        AnnotatedTypeMirror.AnnotatedArrayType varargs = (AnnotatedTypeMirror.AnnotatedArrayType)parameters.get(parameters.size() - 1);
        if (parameters.size() == args.size() && (lastArg = this.factory.getAnnotatedType(args.get(args.size() - 1))).getKind() == TypeKind.ARRAY && this.getArrayDepth(varargs) == this.getArrayDepth((AnnotatedTypeMirror.AnnotatedArrayType)lastArg)) {
            return parameters;
        }
        parameters = new ArrayList<AnnotatedTypeMirror>(parameters.subList(0, parameters.size() - 1));
        for (int i = args.size() - parameters.size(); i > 0; --i) {
            parameters.add(varargs.getComponentType());
        }
        return parameters;
    }

    public List<AnnotatedTypeMirror> getAnnotatedTypes(Iterable<? extends ExpressionTree> trees) {
        ArrayList<AnnotatedTypeMirror> types = new ArrayList<AnnotatedTypeMirror>();
        for (ExpressionTree expressionTree : trees) {
            types.add(this.factory.getAnnotatedType(expressionTree));
        }
        return types;
    }

    public boolean areSame(AnnotatedTypeMirror t1, AnnotatedTypeMirror t2) {
        return t1.toString().equals(t2.toString());
    }

    public int getArrayDepth(AnnotatedTypeMirror.AnnotatedArrayType array) {
        int counter = 0;
        AnnotatedTypeMirror type = array;
        while (type.getKind() == TypeKind.ARRAY) {
            ++counter;
            type = type.getComponentType();
        }
        return counter;
    }

    public static AnnotatedTypeMirror innerMostType(AnnotatedTypeMirror t) {
        AnnotatedTypeMirror inner = t;
        while (inner.getKind() == TypeKind.ARRAY) {
            inner = ((AnnotatedTypeMirror.AnnotatedArrayType)inner).getComponentType();
        }
        return inner;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TypeResolutionFinder
    extends SimpleAnnotatedTypeVisitor<List<AnnotatedTypeMirror>, AnnotatedTypeMirror> {
        private AnnotatedTypeMirror.AnnotatedTypeVariable typeToFind;

        public TypeResolutionFinder(AnnotatedTypeMirror.AnnotatedTypeVariable typeToFind) {
            this.typeToFind = typeToFind;
        }

        List<AnnotatedTypeMirror> visit(List<AnnotatedTypeMirror> types, List<AnnotatedTypeMirror> other) {
            ArrayList<AnnotatedTypeMirror> found = new ArrayList<AnnotatedTypeMirror>();
            assert (types.size() == other.size());
            for (int i = 0; i < types.size(); ++i) {
                List foundHere = (List)this.visit(types.get(i), other.get(i));
                found.addAll(foundHere);
            }
            return found;
        }

        @Override
        public List<AnnotatedTypeMirror> visitArray(AnnotatedTypeMirror.AnnotatedArrayType type, AnnotatedTypeMirror p) {
            if (p.getKind() == TypeKind.NULL) {
                return Collections.emptyList();
            }
            if (p.getKind() == TypeKind.WILDCARD) {
                AnnotatedTypeMirror bound = ((AnnotatedTypeMirror.AnnotatedWildcardType)p).getExtendsBound();
                if (bound != null) assert (bound.getUnderlyingType().toString().equals("java.lang.Object"));
                return Collections.emptyList();
            }
            assert (type.getKind() == p.getKind());
            AnnotatedTypeMirror.AnnotatedArrayType pArray = (AnnotatedTypeMirror.AnnotatedArrayType)p;
            AnnotatedTypeMirror typeToLookIn = pArray.getComponentType().getKind().isPrimitive() ? pArray : pArray.getComponentType();
            return (List)this.visit(type.getComponentType(), typeToLookIn);
        }

        @Override
        public List<AnnotatedTypeMirror> visitDeclared(AnnotatedTypeMirror.AnnotatedDeclaredType type, AnnotatedTypeMirror p) {
            if (p.getKind() == TypeKind.NULL) {
                return Collections.singletonList(p);
            }
            if (p.getKind() == TypeKind.WILDCARD) {
                AnnotatedTypeMirror bound = ((AnnotatedTypeMirror.AnnotatedWildcardType)p).getExtendsBound();
                if (bound == null) {
                    return Collections.emptyList();
                }
                return this.visitDeclared(type, bound);
            }
            AnnotatedTypeMirror.AnnotatedDeclaredType pDeclared = (AnnotatedTypeMirror.AnnotatedDeclaredType)AnnotatedTypes.this.asSuper(p, type);
            if (type.getTypeArguments().isEmpty() || pDeclared == null || pDeclared.getTypeArguments().isEmpty()) {
                return Collections.emptyList();
            }
            return this.visit(type.getTypeArguments(), pDeclared.getTypeArguments());
        }

        @Override
        public List<AnnotatedTypeMirror> visitExecutable(AnnotatedTypeMirror.AnnotatedExecutableType type, AnnotatedTypeMirror p) {
            assert (type.getKind() == p.getKind());
            AnnotatedTypeMirror.AnnotatedExecutableType pExecutable = (AnnotatedTypeMirror.AnnotatedExecutableType)p;
            return this.visit(type.getParameterTypes(), pExecutable.getParameterTypes());
        }

        @Override
        public List<AnnotatedTypeMirror> visitTypeVariable(AnnotatedTypeMirror.AnnotatedTypeVariable type, AnnotatedTypeMirror p) {
            Element elem = type.getUnderlyingType().asElement();
            if (elem.equals(this.typeToFind.getUnderlyingType().asElement())) {
                return Collections.singletonList(p);
            }
            return Collections.emptyList();
        }

        @Override
        public List<AnnotatedTypeMirror> visitWildcard(AnnotatedTypeMirror.AnnotatedWildcardType type, AnnotatedTypeMirror p) {
            ArrayList<AnnotatedTypeMirror> types = new ArrayList<AnnotatedTypeMirror>();
            if (type.getExtendsBound() != null) {
                types.addAll((Collection)this.visit(type.getExtendsBound(), p));
            }
            if (type.getSuperBound() != null) {
                types.addAll((Collection)this.visit(type.getSuperBound(), p));
            }
            return types;
        }

        @Override
        public List<AnnotatedTypeMirror> defaultAction(AnnotatedTypeMirror type, AnnotatedTypeMirror p) {
            return Collections.emptyList();
        }
    }
}

