/*
 * Decompiled with CFR 0.152.
 */
package checkers.types;

import checkers.basetype.BaseTypeChecker;
import checkers.flow.Flow;
import checkers.quals.DefaultLocation;
import checkers.quals.DefaultQualifierInHierarchy;
import checkers.source.SourceChecker;
import checkers.types.AnnotatedTypeFactory;
import checkers.types.AnnotatedTypeMirror;
import checkers.types.TreeAnnotator;
import checkers.types.TypeAnnotator;
import checkers.util.AnnotationUtils;
import checkers.util.InternalUtils;
import checkers.util.QualifierDefaults;
import checkers.util.QualifierPolymorphism;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicAnnotatedTypeFactory<Checker extends BaseTypeChecker>
extends AnnotatedTypeFactory {
    protected static boolean FLOW_BY_DEFAULT = true;
    protected final TypeAnnotator typeAnnotator;
    protected final TreeAnnotator treeAnnotator;
    protected final QualifierPolymorphism poly;
    protected final QualifierDefaults defaults;
    protected boolean useFlow;
    protected final Flow flow;
    boolean scanned = false;
    boolean finishedScanning = false;

    public BasicAnnotatedTypeFactory(Checker checker, CompilationUnitTree root, boolean useFlow) {
        super((SourceChecker)checker, root);
        this.treeAnnotator = this.createTreeAnnotator(checker);
        this.typeAnnotator = this.createTypeAnnotator(checker);
        this.useFlow = useFlow;
        this.poly = new QualifierPolymorphism((BaseTypeChecker)checker, this);
        Set<AnnotationMirror> flowQuals = this.createFlowQualifiers(checker);
        this.flow = useFlow ? this.createFlow(checker, root, flowQuals) : null;
        this.defaults = new QualifierDefaults(this, this.annotations);
        for (Class<? extends Annotation> qual : ((BaseTypeChecker)checker).getSupportedTypeQualifiers()) {
            if (qual.getAnnotation(DefaultQualifierInHierarchy.class) == null) continue;
            this.defaults.setAbsoluteDefaults(this.annotations.fromClass(qual), Collections.singleton(DefaultLocation.ALL));
            break;
        }
        this.postInit();
    }

    public BasicAnnotatedTypeFactory(Checker checker, CompilationUnitTree root) {
        this(checker, root, FLOW_BY_DEFAULT);
    }

    protected TreeAnnotator createTreeAnnotator(Checker checker) {
        return new TreeAnnotator((BaseTypeChecker)checker, this);
    }

    protected TypeAnnotator createTypeAnnotator(Checker checker) {
        return new TypeAnnotator((BaseTypeChecker)checker);
    }

    protected Flow createFlow(Checker checker, CompilationUnitTree root, Set<AnnotationMirror> flowQuals) {
        return new Flow((BaseTypeChecker)checker, root, flowQuals, this);
    }

    @Override
    protected void postDirectSuperTypes(AnnotatedTypeMirror type, List<? extends AnnotatedTypeMirror> supertypes) {
        super.postDirectSuperTypes(type, supertypes);
        if (type.getKind() == TypeKind.DECLARED) {
            for (AnnotatedTypeMirror annotatedTypeMirror : supertypes) {
                if (this.defaults == null) continue;
                this.defaults.annotate(((DeclaredType)annotatedTypeMirror.getUnderlyingType()).asElement(), annotatedTypeMirror);
            }
        }
    }

    @Override
    protected void annotateImplicit(Tree tree, AnnotatedTypeMirror type) {
        AnnotationMirror inferred;
        assert (this.root != null) : "root needs to be set when used on trees";
        if (this.useFlow && !this.scanned) {
            this.scanned = true;
            this.flow.scan((Tree)this.root, null);
            this.fromTreeCache.clear();
            this.finishedScanning = true;
        }
        this.treeAnnotator.visit(tree, type);
        if (this.useFlow && (inferred = this.flow.test(tree)) != null) {
            type.clearAnnotations();
            type.addAnnotation(inferred);
        }
        if (!this.useFlow || this.finishedScanning || tree.getKind() == Tree.Kind.METHOD || tree.getKind() == Tree.Kind.CLASS || tree.getKind() == Tree.Kind.METHOD_INVOCATION) {
            Element elt = InternalUtils.symbol(tree);
            this.typeAnnotator.visit(type, elt != null ? elt.getKind() : ElementKind.OTHER);
            this.defaults.annotate(tree, type);
        }
    }

    @Override
    protected void annotateImplicit(Element elt, AnnotatedTypeMirror type) {
        this.typeAnnotator.visit(type, elt.getKind());
        this.defaults.annotate(elt, type);
    }

    @Override
    public AnnotatedTypeMirror.AnnotatedExecutableType methodFromUse(MethodInvocationTree tree) {
        AnnotatedTypeMirror.AnnotatedExecutableType method = super.methodFromUse(tree);
        this.poly.annotate(tree, method);
        this.poly.annotate(method.getElement(), (AnnotatedTypeMirror)method);
        return method;
    }

    protected Set<AnnotationMirror> createFlowQualifiers(Checker checker) {
        AnnotationUtils annoFactory = AnnotationUtils.getInstance(this.env);
        HashSet<AnnotationMirror> flowQuals = new HashSet<AnnotationMirror>();
        for (Class<? extends Annotation> cl : ((BaseTypeChecker)checker).getSupportedTypeQualifiers()) {
            flowQuals.add(annoFactory.fromClass(cl));
        }
        return flowQuals;
    }
}

