/*
 * Decompiled with CFR 0.152.
 */
package checkers.types;

import checkers.util.AnnotationUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Name;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class QualifierHierarchy {
    public abstract AnnotationMirror getRootAnnotation();

    public abstract AnnotationMirror getBottomQualifier();

    public abstract Set<Name> getTypeQualifiers();

    public abstract boolean isSubtype(AnnotationMirror var1, AnnotationMirror var2);

    public boolean isSubtype(Collection<AnnotationMirror> rhs, Collection<AnnotationMirror> lhs) {
        Collection<AnnotationMirror> rhsAnnos = this.wrapCollection(rhs);
        Collection<AnnotationMirror> lhsAnnos = this.wrapCollection(lhs);
        for (AnnotationMirror lhsAnno : lhsAnnos) {
            for (AnnotationMirror rhsAnno : rhsAnnos) {
                if (!this.isSubtype(rhsAnno, lhsAnno)) continue;
                return true;
            }
        }
        return false;
    }

    public abstract AnnotationMirror leastUpperBound(AnnotationMirror var1, AnnotationMirror var2);

    public abstract AnnotationMirror greatestLowerBound(AnnotationMirror var1, AnnotationMirror var2);

    public Set<AnnotationMirror> leastUpperBound(Collection<AnnotationMirror> annos1, Collection<AnnotationMirror> annos2) {
        Collection<AnnotationMirror> as1 = this.wrapCollection(annos1);
        Collection<AnnotationMirror> as2 = this.wrapCollection(annos2);
        if (as1.size() == 1 && as2.size() == 1) {
            AnnotationMirror a1 = as1.iterator().next();
            AnnotationMirror a2 = as2.iterator().next();
            return Collections.singleton(this.leastUpperBound(a1, a2));
        }
        Set<AnnotationMirror> difference = this.difference(as1, as2);
        Set<AnnotationMirror> lub = AnnotationUtils.createAnnotationSet();
        lub.addAll(this.intersect(as1, as2));
        if (difference.isEmpty()) {
            return lub;
        }
        AnnotationMirror lubOfDiff = difference.iterator().next();
        for (AnnotationMirror a : difference) {
            lubOfDiff = this.leastUpperBound(lubOfDiff, a);
        }
        lub.add(lubOfDiff);
        return lub;
    }

    @Deprecated
    public List<AnnotationMirror> validQualifiers(Collection<AnnotationMirror> annos) {
        ArrayList<AnnotationMirror> results = new ArrayList<AnnotationMirror>();
        Set<Name> typeQualifiers = this.getTypeQualifiers();
        for (AnnotationMirror anno : annos) {
            if (!typeQualifiers.contains(AnnotationUtils.annotationName(anno))) continue;
            results.add(anno);
        }
        return results;
    }

    @Deprecated
    public AnnotationMirror validQualifier(Collection<AnnotationMirror> annos) {
        List<AnnotationMirror> validQualifiers = this.validQualifiers(annos);
        return validQualifiers.isEmpty() ? null : validQualifiers.get(0);
    }

    protected Collection<AnnotationMirror> wrapCollection(Collection<AnnotationMirror> annos) {
        if (annos.size() == 0) {
            return Collections.singleton(null);
        }
        return annos;
    }

    protected Set<AnnotationMirror> intersect(Collection<AnnotationMirror> as1, Collection<AnnotationMirror> as2) {
        Set<AnnotationMirror> intersects = AnnotationUtils.createAnnotationSet();
        intersects.addAll(as1);
        intersects.retainAll(as2);
        return intersects;
    }

    protected Set<AnnotationMirror> difference(Collection<AnnotationMirror> as1, Collection<AnnotationMirror> as2) {
        Set<AnnotationMirror> difference = AnnotationUtils.createAnnotationSet();
        difference.addAll(as1);
        difference.addAll(as2);
        difference.removeAll(this.intersect(as1, as2));
        return difference;
    }
}

