/*
 * Decompiled with CFR 0.152.
 */
package checkers.types;

import checkers.basetype.BaseTypeChecker;
import checkers.quals.ImplicitFor;
import checkers.types.AnnotatedTypeFactory;
import checkers.types.AnnotatedTypeMirror;
import checkers.types.QualifierHierarchy;
import checkers.util.AnnotationUtils;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.SimpleTreeVisitor;
import java.lang.annotation.Annotation;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.type.TypeKind;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeAnnotator
extends SimpleTreeVisitor<Void, AnnotatedTypeMirror> {
    private final Map<Tree.Kind, AnnotationMirror> treeKinds = new EnumMap<Tree.Kind, AnnotationMirror>(Tree.Kind.class);
    private final Map<Class<?>, AnnotationMirror> treeClasses = new HashMap();
    private final Map<Pattern, AnnotationMirror> stringPatterns = new IdentityHashMap<Pattern, AnnotationMirror>();
    private final QualifierHierarchy qualHierarchy;
    private final AnnotatedTypeFactory typeFactory;

    public TreeAnnotator(BaseTypeChecker checker, AnnotatedTypeFactory typeFactory) {
        this.qualHierarchy = checker.getQualifierHierarchy();
        this.typeFactory = typeFactory;
        AnnotationUtils annoFactory = AnnotationUtils.getInstance(checker.getProcessingEnvironment());
        Set<Class<? extends Annotation>> quals = checker.getSupportedTypeQualifiers();
        for (Class<? extends Annotation> qual : quals) {
            ImplicitFor implicit = qual.getAnnotation(ImplicitFor.class);
            if (implicit == null) continue;
            AnnotationMirror theQual = annoFactory.fromClass(qual);
            for (Class<? extends Tree> clazz : implicit.treeClasses()) {
                this.treeClasses.put(clazz, theQual);
            }
            for (Tree.Kind kind : implicit.trees()) {
                this.treeKinds.put(kind, theQual);
            }
            for (String string : implicit.stringPatterns()) {
                this.stringPatterns.put(Pattern.compile(string), theQual);
            }
        }
    }

    @Override
    public Void defaultAction(Tree tree, AnnotatedTypeMirror type) {
        if (type.isAnnotated()) {
            return null;
        }
        if (this.treeKinds.containsKey((Object)tree.getKind())) {
            type.addAnnotation(this.treeKinds.get((Object)tree.getKind()));
        } else if (!this.treeClasses.isEmpty()) {
            Class<?> t = tree.getClass();
            if (this.treeClasses.containsKey(t)) {
                type.addAnnotation(this.treeClasses.get(t));
            }
            for (Class<?> c : t.getInterfaces()) {
                if (!this.treeClasses.containsKey(c)) continue;
                type.addAnnotation(this.treeClasses.get(c));
                this.treeClasses.put(t, this.treeClasses.get(c));
            }
        }
        return null;
    }

    @Override
    public Void visitLiteral(LiteralTree tree, AnnotatedTypeMirror type) {
        if (!this.stringPatterns.isEmpty() && tree.getKind() == Tree.Kind.STRING_LITERAL) {
            String string = (String)tree.getValue();
            for (Pattern pattern : this.stringPatterns.keySet()) {
                if (!pattern.matcher(string).matches()) continue;
                type.addAnnotation(this.stringPatterns.get(pattern));
                break;
            }
        }
        return (Void)super.visitLiteral(tree, type);
    }

    @Override
    public Void visitNewArray(NewArrayTree tree, AnnotatedTypeMirror type) {
        if (tree.getType() == null) {
            Set<AnnotationMirror> lub = null;
            for (ExpressionTree expressionTree : tree.getInitializers()) {
                AnnotatedTypeMirror iniType = this.typeFactory.getAnnotatedType(expressionTree);
                Set<AnnotationMirror> annos = iniType.getAnnotations();
                lub = lub == null ? annos : this.qualHierarchy.leastUpperBound(lub, annos);
            }
            assert (type.getKind() == TypeKind.ARRAY);
            if (lub != null) {
                ((AnnotatedTypeMirror.AnnotatedArrayType)type).getComponentType().addAnnotations(lub);
            }
        }
        return (Void)super.visitNewArray(tree, type);
    }
}

