/*
 * Decompiled with CFR 0.152.
 */
package checkers.types;

import checkers.basetype.BaseTypeChecker;
import checkers.quals.ImplicitFor;
import checkers.types.AnnotatedTypeMirror;
import checkers.types.visitors.AnnotatedTypeScanner;
import checkers.util.AnnotationUtils;
import java.lang.annotation.Annotation;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ElementKind;
import javax.lang.model.type.TypeKind;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeAnnotator
extends AnnotatedTypeScanner<Void, ElementKind> {
    private final Map<TypeKind, AnnotationMirror> typeKinds = new EnumMap<TypeKind, AnnotationMirror>(TypeKind.class);
    private final Map<Class<?>, AnnotationMirror> typeClasses = new HashMap();

    public TypeAnnotator(BaseTypeChecker checker) {
        AnnotationUtils annoFactory = AnnotationUtils.getInstance(checker.getProcessingEnvironment());
        Set<Class<? extends Annotation>> quals = checker.getSupportedTypeQualifiers();
        for (Class<? extends Annotation> qual : quals) {
            ImplicitFor implicit = qual.getAnnotation(ImplicitFor.class);
            if (implicit == null) continue;
            AnnotationMirror theQual = annoFactory.fromClass(qual);
            for (Class<? extends AnnotatedTypeMirror> clazz : implicit.typeClasses()) {
                this.typeClasses.put(clazz, theQual);
            }
            for (TypeKind typeKind : implicit.types()) {
                this.typeKinds.put(typeKind, theQual);
            }
        }
    }

    @Override
    protected Void scan(AnnotatedTypeMirror type, ElementKind p) {
        if (type == null) {
            return (Void)super.scan(type, p);
        }
        if (!type.isAnnotated()) {
            Class<?> t;
            if (this.typeKinds.containsKey((Object)type.getKind())) {
                type.addAnnotation(this.typeKinds.get((Object)type.getKind()));
            } else if (!this.typeClasses.isEmpty() && this.typeClasses.containsKey(t = type.getClass())) {
                type.addAnnotation(this.typeClasses.get(t));
            }
        }
        return (Void)super.scan(type, p);
    }

    @Override
    public Void visitExecutable(AnnotatedTypeMirror.AnnotatedExecutableType t, ElementKind p) {
        this.scan(t.getReturnType(), p);
        this.scanAndReduce(t.getParameterTypes(), p, null);
        this.scanAndReduce(t.getThrownTypes(), p, null);
        this.scanAndReduce(t.getTypeVariables(), p, null);
        return null;
    }
}

